/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.messageplugin.internal.pubsub;

import com.ibm.mq.MQException;
import com.ibm.mq.MQGetMessageOptions;
import com.ibm.mq.MQMessage;
import com.ibm.mq.MQTopic;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.messageplugin.internal.pubsub.SubscribeDialog;

public class GetMessages
extends Thread {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.messageplugin.internal/src/com/ibm/mq/explorer/messageplugin/internal/pubsub/GetMessages.java";
    private MQTopic mqTopic = null;
    private boolean unsubscribed = false;
    private boolean closed = false;
    private boolean exceptionReceived = false;
    private SubscribeDialog subscribeDialog = null;

    public GetMessages(MQTopic mqTopic, int waitTime, SubscribeDialog subscribeDialog) {
        this.mqTopic = mqTopic;
        this.subscribeDialog = subscribeDialog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Trace t = Trace.getDefault();
        while (!this.closed) {
            block18: {
                block16: {
                    if (this.unsubscribed || this.exceptionReceived) {
                        try {
                            GetMessages getMessages = this;
                            synchronized (getMessages) {
                                this.wait();
                            }
                        }
                        catch (InterruptedException e) {
                            if (!Trace.isTracing) break block16;
                            t.data(66, "GetMessages.run", 300, "InterruptedException received:" + e.toString());
                        }
                    }
                }
                if (this.closed) continue;
                this.exceptionReceived = false;
                MQMessage message = null;
                MQException exception = null;
                try {
                    try {
                        message = this.get(t);
                    }
                    catch (MQException mqe) {
                        if (mqe.reasonCode != 2033) {
                            exception = mqe;
                            this.exceptionReceived = true;
                            if (Trace.isTracing) {
                                t.data(66, "GetMessages.run", 900, "Error getting a message from the queue: " + mqe.toString());
                            }
                        }
                        this.subscribeDialog.messageReceived(t, message, exception);
                        break block18;
                    }
                }
                catch (Throwable throwable) {
                    this.subscribeDialog.messageReceived(t, message, exception);
                    throw throwable;
                }
                this.subscribeDialog.messageReceived(t, message, exception);
            }
            try {
                GetMessages.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (Trace.isTracing) {
            t.data(66, "GetMessages.run", 300, "Subscribe dialog closing - Stop polling the topic for messages.");
        }
    }

    public MQMessage get(Trace t) throws MQException {
        MQMessage getMessage;
        block3: {
            getMessage = new MQMessage();
            MQGetMessageOptions gmo = new MQGetMessageOptions();
            gmo.options |= 0x8000000;
            try {
                if (!this.unsubscribed) {
                    this.mqTopic.get(getMessage, gmo);
                }
            }
            catch (MQException mqe) {
                if (mqe.reasonCode == 2079) break block3;
                throw mqe;
            }
        }
        return getMessage;
    }

    public void setMQTopic(MQTopic mqTopic) {
        this.mqTopic = mqTopic;
    }

    public void setUnsubscribed(boolean unsubscribed) {
        this.unsubscribed = unsubscribed;
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public void setExceptionReceived(boolean exceptionReceived) {
        this.exceptionReceived = exceptionReceived;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeUp() {
        GetMessages getMessages = this;
        synchronized (getMessages) {
            this.notify();
        }
    }
}

