/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.messageplugin.internal.datamodel;

import com.ibm.mq.MQMessage;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.constants.MQConstants;
import com.ibm.mq.explorer.core.internal.attrs.AbstractAttrTypeNumber;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrByteArray;
import com.ibm.mq.explorer.core.internal.attrs.AttrInt;
import com.ibm.mq.explorer.core.internal.attrs.AttrLong;
import com.ibm.mq.explorer.core.internal.attrs.AttrString;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeByteArray;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeEnum;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeInt;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeLong;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeString;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.event.DmActionListener;
import com.ibm.mq.explorer.core.internal.objects.DisplayGroup;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.messageplugin.internal.MessagePlugin;
import com.ibm.mq.explorer.messageplugin.internal.datamodel.AttrTypeBitMask;
import com.ibm.mq.explorer.messageplugin.internal.datamodel.MQBrowsesDataModel;
import com.ibm.mq.headers.MQDLH;
import com.ibm.mq.headers.MQDataException;
import com.ibm.mq.headers.MQHeader;
import com.ibm.mq.headers.MQHeaderList;
import java.io.DataInput;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.TimeZone;

public class DmBrowse
implements IDmObject {
    protected static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.messageplugin.internal/src/com/ibm/mq/explorer/messageplugin/internal/datamodel/DmBrowse.java";
    protected static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    private String objectName;
    private Hashtable<Integer, Attr> attributes;
    protected Hashtable<Date, Hashtable<Integer, Attr>> updateTables;
    public MQHeader[] headers;
    public boolean headerTruncated;
    public Hashtable<String, String> msgProperties;
    public int maxDisplayBytes;
    private static final String PROPERTY_WILDCARD = "%";

    public DmBrowse(Trace t, MQMessage message, byte[] messageToken, int _maxDisplayBytes, int position) {
        block24: {
            this.objectName = null;
            this.attributes = null;
            this.updateTables = null;
            this.headers = null;
            this.headerTruncated = false;
            this.msgProperties = null;
            this.maxDisplayBytes = 0;
            if (_maxDisplayBytes > 0) {
                this.maxDisplayBytes = _maxDisplayBytes;
            }
            this.objectName = Message.format((String)MQBrowsesDataModel.messageTitle, (String)Integer.toString(position));
            this.attributes = new Hashtable();
            this.updateTables = new Hashtable();
            DisplayGroup generalGroup = new DisplayGroup(t, 0, 0, MQBrowsesDataModel.displayGroupNameGeneral);
            DisplayGroup reportGroup = new DisplayGroup(t, 1, 1, MQBrowsesDataModel.displayGroupNameReport);
            DisplayGroup contextGroup = new DisplayGroup(t, 2, 2, MQBrowsesDataModel.displayGroupNameContext);
            DisplayGroup identifiersGroup = new DisplayGroup(t, 3, 3, MQBrowsesDataModel.displayGroupNameIdentifiers);
            DisplayGroup segmentationGroup = new DisplayGroup(t, 4, 4, MQBrowsesDataModel.displayGroupNameSegmentation);
            DisplayGroup propGroup = new DisplayGroup(t, 5, 7, MQBrowsesDataModel.displayGroupNameProperties);
            DisplayGroup rfh2PropGroup = new DisplayGroup(t, 6, 8, MQBrowsesDataModel.displayGroupNameRFH2Properties);
            DisplayGroup hdrGroup = new DisplayGroup(t, 7, 9, MQBrowsesDataModel.displayGroupNameHeaders);
            DisplayGroup dataGroup = new DisplayGroup(t, 9, 5, MQBrowsesDataModel.displayGroupNameData);
            DisplayGroup dlhGroup = new DisplayGroup(t, 8, 6, MQBrowsesDataModel.displayGroupNameDeadLetter);
            generalGroup.setResourceStem("MessageBrowseGeneral");
            reportGroup.setResourceStem("MessageBrowseReport");
            contextGroup.setResourceStem("MessageBrowseContext");
            identifiersGroup.setResourceStem("MessageBrowseIdentifiers");
            segmentationGroup.setResourceStem("MessageBrowseSegmentation");
            dataGroup.setResourceStem("MessageBrowseData");
            dlhGroup.setResourceStem("MessageDeadLetterHeader");
            propGroup.setResourceStem("MessageBrowseNamedProperties");
            rfh2PropGroup.setResourceStem("MessageBrowseRFH2Properties");
            hdrGroup.setResourceStem("MessageBrowseHeaders");
            try {
                MQHeaderList headerList;
                block25: {
                    block23: {
                        this.addPosition(t, position, generalGroup);
                        this.addMessageType(t, message.messageType, generalGroup);
                        this.addPriority(t, message.priority, generalGroup);
                        this.addPersistence(t, message.persistence, generalGroup);
                        this.addPutDateTime(t, message.putDateTime, generalGroup);
                        this.addExpiry(t, message.expiry, generalGroup);
                        this.addReplyToQueueName(t, message.replyToQueueName, generalGroup);
                        this.addReplyToQueueManagerName(t, message.replyToQueueManagerName, generalGroup);
                        this.addBackoutCount(t, message.backoutCount, generalGroup);
                        this.addReport(t, message.report, reportGroup);
                        this.addOriginalLength(t, message.originalLength, reportGroup);
                        this.addFeedback(t, message.feedback, reportGroup);
                        this.addUserIdentifier(t, message.userId, contextGroup);
                        this.addApplicationType(t, message.putApplicationType, contextGroup);
                        this.addPutApplicationName(t, message.putApplicationName, contextGroup);
                        this.addApplicationIDData(t, message.applicationIdData, contextGroup);
                        this.addApplicationOriginData(t, message.applicationOriginData, contextGroup);
                        this.addAccountingToken(t, message.accountingToken, contextGroup);
                        this.addMessageID(t, message.messageId, identifiersGroup);
                        this.addMessageIDBytes(t, message.messageId, identifiersGroup);
                        this.addCorrelationID(t, message.correlationId, identifiersGroup);
                        this.addCorrelationIDBytes(t, message.correlationId, identifiersGroup);
                        this.addGroupID(t, message.groupId, identifiersGroup);
                        this.addGroupIDBytes(t, message.groupId, identifiersGroup);
                        this.addMessageTokenBytes(t, messageToken, identifiersGroup);
                        this.addLogicalSequenceNumber(t, message.messageSequenceNumber, segmentationGroup);
                        this.addOffset(t, message.offset, segmentationGroup);
                        this.addFlags(t, message.messageFlags, segmentationGroup);
                        this.addTotalLength(t, message.getTotalMessageLength(), dataGroup);
                        int dataLength = message.getDataLength();
                        this.addDataLength(t, dataLength, dataGroup);
                        this.addFormat(t, message.format, dataGroup);
                        this.addCodedCharacterSetID(t, message.characterSet, dataGroup);
                        this.addEncoding(t, message.encoding, dataGroup);
                        if (dataLength > this.maxDisplayBytes) {
                            dataLength = this.maxDisplayBytes;
                        }
                        byte[] displayBytes = new byte[dataLength];
                        message.readFully(displayBytes, 0, dataLength);
                        AttrByteArray msgAttr = this.addMessageDataBytes(t, displayBytes, dataGroup);
                        int outLength = dataLength;
                        if (dataLength > 50) {
                            outLength = 50;
                        }
                        try {
                            this.addMessageData(t, msgAttr.toStringWithEncoding(t, message.characterSet, message.encoding, outLength), dataGroup);
                        }
                        catch (DmCoreException dmce) {
                            if (!Trace.isTracing) break block23;
                            t.data(66, "DmBrowse.DmBrowse", 900, "DmCoreException received:" + dmce.toString());
                        }
                    }
                    try {
                        if (Trace.isTracing) {
                            t.data(66, "DmBrowse.DmBrowse", 500, "Getting message properties for message " + message);
                        }
                        Enumeration e = message.getPropertyNames(PROPERTY_WILDCARD);
                        while (e.hasMoreElements()) {
                            String name = (String)e.nextElement();
                            String value = null;
                            Object property = message.getObjectProperty(name);
                            value = property == null ? "" : property.toString();
                            if (this.msgProperties == null) {
                                this.msgProperties = new Hashtable();
                            }
                            this.msgProperties.put(name, value);
                        }
                        if (this.msgProperties != null) {
                            this.addProperties(t, propGroup);
                        }
                    }
                    catch (Exception exception) {}
                    if (message.format.equals("        ")) break block24;
                    headerList = new MQHeaderList();
                    try {
                        message.setDataOffset(0);
                        headerList.read((DataInput)message, false);
                    }
                    catch (Exception e) {
                        int rc;
                        Throwable throwable;
                        Throwable cause = e.getCause();
                        if (!(cause instanceof RuntimeException) || !((throwable = cause.getCause()) instanceof MQDataException) || (rc = ((MQDataException)throwable).getReason()) != 6114) break block25;
                        this.headerTruncated = true;
                    }
                }
                try {
                    this.headers = new MQHeader[headerList.size()];
                    Iterator it = headerList.iterator();
                    int i = 0;
                    int indexDLH = -1;
                    boolean hasRFH2 = false;
                    while (it.hasNext()) {
                        boolean isRFH2;
                        MQHeader header = (MQHeader)it.next();
                        boolean isDLH = header != null && "MQDLH".compareTo(header.type()) == 0;
                        boolean bl = isRFH2 = header != null && "MQRFH2".compareTo(header.type()) == 0;
                        if (isDLH) {
                            indexDLH = i;
                        }
                        if (isRFH2) {
                            hasRFH2 = true;
                        }
                        this.headers[i++] = MessagePlugin.showHeaders || isDLH || isRFH2 ? header : null;
                    }
                    if (hasRFH2) {
                        this.addRFH2Properties(t, rfh2PropGroup);
                    }
                    if (indexDLH >= 0) {
                        MQDLH dlh = (MQDLH)this.headers[indexDLH];
                        this.addDLHReason(t, dlh.getReason(), dlhGroup);
                        this.addDLHDestQName(t, dlh.getDestQName(), dlhGroup);
                        this.addDLHDestQMgrName(t, dlh.getDestQMgrName(), dlhGroup);
                        this.addDLHEncoding(t, dlh.getEncoding(), dlhGroup);
                        this.addDLHCodedCharSetId(t, dlh.getCodedCharSetId(), dlhGroup);
                        this.addDLHFormat(t, dlh.getFormat(), dlhGroup);
                        this.addDLHputApplType(t, dlh.getPutApplType(), dlhGroup);
                        this.addDLHputApplName(t, dlh.getPutApplName(), dlhGroup);
                        this.addDLHputDate(t, dlh.getPutDate(), dlhGroup);
                        this.addDLHputTime(t, dlh.getPutTime(), dlhGroup);
                    }
                    if (MessagePlugin.showHeaders && this.headers.length > 0) {
                        this.addHeader(t, hdrGroup);
                    }
                }
                catch (Exception exception) {}
            }
            catch (IOException iOException) {
                this.updateTables = null;
            }
        }
    }

    public String toString(Trace t) {
        return this.objectName;
    }

    public Attr getAttribute(Trace t, int id, int index) {
        Attr attr = null;
        Integer key = id;
        if (this.attributes.containsKey(key)) {
            attr = this.attributes.get(key);
        }
        return attr;
    }

    public String getAttributeValue(Trace t, int id, int index) {
        String value = null;
        Integer key = id;
        if (this.attributes.containsKey(key)) {
            Attr attr = this.attributes.get(key);
            value = attr.toString(t);
        }
        return value;
    }

    public int getRepeatingIndexes(Trace t, int id) {
        return 0;
    }

    public int[] getAllAttributes(Trace t) {
        int[] attrs = new int[this.attributes.size()];
        int index = 0;
        Enumeration<Attr> en = this.attributes.elements();
        while (en.hasMoreElements()) {
            Attr attr = en.nextElement();
            attrs[index++] = attr.getAttributeID();
        }
        return attrs;
    }

    public String getTitle() {
        return this.objectName;
    }

    public DmQueueManager getQueueManager() {
        return null;
    }

    public void debug(Trace t) {
    }

    public boolean refreshAttributes(Trace t) {
        return true;
    }

    public boolean setAttributeValue(Trace t, Object job, int id, int index, Object value) {
        boolean setAttribute = true;
        AttrString attrUpdate = null;
        Hashtable<Integer, Attr> tableUpdate = this.getUpdateTable(t, job);
        Attr attr = this.getAttribute(t, id, index);
        if (attr == null) {
            setAttribute = false;
        } else {
            AttrType attrType = attr.getAttrType();
            if (attrType instanceof AttrTypeString) {
                attrUpdate = new AttrString(t, attr.getAttributeID(), 0, (String)value, (AttrTypeString)attrType, (IDmObject)this);
            } else if (attrType instanceof AttrTypeLong) {
                attrUpdate = new AttrLong(t, attr.getAttributeID(), 0, (long)((Long)value).intValue(), (AbstractAttrTypeNumber)((AttrTypeLong)attrType), (IDmObject)this);
            } else if (attrType instanceof AttrTypeInt) {
                attrUpdate = new AttrInt(t, attr.getAttributeID(), 0, ((Integer)value).intValue(), (AbstractAttrTypeNumber)((AttrTypeInt)attrType), (IDmObject)this);
            } else if (attrType instanceof AttrTypeEnum) {
                attrUpdate = new AttrInt(t, attr.getAttributeID(), 0, ((Integer)value).intValue(), (AbstractAttrTypeNumber)((AttrTypeEnum)attrType), (IDmObject)this);
            } else {
                setAttribute = false;
            }
        }
        if (setAttribute) {
            tableUpdate.put(id, (Attr)attrUpdate);
        }
        return setAttribute;
    }

    public Object beginUpdate(Trace t) {
        Date job = new Date();
        this.updateTables.put(job, new Hashtable());
        return job;
    }

    public void endUpdate(Trace t, Object job) {
        Hashtable<Integer, Attr> table = this.updateTables.remove(job);
        if (table != null) {
            table.clear();
        }
    }

    public boolean apply(Trace t, Object job) {
        boolean applied = false;
        Hashtable<Integer, Attr> updateTable = this.getUpdateTable(t, job);
        if (updateTable.size() != 0) {
            Set<Integer> k = updateTable.keySet();
            for (Integer key : k) {
                Attr a = updateTable.get(key);
                this.attributes.put(key, a);
            }
            this.endUpdate(t, job);
        }
        return applied;
    }

    public boolean isSystemObject(Trace t) {
        return false;
    }

    public int getStatusType(Trace t) {
        return 0;
    }

    public int actionDelete(Trace t) {
        return 0;
    }

    protected Hashtable<Integer, Attr> getUpdateTable(Trace t, Object job) {
        Hashtable<Integer, Attr> table = this.updateTables.get(job);
        return table;
    }

    private void addPosition(Trace t, int count, DisplayGroup dispGroup) {
        this.addInt(t, count, dispGroup, MQBrowsesDataModel.attrTypeNamePosition, 0, 0, 2000);
    }

    private void addPutDateTime(Trace t, Calendar putDateTime, DisplayGroup dispGroup) {
        String dateString;
        if (putDateTime == null) {
            dateString = new String();
        } else {
            String putTime = new String();
            String putDate = new String();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
            SimpleDateFormat timeFormat = new SimpleDateFormat("HHmmssSS");
            dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            timeFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            putDate = dateFormat.format(putDateTime.getTime());
            putTime = timeFormat.format(putDateTime.getTime());
            dateString = putDate.equalsIgnoreCase("00010101") ? DateFormat.getTimeInstance().format(putDateTime.getTime()) : (putTime.equalsIgnoreCase("00000000") ? DateFormat.getDateInstance().format(putDateTime.getTime()) : DateFormat.getDateTimeInstance().format(putDateTime.getTime()));
        }
        this.addStr(t, dateString, dispGroup, MQBrowsesDataModel.attrTypeNamePutDateTime, 4, 1, 4001);
    }

    private void addUserIdentifier(Trace t, String userIdentifier, DisplayGroup dispGroup) {
        this.addStr(t, userIdentifier, dispGroup, MQBrowsesDataModel.attrTypeNameUserIdentifier, 0, 2, 4002);
    }

    private void addPutApplicationName(Trace t, String putDateTime, DisplayGroup dispGroup) {
        this.addStr(t, putDateTime, dispGroup, MQBrowsesDataModel.attrTypeNameApplicationName, 2, 3, 4003);
    }

    private void addFormat(Trace t, String format, DisplayGroup dispGroup) {
        this.addStr(t, format, dispGroup, MQBrowsesDataModel.attrTypeNameFormat, 1, 4, 4004);
    }

    private void addProperties(Trace t, DisplayGroup dispGroup) {
        this.addStr(t, "", dispGroup, "", 5, -2, 2043);
    }

    private void addRFH2Properties(Trace t, DisplayGroup dispGroup) {
        this.addStr(t, "", dispGroup, "", 6, -2, 2044);
    }

    private void addHeader(Trace t, DisplayGroup dispGroup) {
        this.addStr(t, "", dispGroup, "", 7, -2, 2045);
    }

    private void addDLHReason(Trace t, int reason, DisplayGroup dispGroup) {
        String reasonStr = this.getSymbol(reason);
        this.addStr(t, reasonStr, dispGroup, MQBrowsesDataModel.attrTypeDlhReason, 0, -2, 2033);
    }

    private void addDLHDestQName(Trace t, String destQName, DisplayGroup dispGroup) {
        this.addStr(t, destQName, dispGroup, MQBrowsesDataModel.attrTypeDlhDestQ, 1, -2, 2034);
    }

    private void addDLHDestQMgrName(Trace t, String destQmgrName, DisplayGroup dispGroup) {
        this.addStr(t, destQmgrName, dispGroup, MQBrowsesDataModel.attrTypeDlhDestQmgr, 2, -2, 2035);
    }

    private void addDLHEncoding(Trace t, int encoding, DisplayGroup dispGroup) {
        this.addInt(t, encoding, dispGroup, MQBrowsesDataModel.attrTypeDlhEncoding, 3, -2, 2036);
    }

    private void addDLHCodedCharSetId(Trace t, int ccsid, DisplayGroup dispGroup) {
        this.addInt(t, ccsid, dispGroup, MQBrowsesDataModel.attrTypeDlhCCSID, 4, -2, 2012);
    }

    private void addDLHFormat(Trace t, String format, DisplayGroup dispGroup) {
        this.addStr(t, format, dispGroup, MQBrowsesDataModel.attrTypeDlhFormat, 5, -2, 2038);
    }

    private void addDLHputApplType(Trace t, int applType, DisplayGroup dispGroup) {
        String data = this.getApplTypeString(applType);
        this.addStr(t, data, dispGroup, MQBrowsesDataModel.attrTypeDlhApplType, 6, -2, 2039);
    }

    private void addDLHputApplName(Trace t, String applName, DisplayGroup dispGroup) {
        this.addStr(t, applName, dispGroup, MQBrowsesDataModel.attrTypeDlhApplName, 7, -2, 2040);
    }

    private void addDLHputDate(Trace t, String putDate, DisplayGroup dispGroup) {
        StringBuffer bufDate = new StringBuffer();
        bufDate.append(putDate.substring(0, 4));
        bufDate.append("/");
        bufDate.append(putDate.substring(4, 6));
        bufDate.append("/");
        bufDate.append(putDate.substring(6, 8));
        this.addStr(t, bufDate.toString(), dispGroup, MQBrowsesDataModel.attrTypeDlhPutDate, 8, -2, 2041);
    }

    private void addDLHputTime(Trace t, String putTime, DisplayGroup dispGroup) {
        StringBuffer bufTime = new StringBuffer();
        bufTime.append(putTime.substring(0, 2));
        bufTime.append(":");
        bufTime.append(putTime.substring(2, 4));
        bufTime.append(":");
        bufTime.append(putTime.substring(4, 6));
        this.addStr(t, bufTime.toString(), dispGroup, MQBrowsesDataModel.attrTypeDlhPutTime, 9, -2, 2042);
    }

    private void addTotalLength(Trace t, int length, DisplayGroup dispGroup) {
        this.addInt(t, length, dispGroup, MQBrowsesDataModel.attrTypeNameLength, 0, 5, 2005);
    }

    private void addDataLength(Trace t, int length, DisplayGroup dispGroup) {
        this.addInt(t, length, dispGroup, MQBrowsesDataModel.attrTypeNameDataLength, 0, 6, 2047);
    }

    private void addMessageData(Trace t, String string, DisplayGroup dispGroup) {
        this.addStr(t, string, dispGroup, MQBrowsesDataModel.attrTypeNameMessageData, 4, 7, 4006);
    }

    private void addAccountingToken(Trace t, byte[] accountingToken, DisplayGroup dispGroup) {
        this.addByte(t, accountingToken, dispGroup, MQBrowsesDataModel.attrTypeNameAccountingToken, 5, 8, 4007);
    }

    private void addApplicationIDData(Trace t, String applicationIdData, DisplayGroup dispGroup) {
        this.addStr(t, applicationIdData, dispGroup, MQBrowsesDataModel.attrTypeNameApplicationIdentityData, 3, 9, 4008);
    }

    private void addApplicationOriginData(Trace t, String applicationOriginData, DisplayGroup dispGroup) {
        this.addStr(t, applicationOriginData, dispGroup, MQBrowsesDataModel.attrTypeNameApplicationOriginData, 4, 10, 4009);
    }

    private void addApplicationType(Trace t, int applicationType, DisplayGroup dispGroup) {
        String data = this.getApplTypeString(applicationType);
        this.addStr(t, data, dispGroup, MQBrowsesDataModel.attrTypeNameApplicationType, 1, 11, 2010);
    }

    private void addBackoutCount(Trace t, int backoutCount, DisplayGroup dispGroup) {
        this.addInt(t, backoutCount, dispGroup, MQBrowsesDataModel.attrTypeNameBackoutCount, 8, 12, 2011);
    }

    private void addCodedCharacterSetID(Trace t, int codedCharacterSetID, DisplayGroup dispGroup) {
        this.addInt(t, codedCharacterSetID, dispGroup, MQBrowsesDataModel.attrTypeNameCodedCharacterSetID, 2, 13, 2012);
    }

    private void addCorrelationID(Trace t, byte[] correlationID, DisplayGroup dispGroup) {
        this.addStr(t, new String(correlationID), dispGroup, MQBrowsesDataModel.attrTypeNameCorrelationID, 2, 14, 4013);
    }

    private void addCorrelationIDBytes(Trace t, byte[] correlationID, DisplayGroup dispGroup) {
        this.addByte(t, correlationID, dispGroup, MQBrowsesDataModel.attrTypeNameCorrelationIDBytes, 3, 15, 4014);
    }

    private void addMessageTokenBytes(Trace t, byte[] token, DisplayGroup dispGroup) {
        this.addByte(t, token, dispGroup, MQBrowsesDataModel.attrTypeNameMessageTokenBytes, -2, -2, 4046);
    }

    private void addEncoding(Trace t, int encoding, DisplayGroup dispGroup) {
        this.addInt(t, encoding, dispGroup, MQBrowsesDataModel.attrTypeNameEncoding, 3, 16, 2015);
    }

    private void addExpiry(Trace t, int expiry, DisplayGroup dispGroup) {
        String data = expiry == -1 ? MQBrowsesDataModel.mqeiUnlimited : Integer.toString(expiry);
        this.addStr(t, data, dispGroup, MQBrowsesDataModel.attrTypeNameExpiry, 5, 17, 2016);
    }

    private void addFeedback(Trace t, int feedback, DisplayGroup dispGroup) {
        String data;
        if (feedback == 0) {
            String string = MQBrowsesDataModel.mqfbNone;
        }
        switch (feedback) {
            case 0: {
                data = MQBrowsesDataModel.mqfbNone;
                break;
            }
            case 256: {
                data = MQBrowsesDataModel.mqfbQuit;
                break;
            }
            case 258: {
                data = MQBrowsesDataModel.mqfbExpiration;
                break;
            }
            case 259: {
                data = MQBrowsesDataModel.mqfbCOA;
                break;
            }
            case 260: {
                data = MQBrowsesDataModel.mqfbCOD;
                break;
            }
            case 262: {
                data = MQBrowsesDataModel.mqfbChannelCompleted;
                break;
            }
            case 263: {
                data = MQBrowsesDataModel.mqfbChannelFailRetry;
                break;
            }
            case 264: {
                data = MQBrowsesDataModel.mqfbChannelFail;
                break;
            }
            case 265: {
                data = MQBrowsesDataModel.mqfbApplCannotBeStarted;
                break;
            }
            case 266: {
                data = MQBrowsesDataModel.mqfbTMError;
                break;
            }
            case 267: {
                data = MQBrowsesDataModel.mqfbApplTypeError;
                break;
            }
            case 268: {
                data = MQBrowsesDataModel.mqfbStoppedByMsgExit;
                break;
            }
            case 271: {
                data = MQBrowsesDataModel.mqfbXmitQMsgError;
                break;
            }
            case 275: {
                data = MQBrowsesDataModel.mqfbPAN;
                break;
            }
            case 276: {
                data = MQBrowsesDataModel.mqfbNAM;
                break;
            }
            case 291: {
                data = MQBrowsesDataModel.mqfbDataLenZero;
                break;
            }
            case 292: {
                data = MQBrowsesDataModel.mqfbDataLenNegative;
                break;
            }
            case 293: {
                data = MQBrowsesDataModel.mqfbDataLengthTooBig;
                break;
            }
            case 294: {
                data = MQBrowsesDataModel.mqfbBufferOverflow;
                break;
            }
            case 295: {
                data = MQBrowsesDataModel.mqfbLengthOffByOne;
                break;
            }
            case 296: {
                data = MQBrowsesDataModel.mqfbIIHError;
                break;
            }
            default: {
                data = Integer.toString(feedback);
            }
        }
        this.addStr(t, data, dispGroup, MQBrowsesDataModel.attrTypeNameFeedback, 1, 18, 2017);
    }

    private void addFlags(Trace t, int messageFlags, DisplayGroup dispGroup) {
        this.addFlagsMask(t, messageFlags, dispGroup, MQBrowsesDataModel.attrTypeNameFlags, 2, 19, 2018);
    }

    private void addGroupID(Trace t, byte[] groupID, DisplayGroup dispGroup) {
        this.addStr(t, new String(groupID), dispGroup, MQBrowsesDataModel.attrTypeNameGroupID, 4, 20, 4019);
    }

    private void addGroupIDBytes(Trace t, byte[] groupID, DisplayGroup dispGroup) {
        this.addByte(t, groupID, dispGroup, MQBrowsesDataModel.attrTypeNameGroupIDBytes, 5, 21, 4020);
    }

    private void addLogicalSequenceNumber(Trace t, int sequenceNumber, DisplayGroup dispGroup) {
        this.addInt(t, sequenceNumber, dispGroup, MQBrowsesDataModel.attrTypeNameLogicalSequenceNumber, 0, 22, 2021);
    }

    private AttrByteArray addMessageDataBytes(Trace t, byte[] message, DisplayGroup dispGroup) {
        AttrByteArray msgAttr = this.addByteAttr(t, message, dispGroup, MQBrowsesDataModel.attrTypeNameMessageDataBytes, 5, -1, 4022);
        return msgAttr;
    }

    private void addMessageID(Trace t, byte[] messageID, DisplayGroup dispGroup) {
        this.addStr(t, new String(messageID), dispGroup, MQBrowsesDataModel.attrTypeNameMessageID, 0, 23, 4023);
    }

    private void addMessageIDBytes(Trace t, byte[] messageID, DisplayGroup dispGroup) {
        this.addByte(t, messageID, dispGroup, MQBrowsesDataModel.attrTypeNameMessageIDBytes, 1, 24, 4024);
    }

    private void addMessageType(Trace t, int messageType, DisplayGroup dispGroup) {
        String data;
        switch (messageType) {
            case 8: {
                data = MQBrowsesDataModel.mqmtDatagram;
                break;
            }
            case 1: {
                data = MQBrowsesDataModel.mqmtRequest;
                break;
            }
            case 2: {
                data = MQBrowsesDataModel.mqmtReply;
                break;
            }
            case 4: {
                data = MQBrowsesDataModel.mqmtReport;
                break;
            }
            default: {
                data = Integer.toString(messageType);
            }
        }
        this.addStr(t, data, dispGroup, MQBrowsesDataModel.attrTypeNameMessageType, 1, 25, 2025);
    }

    private void addOffset(Trace t, int offset, DisplayGroup dispGroup) {
        this.addInt(t, offset, dispGroup, MQBrowsesDataModel.attrTypeNameOffset, 1, 26, 2026);
    }

    private void addOriginalLength(Trace t, int originalLength, DisplayGroup dispGroup) {
        this.addInt(t, originalLength, dispGroup, MQBrowsesDataModel.attrTypeNameOriginalLength, 2, 27, 4027);
    }

    private void addPersistence(Trace t, int persistence, DisplayGroup dispGroup) {
        String data;
        switch (persistence) {
            case 1: {
                data = MQBrowsesDataModel.mqperPersistent;
                break;
            }
            case 0: {
                data = MQBrowsesDataModel.mqperNotPersistent;
                break;
            }
            default: {
                data = Integer.toString(persistence);
            }
        }
        this.addStr(t, data, dispGroup, MQBrowsesDataModel.attrTypeNamePersistence, 3, 28, 2028);
    }

    private void addPriority(Trace t, int priority, DisplayGroup dispGroup) {
        this.addInt(t, priority, dispGroup, MQBrowsesDataModel.attrTypeNamePriority, 2, 29, 2029);
    }

    private void addReplyToQueueName(Trace t, String replyToQueueName, DisplayGroup dispGroup) {
        this.addStr(t, replyToQueueName, dispGroup, MQBrowsesDataModel.attrTypeNameReplyToQueue, 6, 30, 4030);
    }

    private void addReplyToQueueManagerName(Trace t, String replyToQueueManagerName, DisplayGroup dispGroup) {
        this.addStr(t, replyToQueueManagerName, dispGroup, MQBrowsesDataModel.attrTypeNameReplyToQueueManager, 7, 31, 4031);
    }

    private void addReport(Trace t, int reportByte, DisplayGroup dispGroup) {
        this.addReportMask(t, reportByte, dispGroup, MQBrowsesDataModel.attrTypeNameReport, 0, 32, 2032);
    }

    private void addInt(Trace t, int value, DisplayGroup dispGroup, String title, int pageSeq, int colSeq, int id) {
        AttrTypeInt attrType = new AttrTypeInt(t, "", pageSeq, dispGroup, colSeq, colSeq, -1, false, false, false, -1, null);
        attrType.setDisplayTitle(title);
        AttrInt attrInt = new AttrInt(t, id, 0, value, (AbstractAttrTypeNumber)attrType, (IDmObject)this);
        this.attributes.put(id, (Attr)attrInt);
    }

    private void addStr(Trace t, String string, DisplayGroup dispGroup, String title, int pageSeq, int colSeq, int id) {
        AttrTypeString attrType = new AttrTypeString(t, "", pageSeq, dispGroup, colSeq, colSeq, -1, false, false, false, -1, null);
        attrType.setDisplayTitle(title);
        AttrString attrString = new AttrString(t, id, 0, string.trim(), attrType, (IDmObject)this);
        this.attributes.put(id, (Attr)attrString);
    }

    private void addByte(Trace t, byte[] byteArray, DisplayGroup dispGroup, String title, int pageSeq, int colSeq, int id) {
        AttrTypeByteArray attrType = new AttrTypeByteArray(t, "", pageSeq, dispGroup, colSeq, colSeq, -1, false, false, false, -1, null);
        attrType.setDisplayTitle(title);
        AttrByteArray attrByteArray = new AttrByteArray(t, id, 0, byteArray, attrType, (IDmObject)this);
        this.attributes.put(id, (Attr)attrByteArray);
    }

    private AttrByteArray addByteAttr(Trace t, byte[] byteArray, DisplayGroup dispGroup, String title, int pageSeq, int colSeq, int id) {
        AttrTypeByteArray attrType = new AttrTypeByteArray(t, "", pageSeq, dispGroup, colSeq, colSeq, -1, false, false, false, -1, null);
        attrType.setDisplayTitle(title);
        AttrByteArray attrByteArray = new AttrByteArray(t, id, 0, byteArray, attrType, (IDmObject)this);
        this.attributes.put(id, (Attr)attrByteArray);
        return attrByteArray;
    }

    private void addReportMask(Trace t, int option, DisplayGroup dispGroup, String title, int pageSeq, int colSeq, int id) {
        int[] nArray = new int[21];
        nArray[0] = 0x1000000;
        nArray[1] = 0x3000000;
        nArray[2] = 0x7000000;
        nArray[3] = 0x200000;
        nArray[4] = 0x600000;
        nArray[5] = 0xE00000;
        nArray[6] = 256;
        nArray[7] = 768;
        nArray[8] = 1792;
        nArray[9] = 2048;
        nArray[10] = 6144;
        nArray[11] = 14336;
        nArray[12] = 1;
        nArray[13] = 2;
        nArray[15] = 128;
        nArray[17] = 64;
        nArray[19] = 0x8000000;
        AttrTypeBitMask attrType = new AttrTypeBitMask(t, "", pageSeq, dispGroup, colSeq, colSeq, -1, false, false, false, nArray, new String[]{MQBrowsesDataModel.mqro_exception, MQBrowsesDataModel.mqro_exception_with_data, MQBrowsesDataModel.mqro_exception_with_full_data, MQBrowsesDataModel.mqro_expiration, MQBrowsesDataModel.mqro_expiration_with_data, MQBrowsesDataModel.mqro_expiration_with_full_data, MQBrowsesDataModel.mqro_coa, MQBrowsesDataModel.mqro_coa_with_data, MQBrowsesDataModel.mqro_coa_with_full_data, MQBrowsesDataModel.mqro_cod, MQBrowsesDataModel.mqro_cod_with_data, MQBrowsesDataModel.mqro_cod_with_full_data, MQBrowsesDataModel.mqro_pan, MQBrowsesDataModel.mqro_nan, MQBrowsesDataModel.mqro_new_msg_id, MQBrowsesDataModel.mqro_pass_msg_id, MQBrowsesDataModel.mqro_copy_msg_id_to_correl_id, MQBrowsesDataModel.mqro_pass_correl_id, MQBrowsesDataModel.mqro_dead_letter_q, MQBrowsesDataModel.mqro_discard_msg, MQBrowsesDataModel.mqro_none}, new int[]{0x7000000, 0x7000000, 0x7000000, 0xE00000, 0xE00000, 0xE00000, 1792, 1792, 1792, 14336, 14336, 14336, 1, 2, -1, 128, -1, 64, -1, 0x8000000, -1});
        attrType.setDisplayTitle(title);
        AttrInt attrReport = new AttrInt(t, id, 0, option, (AbstractAttrTypeNumber)attrType, (IDmObject)this);
        this.attributes.put(id, (Attr)attrReport);
    }

    private void addFlagsMask(Trace t, int option, DisplayGroup dispGroup, String title, int pageSeq, int colSeq, int id) {
        int[] nArray = new int[7];
        nArray[1] = 1;
        nArray[2] = 8;
        nArray[3] = 16;
        nArray[4] = 2;
        nArray[5] = 4;
        AttrTypeBitMask attrType = new AttrTypeBitMask(t, "", pageSeq, dispGroup, colSeq, colSeq, -1, false, false, false, nArray, new String[]{MQBrowsesDataModel.mqmf_segmentation_inhibited, MQBrowsesDataModel.mqmf_segmentation_allowed, MQBrowsesDataModel.mqmf_msg_in_group, MQBrowsesDataModel.mqmf_last_msg_in_group, MQBrowsesDataModel.mqmf_segment, MQBrowsesDataModel.mqmf_last_segment, MQBrowsesDataModel.mqmf_none}, new int[]{-1, 1, 8, 16, 2, 4, -1});
        attrType.setDisplayTitle(title);
        AttrInt attrFlags = new AttrInt(t, id, 0, option, (AbstractAttrTypeNumber)attrType, (IDmObject)this);
        this.attributes.put(id, (Attr)attrFlags);
    }

    public int actionDelete(Trace t, DmActionListener listener, Object parms) {
        return 0;
    }

    public int actionCreate(Trace t, DmActionListener listener, Object job) {
        return 0;
    }

    public boolean isSystemDefault(Trace t) {
        return false;
    }

    public boolean isEnumerationIdValid(Trace t, int attrId, int enumId) {
        return false;
    }

    public boolean isFilteringSupported(Trace t) {
        return false;
    }

    public int getObjectType(Trace t) {
        return 0;
    }

    public int getObjectSubType(Trace t) {
        return 0;
    }

    public int[] getObjectSubTypes(Trace t) {
        return new int[0];
    }

    public int[] getMandatoryIds(Trace t) {
        return new int[0];
    }

    public Attr createAttribute(Trace t, Object job, int id, int repeatingIndex, Object value) {
        return null;
    }

    public boolean deleteAttribute(Trace t, Object job, int id, int repeatingIndex) {
        return false;
    }

    public int actionChange(Trace t, DmActionListener listener, Object job, boolean force) {
        return 0;
    }

    public String getParentName(Trace t) {
        return null;
    }

    public boolean replaceAttributeValue(Trace t, int id, int index, Object value) {
        return false;
    }

    private String getSymbol(int number) {
        String symbol = null;
        symbol = MQConstants.lookup((int)number, (String)"MQRC_.*");
        if (symbol == null) {
            symbol = MQConstants.lookup((int)number, (String)"MQFB_.*");
        }
        if (symbol == null) {
            symbol = Integer.toString(number);
        }
        return symbol;
    }

    private String getApplTypeString(int applicationType) {
        String data = null;
        switch (applicationType) {
            case -1: {
                data = MQBrowsesDataModel.mqatUnknown;
                break;
            }
            case 0: {
                data = MQBrowsesDataModel.mqatNoContext;
                break;
            }
            case 1: {
                data = MQBrowsesDataModel.mqatCICS;
                break;
            }
            case 2: {
                data = MQBrowsesDataModel.mqatZOS;
                break;
            }
            case 3: {
                data = MQBrowsesDataModel.mqatIMS;
                break;
            }
            case 4: {
                data = MQBrowsesDataModel.mqatOS2;
                break;
            }
            case 6: {
                data = MQBrowsesDataModel.mqatUnix;
                break;
            }
            case 7: {
                data = MQBrowsesDataModel.mqatQmgr;
                break;
            }
            case 8: {
                data = MQBrowsesDataModel.mqatOS400;
                break;
            }
            case 9: {
                data = MQBrowsesDataModel.mqatWindows;
                break;
            }
            case 10: {
                data = MQBrowsesDataModel.mqatCICSVSE;
                break;
            }
            case 11: {
                data = MQBrowsesDataModel.mqatWindowsNT;
                break;
            }
            case 12: {
                data = MQBrowsesDataModel.mqatVMS;
                break;
            }
            case 13: {
                data = MQBrowsesDataModel.mqatNSK;
                break;
            }
            case 14: {
                data = MQBrowsesDataModel.mqatVOS;
                break;
            }
            case 19: {
                data = MQBrowsesDataModel.mqatIMSBridge;
                break;
            }
            case 20: {
                data = MQBrowsesDataModel.mqatXCF;
                break;
            }
            case 21: {
                data = MQBrowsesDataModel.mqatCICSBridge;
                break;
            }
            case 22: {
                data = MQBrowsesDataModel.mqatNotesAgent;
                break;
            }
            case 25: {
                data = MQBrowsesDataModel.mqatUser;
                break;
            }
            case 26: {
                data = MQBrowsesDataModel.mqatQMPublish;
                break;
            }
            case 28: {
                data = MQBrowsesDataModel.mqatJava;
                break;
            }
            case 29: {
                data = MQBrowsesDataModel.mqatDQM;
                break;
            }
            case 30: {
                data = MQBrowsesDataModel.mqatChinit;
                break;
            }
            case 31: {
                data = MQBrowsesDataModel.mqatWLM;
                break;
            }
            case 34: {
                data = MQBrowsesDataModel.mqatSIB;
                break;
            }
            default: {
                String ats = Integer.toString(applicationType);
                data = MQConstants.lookup((int)applicationType, (String)"MQAT_.*");
                data = data == null ? ats : String.valueOf(data) + " (" + ats + ")";
            }
        }
        return data;
    }

    public void initialize(Trace t) {
    }

    public IDmObject clone(Trace t, String name) {
        return null;
    }

    public void initializeWithDefaults(Trace t) {
    }

    public int getNameAttributeId() {
        return -1;
    }

    public int getAttributeDifferenceCount(Trace t, IDmObject second) {
        return 0;
    }
}

