/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.messageplugin.internal.datamodel;

import com.ibm.mq.MQException;
import com.ibm.mq.MQMessage;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.internal.MQCommonServices;
import com.ibm.mq.jmqi.JmqiEnvironment;
import com.ibm.mq.jmqi.system.JmqiCodepage;
import java.io.UnsupportedEncodingException;

public class DLH {
    protected static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.messageplugin.internal/src/com/ibm/mq/explorer/messageplugin/internal/datamodel/DLH.java";
    protected static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    String strucId;
    int version;
    int reason;
    String destQName;
    String destQMgrName;
    int encoding;
    int codedCharSetId;
    String format;
    int putApplType;
    String putApplName;
    String putDate;
    String putTime;
    int msgCharSet;
    int msgEncoding;

    public DLH(Trace t, MQMessage message) throws MQException {
        if (message == null) {
            throw new MQException(2, 2141, (Object)message);
        }
        this.msgCharSet = message.characterSet;
        this.msgEncoding = message.encoding;
        try {
            byte[] tmp = new byte[4];
            message.readFully(tmp, 0, 4);
            this.strucId = this.getString(tmp);
            if (!this.strucId.equals("DLH ")) {
                throw new MQException(2, 2141, (Object)message);
            }
            this.version = message.readInt();
            if (this.version != 1) {
                throw new MQException(2, 2141, (Object)message);
            }
            this.reason = message.readInt();
            tmp = new byte[48];
            message.readFully(tmp, 0, 48);
            this.destQName = this.getString(tmp);
            message.readFully(tmp, 0, 48);
            this.destQMgrName = this.getString(tmp);
            this.encoding = message.readInt();
            this.codedCharSetId = message.readInt();
            tmp = new byte[8];
            message.readFully(tmp, 0, 8);
            this.format = this.getString(tmp);
            this.putApplType = message.readInt();
            tmp = new byte[28];
            message.readFully(tmp, 0, 28);
            this.putApplName = this.getString(tmp);
            tmp = new byte[8];
            message.readFully(tmp, 0, 8);
            this.putDate = this.getString(tmp);
            message.readFully(tmp, 0, 8);
            this.putTime = this.getString(tmp);
        }
        catch (Exception exception) {
            throw new MQException(2, 2141, (Object)message);
        }
    }

    private String getString(byte[] barray) throws UnsupportedEncodingException {
        return new String(barray, DLH.getCharacterSetString(this.msgCharSet, this.msgEncoding));
    }

    static String getCharacterSetString(int charSet, int encoding) {
        String retVal;
        int characterSet = charSet;
        if (characterSet == 0) {
            characterSet = 819;
        }
        if (characterSet % 4096 == 1200) {
            retVal = (encoding & 0xF) == 2 ? "UnicodeLittle" : "UnicodeBig";
        } else {
            String csString = Integer.toString(characterSet);
            retVal = JmqiCodepage.getJmqiCodepage((JmqiEnvironment)MQCommonServices.jmqiEnv, (int)characterSet).charsetId;
            if (retVal == null) {
                retVal = "Cp" + csString;
            }
        }
        return retVal;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("StrucId='" + this.strucId + "'\n");
        buf.append("Version=" + this.version + "\n");
        buf.append("Reason=" + this.reason + "\n");
        buf.append("DestQName='" + this.destQName + "'\n");
        buf.append("DestQMgrName='" + this.destQMgrName + "'\n");
        buf.append("Encoding=" + this.encoding + "\n");
        buf.append("CodedCharSetId=" + this.codedCharSetId + "\n");
        buf.append("Format='" + this.format + "'\n");
        buf.append("PutApplType=" + this.putApplType + "\n");
        buf.append("PutApplName='" + this.putApplName + "'\n");
        buf.append("PutDate='" + this.putDate + "'\n");
        buf.append("PutTime='" + this.putTime + "'");
        return buf.toString();
    }
}

