/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.messageplugin.internal.datamodel;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeInt;
import com.ibm.mq.explorer.core.internal.objects.DisplayGroup;
import com.ibm.mq.explorer.core.internal.utils.CoreServices;
import java.util.Vector;

public class AttrTypeBitMask
extends AttrTypeInt {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.messageplugin.internal/src/com/ibm/mq/explorer/messageplugin/internal/datamodel/AttrTypeBitMask.java";
    private Vector maskVectorInt = null;
    private Vector maskVectorStr = null;
    private Vector maskVectorMsk = null;

    public AttrTypeBitMask(Trace t, String resource_stem, int grpseq, DisplayGroup grp, int distcolseq, int zoscolseq, int pcftype, boolean rep, boolean rw, boolean rwoc, int rwctrl, Object rwswval, int[] keys, String[] values, int[] masks) {
        super(t, resource_stem, grpseq, grp, distcolseq, zoscolseq, pcftype, rep, rw, rwoc, rwctrl, rwswval);
        this.setAttributeType(t, 20);
        if (keys != null && values != null && masks != null) {
            if (keys.length == values.length & keys.length == masks.length) {
                int i = 0;
                while (i < keys.length) {
                    if (resource_stem == null || resource_stem.equals("")) {
                        this.addVector(t, keys[i], values[i], masks[i]);
                    } else {
                        this.addVector(t, keys[i], CoreServices.message.getMessage(t, String.valueOf(values[i]) + ".title"), masks[i]);
                    }
                    ++i;
                }
            }
        } else if (keys == null) {
            // empty if block
        }
    }

    public AttrTypeBitMask(Trace t, String resource_stem, int grpseq, DisplayGroup grp, int distcolseq, int zoscolseq, int pcftype, boolean rep, boolean rw, boolean rwoc, int[] keys, String[] values, int[] masks) {
        this(t, resource_stem, grpseq, grp, distcolseq, zoscolseq, pcftype, rep, rw, rwoc, -1, NO_RWSWITCHVALUE, keys, values, masks);
    }

    private String formatString(Trace t, Attr attr, String sep) {
        Object value = attr.getValue(t);
        int val = (Integer)value;
        String output = "";
        int k = 0;
        while (k < this.maskVectorInt.size()) {
            int rIntval = (Integer)this.maskVectorInt.elementAt(k);
            int rMskval = (Integer)this.maskVectorMsk.elementAt(k);
            if ((rMskval & val) == rIntval) {
                output = output.concat((String)this.maskVectorStr.elementAt(k));
                output = output.concat(sep);
            }
            ++k;
        }
        if (!output.equals("")) {
            output = output.substring(0, output.length() - sep.length());
        }
        return output;
    }

    protected String toString(Trace t, Attr attr) {
        return this.toString(t, attr, false);
    }

    protected String toString(Trace t, Attr attr, boolean ebcdic) {
        String output = this.formatString(t, attr, ", ");
        return output;
    }

    protected String toFormattedString(Trace t, Attr attr) {
        return this.toFormattedString(t, attr, false);
    }

    protected String toFormattedString(Trace t, Attr attr, boolean ebcdic) {
        String output = this.formatString(t, attr, "\n");
        return output;
    }

    private boolean addVector(Trace t, Integer key, String value, Integer mask) {
        if (this.maskVectorInt == null) {
            this.maskVectorInt = new Vector();
            this.maskVectorStr = new Vector();
            this.maskVectorMsk = new Vector();
        }
        try {
            this.maskVectorInt.addElement(key);
            this.maskVectorStr.addElement(value);
            this.maskVectorMsk.addElement(mask);
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        return true;
    }

    public boolean isMultiLine() {
        return true;
    }
}

