/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.messageplugin.internal;

import com.ibm.mq.MQException;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.messageplugin.internal.AccessMQ;
import com.ibm.mq.explorer.messageplugin.internal.MessagePlugin;
import com.ibm.mq.explorer.messageplugin.internal.ProcessResponse;
import com.ibm.mq.explorer.qmgradmin.internal.queues.UiQueue;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.util.Vector;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PutDialog
extends Dialog {
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.messageplugin.internal/src/com/ibm/mq/explorer/messageplugin/internal/PutDialog.java";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    private static final int MIN_DIALOG_HORIZONTAL_SIZE_HINT = 700;
    private static final int MIN_DIALOG_VERTICAL_SIZE_HINT = 20;
    private static String putDialogTitleText = null;
    private static String queueManagerLabelText = null;
    private static String queueLabelText = null;
    private static String putMessageToLabelText = null;
    private static String messageDataLabelText = null;
    private static String closeButtonText = null;
    private static String putButtonText = null;
    private static String messageInfoLabelText = null;
    private Shell parent;
    private Shell shell;
    private Text messageInputText;
    private Button putButton;
    private Button closeButton;
    private UiQueue uiQueue = null;
    private Composite compositeMain;
    private GridLayout gridLayout;
    public static final String UNKNOWN_ALIAS_BASE_Q_ERROR_V6 = "AMQ4197";
    public static final String UNKNOWN_ALIAS_BASE_Q_ERROR_V7 = "AMQ4479";

    public PutDialog(Trace t, Shell argParent) {
        super(argParent);
        this.parent = argParent;
        if (putDialogTitleText == null) {
            Message messageFile = MessagePlugin.getPluginMessages(t);
            putDialogTitleText = messageFile.getMessage(t, "MSG.PutDialogMessageTitle");
            queueManagerLabelText = messageFile.getMessage(t, "MSG.PutQueueManager");
            queueLabelText = messageFile.getMessage(t, "MSG.PutQueue");
            putMessageToLabelText = messageFile.getMessage(t, "MSG.Put.Message.To");
            messageDataLabelText = messageFile.getMessage(t, "MSG.Message.Data");
            putButtonText = messageFile.getMessage(t, "MSG.PutMessage");
            closeButtonText = messageFile.getMessage(t, "MSG.PutClose");
            messageInfoLabelText = messageFile.getMessage(t, "MSG.MessageInfo");
        }
    }

    private void enablePut(Trace t) {
        int charCount = this.messageInputText.getText().length();
        if (charCount > 0) {
            this.putButton.setEnabled(true);
            this.shell.setDefaultButton(this.putButton);
        } else {
            this.putButton.setEnabled(false);
            this.shell.setDefaultButton(this.closeButton);
            this.messageInputText.setFocus();
        }
    }

    public void open(Trace t, UiQueue argUiQueue) {
        this.uiQueue = argUiQueue;
        this.shell = new Shell(this.parent, 68848);
        this.shell.setText(putDialogTitleText);
        this.shell.setImage(this.uiQueue.getImage());
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        this.shell.setLayout((Layout)layout);
        UiPlugin.getHelpSystem().setHelp((Control)this.shell, "com.ibm.mq.explorer.ui.infopop.UI_MessagePutDialog");
        Composite comp = new Composite((Composite)this.shell, 0);
        FillLayout fillLayout = new FillLayout();
        comp.setLayout((Layout)fillLayout);
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        comp.setLayoutData((Object)gridData);
        ScrolledComposite scrolledComposite = new ScrolledComposite(comp, 768);
        this.compositeMain = new Composite((Composite)scrolledComposite, 0);
        scrolledComposite.setContent((Control)this.compositeMain);
        this.gridLayout = new GridLayout();
        this.gridLayout.numColumns = 1;
        this.gridLayout.makeColumnsEqualWidth = false;
        this.gridLayout.marginWidth *= 2;
        this.gridLayout.marginHeight *= 2;
        this.compositeMain.setLayout((Layout)this.gridLayout);
        Group putMsgToGroup = new Group(this.compositeMain, 0);
        putMsgToGroup.setText(putMessageToLabelText);
        gridData = new GridData(772);
        putMsgToGroup.setLayoutData((Object)gridData);
        GridLayout groupLayout = new GridLayout();
        groupLayout.numColumns = 1;
        putMsgToGroup.setLayout((Layout)groupLayout);
        Label queueManagerLabel = new Label((Composite)putMsgToGroup, 0);
        queueManagerLabel.setText(queueManagerLabelText);
        gridData = new GridData(772);
        queueManagerLabel.setLayoutData((Object)gridData);
        Text queueManagerText = new Text((Composite)putMsgToGroup, 2048);
        queueManagerText.setText(this.uiQueue.getDmObject().getQueueManager().toString(t));
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)queueManagerText, (boolean)false);
        gridData = new GridData(260);
        queueManagerText.setLayoutData((Object)gridData);
        Label queueLabel = new Label((Composite)putMsgToGroup, 0);
        queueLabel.setText(queueLabelText);
        gridData = new GridData(260);
        queueLabel.setLayoutData((Object)gridData);
        Text queueText = new Text((Composite)putMsgToGroup, 2048);
        queueText.setText(this.uiQueue.toString());
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)queueText, (boolean)false);
        gridData = new GridData(260);
        queueText.setLayoutData((Object)gridData);
        Label MessageDataLabel = new Label(this.compositeMain, 0);
        MessageDataLabel.setText(messageDataLabelText);
        gridData = new GridData(260);
        MessageDataLabel.setLayoutData((Object)gridData);
        this.messageInputText = new Text(this.compositeMain, 2048);
        this.messageInputText.setFocus();
        gridData = new GridData(260);
        this.messageInputText.setLayoutData((Object)gridData);
        gridData.widthHint = 700;
        if (this.uiQueue.getDmObject().getQueueManager().isLocal()) {
            Group infoGroup = new Group(this.compositeMain, 0);
            putMsgToGroup.setText(putMessageToLabelText);
            gridData = new GridData(772);
            putMsgToGroup.setLayoutData((Object)gridData);
            GridLayout infoLayout = new GridLayout();
            infoLayout.numColumns = 2;
            infoGroup.setLayout((Layout)infoLayout);
            Label imageLabel = new Label((Composite)infoGroup, 0);
            gridData = new GridData(258);
            imageLabel.setLayoutData((Object)gridData);
            ImageRegistry imageRegistry = JFaceResources.getImageRegistry();
            imageLabel.setImage(imageRegistry.get("dialog_messasge_info_image"));
            imageLabel.setImage(imageRegistry.get("dialog_messasge_info_image"));
            Label textLabel = new Label((Composite)infoGroup, 0);
            gridData = new GridData(784);
            textLabel.setLayoutData((Object)gridData);
            textLabel.setText(messageInfoLabelText);
        }
        GridLayout onRightLayout = new GridLayout();
        Composite onRight = new Composite((Composite)this.shell, 0);
        onRightLayout.numColumns = 2;
        onRightLayout.makeColumnsEqualWidth = true;
        onRightLayout.marginWidth = 0;
        onRightLayout.marginHeight = 0;
        onRight.setLayout((Layout)onRightLayout);
        gridData = new GridData(132);
        onRight.setLayoutData((Object)gridData);
        gridData.horizontalSpan = 2;
        this.putButton = new Button(onRight, 8);
        this.putButton.setText(putButtonText);
        this.putButton.setEnabled(false);
        gridData = new GridData(784);
        this.putButton.setLayoutData((Object)gridData);
        this.closeButton = new Button(onRight, 8);
        this.closeButton.setText(closeButtonText);
        gridData = new GridData(784);
        this.closeButton.setLayoutData((Object)gridData);
        this.messageInputText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Trace t2 = Trace.getDefault();
                t2.entry(66, "PutDialog.modifyText");
                PutDialog.this.enablePut(t2);
                t2.exit(66, "PutDialog.modifyText");
            }
        });
        this.putButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Trace t2 = Trace.getDefault();
                t2.entry(66, "PutDialog.widgetSelected");
                PutDialog.this.put(t2, PutDialog.this.messageInputText.getText());
                PutDialog.this.enablePut(t2);
                t2.exit(66, "PutDialog.widgetSelected");
            }
        });
        this.closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PutDialog.this.shell.close();
            }
        });
        this.enablePut(t);
        Point size = this.compositeMain.computeSize(-1, -1);
        scrolledComposite.setMinSize(size);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        this.shell.pack();
        this.shell.open();
        Display display = this.parent.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    private void put(Trace t, String data) {
        try {
            new AccessMQ(t, this.uiQueue, data);
            this.messageInputText.setText("");
        }
        catch (MQException mqe) {
            String errorMsg = null;
            String errorCode = null;
            if (mqe.reasonCode == 2082) {
                if (this.uiQueue.getDmObject().getQueueManager().getCommandLevel() >= 700) {
                    errorMsg = CommonServices.getSystemMessage((Trace)t, (String)UNKNOWN_ALIAS_BASE_Q_ERROR_V7);
                    errorCode = UNKNOWN_ALIAS_BASE_Q_ERROR_V7;
                } else {
                    errorMsg = CommonServices.getSystemMessage((Trace)t, (String)UNKNOWN_ALIAS_BASE_Q_ERROR_V6);
                    errorCode = UNKNOWN_ALIAS_BASE_Q_ERROR_V6;
                }
            } else {
                Vector<String> msgString = ProcessResponse.Getinsert(t, mqe.reasonCode);
                errorMsg = msgString.get(0);
                errorCode = msgString.get(1);
            }
            MessageBox.showMessageFailure((Trace)t, (Shell)UiPlugin.getShell(), (String)errorMsg, (String)errorCode);
        }
    }
}

