/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.messageplugin.internal;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class MessagePlugin
extends AbstractUIPlugin {
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.messageplugin.internal/src/com/ibm/mq/explorer/messageplugin/internal/MessagePlugin.java";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String PLUGIN_ID = "com.ibm.mq.explorer.messageplugin.internal";
    public static final String MESSAGE_PLUGIN = "com.ibm.mq.explorer.messageplugin.internal.MessagePluginStrings";
    protected static final int DEFAULT_MAX_MESSAGE_COUNT = 500;
    protected static final int DEFAULT_MAX_MESSAGE_BYTES_COUNT = 1000;
    public static final String ID_PREFERENCES = "com.ibm.mq.explorer.messageplugin.internal.prefs";
    public static final String PREFER_MAX_MESSAGE_COUNT = "max_message_count";
    public static final String PREFER_MAX_MESSAGE_BYTES_COUNT = "max_message_bytes_count";
    public static final String PREFER_PROPERTY_OPTION_ON_GET = "property_option_on_get";
    public static final String SHOW_HEADERS_SYSPROP = "com.ibm.mq.explorer.messageplugin.internal.showHeaders";
    public static boolean showHeaders = false;
    private static MessagePlugin messagePlugin = null;
    private static Message message = null;
    private ResourceBundle resourceBundle;

    public MessagePlugin() {
        messagePlugin = this;
    }

    public static Message getPluginMessages(Trace t) {
        if (message == null) {
            try {
                ClassLoader classLoader = ((Object)((Object)messagePlugin)).getClass().getClassLoader();
                message = new Message(t, MESSAGE_PLUGIN, classLoader);
            }
            catch (Exception exception) {
                message = new Message(t, MESSAGE_PLUGIN);
            }
        }
        return message;
    }

    public static String getResourceString(Trace t, String key) {
        String messageText;
        ResourceBundle bundle = MessagePlugin.getDefault().getResourceBundle();
        try {
            messageText = bundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            messageText = key;
        }
        return messageText;
    }

    public static MessagePlugin getDefault() {
        return messagePlugin;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        UiPlugin.logStartupData((Trace)Trace.getDefault(), (int)66, (String)"MessagePlugin.start", (Bundle)this.getBundle());
        showHeaders = System.getProperty(SHOW_HEADERS_SYSPROP) != null;
        IPreferenceStore store = UiPlugin.getDefault().getPreferenceStore();
        store.setDefault(PREFER_MAX_MESSAGE_COUNT, 500);
        store.setDefault(PREFER_MAX_MESSAGE_BYTES_COUNT, 1000);
        store.setDefault(PREFER_PROPERTY_OPTION_ON_GET, 0x8000000);
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public int getMaxMessagesCount(Trace t) {
        IPreferenceStore store = UiPlugin.getDefault().getPreferenceStore();
        return store.getInt(PREFER_MAX_MESSAGE_COUNT);
    }

    public int getMaxMessageBytes(Trace t) {
        IPreferenceStore store = UiPlugin.getDefault().getPreferenceStore();
        return store.getInt(PREFER_MAX_MESSAGE_BYTES_COUNT);
    }

    public int getPropertyOptionOnGet(Trace t) {
        IPreferenceStore store = UiPlugin.getDefault().getPreferenceStore();
        return store.getInt(PREFER_PROPERTY_OPTION_ON_GET);
    }
}

