/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.messageplugin.internal;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.ui.extensions.IExplorerRuntimeImportExport;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

public class ExplorerImportExport
implements IExplorerRuntimeImportExport {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.messageplugin.internal/src/com/ibm/mq/explorer/messageplugin/internal/ExplorerImportExport.java";
    public static final String SUBCATEGORY_ID_PREFS_MESSAGES = "com.ibm.mq.explorer.messageplugin.subcategory.prefs";
    protected static final String ROOT_NODE = "MsgPreferences";
    private static final String MSG_NODE = "Msg";
    protected static final String VERSION_KEY = "FileVersion";
    protected static final String THIS_VERSION = "1.0.0";
    private IPreferenceStore preferenceStore = UiPlugin.getPrefStore();

    public boolean importData(String categoryId, String subcategoryId, IMemento rootRead) {
        IMemento child;
        boolean result = false;
        if (categoryId.compareTo("com.ibm.mq.explorer.ui.category.preferences") == 0 && subcategoryId.compareTo(SUBCATEGORY_ID_PREFS_MESSAGES) == 0 && (child = rootRead.getChild(MSG_NODE)) != null) {
            String value = child.getString("max_message_count");
            this.preferenceStore.setValue("max_message_count", value);
            value = child.getString("max_message_bytes_count");
            this.preferenceStore.setValue("max_message_bytes_count", value);
            value = child.getString("property_option_on_get");
            this.preferenceStore.setValue("property_option_on_get", value);
            result = true;
        }
        return result;
    }

    public IMemento exportData(String categoryId, String subcategoryId) {
        Trace t = Trace.getDefault();
        XMLMemento rootWrite = null;
        if (categoryId.compareTo("com.ibm.mq.explorer.ui.category.preferences") == 0 && subcategoryId.compareTo(SUBCATEGORY_ID_PREFS_MESSAGES) == 0) {
            rootWrite = XMLMemento.createWriteRoot((String)ROOT_NODE);
            rootWrite.putString(VERSION_KEY, THIS_VERSION);
            IMemento msgWrite = ExplorerImportExport.openChild(t, (IMemento)rootWrite, MSG_NODE);
            String string = this.preferenceStore.getString("max_message_count");
            msgWrite.putString("max_message_count", string);
            string = this.preferenceStore.getString("max_message_bytes_count");
            msgWrite.putString("max_message_bytes_count", string);
            string = this.preferenceStore.getString("property_option_on_get");
            msgWrite.putString("property_option_on_get", string);
        }
        return rootWrite;
    }

    protected static IMemento openChild(Trace t, IMemento parent, String childName) {
        IMemento child = null;
        child = parent.getChild(childName);
        if (child == null) {
            child = parent.createChild(childName);
        }
        return child;
    }

    public boolean persistData() {
        return true;
    }

    public boolean isDestructiveImport() {
        return true;
    }
}

