/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.messageplugin.internal;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.event.DmActionEvent;
import com.ibm.mq.explorer.core.internal.event.DmActionListener;
import com.ibm.mq.explorer.core.internal.objects.DmQueue;
import com.ibm.mq.explorer.messageplugin.internal.ClearThread;
import com.ibm.mq.explorer.messageplugin.internal.MessagePlugin;
import com.ibm.mq.explorer.messageplugin.internal.ProcessResponse;
import com.ibm.mq.explorer.qmgradmin.internal.queues.UiQueue;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.messagebox.BusyDialog;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.util.Vector;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ClearDialog
extends Dialog
implements DmActionListener {
    protected static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.messageplugin.internal/src/com/ibm/mq/explorer/messageplugin/internal/ClearDialog.java";
    protected static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    private static final int MIN_DIALOG_HORIZONTAL_SIZE_HINT = 475;
    private static String clearDialogTitleString = null;
    private static String queueManagerLabelString = null;
    private static String queueLabelString = null;
    private static String clearTypeString = null;
    private static String clearCmdButtonString = null;
    private static String clearGetButtonString = null;
    private static String clearButtonString = null;
    private static String closeButtonString = null;
    private static String busyCmdString = null;
    private static String busyGetString = null;
    private UiQueue uiQueue = null;
    private Shell parent;
    private Shell shell;
    private Composite compositeMain;
    private GridLayout gridLayout;
    private Button clearCmdButton;
    private Button clearGetButton;
    private Button clearButton;
    private Button closeButton;
    private Label queueManagerLabel;
    private Label queueLabel;
    private Text queueManagerNameText;
    private Text queueNameText;
    private BusyDialog clearBox = null;
    public static final String QUEUE_CLEARED = "AMQ4011";

    public ClearDialog(Trace t, Shell argParent) {
        super(argParent);
        this.parent = argParent;
        if (clearDialogTitleString == null) {
            Message messageFile = MessagePlugin.getPluginMessages(t);
            clearDialogTitleString = messageFile.getMessage(t, "MSG.Clear.Queue");
            clearTypeString = messageFile.getMessage(t, "MSG.Clear.Type");
            queueManagerLabelString = messageFile.getMessage(t, "MSG.ClearQueueManager");
            queueLabelString = messageFile.getMessage(t, "MSG.ClearQueue");
            clearCmdButtonString = messageFile.getMessage(t, "MSG.ClearCmd.Button.Text");
            clearGetButtonString = messageFile.getMessage(t, "MSG.ClearGet.Button.Text");
            clearButtonString = messageFile.getMessage(t, "MSG.ClearClear");
            closeButtonString = messageFile.getMessage(t, "MSG.ClearClose");
            busyCmdString = messageFile.getMessage(t, "MSG.ClearCmdBusy");
            busyGetString = messageFile.getMessage(t, "MSG.ClearGetBusy");
        }
    }

    public void open(Trace t, UiQueue queue) {
        this.uiQueue = queue;
        this.shell = new Shell(this.parent, 68848);
        this.shell.setText(clearDialogTitleString);
        this.shell.setImage(this.uiQueue.getImage());
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth *= 2;
        layout.marginHeight *= 2;
        this.shell.setLayout((Layout)layout);
        UiPlugin.getHelpSystem().setHelp((Control)this.shell, "com.ibm.mq.explorer.ui.infopop.UI_MessageClearDialog");
        Composite comp = new Composite((Composite)this.shell, 0);
        FillLayout fillLayout = new FillLayout();
        comp.setLayout((Layout)fillLayout);
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        comp.setLayoutData((Object)gridData);
        ScrolledComposite scrolledComposite = new ScrolledComposite(comp, 768);
        this.compositeMain = new Composite((Composite)scrolledComposite, 0);
        scrolledComposite.setContent((Control)this.compositeMain);
        this.gridLayout = new GridLayout(1, false);
        this.gridLayout.marginWidth *= 2;
        this.gridLayout.marginHeight *= 2;
        this.compositeMain.setLayout((Layout)this.gridLayout);
        Composite qInfo = new Composite(this.compositeMain, 0);
        GridLayout statusGridLayout = new GridLayout(2, false);
        statusGridLayout.marginWidth = 0;
        statusGridLayout.marginHeight = 0;
        qInfo.setLayout((Layout)statusGridLayout);
        gridData = new GridData(36);
        qInfo.setLayoutData((Object)gridData);
        this.queueManagerLabel = new Label(qInfo, 8);
        this.queueManagerLabel.setText(queueManagerLabelString);
        this.queueManagerNameText = new Text(qInfo, 8);
        this.queueManagerNameText.setText(this.uiQueue.getDmObject().getQueueManager().toString(t));
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)this.queueManagerNameText, (boolean)false);
        this.queueLabel = new Label(qInfo, 8);
        this.queueLabel.setText(queueLabelString);
        this.queueNameText = new Text(qInfo, 8);
        this.queueNameText.setText(this.uiQueue.toString());
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)this.queueNameText, (boolean)false);
        Label pad = new Label(qInfo, 0);
        pad.setText("");
        Group clearTypeGroup = new Group(this.compositeMain, 0);
        clearTypeGroup.setText(clearTypeString);
        gridData = new GridData(772);
        clearTypeGroup.setLayoutData((Object)gridData);
        gridData.widthHint = 475;
        GridLayout clearTypeGroupLayout = new GridLayout(1, false);
        clearTypeGroup.setLayout((Layout)clearTypeGroupLayout);
        GridLayout componentGridLayout = new GridLayout();
        Composite clrComponent = new Composite((Composite)clearTypeGroup, 0);
        componentGridLayout.numColumns = 1;
        componentGridLayout.marginWidth = 0;
        componentGridLayout.marginHeight = 0;
        clrComponent.setLayout((Layout)componentGridLayout);
        gridData = new GridData(132);
        clrComponent.setLayoutData((Object)gridData);
        this.clearCmdButton = new Button(clrComponent, 16);
        this.clearCmdButton.setText(clearCmdButtonString);
        this.clearCmdButton.setSelection(true);
        this.clearGetButton = new Button(clrComponent, 16);
        this.clearGetButton.setText(clearGetButtonString);
        this.clearGetButton.setSelection(false);
        if (this.uiQueue.testAttribute((Object)this.uiQueue.getExternalObject(), "ConnectionType", "Indirect")) {
            this.clearGetButton.setEnabled(false);
        }
        GridLayout onRightLayout = new GridLayout();
        Composite onRight = new Composite((Composite)this.shell, 0);
        onRightLayout.numColumns = 2;
        onRightLayout.makeColumnsEqualWidth = true;
        onRightLayout.marginWidth = 0;
        onRightLayout.marginHeight = 0;
        onRight.setLayout((Layout)onRightLayout);
        gridData = new GridData(132);
        onRight.setLayoutData((Object)gridData);
        gridData.horizontalSpan = 2;
        this.clearButton = new Button(onRight, 8);
        this.clearButton.setText(clearButtonString);
        gridData = new GridData(784);
        this.clearButton.setLayoutData((Object)gridData);
        this.closeButton = new Button(onRight, 8);
        this.closeButton.setText(closeButtonString);
        this.closeButton.setFocus();
        gridData = new GridData(784);
        this.closeButton.setLayoutData((Object)gridData);
        this.clearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Trace t2 = Trace.getDefault();
                ClearDialog.this.clear(t2);
                ClearDialog.this.shell.close();
            }
        });
        this.closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ClearDialog.this.shell.close();
            }
        });
        this.shell.setDefaultButton(this.closeButton);
        Point size = this.compositeMain.computeSize(-1, -1);
        scrolledComposite.setMinSize(size);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        this.shell.pack();
        UiUtils.makeShellCenteredOnParent((Trace)t, (Shell)this.parent, (Shell)this.shell);
        this.shell.open();
        Display display = this.parent.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public void clear(Trace t) {
        if (this.clearCmdButton.getSelection()) {
            int returnCode = 0;
            this.clearBox = new BusyDialog(UiPlugin.getShell(), busyCmdString);
            DmQueue dmQueue = (DmQueue)this.uiQueue.getDmObject();
            returnCode = dmQueue.actionClear(t, (DmActionListener)this);
            if (returnCode == 0) {
                this.clearBox.showDialog(t);
            } else {
                Vector<String> msgString = ProcessResponse.Getinsert(t, returnCode, this.queueManagerNameText.getText());
                MessageBox.showMessageFailure((Trace)t, (Shell)UiPlugin.getShell(), (String)msgString.elementAt(0), (String)msgString.elementAt(1));
            }
        } else {
            this.clearBox = new BusyDialog(UiPlugin.getShell(), busyGetString);
            ClearThread ct = new ClearThread(t, this.uiQueue, this);
            ct.start();
            this.clearBox.showDialog(t);
            UiPlugin.refreshContentViews((Trace)t, null);
        }
    }

    public void dmActionDone(DmActionEvent event) {
        final Trace t = Trace.getDefault();
        final int rc = event.getReasonCode();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Trace trace = Trace.getDefault();
                ClearDialog.this.clearBox.closeDialog(trace);
                if (rc == 0) {
                    MessageBox.showSystemMessageById((Trace)t, (Shell)UiPlugin.getShell(), (String)ClearDialog.QUEUE_CLEARED);
                } else {
                    Vector<String> msgString = ProcessResponse.Getinsert(t, rc, ClearDialog.this.queueManagerNameText.getText());
                    MessageBox.showMessageFailure((Trace)t, (Shell)UiPlugin.getShell(), (String)msgString.elementAt(0), (String)msgString.elementAt(1));
                }
            }
        });
    }

    public void cdActionDone(int reasoncode) {
        final Trace t = Trace.getDefault();
        final int rc = reasoncode;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Trace trace = Trace.getDefault();
                ClearDialog.this.clearBox.closeDialog(trace);
                if (rc == 2033) {
                    MessageBox.showSystemMessageById((Trace)t, (Shell)UiPlugin.getShell(), (String)ClearDialog.QUEUE_CLEARED);
                } else {
                    Vector<String> msgString = ProcessResponse.Getinsert(t, rc, ClearDialog.this.queueManagerNameText.getText());
                    MessageBox.showMessageFailure((Trace)t, (Shell)UiPlugin.getShell(), (String)msgString.elementAt(0), (String)msgString.elementAt(1));
                }
            }
        });
    }
}

