/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.messageplugin.internal;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.messageplugin.internal.BrowseThread;
import com.ibm.mq.explorer.messageplugin.internal.MQBrowse;
import com.ibm.mq.explorer.messageplugin.internal.MQBrowseAttributeDetails;
import com.ibm.mq.explorer.messageplugin.internal.MessagePlugin;
import com.ibm.mq.explorer.messageplugin.internal.ProcessResponse;
import com.ibm.mq.explorer.messageplugin.internal.datamodel.DmBrowse;
import com.ibm.mq.explorer.messageplugin.internal.datamodel.MQBrowsesDataModel;
import com.ibm.mq.explorer.qmgradmin.internal.queues.UiQueue;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrderManager;
import com.ibm.mq.explorer.ui.internal.attributeorder.IAttributeDetails;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTable;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTableSelectionChangedEvent;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTableSelectionChangedListener;
import com.ibm.mq.explorer.ui.internal.messagebox.BusyDialog;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.text.MessageFormat;
import java.util.Vector;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;

public class BrowseDialog
extends TrayDialog
implements ExplorerTableSelectionChangedListener {
    protected static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.messageplugin.internal/src/com/ibm/mq/explorer/messageplugin/internal/BrowseDialog.java";
    protected static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    protected static final int MIN_EXPLORER_WIDTH_HINT = 700;
    private static final int TABLE_ROWS_HINT = 15;
    private static String browsedialogTitleText = null;
    private static String queueManagerLabelText = null;
    private static String queueLabelText = null;
    private static String refreshButtonText = null;
    private static String browsedAllMessagesText = null;
    private static String incompleteBrowsedMaxMessagesText = null;
    private static String browsedMaxMessagesText = null;
    private static String browsedMaxMessageLengthText = null;
    private static String browsedHeaderTruncatedText = null;
    private static String previousSelectionNonSpecificText = null;
    private static String noMessagesText = null;
    private static String attrOrderNameText = null;
    private static String busyBrowseString = null;
    private UiQueue uiQueue = null;
    private Composite compositeMain;
    private GridLayout gridLayout;
    private Text infoDataText;
    private static MQBrowsesDataModel dataModel = null;
    private ExplorerTable explorerTable;
    private MQBrowseAttributeDetails attrDetails = new MQBrowseAttributeDetails();
    private BusyDialog browseBox = null;
    private int maxMessagesCount;

    public BrowseDialog(Trace t, Shell argParent) {
        super(argParent);
        if (browsedialogTitleText == null) {
            Message messageFile = MessagePlugin.getPluginMessages(t);
            browsedialogTitleText = messageFile.getMessage(t, "MSG.Message.Browser");
            queueManagerLabelText = messageFile.getMessage(t, "MSG.BrowseQueueManager");
            queueLabelText = messageFile.getMessage(t, "MSG.BrowseQueue");
            refreshButtonText = messageFile.getMessage(t, "MSG.BrowseRefresh");
            browsedAllMessagesText = messageFile.getMessage(t, "MSG.browsedAllMessagesText");
            incompleteBrowsedMaxMessagesText = messageFile.getMessage(t, "MSG.browsedMaxMessagesText");
            noMessagesText = messageFile.getMessage(t, "MSG.noMessagesText");
            browsedMaxMessageLengthText = messageFile.getMessage(t, "MSG.browsedMaxMessageLength");
            browsedHeaderTruncatedText = messageFile.getMessage(t, "MSG.browsedHeaderTruncated");
            attrOrderNameText = messageFile.getMessage(t, "MSG.attrOrderNameText");
            busyBrowseString = messageFile.getMessage(t, "MSG.BrowseBusy");
        }
        this.maxMessagesCount = MessagePlugin.getDefault().getMaxMessagesCount(t);
        Object[] inserts = new String[]{Integer.toString(this.maxMessagesCount)};
        browsedMaxMessagesText = MessageFormat.format(incompleteBrowsedMaxMessagesText, inserts);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(browsedialogTitleText);
        newShell.setImage(this.uiQueue.getImage());
        UiPlugin.getHelpSystem().setHelp((Control)newShell, "com.ibm.mq.explorer.ui.infopop.UI_MessageBrowseDialog");
    }

    public void open(Trace t, UiQueue queue) {
        this.uiQueue = queue;
        dataModel = new MQBrowsesDataModel(t, this.uiQueue);
        this.open();
    }

    public Control createDialogArea(Composite parent) {
        Trace t = Trace.getDefault();
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite comp = new Composite(composite, 0);
        FillLayout fillLayout = new FillLayout();
        comp.setLayout((Layout)fillLayout);
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        comp.setLayoutData((Object)gridData);
        ScrolledComposite scrolledComposite = new ScrolledComposite(comp, 768);
        this.compositeMain = new Composite((Composite)scrolledComposite, 0);
        scrolledComposite.setContent((Control)this.compositeMain);
        this.gridLayout = new GridLayout();
        this.gridLayout.numColumns = 2;
        this.gridLayout.makeColumnsEqualWidth = false;
        this.compositeMain.setLayout((Layout)this.gridLayout);
        Label queueManagerLabel = new Label(this.compositeMain, 0);
        queueManagerLabel.setText(queueManagerLabelText);
        gridData = new GridData(4);
        queueManagerLabel.setLayoutData((Object)gridData);
        Text queueManagerText = new Text(this.compositeMain, 0);
        queueManagerText.setText(this.uiQueue.getDmObject().getQueueManager().toString(t));
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)queueManagerText, (boolean)false);
        gridData = new GridData(772);
        queueManagerText.setLayoutData((Object)gridData);
        Label queueLabel = new Label(this.compositeMain, 0);
        queueLabel.setText(queueLabelText);
        gridData = new GridData(4);
        queueLabel.setLayoutData((Object)gridData);
        Text queueText = new Text(this.compositeMain, 0);
        queueText.setText(this.uiQueue.toString());
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)queueText, (boolean)false);
        gridData = new GridData(772);
        queueText.setLayoutData((Object)gridData);
        this.explorerTable = new ExplorerTable(t, this.compositeMain, 0, "MQBrowses", false, true, true, true, (Object)"com.ibm.mq.explorer.messageplugin.internal.MessagePluginStrings");
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 2;
        gridData.widthHint = 700;
        gridData.heightHint = this.explorerTable.calculateHeight(t, 15, true);
        this.explorerTable.setLayoutData((Object)gridData);
        this.explorerTable.setObjectId(t, "com.ibm.mq.explorer.messageplugin.internal.mqbrowse");
        AttributeOrderManager attrOrderManager = UiPlugin.getAttributeOrderManager();
        attrOrderManager.register(t, (IAttributeDetails)this.attrDetails, "com.ibm.mq.explorer.messageplugin.internal.mqbrowse", "com.ibm.mq.explorer.messageplugin.internal.mqbrowse", attrOrderNameText, MQBrowsesDataModel.getDefaultAttributeOrder(t));
        this.explorerTable.setAttributeOrderId(t, "com.ibm.mq.explorer.messageplugin.internal.mqbrowse");
        this.explorerTable.setInstance(t, this.uiQueue.getDmObject().getQueueManager().getTreeName(t), false);
        this.explorerTable.setViewPart(t, (ViewPart)UiPlugin.getMQNavigatorView());
        this.explorerTable.addSelChangedListener(t, (ExplorerTableSelectionChangedListener)this);
        Composite infoComposite = new Composite(this.compositeMain, 0);
        gridData = new GridData(772);
        infoComposite.setLayoutData((Object)gridData);
        gridData.horizontalSpan = 2;
        GridLayout infoGroupLayout = new GridLayout();
        infoGroupLayout.numColumns = 2;
        infoComposite.setLayout((Layout)infoGroupLayout);
        Label imageLabel = new Label(infoComposite, 0);
        gridData = new GridData(258);
        imageLabel.setLayoutData((Object)gridData);
        ImageRegistry imageRegistry = JFaceResources.getImageRegistry();
        imageLabel.setImage(imageRegistry.get("dialog_messasge_info_image"));
        imageLabel.setImage(imageRegistry.get("dialog_messasge_info_image"));
        this.infoDataText = new Text(infoComposite, 2048);
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)this.infoDataText, (boolean)false);
        gridData = new GridData(768);
        this.infoDataText.setLayoutData((Object)gridData);
        this.refresh(t);
        if (MQBrowsesDataModel.mqBrowseFailed) {
            Vector<String> msgString = ProcessResponse.Getinsert(t, MQBrowsesDataModel.mqBrowseRC);
            MessageBox.showMessageFailure((Trace)t, (Shell)UiPlugin.getShell(), (String)msgString.elementAt(0), (String)msgString.elementAt(1));
        }
        this.explorerTable.setFocus();
        Point size = this.compositeMain.computeSize(-1, -1);
        scrolledComposite.setMinSize(size);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, refreshButtonText, false);
        Button close = this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, true);
        close.setFocus();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 12) {
            this.okPressed();
        } else {
            Trace t2 = Trace.getDefault();
            this.refresh(t2);
            if (MQBrowsesDataModel.mqBrowseFailed) {
                Vector<String> msgString = ProcessResponse.Getinsert(t2, MQBrowsesDataModel.mqBrowseRC);
                MessageBox.showMessageFailure((Trace)t2, (Shell)UiPlugin.getShell(), (String)msgString.elementAt(0), (String)msgString.elementAt(1));
            }
        }
    }

    public void refresh(Trace t) {
        this.browseBox = new BusyDialog(UiPlugin.getShell(), busyBrowseString);
        BrowseThread bt = new BrowseThread(t, this.explorerTable, this.uiQueue, this);
        bt.start();
        this.browseBox.showDialog(t);
    }

    public void bdActionDone(int messageCount) {
        Trace t = Trace.getDefault();
        final int mcount = messageCount;
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Trace trace = Trace.getDefault();
                if (mcount == BrowseDialog.this.maxMessagesCount) {
                    BrowseDialog.this.infoDataText.setText(browsedMaxMessagesText);
                } else {
                    switch (mcount) {
                        case 0: {
                            BrowseDialog.this.infoDataText.setText(noMessagesText);
                            break;
                        }
                        default: {
                            BrowseDialog.this.infoDataText.setText(browsedAllMessagesText);
                        }
                    }
                }
                BrowseDialog.this.browseBox.closeDialog(trace);
            }
        });
        this.explorerTable.asyncEndUpdate(t);
    }

    public static MQBrowsesDataModel getDataModel() {
        return dataModel;
    }

    public MQBrowsesDataModel refreshDataModel(Trace t, UiQueue _uiQueue, boolean getMsgs) {
        dataModel.refresh(t);
        return dataModel;
    }

    public void close(Trace t) {
        if (dataModel != null) {
            dataModel.close(t);
        }
    }

    public void selChanged(ExplorerTableSelectionChangedEvent event) {
        MQBrowse browse;
        Trace t = Trace.getDefault();
        if (previousSelectionNonSpecificText == null) {
            previousSelectionNonSpecificText = this.infoDataText.getText();
        }
        if (event.getObject() instanceof MQBrowse && (browse = (MQBrowse)event.getObject()).getDmObject() instanceof DmBrowse) {
            DmBrowse dmBrowse = (DmBrowse)browse.getDmObject();
            String messageLengthAttr = dmBrowse.getAttributeValue(t, 2005, 0);
            try {
                int msgLength = Integer.parseInt(messageLengthAttr);
                if (dmBrowse.headerTruncated) {
                    this.infoDataText.setText(browsedHeaderTruncatedText);
                } else if (msgLength > MessagePlugin.getDefault().getMaxMessageBytes(t)) {
                    this.infoDataText.setText(browsedMaxMessageLengthText);
                } else {
                    this.infoDataText.setText(previousSelectionNonSpecificText);
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }
}

