/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.messageplugin.internal;

import com.ibm.mq.MQException;
import com.ibm.mq.MQGetMessageOptions;
import com.ibm.mq.MQMessage;
import com.ibm.mq.MQPutMessageOptions;
import com.ibm.mq.MQQueue;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.constants.CMQC;
import com.ibm.mq.explorer.core.internal.objects.DmMQQueueManager;
import com.ibm.mq.explorer.messageplugin.internal.MessagePlugin;
import com.ibm.mq.explorer.qmgradmin.internal.queues.UiQueue;
import com.ibm.mq.pcf.CCSID;
import java.io.IOException;

public class AccessMQ {
    protected static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.messageplugin.internal/src/com/ibm/mq/explorer/messageplugin/internal/AccessMQ.java";
    protected static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    private MQQueueManager queueManager;
    private MQQueue queue;
    protected static int BROWSE_DEFAULT_MAX_MESSAGE_SIZE = 4096;
    private byte[] lastMessageToken = CMQC.MQMTOK_NONE;

    public AccessMQ(Trace t, UiQueue uiQueue) throws MQException {
        this.open(t, uiQueue, 8);
    }

    public AccessMQ(Trace t, UiQueue uiQueue, int openOptions) throws MQException {
        this.open(t, uiQueue, openOptions);
    }

    public AccessMQ(Trace t, UiQueue uiQueue, String data) throws MQException {
        this.open(t, uiQueue, 16);
        try {
            this.put(t, data);
        }
        finally {
            this.close(t);
        }
    }

    public MQMessage browse(Trace t) throws MQException {
        return this.browse(t, 32);
    }

    public MQMessage browse(Trace t, int browseOption) throws MQException {
        return this.browse(t, 32, BROWSE_DEFAULT_MAX_MESSAGE_SIZE);
    }

    public MQMessage browse(Trace t, int browseOption, int maxMsgSize) throws MQException {
        MQMessage browseMessage;
        block4: {
            MQGetMessageOptions gmo = new MQGetMessageOptions();
            gmo.options = browseOption + 64;
            if (this.queueManager != null && this.queueManager.getCommandLevel() >= 700) {
                int preferredPropertyGetOption = MessagePlugin.getDefault().getPropertyOptionOnGet(t);
                gmo.options |= preferredPropertyGetOption;
            }
            browseMessage = new MQMessage();
            try {
                this.lastMessageToken = CMQC.MQMTOK_NONE;
                this.queue.get(browseMessage, gmo, maxMsgSize);
                if (this.queueManager != null && this.queueManager.getCommandLevel() >= 700) {
                    this.lastMessageToken = (byte[])gmo.msgToken.clone();
                }
            }
            catch (MQException mqe) {
                if (mqe.reasonCode == 2079) break block4;
                throw mqe;
            }
        }
        return browseMessage;
    }

    public void close(Trace t) {
        try {
            this.queue.close();
            this.queueManager.disconnect();
        }
        catch (MQException mQException) {
            this.queueManager = null;
        }
    }

    private void open(Trace t, UiQueue uiQueue, int openOptions) throws MQException {
        DmMQQueueManager dmMQQueueManager = uiQueue.getDmObject().getQueueManager().getNewConnection(t);
        dmMQQueueManager.connect(t);
        try {
            dmMQQueueManager.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.queueManager = dmMQQueueManager.getQueueManager(t);
        try {
            this.queue = this.queueManager.accessQueue(uiQueue.toString(), openOptions);
        }
        catch (MQException mqe) {
            this.queueManager.disconnect();
            throw mqe;
        }
        catch (NullPointerException nullPointerException) {
            throw new MQException(2, 2059, (Object)this);
        }
    }

    private void put(Trace t, String data) throws MQException {
        int defaultCCSID = 1208;
        int defaultEncoding = 546;
        byte[] dataArray = null;
        MQPutMessageOptions pmo = new MQPutMessageOptions();
        MQMessage message = new MQMessage();
        try {
            String msgCharSet = CCSID.getCharSet((int)defaultCCSID, (int)defaultEncoding);
            dataArray = data.getBytes(msgCharSet);
            message.encoding = defaultEncoding;
            message.characterSet = defaultCCSID;
        }
        catch (Throwable throwable) {
            dataArray = data.getBytes();
        }
        try {
            message.write(dataArray);
            message.format = "MQSTR   ";
            this.queue.put(message, pmo);
        }
        catch (IOException iOException) {}
    }

    public MQMessage get(Trace t) throws MQException {
        MQMessage getMessage;
        block3: {
            MQGetMessageOptions gmo = new MQGetMessageOptions();
            gmo.options = 8260;
            getMessage = new MQMessage();
            try {
                this.lastMessageToken = CMQC.MQMTOK_NONE;
                this.queue.get(getMessage, gmo);
                if (this.queueManager != null && this.queueManager.getCommandLevel() >= 700) {
                    this.lastMessageToken = (byte[])gmo.msgToken.clone();
                }
            }
            catch (MQException mqe) {
                if (mqe.reasonCode == 2079) break block3;
                throw mqe;
            }
        }
        return getMessage;
    }

    public byte[] getLastMessageToken() {
        return this.lastMessageToken;
    }
}

