/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.tests.coretests.security.internal.tests;

import com.ibm.mq.MQException;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.tests.WMQTest;
import com.ibm.mq.explorer.tests.coretests.security.SecurityTestsPlugin;
import com.ibm.mq.explorer.tests.internal.actions.WMQTestEngine;
import com.ibm.mq.explorer.tests.internal.objects.WMQTestResult;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.MQQmgrExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import com.ibm.mq.pcf.MQCFIL;
import com.ibm.mq.pcf.MQCFIN;
import com.ibm.mq.pcf.MQCFST;
import com.ibm.mq.pcf.PCFMessage;
import com.ibm.mq.pcf.PCFMessageAgent;
import com.ibm.mq.pcf.PCFParameter;
import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.core.runtime.IProgressMonitor;

public class VerifySSLCipherSpec
extends WMQTest {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.tests.coretests.security/src/com/ibm/mq/explorer/tests/coretests/security/internal/tests/VerifySSLCipherSpec.java";
    private static final String DEPRECATED_CIPHER_SPEC = "VerifySSLCipherSpec.deprecated";
    private static final String WEAK_HASHING_ALGORITHM = "VerifySSLCipherSpec.weakHashingAlgorithm";
    private static final String NO_ENCRYPTION_CHANNEL = "VerifySSLCipherSpec.noEncryptionChannel";

    public void runTest(WMQTestEngine callback, IProgressMonitor guimonitor, MQExtObject[] contextObjects, TreeNode treenode) {
        Trace t = Trace.getDefault();
        super.runTest(callback, guimonitor, contextObjects, treenode);
        ArrayList<WMQTestResult> testresults = new ArrayList<WMQTestResult>();
        String errorMessage = null;
        guimonitor.beginTask(this.getTestName(), -1);
        int i = 0;
        while (i < contextObjects.length) {
            block14: {
                this.getGUIMonitor().worked(1);
                if (contextObjects[i] instanceof MQQmgrExtObject) {
                    MQQmgrExtObject nextQmgr = (MQQmgrExtObject)contextObjects[i];
                    if (nextQmgr != null) {
                        MQQueueManager qmgr = nextQmgr.getMQQueueManager();
                        if (qmgr.isConnected()) {
                            try {
                                String qmgrName = qmgr.getName();
                                if (Trace.isTracing) {
                                    t.data(66, "VerifySSLCipherSpec.runTest", 300, "Testing queue manager : " + qmgrName);
                                }
                                PCFMessageAgent agent = null;
                                agent = new PCFMessageAgent(qmgr);
                                Hashtable<String, String> cipherSpecs = this.getCipherSpecs(t, agent, qmgr);
                                for (String channelName : cipherSpecs.keySet()) {
                                    WMQTestResult testResult;
                                    String cipherSpec = cipherSpecs.get(channelName).trim();
                                    channelName = channelName.trim();
                                    if (cipherSpec.equals("FIPS_WITH_DES_CBC_SHA") || cipherSpec.equals("FIPS_WITH_3DES_EDE_CBC_SHA")) {
                                        errorMessage = SecurityTestsPlugin.testMessages.getMessage(DEPRECATED_CIPHER_SPEC, new String[]{cipherSpec, channelName});
                                        testResult = new WMQTestResult(1, errorMessage, qmgrName, this.getTestSubCategory());
                                        testresults.add(testResult);
                                    }
                                    if (cipherSpec.equals("NULL_MD5") || cipherSpec.equals("RC2_MD5_EXPORT") || cipherSpec.equals("RC4_MD5_EXPORT") || cipherSpec.equals("RC4_MD5_US") || cipherSpec.equals("TLS_RSA_EXPORT_WITH_RC2_40_MD5") || cipherSpec.equals("TLS_RSA_EXPORT_WITH_RC4_40_MD5") || cipherSpec.equals("TLS_RSA_WITH_NULL_MD5") || cipherSpec.equals("TLS_RSA_WITH_RC4_128_MD5")) {
                                        errorMessage = SecurityTestsPlugin.testMessages.getMessage(WEAK_HASHING_ALGORITHM, new String[]{cipherSpec, channelName});
                                        testResult = new WMQTestResult(1, errorMessage, qmgrName, this.getTestSubCategory());
                                        testresults.add(testResult);
                                    }
                                    if (!cipherSpec.equals("ECDHE_ECDSA_NULL_SHA256") && !cipherSpec.equals("ECDHE_RSA_NULL_SHA256") && !cipherSpec.equals("NULL_MD5") && !cipherSpec.equals("NULL_SHA") && !cipherSpec.equals("TLS_RSA_WITH_NULL_MD5") && !cipherSpec.equals("TLS_RsA_WITH_NULL_NULL") && !cipherSpec.equals("TLS_RSA_WITH_NULL_SHA") && !cipherSpec.equals("TLS_RSA_WITH_NULL_SHA256")) continue;
                                    errorMessage = SecurityTestsPlugin.testMessages.getMessage(NO_ENCRYPTION_CHANNEL, new String[]{cipherSpec, channelName});
                                    testResult = new WMQTestResult(1, errorMessage, qmgrName, this.getTestSubCategory());
                                    testresults.add(testResult);
                                }
                                break block14;
                            }
                            catch (MQException qE) {
                                if (Trace.isTracing) {
                                    t.data(66, "VerifySSLCipherSpec.runTest", 900, "Error getting from queue manager\n" + (Object)((Object)qE));
                                }
                                break block14;
                            }
                        }
                        if (Trace.isTracing) {
                            t.data(66, "VerifySSLCipherSpec.runTest", 900, "Qmgr is not connected : " + contextObjects[i].getName());
                        }
                    }
                } else if (Trace.isTracing) {
                    t.data(66, "VerifySSLCipherSpec.runTest", 900, "Not an MQQmgrExtObject : " + contextObjects[i].getName());
                }
            }
            ++i;
        }
        WMQTestResult[] finalresults = testresults.toArray(new WMQTestResult[testresults.size()]);
        this.testComplete(finalresults);
    }

    private Hashtable<String, String> getCipherSpecs(Trace t, PCFMessageAgent agent, MQQueueManager qmgr) {
        Hashtable<String, String> sslCipherSpecs;
        block8: {
            PCFMessage[] response;
            block7: {
                PCFMessage request = new PCFMessage(25);
                request.addParameter((PCFParameter)new MQCFST(3501, "*"));
                request.addParameter((PCFParameter)new MQCFIN(1511, 5));
                request.addParameter((PCFParameter)new MQCFIL(1015, new int[]{3501, 3544}));
                sslCipherSpecs = new Hashtable<String, String>();
                response = null;
                try {
                    if (Trace.isTracing) {
                        t.data(66, "VerifySSLCipherSpec.getCipherSpecs", 300, "Sending command to " + agent.getQManagerName());
                    }
                    response = agent.send(request);
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                    if (!Trace.isTracing) break block7;
                    t.data(66, "VerifySSLCipherSpec.getCipherSpecs", 900, "Error from send command\n" + e);
                }
            }
            try {
                if (response != null) {
                    int j = 0;
                    while (j < response.length) {
                        String channelName = response[j].getStringParameterValue(3501);
                        String cipherSpec = response[j].getStringParameterValue(3544);
                        sslCipherSpecs.put(channelName, cipherSpec);
                        ++j;
                    }
                }
            }
            catch (MQException e) {
                if (!Trace.isTracing) break block8;
                t.data(66, "VerifySSLCipherSpec.getCipherSpecs", 900, "Error during response processing\n" + (Object)((Object)e));
            }
        }
        return sslCipherSpecs;
    }
}

