/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.tests.coretests.security.internal.tests;

import com.ibm.mq.MQException;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.tests.PreferenceStoreManager;
import com.ibm.mq.explorer.tests.coretests.internal.objects.WMQInternalTest;
import com.ibm.mq.explorer.tests.coretests.security.SecurityTestsPlugin;
import com.ibm.mq.explorer.tests.internal.actions.WMQTestEngine;
import com.ibm.mq.explorer.tests.internal.objects.WMQTestResult;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.MQQmgrExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import com.ibm.mq.pcf.MQCFIL;
import com.ibm.mq.pcf.MQCFST;
import com.ibm.mq.pcf.PCFMessage;
import com.ibm.mq.pcf.PCFMessageAgent;
import com.ibm.mq.pcf.PCFParameter;
import com.ibm.mq.pcf.event.PCFQuery;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

public class VerifyPasswordAuth
extends WMQInternalTest {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.tests.coretests.security/src/com/ibm/mq/explorer/tests/coretests/security/internal/tests/VerifyPasswordAuth.java";
    private static final String CLIENT_BINDINGS_SET_TO_NONE = "VerifyPasswordAuth.failCHCKCLNT";
    private static final String LOCAL_BINDINGS_SET_TO_NONE = "VerifyPasswordAuth.failCHCKLOCL";
    private static final int commandLevelFail = 9999;

    public void runTest(WMQTestEngine callback, IProgressMonitor guimonitor, MQExtObject[] contextObjects, TreeNode treenode) {
        Trace t = Trace.getDefault();
        super.runTest(callback, guimonitor, contextObjects, treenode);
        ArrayList<WMQTestResult> testresults = new ArrayList<WMQTestResult>();
        String errorMessage = null;
        guimonitor.beginTask(this.getTestName(), -1);
        int i = 0;
        while (i < contextObjects.length) {
            block13: {
                this.getGUIMonitor().worked(1);
                if (contextObjects[i] instanceof MQQmgrExtObject) {
                    MQQmgrExtObject nextQmgr = (MQQmgrExtObject)contextObjects[i];
                    if (nextQmgr != null) {
                        MQQueueManager qmgr = nextQmgr.getMQQueueManager();
                        if (qmgr.isConnected()) {
                            try {
                                WMQTestResult testResult;
                                String qmgrName = qmgr.getName();
                                if (Trace.isTracing) {
                                    t.data(66, "VerifyPasswordAuth.runTest", 300, "Testing queue manager : " + qmgrName);
                                }
                                int[] bindings = this.getAuthorityBindings(t, qmgr);
                                int clientBindings = bindings[0];
                                int localBindings = bindings[1];
                                if (clientBindings == 1) {
                                    errorMessage = SecurityTestsPlugin.testMessages.getMessage(CLIENT_BINDINGS_SET_TO_NONE);
                                    testResult = new WMQTestResult(2, errorMessage, qmgrName, this.getTestSubCategory());
                                    testresults.add(testResult);
                                }
                                if (localBindings == 1) {
                                    errorMessage = SecurityTestsPlugin.testMessages.getMessage(LOCAL_BINDINGS_SET_TO_NONE);
                                    testResult = new WMQTestResult(0, errorMessage, qmgrName, this.getTestSubCategory());
                                    testresults.add(testResult);
                                }
                                break block13;
                            }
                            catch (MQException qE) {
                                if (Trace.isTracing) {
                                    t.data(66, "VerifyPasswordAuth.runTest", 900, "Error getting from queue manager\n" + (Object)((Object)qE));
                                }
                                break block13;
                            }
                        }
                        if (Trace.isTracing) {
                            t.data(66, "VerifyPasswordAuth.runTest", 900, "Qmgr is not connected : " + contextObjects[i].getName());
                        }
                    }
                } else if (Trace.isTracing) {
                    t.data(66, "VerifyPasswordAuth.runTest", 900, "Not an MQQmgrExtObject : " + contextObjects[i].getName());
                }
            }
            ++i;
        }
        WMQTestResult[] finalresults = testresults.toArray(new WMQTestResult[testresults.size()]);
        this.testComplete(finalresults);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int[] getAuthorityBindings(Trace t, MQQueueManager qmgr) {
        PCFMessageAgent agent = null;
        int[] outputBindings = null;
        try {
            try {
                PCFMessage[] response;
                block27: {
                    agent = new PCFMessageAgent(qmgr);
                    if (Trace.isTracing) {
                        t.data(66, "VerifyPasswordAuth.getAuthorityByName", 300, "Connected to " + agent.getQManagerName());
                    }
                    String authName = qmgr.getAttributeString(2125, 48).trim();
                    PCFMessage request = new PCFMessage(83);
                    request.addParameter((PCFParameter)new MQCFST(2045, authName));
                    request.addParameter((PCFParameter)new MQCFIL(1019, PCFQuery.ALL_ATTRS));
                    response = null;
                    try {
                        if (Trace.isTracing) {
                            t.data(66, "VerifyPasswordAuth.getAuthorityByName", 300, "Sending command to " + agent.getQManagerName());
                        }
                        response = agent.send(request);
                    }
                    catch (Exception e) {
                        if (!Trace.isTracing) break block27;
                        t.data(66, "VerifyPasswordAuth.getAuthorityByName", 900, "Error from send command\n" + e);
                    }
                }
                if (response != null) {
                    int j = 0;
                    while (j < response.length) {
                        int authType = response[j].getIntParameterValue(66);
                        if (authType == 3 || authType == 4) {
                            int checkClientBinding = response[j].getIntParameterValue(258);
                            int checkLocalBinding = response[j].getIntParameterValue(257);
                            outputBindings = new int[]{checkClientBinding, checkLocalBinding};
                        } else {
                            outputBindings = new int[]{1, 1};
                        }
                        ++j;
                    }
                    return outputBindings;
                } else {
                    outputBindings = new int[]{1, 1};
                }
                return outputBindings;
            }
            catch (MQException mqe) {
                if (Trace.isTracing) {
                    t.data(66, "VerifyPasswordAuth.getAuthorityByName", 900, "Error connecting\n" + (Object)((Object)mqe));
                }
                if (agent == null) return outputBindings;
                try {
                    agent.disconnect();
                    return outputBindings;
                }
                catch (MQException mqe2) {
                    if (!Trace.isTracing) return outputBindings;
                    t.data(66, "VerifyPasswordAuth.getAuthorityByName", 900, "Error disconnecting\n" + (Object)((Object)mqe2));
                }
                return outputBindings;
            }
            catch (Exception e) {
                if (Trace.isTracing) {
                    t.data(66, "VerifyPasswordAuth.getAuthorityByName", 900, "Error processing request\n" + e);
                }
                if (agent == null) return outputBindings;
                try {
                    agent.disconnect();
                    return outputBindings;
                }
                catch (MQException mqe) {
                    if (!Trace.isTracing) return outputBindings;
                    t.data(66, "VerifyPasswordAuth.getAuthorityByName", 900, "Error disconnecting\n" + (Object)((Object)mqe));
                }
                return outputBindings;
            }
        }
        finally {
            block28: {
                if (agent != null) {
                    try {
                        agent.disconnect();
                    }
                    catch (MQException mqe) {
                        if (!Trace.isTracing) break block28;
                        t.data(66, "VerifyPasswordAuth.getAuthorityByName", 900, "Error disconnecting\n" + (Object)((Object)mqe));
                    }
                }
            }
        }
    }

    public MQExtObject[] getApplicableObjects(MQExtObject[] contextObjects) {
        Trace t = Trace.getDefault();
        boolean visibleQmgrsOnly = !PreferenceStoreManager.getIncludeHiddenQmgrsPreference();
        Map qmgrMap = this.getFilteredQueueManagersMap(t, contextObjects, false, true, true, visibleQmgrsOnly, false);
        ArrayList<DmQueueManager> qmgrsToRemove = new ArrayList<DmQueueManager>();
        for (DmQueueManager qmgr : qmgrMap.keySet()) {
            if (qmgr.getCommandLevel() >= 800) continue;
            qmgrsToRemove.add(qmgr);
        }
        for (DmQueueManager qmgr : qmgrsToRemove) {
            qmgrMap.remove(qmgr);
        }
        MQExtObject[] validObjs = qmgrMap.values().toArray(new MQExtObject[0]);
        return validObjs;
    }
}

