/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.tests.coretests.security.internal.tests;

import com.ibm.mq.MQException;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.commonservices.CommonServicesException;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.NativeCalls;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.tests.PreferenceStoreManager;
import com.ibm.mq.explorer.tests.coretests.internal.objects.WMQInternalTest;
import com.ibm.mq.explorer.tests.coretests.security.SecurityTestsPlugin;
import com.ibm.mq.explorer.tests.internal.actions.WMQTestEngine;
import com.ibm.mq.explorer.tests.internal.objects.WMQTestResult;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.MQQmgrExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import com.ibm.mq.pcf.MQCFIL;
import com.ibm.mq.pcf.MQCFIN;
import com.ibm.mq.pcf.MQCFST;
import com.ibm.mq.pcf.PCFMessage;
import com.ibm.mq.pcf.PCFMessageAgent;
import com.ibm.mq.pcf.PCFParameter;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

public class VerifyAuthProfiles
extends WMQInternalTest {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.tests.coretests.security/src/com/ibm/mq/explorer/tests/coretests/security/internal/tests/VerifyAuthProfiles.java";
    private static final String LOCAL_QMGR_HAS_UNNEEDED_PROFILES = "VerifyAuthProfiles.unneededAuthProfilesFound_Local";
    private static final String REMOTE_QMGR_HAS_UNNEEDED_PROFILES = "VerifyAuthProfiles.unneededAuthProfilesFound_Remote";
    private static final String SECURITY_STANZA_KEY = "Security";
    private static final String CQAC_EQUAL_RQMNAME = "ClusterQueueAccessControl\nRQMName";

    public void runTest(WMQTestEngine callback, IProgressMonitor guimonitor, MQExtObject[] contextObjects, TreeNode treenode) {
        Trace t = Trace.getDefault();
        super.runTest(callback, guimonitor, contextObjects, treenode);
        ArrayList<WMQTestResult> testresults = new ArrayList<WMQTestResult>();
        String errorMessage = null;
        guimonitor.beginTask(this.getTestName(), -1);
        int i = 0;
        while (i < contextObjects.length) {
            block13: {
                this.getGUIMonitor().worked(1);
                if (contextObjects[i] instanceof MQQmgrExtObject) {
                    MQQmgrExtObject nextQmgr = (MQQmgrExtObject)contextObjects[i];
                    if (nextQmgr != null) {
                        MQQueueManager qmgr = nextQmgr.getMQQueueManager();
                        if (qmgr.isConnected()) {
                            try {
                                WMQTestResult testResult;
                                String qmgrName = qmgr.getName();
                                if (Trace.isTracing) {
                                    t.data(66, "VerifyAuthProfiles.runTest", 300, "Testing queue manager : " + qmgrName);
                                }
                                PCFMessageAgent agent = null;
                                agent = new PCFMessageAgent(qmgr);
                                boolean hasUnneededAuthProfiles = this.hasPutAccessForSCTQProfiles(t, agent, qmgr);
                                if (!hasUnneededAuthProfiles) break block13;
                                if (nextQmgr.isLocal()) {
                                    if (this.hasClusterQueueAccessControlEqualRQMName(t, (MQExtObject)nextQmgr)) {
                                        errorMessage = SecurityTestsPlugin.testMessages.getMessage(LOCAL_QMGR_HAS_UNNEEDED_PROFILES);
                                        testResult = new WMQTestResult(1, errorMessage, qmgrName, this.getTestSubCategory());
                                        testresults.add(testResult);
                                    }
                                    break block13;
                                }
                                errorMessage = SecurityTestsPlugin.testMessages.getMessage(REMOTE_QMGR_HAS_UNNEEDED_PROFILES);
                                testResult = new WMQTestResult(1, errorMessage, qmgrName, this.getTestSubCategory());
                                testresults.add(testResult);
                            }
                            catch (MQException qE) {
                                if (Trace.isTracing) {
                                    t.data(66, "VerifyAuthProfiles.runTest", 900, "Error getting from queue manager\n" + (Object)((Object)qE));
                                }
                                break block13;
                            }
                        }
                        if (Trace.isTracing) {
                            t.data(66, "VerifyAuthProfiles.runTest", 900, "Qmgr is not connected : " + contextObjects[i].getName());
                        }
                    }
                } else if (Trace.isTracing) {
                    t.data(66, "VerifyAuthProfiles.runTest", 900, "Not an MQQmgrExtObject : " + contextObjects[i].getName());
                }
            }
            ++i;
        }
        WMQTestResult[] finalresults = testresults.toArray(new WMQTestResult[testresults.size()]);
        this.testComplete(finalresults);
    }

    private boolean hasPutAccessForSCTQProfiles(Trace t, PCFMessageAgent agent, MQQueueManager qmgr) {
        boolean containsPut;
        block10: {
            PCFMessage[] response;
            block9: {
                PCFMessage request = new PCFMessage(87);
                request.addParameter((PCFParameter)new MQCFIN(1228, 17));
                request.addParameter((PCFParameter)new MQCFST(3067, "SYSTEM.CLUSTER.TRANSMIT.QUEUE"));
                request.addParameter((PCFParameter)new MQCFIN(1016, 1));
                request.addParameter((PCFParameter)new MQCFIL(1114, new int[]{1115}));
                containsPut = false;
                response = null;
                try {
                    if (Trace.isTracing) {
                        t.data(66, "VerifyAuthProfiles.hasPutAccessForSCTQProfiles", 300, "Sending command to " + agent.getQManagerName());
                    }
                    response = agent.send(request);
                }
                catch (Exception e) {
                    if (!Trace.isTracing) break block9;
                    t.data(66, "VerifyAuthProfiles.hasPutAccessForSCTQProfiles", 900, "Error from send command\n" + e);
                }
            }
            try {
                if (response != null) {
                    int j = 0;
                    while (j < response.length && !containsPut) {
                        int[] authType;
                        int[] nArray = authType = response[j].getIntListParameterValue(1115);
                        int n = authType.length;
                        int n2 = 0;
                        while (n2 < n) {
                            int auth = nArray[n2];
                            if (auth == 11) {
                                containsPut = true;
                            }
                            ++n2;
                        }
                        ++j;
                    }
                }
            }
            catch (MQException e) {
                if (!Trace.isTracing) break block10;
                t.data(66, "VerifyAuthProfiles.hasPutAccessForSCTQProfiles", 900, "Error during response processing\n" + (Object)((Object)e));
            }
        }
        return containsPut;
    }

    private boolean hasClusterQueueAccessControlEqualRQMName(Trace t, MQExtObject qmgr) {
        block3: {
            String stanza = null;
            try {
                stanza = NativeCalls.getAttrs((Trace)t, (String)qmgr.getName(), (String)SECURITY_STANZA_KEY);
                if (stanza.contains(CQAC_EQUAL_RQMNAME)) {
                    return true;
                }
            }
            catch (CommonServicesException csE) {
                if (!Trace.isTracing) break block3;
                t.data(66, "VerifyAuthProfiles.hasClusterQueueAccessControlEqualRQMName", 500, "Unable to find a security stanza on qmgr" + qmgr.getName() + "\n" + (Object)((Object)csE));
            }
        }
        return false;
    }

    public MQExtObject[] getApplicableObjects(MQExtObject[] contextObjects) {
        Trace t = Trace.getDefault();
        boolean visibleQmgrsOnly = !PreferenceStoreManager.getIncludeHiddenQmgrsPreference();
        Map qmgrMap = this.getFilteredQueueManagersMap(t, contextObjects, false, true, true, visibleQmgrsOnly, false);
        ArrayList<DmQueueManager> qmgrsToRemove = new ArrayList<DmQueueManager>();
        for (DmQueueManager qmgr : qmgrMap.keySet()) {
            if (qmgr.getCommandLevel() >= 710) continue;
            qmgrsToRemove.add(qmgr);
        }
        for (DmQueueManager qmgr : qmgrsToRemove) {
            qmgrMap.remove(qmgr);
        }
        MQExtObject[] validObjs = qmgrMap.values().toArray(new MQExtObject[0]);
        return validObjs;
    }
}

