/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.telemetry.mqtt.utility.internal;

import com.ibm.mq.explorer.telemetry.mqtt.utility.internal.Messages;
import com.ibm.mq.telemetry.mqtt.utility.internal.ui.MQTTClientUtility;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

public class UtilityDialog
extends TrayDialog {
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.telemetry.mqtt.utility/src/com/ibm/mq/explorer/telemetry/mqtt/utility/internal/UtilityDialog.java";
    private String host;
    private int port;
    private int instance;

    public UtilityDialog(Shell shell, String host, int port, int instance) {
        super(shell);
        this.setShellStyle(1264);
        this.setBlockOnOpen(false);
        this.host = host;
        if (host == null || host.length() == 0) {
            this.host = "localhost";
        }
        this.port = port;
        this.instance = instance;
    }

    protected Control createContents(Composite parent) {
        MQTTClientUtility utility = new MQTTClientUtility(this.instance);
        utility.createPartControl(parent);
        if (this.host != null && this.host.length() > 0) {
            utility.autoConnect(this.host, this.port);
        }
        return parent;
    }

    protected void configureShell(final Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.UtilityDialog_Title);
        Menu bar = new Menu((Decorations)shell, 2);
        shell.setMenuBar(bar);
        MenuItem fileItem = new MenuItem(bar, 64);
        fileItem.setText(Messages.UtilityDialog_FileMenu);
        Menu submenu = new Menu((Decorations)shell, 4);
        fileItem.setMenu(submenu);
        MenuItem item = new MenuItem(submenu, 8);
        item.setText(Messages.UtilityDialog_ExitMenuItem);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                shell.close();
            }
        });
        MenuItem helpItem = new MenuItem(bar, 64);
        helpItem.setText(Messages.UtilityDialog_HelpMenu);
        submenu = new Menu((Decorations)shell, 4);
        helpItem.setMenu(submenu);
        item = new MenuItem(submenu, 8);
        item.setText(Messages.UtilityDialog_DynamicHelpMenuItem);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (UtilityDialog.this.getShell() != null) {
                    Control c = UtilityDialog.this.getShell().getDisplay().getFocusControl();
                    while (c != null) {
                        if (c.isListening(28)) {
                            c.notifyListeners(28, new Event());
                            break;
                        }
                        c = c.getParent();
                    }
                }
            }
        });
        this.setHelpAvailable(true);
    }
}

