/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.telemetry.mqtt.utility.internal.ui;

import com.ibm.mq.telemetry.mqtt.utility.internal.Messages;
import com.ibm.mq.telemetry.mqtt.utility.internal.ui.MQTTClientUtility;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttMessage;

public class MqttUtilityCallback
implements MqttCallback {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2010.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.telemetry.mqtt.utility/src/com/ibm/mq/telemetry/mqtt/utility/internal/ui/MqttUtilityCallback.java";
    private MQTTClientUtility view;

    public MqttUtilityCallback(MQTTClientUtility view) {
        this.view = view;
    }

    public void connectionLost(Throwable cause) {
        String exceptionMessage = MQTTClientUtility.getExceptionMessage(cause);
        this.view.indicateDisconnection(Messages.MQTTClientUtility_ConnectionLostStatus, exceptionMessage);
    }

    public void deliveryComplete(IMqttDeliveryToken arg0) {
    }

    public void messageArrived(String topic, MqttMessage message) throws Exception {
        String msg = new String(message.getPayload(), "UTF8");
        this.view.showReceived(msg, topic, message.getQos(), message.isRetained());
    }
}

