/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.telemetry.mqtt.utility.internal.ui;

import com.ibm.mq.telemetry.mqtt.utility.internal.Messages;
import com.ibm.mq.telemetry.mqtt.utility.internal.ui.ClientHistorySection;
import com.ibm.mq.telemetry.mqtt.utility.internal.ui.ConnectOptionsDialog;
import com.ibm.mq.telemetry.mqtt.utility.internal.ui.MqttUtilityCallback;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttTopic;
import org.eclipse.paho.client.mqttv3.persist.MqttDefaultFilePersistence;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class MQTTClientUtility {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2010.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.telemetry.mqtt.utility/src/com/ibm/mq/telemetry/mqtt/utility/internal/ui/MQTTClientUtility.java";
    private Button connButton;
    private Button discButton;
    private Combo addrField;
    private Combo portField;
    private Button publishButton;
    private Button subButton;
    private Button unsubButton;
    private Text statusField;
    private Text clientIdField;
    private ClientHistorySection clientHistory;
    private Composite parentComp;
    private int subLabelWidth;
    private int subButtonWidth;
    private MqttClient mqttClient;
    private String pubTopic = Messages.MQTTClientUtility_InitialTopic;
    private String clientIdentifier;
    private boolean cleanSession = true;
    private String willTopic = "";
    private String willPayload = "";
    private int willQos = 0;
    private boolean willRetained = false;
    private int portValue = 1883;
    public static final int CLIENTID_LIMIT = 23;

    public MQTTClientUtility(int instance) {
        String hostname = "";
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {}
        String pre = "mqtt_";
        String post = "_" + instance;
        int maxhost = 23 - pre.length() - post.length();
        String hostStr = hostname.replaceAll("-", "");
        if (hostStr.length() > maxhost) {
            hostStr = hostStr.substring(0, maxhost);
        }
        this.clientIdentifier = String.valueOf(pre) + hostStr + post;
    }

    public void createPartControl(Composite parent) {
        this.parentComp = parent;
        this.getShell().addShellListener((ShellListener)new ShellAdapter(){

            public void shellActivated(ShellEvent e) {
                Point size = MQTTClientUtility.this.getShell().getSize();
                int gap = MQTTClientUtility.this.clientHistory.getTableShrinkHeight();
                size.y -= gap;
                MQTTClientUtility.this.getShell().setMinimumSize(size);
                MQTTClientUtility.this.getShell().removeShellListener((ShellListener)this);
                MQTTClientUtility.this.portField.setText(Integer.valueOf(MQTTClientUtility.this.portValue).toString());
            }
        });
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                if (MQTTClientUtility.this.mqttClient != null && MQTTClientUtility.this.mqttClient.isConnected()) {
                    try {
                        MQTTClientUtility.this.mqttClient.disconnect();
                    }
                    catch (Exception exception) {}
                }
            }
        });
        Composite main = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        main.setLayout((Layout)layout);
        GridData gridData = new GridData(4, 4, true, true);
        main.setLayoutData((Object)gridData);
        this.createConnectionGroup(main);
        this.clientHistory = new ClientHistorySection(this);
        this.clientHistory.createHistoryGroup(main);
        this.createSubscriptionGroup(main);
        this.createPublicationGroup(main);
    }

    private void createConnectionGroup(Composite parent) {
        Group connectGroup = new Group(parent, 0);
        connectGroup.setText(Messages.MQTTClientUtility_ConnectionGroup);
        GridData gridData = new GridData(4, 1, true, false);
        gridData.horizontalSpan = 2;
        connectGroup.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(6, false);
        connectGroup.setLayout((Layout)gridLayout);
        new Label((Composite)connectGroup, 0).setText(Messages.MQTTClientUtility_HostLabel);
        this.addrField = new Combo((Composite)connectGroup, 0);
        this.addrField.setText("localhost");
        this.registerContextHelp((Control)this.addrField, "com.ibm.mq.telemetry.mqtt.utility.Connect_Host");
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        this.addrField.setLayoutData((Object)gridData);
        this.addrField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MQTTClientUtility.this.checkEnableConnect();
            }
        });
        new Label((Composite)connectGroup, 0).setText(Messages.MQTTClientUtility_PortLabel);
        this.portField = new Combo((Composite)connectGroup, 0);
        this.portField.setText("000000");
        this.portField.setTextLimit(5);
        this.registerContextHelp((Control)this.portField, "com.ibm.mq.telemetry.mqtt.utility.Connect_Port");
        this.portField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MQTTClientUtility.this.checkEnableConnect();
            }
        });
        this.portField.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                int i = 0;
                while (i < e.text.length()) {
                    char c = e.text.charAt(i);
                    if (c < '0' || c > '9') {
                        e.doit = false;
                    }
                    ++i;
                }
            }
        });
        new Label((Composite)connectGroup, 0).setText(Messages.MQTTClientUtility_ClientId);
        this.clientIdField = new Text((Composite)connectGroup, 2052);
        this.clientIdField.setText(this.clientIdentifier);
        this.clientIdField.setTextLimit(23);
        this.registerContextHelp((Control)this.clientIdField, "com.ibm.mq.telemetry.mqtt.utility.Client_Id");
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        this.clientIdField.setLayoutData((Object)gridData);
        this.clientIdField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MQTTClientUtility.this.checkEnableConnect();
            }
        });
        Label statusLabel = new Label((Composite)connectGroup, 0);
        statusLabel.setText(Messages.MQTTClientUtility_StatusLabel);
        String[] status = new String[]{Messages.MQTTClientUtility_ConnectedStatus, Messages.MQTTClientUtility_ConnectFailedStatus, Messages.MQTTClientUtility_ConnectingStatus, Messages.MQTTClientUtility_ConnectionLostStatus};
        String longestStatus = status[0];
        int i = 1;
        while (i < status.length) {
            if (status[i].length() > longestStatus.length()) {
                longestStatus = status[i];
            }
            ++i;
        }
        this.statusField = new Text((Composite)connectGroup, 2052);
        this.statusField.setText(String.valueOf(longestStatus) + " ");
        this.statusField.setEditable(false);
        this.registerContextHelp((Control)this.statusField, "com.ibm.mq.telemetry.mqtt.utility.Connect_Status");
        int statusWidth = this.statusField.computeSize((int)-1, (int)-1).x;
        gridData = new GridData(4, 0x1000000, true, false);
        gridData.widthHint = statusWidth;
        this.statusField.setLayoutData((Object)gridData);
        this.statusField.setText(Messages.MQTTClientUtility_DisconnectedStatus);
        Composite buttonComp = new Composite((Composite)connectGroup, 0);
        gridData = new GridData(4, 1, true, false);
        gridData.horizontalSpan = 4;
        buttonComp.setLayoutData((Object)gridData);
        gridLayout = new GridLayout(3, false);
        gridLayout.marginWidth = 0;
        buttonComp.setLayout((Layout)gridLayout);
        Button optionsButton = new Button(buttonComp, 8);
        gridData = new GridData(4, 1, true, false);
        optionsButton.setLayoutData((Object)gridData);
        optionsButton.setText(Messages.MQTTClientUtility_OptionsButton);
        this.registerContextHelp((Control)optionsButton, "com.ibm.mq.telemetry.mqtt.utility.Connect_Options");
        optionsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectOptionsDialog options = new ConnectOptionsDialog(MQTTClientUtility.this.getShell(), MQTTClientUtility.this.cleanSession, MQTTClientUtility.this.willTopic, MQTTClientUtility.this.willPayload, MQTTClientUtility.this.willQos, MQTTClientUtility.this.willRetained);
                int ret = options.open();
                if (ret == 0) {
                    MQTTClientUtility.this.cleanSession = options.isCleanSession();
                    MQTTClientUtility.this.willTopic = options.getWillTopic();
                    MQTTClientUtility.this.willPayload = options.getWillPayload();
                    MQTTClientUtility.this.willQos = options.getWillQos();
                    MQTTClientUtility.this.willRetained = options.getWillRetained();
                }
            }
        });
        this.connButton = new Button(buttonComp, 8);
        gridData = new GridData(4, 1, true, false);
        this.connButton.setLayoutData((Object)gridData);
        this.connButton.setText(Messages.MQTTClientUtility_ConnectButton);
        this.registerContextHelp((Control)this.connButton, "com.ibm.mq.telemetry.mqtt.utility.Connect");
        this.connButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String addr = MQTTClientUtility.this.addrField.getText();
                String port = MQTTClientUtility.this.portField.getText();
                String serverURI = "tcp://" + addr + ":" + port;
                MQTTClientUtility.this.addToComboHistory(MQTTClientUtility.this.addrField, addr);
                MQTTClientUtility.this.addToComboHistory(MQTTClientUtility.this.portField, port);
                MQTTClientUtility.this.connect(serverURI);
            }
        });
        this.discButton = new Button(buttonComp, 8);
        gridData = new GridData(4, 1, true, false);
        this.discButton.setLayoutData((Object)gridData);
        this.discButton.setText(Messages.MQTTClientUtility_DisconnectButton);
        this.registerContextHelp((Control)this.discButton, "com.ibm.mq.telemetry.mqtt.utility.Disconnect");
        this.discButton.setEnabled(false);
        this.discButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (MQTTClientUtility.this.mqttClient != null) {
                    try {
                        MQTTClientUtility.this.mqttClient.disconnect();
                        MQTTClientUtility.this.indicateDisconnection(Messages.MQTTClientUtility_DisconnectedStatus, "");
                    }
                    catch (Exception e) {
                        final String exceptionMessage = MQTTClientUtility.getExceptionMessage(e);
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                MQTTClientUtility.this.showStatus(Messages.MQTTClientUtility_ExceptionStatus, exceptionMessage, "", "", "");
                            }
                        });
                    }
                }
            }
        });
    }

    private void createSubscriptionGroup(Composite parent) {
        Group subGroup = new Group(parent, 0);
        subGroup.setText(Messages.MQTTClientUtility_SubscriptionGroup);
        subGroup.setLayout((Layout)new GridLayout(4, false));
        GridData gridData = new GridData(4, 4, true, false);
        subGroup.setLayoutData((Object)gridData);
        Label subTopicLabel = new Label((Composite)subGroup, 0);
        subTopicLabel.setText(Messages.MQTTClientUtility_SubTopicLabel);
        final Combo subTopicField = new Combo((Composite)subGroup, 0);
        gridData = new GridData(4, 1, true, false);
        gridData.horizontalSpan = 3;
        subTopicField.setLayoutData((Object)gridData);
        subTopicField.setText(this.pubTopic);
        this.registerContextHelp((Control)subTopicField, "com.ibm.mq.telemetry.mqtt.utility.Sub_Topic");
        subTopicField.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                int ind = e.text.indexOf(10);
                if (ind >= 0) {
                    e.text = e.text.substring(0, ind);
                }
            }
        });
        Label subQosLabel = new Label((Composite)subGroup, 0);
        subQosLabel.setText(Messages.MQTTClientUtility_SubQoSLabel);
        final Combo subQosChoice = new Combo((Composite)subGroup, 8);
        gridData = new GridData(4, 1, true, false);
        subQosChoice.setLayoutData((Object)gridData);
        subQosChoice.add(Messages.MQTTClientUtility_QoS_0);
        subQosChoice.add(Messages.MQTTClientUtility_QoS_1);
        subQosChoice.add(Messages.MQTTClientUtility_QoS_2);
        subQosChoice.select(0);
        this.registerContextHelp((Control)subQosChoice, "com.ibm.mq.telemetry.mqtt.utility.Sub_QoS");
        this.subButton = new Button((Composite)subGroup, 8);
        this.subButton.setText(Messages.MQTTClientUtility_SubscribeButton);
        this.subButton.setEnabled(false);
        this.subButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MQTTClientUtility.this.mqttClient != null && !subTopicField.isDisposed() && !subQosChoice.isDisposed()) {
                    String topic = subTopicField.getText();
                    MQTTClientUtility.this.addToComboHistory(subTopicField, topic);
                    MQTTClientUtility.this.subscribe(topic, subQosChoice.getSelectionIndex());
                }
            }
        });
        this.unsubButton = new Button((Composite)subGroup, 8);
        this.unsubButton.setText(Messages.MQTTClientUtility_UnsubscribeButton);
        this.unsubButton.setEnabled(false);
        this.unsubButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MQTTClientUtility.this.mqttClient != null && !subTopicField.isDisposed()) {
                    MQTTClientUtility.this.unsubscribe(subTopicField.getText());
                }
            }
        });
        subGroup.pack();
        int maxWidth = Math.max(this.subButton.getBounds().width, this.unsubButton.getBounds().width);
        gridData = (GridData)this.subButton.getLayoutData();
        gridData.widthHint = maxWidth;
        this.subButton.setLayoutData((Object)gridData);
        gridData = (GridData)this.unsubButton.getLayoutData();
        gridData.widthHint = maxWidth;
        this.unsubButton.setLayoutData((Object)gridData);
        subGroup.pack();
        this.subLabelWidth = subQosLabel.getBounds().width;
        this.subButtonWidth = maxWidth;
    }

    private void addToComboHistory(Combo combo, String item) {
        String[] items = combo.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].equals(item)) {
                return;
            }
            ++i;
        }
        combo.add(item);
    }

    private void createPublicationGroup(Composite parent) {
        Group pubGroup = new Group(parent, 0);
        pubGroup.setText(Messages.MQTTClientUtility_PublicationGroup);
        pubGroup.setLayout((Layout)new GridLayout(4, false));
        GridData gridData = new GridData(4, 4, true, false);
        pubGroup.setLayoutData((Object)gridData);
        Label pubTopicLabel = new Label((Composite)pubGroup, 0);
        pubTopicLabel.setText(Messages.MQTTClientUtility_PubTopicLabel);
        gridData = new GridData();
        gridData.widthHint = this.subLabelWidth;
        pubTopicLabel.setLayoutData((Object)gridData);
        final Combo pubTopicField = new Combo((Composite)pubGroup, 0);
        gridData = new GridData(4, 1, true, false);
        gridData.horizontalSpan = 3;
        pubTopicField.setLayoutData((Object)gridData);
        pubTopicField.setText(this.pubTopic);
        this.registerContextHelp((Control)pubTopicField, "com.ibm.mq.telemetry.mqtt.utility.Pub_Topic");
        pubTopicField.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                int ind = e.text.indexOf(10);
                if (ind >= 0) {
                    e.text = e.text.substring(0, ind);
                }
            }
        });
        Label messageLabel = new Label((Composite)pubGroup, 0);
        messageLabel.setText(Messages.MQTTClientUtility_PubMessageLabel);
        final Text pubField = new Text((Composite)pubGroup, 2050);
        gridData = new GridData(4, 4, true, false);
        gridData.horizontalSpan = 3;
        gridData.heightHint = pubField.getLineHeight() * 2;
        pubField.setLayoutData((Object)gridData);
        String initialMsg = Messages.MQTTClientUtility_InitialPubMessage;
        pubField.setText(initialMsg);
        this.registerContextHelp((Control)pubField, "com.ibm.mq.telemetry.mqtt.utility.Pub_Msg");
        Label pubQosLabel = new Label((Composite)pubGroup, 0);
        pubQosLabel.setText(Messages.MQTTClientUtility_PubQoSLabel);
        final Combo pubQosChoice = new Combo((Composite)pubGroup, 8);
        gridData = new GridData(4, 0x1000000, true, false);
        pubQosChoice.setLayoutData((Object)gridData);
        pubQosChoice.add(Messages.MQTTClientUtility_QoS_0);
        pubQosChoice.add(Messages.MQTTClientUtility_QoS_1);
        pubQosChoice.add(Messages.MQTTClientUtility_QoS_2);
        pubQosChoice.select(0);
        this.registerContextHelp((Control)pubQosChoice, "com.ibm.mq.telemetry.mqtt.utility.Pub_QoS");
        final Button pubRetainedButton = new Button((Composite)pubGroup, 32);
        pubRetainedButton.setText(Messages.MQTTClientUtility_RetainedButton);
        gridData = new GridData(0x1000000, 0x1000000, false, false);
        gridData.widthHint = this.subButtonWidth;
        gridData.horizontalAlignment = 0x1000000;
        pubRetainedButton.setLayoutData((Object)gridData);
        this.registerContextHelp((Control)pubRetainedButton, "com.ibm.mq.telemetry.mqtt.utility.Pub_Retain");
        this.publishButton = new Button((Composite)pubGroup, 8);
        this.publishButton.setText(Messages.MQTTClientUtility_PublishButton);
        gridData = new GridData();
        gridData.widthHint = this.subButtonWidth;
        this.publishButton.setLayoutData((Object)gridData);
        this.publishButton.setEnabled(false);
        this.publishButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!(MQTTClientUtility.this.mqttClient == null || pubField.isDisposed() || pubTopicField.isDisposed() || pubRetainedButton.isDisposed())) {
                    String topic = pubTopicField.getText();
                    MQTTClientUtility.this.addToComboHistory(pubTopicField, topic);
                    String msg = pubField.getText();
                    int qos = pubQosChoice.getSelectionIndex();
                    MQTTClientUtility.this.publish(topic, msg, qos, pubRetainedButton.getSelection());
                }
            }
        });
    }

    public void registerContextHelp(Control control, String helpId) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(control, helpId);
    }

    private void connect(final String serverURI) {
        this.clientIdentifier = this.clientIdField.getText();
        this.statusField.setText(Messages.MQTTClientUtility_ConnectingStatus);
        Job job = new Job(String.valueOf(Messages.MQTTClientUtility_ConnectJobName) + serverURI){

            public IStatus run(IProgressMonitor monitor) {
                try {
                    String tmpDir = System.getProperty("java.io.tmpdir");
                    MqttDefaultFilePersistence dataStore = new MqttDefaultFilePersistence(tmpDir);
                    MQTTClientUtility.this.mqttClient = new MqttClient(serverURI, MQTTClientUtility.this.clientIdentifier, (MqttClientPersistence)dataStore);
                    MQTTClientUtility.this.mqttClient.setCallback((MqttCallback)new MqttUtilityCallback(MQTTClientUtility.this));
                    MqttConnectOptions mqttConnectOptions = new MqttConnectOptions();
                    mqttConnectOptions.setCleanSession(MQTTClientUtility.this.cleanSession);
                    if (MQTTClientUtility.this.willTopic != null && MQTTClientUtility.this.willTopic.length() > 0 && MQTTClientUtility.this.willPayload != null && MQTTClientUtility.this.willPayload.length() > 0) {
                        System.out.println("willTopic=" + MQTTClientUtility.this.willTopic + " message=" + MQTTClientUtility.this.willPayload);
                        MqttTopic topic = MQTTClientUtility.this.mqttClient.getTopic(MQTTClientUtility.this.willTopic);
                        mqttConnectOptions.setWill(topic, MQTTClientUtility.this.willPayload.getBytes(), MQTTClientUtility.this.willQos, MQTTClientUtility.this.willRetained);
                    }
                    MQTTClientUtility.this.mqttClient.connect(mqttConnectOptions);
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MQTTClientUtility.this.indicateConnection();
                        }
                    });
                }
                catch (Exception e) {
                    final String exceptionMessage = MQTTClientUtility.getExceptionMessage(e);
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MQTTClientUtility.this.statusField.setText(Messages.MQTTClientUtility_ConnectFailedStatus);
                            MQTTClientUtility.this.showStatus(Messages.MQTTClientUtility_ConnectFailedStatus, exceptionMessage, "", "", "");
                        }
                    });
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    private void checkEnableConnect() {
        if (this.addrField.getText().length() > 0 && this.portField.getText().length() > 0 && this.clientIdField.getText().length() > 0) {
            this.connButton.setEnabled(true);
        } else {
            this.connButton.setEnabled(false);
        }
    }

    public static String getExceptionMessage(Throwable e) {
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    private void publish(String topicStr, String payloadString, int qos, boolean retained) {
        try {
            MqttTopic topic = this.mqttClient.getTopic(topicStr);
            topic.publish(payloadString.getBytes("UTF8"), qos, retained);
            this.showStatus(Messages.MQTTClientUtility_PublishedStatus, payloadString, topicStr, Integer.valueOf(qos).toString(), retained ? Messages.MQTTClientUtility_RetainedYes : Messages.MQTTClientUtility_RetainedNo);
        }
        catch (Exception e) {
            final String exceptionMessage = MQTTClientUtility.getExceptionMessage(e);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MQTTClientUtility.this.showStatus(Messages.MQTTClientUtility_PublishFailedStatus, exceptionMessage, "", "", "");
                }
            });
        }
    }

    private void subscribe(String topic, int qos) {
        String[] subscriptionArray = new String[]{topic};
        int[] qosArray = new int[]{qos};
        try {
            this.mqttClient.subscribe(subscriptionArray, qosArray);
            this.showStatus(Messages.MQTTClientUtility_SubscribedStatus, "", topic, Integer.valueOf(qos).toString(), "");
        }
        catch (Exception e) {
            final String exceptionMessage = MQTTClientUtility.getExceptionMessage(e);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MQTTClientUtility.this.showStatus(Messages.MQTTClientUtility_SubscribeFailedStatus, exceptionMessage, "", "", "");
                }
            });
        }
    }

    private void unsubscribe(String topic) {
        String[] subscriptionArray = new String[]{topic};
        try {
            this.mqttClient.unsubscribe(subscriptionArray);
            this.showStatus(Messages.MQTTClientUtility_UnsubscribedStatus, "", topic, "", "");
        }
        catch (Exception e) {
            final String exceptionMessage = MQTTClientUtility.getExceptionMessage(e);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MQTTClientUtility.this.showStatus(Messages.MQTTClientUtility_UnsubscribeFailedStatus, exceptionMessage, "", "", "");
                }
            });
        }
    }

    public void indicateConnection() {
        this.statusField.setText(Messages.MQTTClientUtility_ConnectedStatus);
        this.showStatus(Messages.MQTTClientUtility_ConnectedStatus);
        this.addrField.setEnabled(false);
        this.portField.setEnabled(false);
        this.clientIdField.setEnabled(false);
        this.connButton.setEnabled(false);
        this.discButton.setEnabled(true);
        this.publishButton.setEnabled(true);
        this.subButton.setEnabled(true);
        this.unsubButton.setEnabled(true);
    }

    public void indicateDisconnection(final String status, final String reason) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MQTTClientUtility.this.statusField.setText(status);
                MQTTClientUtility.this.showStatus(status, reason, "", "", "");
                MQTTClientUtility.this.addrField.setEnabled(true);
                MQTTClientUtility.this.portField.setEnabled(true);
                MQTTClientUtility.this.clientIdField.setEnabled(true);
                MQTTClientUtility.this.connButton.setEnabled(true);
                MQTTClientUtility.this.discButton.setEnabled(false);
                MQTTClientUtility.this.publishButton.setEnabled(false);
                MQTTClientUtility.this.subButton.setEnabled(false);
                MQTTClientUtility.this.unsubButton.setEnabled(false);
            }
        });
    }

    public void setFocus() {
    }

    public Shell getShell() {
        return this.parentComp.getShell();
    }

    public void showReceived(final String message, final String topic, final int qos, final boolean retained) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MQTTClientUtility.this.showStatus(Messages.MQTTClientUtility_ReceivedStatus, message, topic, Integer.valueOf(qos).toString(), retained ? Messages.MQTTClientUtility_RetainedYes : Messages.MQTTClientUtility_RetainedNo);
            }
        });
    }

    private void showStatus(String event) {
        this.showStatus(event, "", "", "", "");
    }

    private void showStatus(String event, String message, String topic, String qos, String retained) {
        this.clientHistory.addToTable(event, message, topic, qos, retained);
    }

    public void autoConnect(String host, int port) {
        this.addrField.setText(host);
        if (port > 0) {
            this.portValue = port;
        }
    }
}

