/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.servicedef.ui.internal.repositories;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.servicedef.core.internal.objects.DmServiceDefinitionAbstractRepository;
import com.ibm.mq.explorer.servicedef.core.internal.objects.DmServiceDefinitionRepository;
import com.ibm.mq.explorer.servicedef.ui.extensions.ServiceDefinitionRepositoryExtObject;
import com.ibm.mq.explorer.servicedef.ui.internal.base.OpeningTreeNode;
import com.ibm.mq.explorer.servicedef.ui.internal.base.ServiceDefinitionPlugin;
import com.ibm.mq.explorer.servicedef.ui.internal.base.Utilities;
import com.ibm.mq.explorer.servicedef.ui.internal.defaults.ServiceDefinitionTreeNode;
import com.ibm.mq.explorer.servicedef.ui.internal.repositories.ServiceDefinitionRepository;
import com.ibm.mq.explorer.servicedef.ui.internal.repositories.UiServiceDefinitionRepository;
import com.ibm.mq.explorer.servicedef.ui.internal.wsdls.NewServiceDefinitionWSDLObjectProvider;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import org.eclipse.swt.graphics.Image;

public class ServiceDefinitionRepositoryTreeNode
extends ServiceDefinitionTreeNode {
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.servicedef/src/com/ibm/mq/explorer/servicedef/ui/internal/repositories/ServiceDefinitionRepositoryTreeNode.java";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    private String displayName;
    private OpeningTreeNode openingTreeNode;

    public ServiceDefinitionRepositoryTreeNode(Trace t, TreeNode parent, ServiceDefinitionRepositoryExtObject object) {
        super(t, parent, object);
        this.displayName = object.getDisplayName();
        UiServiceDefinitionRepository uiServiceDefinitionRepository = (UiServiceDefinitionRepository)Utilities.getUiObject(object);
        NewServiceDefinitionWSDLObjectProvider newObjectProvider = new NewServiceDefinitionWSDLObjectProvider(t, uiServiceDefinitionRepository);
        this.setNewObjectProvider(t, newObjectProvider);
    }

    @Override
    public String toString() {
        Trace t = Trace.getDefault();
        String name = this.getDisplayName();
        ServiceDefinitionRepository serviceDefinitionRepository = ServiceDefinitionPlugin.getServiceDefinitionRepository(name);
        if (serviceDefinitionRepository != null) {
            DmServiceDefinitionRepository dmServiceDefinitionRepository = serviceDefinitionRepository.getDmObject();
            if (UiPlugin.isShowObjectStatus()) {
                name = this.appendStatusToName(t, name, dmServiceDefinitionRepository);
            }
        }
        return name;
    }

    protected String appendStatusToName(Trace t, String name, DmServiceDefinitionAbstractRepository dmServiceDefinitionRepository) {
        String newName = dmServiceDefinitionRepository.isOpen() ? String.valueOf(name) + ' ' + '[' + ServiceDefinitionPlugin.getMessage("ServiceDefinition.ServiceDefinitionRepository.Status.Connected") + ']' : String.valueOf(name) + ' ' + '[' + ServiceDefinitionPlugin.getMessage("ServiceDefinition.ServiceDefinitionRepository.Status.Disconnected") + ']';
        return newName;
    }

    @Override
    public boolean isContextMenuFromUiObject() {
        return false;
    }

    @Override
    public String getId() {
        return "com.ibm.mq.explorer.servicedef.treenode.Repository." + this.getUniqueIdentifier();
    }

    @Override
    public String getSequence() {
        return "100";
    }

    @Override
    public String getContentPageId() {
        return "com.ibm.mq.explorer.servicedef.contentpage.Repository";
    }

    @Override
    public String getHelpId() {
        return "com.ibm.mq.explorer.servicedef.infopop.UI_RepositoryTreeNode";
    }

    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public Image getIcon() {
        ServiceDefinitionRepositoryExtObject serviceDefinitionRepositoryExtObject = (ServiceDefinitionRepositoryExtObject)((Object)this.getObject());
        UiServiceDefinitionRepository uiServiceDefinitionRepository = (UiServiceDefinitionRepository)((Object)serviceDefinitionRepositoryExtObject.getInternalObject());
        uiServiceDefinitionRepository.updateIcon();
        Image icon = uiServiceDefinitionRepository.getImage();
        return icon;
    }

    @Override
    public int compare(TreeNode child1, TreeNode child2) {
        int result = 0;
        result = TreeNode.compareByName((TreeNode)child1, (TreeNode)child2);
        return result;
    }

    public void repositoryOpening(Trace t) {
        this.addOpeningTreeNode(t);
    }

    public void repositoryOpen(Trace t) {
        this.removeOpeningNode(t);
    }

    public void repositoryClosed(Trace t) {
        this.removeAllChildren(t);
    }

    public void removeAllChildren(Trace t) {
        TreeNode[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            this.removeChildFromNode(children[i]);
            ++i;
        }
    }

    private void addOpeningTreeNode(Trace t) {
        if (this.openingTreeNode == null) {
            this.openingTreeNode = new OpeningTreeNode(t, this, (MQExtObject)this.getObject());
            this.addChildToNode(this.openingTreeNode, 0);
        }
    }

    private void removeOpeningNode(Trace t) {
        if (this.openingTreeNode != null) {
            this.removeChildFromNode(this.openingTreeNode);
            this.openingTreeNode = null;
        }
    }

    public void setObject(Object obj) {
        Trace t = Trace.getDefault();
        super.setObject(obj);
        UiServiceDefinitionRepository uiServiceDefinitionRepository = (UiServiceDefinitionRepository)Utilities.getUiObject((ServiceDefinitionRepositoryExtObject)((Object)obj));
        NewServiceDefinitionWSDLObjectProvider newObjectProvider = new NewServiceDefinitionWSDLObjectProvider(t, uiServiceDefinitionRepository);
        this.setNewObjectProvider(t, newObjectProvider);
    }
}

