/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.servicedef.ui.internal.defaults;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.servicedef.core.internal.events.DmServiceDefinitionChangedEvent;
import com.ibm.mq.explorer.servicedef.core.internal.events.DmServiceDefinitionChangingEvent;
import com.ibm.mq.explorer.servicedef.core.internal.events.DmServiceDefinitionChildAddedEvent;
import com.ibm.mq.explorer.servicedef.core.internal.events.DmServiceDefinitionClosedEvent;
import com.ibm.mq.explorer.servicedef.core.internal.events.DmServiceDefinitionClosingEvent;
import com.ibm.mq.explorer.servicedef.core.internal.events.DmServiceDefinitionDeletedEvent;
import com.ibm.mq.explorer.servicedef.core.internal.events.DmServiceDefinitionDeletingEvent;
import com.ibm.mq.explorer.servicedef.core.internal.events.DmServiceDefinitionEventHandler;
import com.ibm.mq.explorer.servicedef.core.internal.events.DmServiceDefinitionEventObserver;
import com.ibm.mq.explorer.servicedef.core.internal.events.DmServiceDefinitionOpenedEvent;
import com.ibm.mq.explorer.servicedef.core.internal.events.DmServiceDefinitionOpeningEvent;
import com.ibm.mq.explorer.servicedef.core.internal.events.DmServiceDefinitionRenameEvent;
import com.ibm.mq.explorer.servicedef.core.internal.events.DmServiceDefinitionRenamingEvent;
import com.ibm.mq.explorer.servicedef.core.internal.events.DmServiceDefinitionReopenedEvent;
import com.ibm.mq.explorer.servicedef.core.internal.events.DmServiceDefinitionReopeningEvent;
import com.ibm.mq.explorer.servicedef.core.internal.objects.DmServiceDefinitionAbstractRepository;
import com.ibm.mq.explorer.servicedef.core.internal.objects.DmServiceDefinitionAbstractWSDL;
import com.ibm.mq.explorer.servicedef.core.internal.objects.DmServiceDefinitionObject;
import com.ibm.mq.explorer.servicedef.core.internal.objects.DmServiceDefinitionRepository;
import com.ibm.mq.explorer.servicedef.ui.extensions.ServiceDefinitionRepositoryExtObject;
import com.ibm.mq.explorer.servicedef.ui.internal.base.ServiceDefinitionPlugin;
import com.ibm.mq.explorer.servicedef.ui.internal.base.Utilities;
import com.ibm.mq.explorer.servicedef.ui.internal.defaults.UiServiceDefinitionObject;
import com.ibm.mq.explorer.servicedef.ui.internal.objects.UiServiceDefinitionRepositoryFactory;
import com.ibm.mq.explorer.servicedef.ui.internal.objects.UiServiceDefinitionWSDLFactory;
import com.ibm.mq.explorer.ui.extensions.ContentPage;
import com.ibm.mq.explorer.ui.extensions.ContentTitleBar;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTable;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTableUpdate;
import com.ibm.mq.explorer.ui.internal.filters.Filter;
import com.ibm.mq.explorer.ui.internal.filters.FilterChangedEvent;
import com.ibm.mq.explorer.ui.internal.filters.IFilterChangedListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Observable;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class ServiceDefinitionContentPage
extends ContentPage
implements DmServiceDefinitionEventObserver,
IFilterChangedListener {
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.servicedef/src/com/ibm/mq/explorer/servicedef/ui/internal/defaults/ServiceDefinitionContentPage.java";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    protected ExplorerTable explorerTable;
    protected Label explorerTableLabel;
    private MQExtObject externalObject;
    protected ContentTitleBar titleBar;

    public ServiceDefinitionContentPage(Trace t, Composite parent) {
        super(parent, 0);
    }

    public void init() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.setLayout((Layout)gridLayout);
    }

    public void initTitleBar() {
        this.titleBar = new ContentTitleBar((Composite)this, 0);
        GridData gridData = new GridData(768);
        this.titleBar.setLayoutData((Object)gridData);
    }

    protected void addExplorerTableLabel(Trace t) {
        this.explorerTableLabel = new Label((Composite)this, 0);
        this.setExplorerTableLabel(t, true);
        GridData layout = new GridData(768);
        this.explorerTableLabel.setLayoutData((Object)layout);
    }

    private void setExplorerTableLabel(Trace t, boolean connected) {
    }

    public abstract String getId();

    public MQExtObject getObject() {
        return this.externalObject;
    }

    public void updatePage() {
    }

    public void refresh() {
    }

    public void repaint() {
        this.explorerTable.repaint();
    }

    public boolean isEnableRefreshAction() {
        return true;
    }

    public boolean isEnableSystemObjectsAction() {
        return false;
    }

    public void showSystemObjects(boolean show) {
    }

    public void instanceDeleted(Object object) {
    }

    public void setObject(MQExtObject object) {
        if (this.externalObject != object) {
            this.externalObject = object;
        }
    }

    protected void beginUpdate(Trace t) {
        this.explorerTable.queueUpdate(t, new ExplorerTableUpdate(t, 4), true, true);
    }

    private void endUpdate(Trace t) {
        this.explorerTable.queueUpdate(t, new ExplorerTableUpdate(t, 5), true, true);
    }

    private UiServiceDefinitionObject createUiServiceDefinitionObject(Trace t, DmServiceDefinitionObject dmServiceDefinitionObject, ServiceDefinitionRepositoryExtObject serviceDefinitionRepositoryExtObject) {
        UiServiceDefinitionObject uiServiceDefinitionObject = null;
        if (dmServiceDefinitionObject instanceof DmServiceDefinitionRepository) {
            uiServiceDefinitionObject = UiServiceDefinitionRepositoryFactory.create(t, (DmServiceDefinitionRepository)dmServiceDefinitionObject);
        } else if (dmServiceDefinitionObject instanceof DmServiceDefinitionAbstractWSDL) {
            uiServiceDefinitionObject = UiServiceDefinitionWSDLFactory.create(t, (DmServiceDefinitionAbstractWSDL)dmServiceDefinitionObject, serviceDefinitionRepositoryExtObject);
        } else {
            String helpID = "ServiceDefinition.ServiceDefinitionRepository.Invalid.ObjectType";
            String message = ServiceDefinitionPlugin.getMessage(helpID);
            String className = dmServiceDefinitionObject.getClass().toString();
            DmServiceDefinitionAbstractRepository dmServiceDefinitionRepository = (DmServiceDefinitionAbstractRepository)Utilities.getDmObject(serviceDefinitionRepositoryExtObject);
            message = Message.format((String)message, (String)className, (String)dmServiceDefinitionRepository.getTitle(), null);
            t.FFST(66, "ServiceDefinitionContentPage.createUiServiceDefinitionObject", 0, 0, message);
        }
        return uiServiceDefinitionObject;
    }

    protected void addItemToTable(Trace t, DmServiceDefinitionObject dmServiceDefinitionObject, boolean endUpdate) {
        ServiceDefinitionRepositoryExtObject serviceDefinitionRepositoryExtObject = (ServiceDefinitionRepositoryExtObject)this.getObject();
        UiServiceDefinitionObject uiServiceDefinitionObject = this.createUiServiceDefinitionObject(t, dmServiceDefinitionObject, serviceDefinitionRepositoryExtObject);
        dmServiceDefinitionObject.addObserver(this);
        DmServiceDefinitionAbstractRepository dmServiceDefininitionRepository = dmServiceDefinitionObject.getParent();
        Filter filter = this.explorerTable.getCurrentFilterSelection(t);
        DmObjectFilter dmFilter = filter.getDmObjectFilter(t);
        if (dmServiceDefininitionRepository == null || dmServiceDefininitionRepository.match(t, dmServiceDefinitionObject, dmFilter)) {
            this.updateItemInTable(t, uiServiceDefinitionObject, 1, endUpdate);
        }
    }

    private void updateItemInTable(Trace t, UiServiceDefinitionObject uiServiceDefinitionObject, int updateType, boolean endUpdate) {
        this.explorerTable.queueUpdate(t, new ExplorerTableUpdate(t, updateType, (Object)uiServiceDefinitionObject), false, true);
        if (endUpdate) {
            this.endUpdate(t);
        }
    }

    protected void modifyItemInTable(Trace t, DmServiceDefinitionObject dmServiceDefinitionObject) {
        UiServiceDefinitionObject uiServiceDefinitionObject = this.getItemInTable(t, dmServiceDefinitionObject);
        if (uiServiceDefinitionObject != null) {
            this.updateItemInTable(t, uiServiceDefinitionObject, 2, true);
        } else {
            this.endUpdate(t);
        }
    }

    protected void removeItemFromTable(Trace t, DmServiceDefinitionObject dmServiceDefinitionObject, boolean endUpdate) {
        UiServiceDefinitionObject uiServiceDefinitionObject = this.getItemInTable(t, dmServiceDefinitionObject);
        if (uiServiceDefinitionObject != null) {
            this.removeItemFromTable(t, uiServiceDefinitionObject, endUpdate);
        }
    }

    private void removeItemFromTable(Trace t, UiServiceDefinitionObject uiServiceDefinitionObject, boolean endUpdate) {
        this.updateItemInTable(t, uiServiceDefinitionObject, 3, endUpdate);
    }

    private UiServiceDefinitionObject getItemInTable(Trace t, DmServiceDefinitionObject dmServiceDefinitionObject) {
        UiServiceDefinitionObject uiServiceDefinitionObject = null;
        ArrayList serviceDefinitionExtObjects = this.explorerTable.getObjects(t);
        Iterator iter = serviceDefinitionExtObjects.iterator();
        while (iter.hasNext() && uiServiceDefinitionObject == null) {
            MQExtObject extObject = (MQExtObject)iter.next();
            DmServiceDefinitionObject currentObject = Utilities.getDmObject(extObject);
            if (!currentObject.equals(dmServiceDefinitionObject)) continue;
            uiServiceDefinitionObject = (UiServiceDefinitionObject)((Object)extObject.getInternalObject());
        }
        return uiServiceDefinitionObject;
    }

    private void removeAllObjectsInTable(Trace t) {
        ArrayList jmsExtObjects = this.explorerTable.getObjects(t);
        for (MQExtObject extObject : jmsExtObjects) {
            UiServiceDefinitionObject uiServiceDefinitionObject = (UiServiceDefinitionObject)((Object)extObject.getInternalObject());
            this.removeItemFromTable(t, uiServiceDefinitionObject, false);
        }
        this.endUpdate(t);
    }

    protected void updateTable(Trace t, DmServiceDefinitionAbstractRepository dmServiceDefinitionRepository) {
        Filter filter = this.explorerTable.getCurrentFilterSelection(t);
        DmObjectFilter dmFilter = filter.getDmObjectFilter(t);
        Collection<DmServiceDefinitionObject> objects = dmServiceDefinitionRepository.getObjects(t, dmFilter);
        this.beginUpdate(t);
        this.explorerTable.queueUpdate(t, new ExplorerTableUpdate(t, 6), false, true);
        for (DmServiceDefinitionObject dmServiceDefinitionObject : objects) {
            this.addItemToTable(t, dmServiceDefinitionObject, false);
        }
        this.endUpdate(t);
    }

    @Override
    public void update(final Observable o, final Object arg) {
        final Trace t = Trace.getDefault();
        final ServiceDefinitionContentPage observer = this;
        UiPlugin.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                DmServiceDefinitionObject dmServiceDefinitionObject = (DmServiceDefinitionObject)o;
                DmServiceDefinitionEventHandler.handleEvent(t, observer, dmServiceDefinitionObject, arg);
            }
        });
    }

    @Override
    public void changedEventReceived(Trace t, DmServiceDefinitionObject object, DmServiceDefinitionChangedEvent event) {
        this.modifyItemInTable(t, object);
    }

    @Override
    public void changingEventReceived(Trace t, DmServiceDefinitionObject object, DmServiceDefinitionChangingEvent event) {
        this.beginUpdate(t);
    }

    @Override
    public void childAddedEventReceived(Trace t, DmServiceDefinitionObject object, DmServiceDefinitionChildAddedEvent event) {
        DmServiceDefinitionAbstractRepository dmServiceDefinitionRepository = (DmServiceDefinitionAbstractRepository)Utilities.getDmObject(this.externalObject);
        if (dmServiceDefinitionRepository == object && event.isNoError()) {
            DmServiceDefinitionObject newObject = event.getNewObject();
            this.addItemToTable(t, newObject, true);
        }
    }

    @Override
    public void closedEventReceived(Trace t, DmServiceDefinitionObject object, DmServiceDefinitionClosedEvent event) {
        DmServiceDefinitionAbstractRepository dmServiceDefinitionRepository = (DmServiceDefinitionAbstractRepository)Utilities.getDmObject(this.externalObject);
        if (dmServiceDefinitionRepository == object) {
            boolean open = dmServiceDefinitionRepository.isOpen();
            this.updateRepositoryStatus(t, open);
            if (!open) {
                this.removeAllObjectsInTable(t);
            }
        } else {
            this.modifyItemInTable(t, object);
        }
    }

    public void updateRepositoryStatus(Trace t, boolean open) {
        this.setExplorerTableLabel(t, open);
        this.explorerTable.setEnabled(open);
    }

    @Override
    public void closingEventReceived(Trace t, DmServiceDefinitionObject object, DmServiceDefinitionClosingEvent event) {
        DmServiceDefinitionAbstractRepository dmServiceDefinitionRepository = (DmServiceDefinitionAbstractRepository)Utilities.getDmObject(this.externalObject);
        if (dmServiceDefinitionRepository == object) {
            this.beginUpdate(t);
        }
    }

    @Override
    public void deletedEventReceived(Trace t, DmServiceDefinitionObject object, DmServiceDefinitionDeletedEvent event) {
        if (event.isNoError()) {
            this.removeItemFromTable(t, object, true);
        } else {
            this.endUpdate(t);
        }
    }

    @Override
    public void deletingEventReceived(Trace t, DmServiceDefinitionObject object, DmServiceDefinitionDeletingEvent event) {
        this.beginUpdate(t);
    }

    @Override
    public void openedEventReceived(Trace t, DmServiceDefinitionObject object, DmServiceDefinitionOpenedEvent event) {
        DmServiceDefinitionAbstractRepository dmServiceDefinitionRepository = (DmServiceDefinitionAbstractRepository)Utilities.getDmObject(this.externalObject);
        if (dmServiceDefinitionRepository == object) {
            this.updateRepositoryStatus(t, dmServiceDefinitionRepository.isOpen());
            this.updateTable(t, (DmServiceDefinitionAbstractRepository)object);
        } else {
            this.modifyItemInTable(t, object);
        }
    }

    @Override
    public void openingEventReceived(Trace t, DmServiceDefinitionObject object, DmServiceDefinitionOpeningEvent event) {
        DmServiceDefinitionAbstractRepository dmServiceDefinitionRepository = (DmServiceDefinitionAbstractRepository)Utilities.getDmObject(this.externalObject);
        if (dmServiceDefinitionRepository == object) {
            this.beginUpdate(t);
        }
    }

    @Override
    public void renameEventReceived(Trace t, DmServiceDefinitionObject object, DmServiceDefinitionRenameEvent event) {
        if (event.isNoError()) {
            DmServiceDefinitionObject newDmObject = event.getNewObject();
            DmServiceDefinitionObject oldDmObject = Utilities.getDmObject(this.externalObject);
            if (oldDmObject != object) {
                this.removeItemFromTable(t, object, false);
                this.addItemToTable(t, newDmObject, true);
            }
        } else {
            this.endUpdate(t);
        }
    }

    @Override
    public void renamingEventReceived(Trace t, DmServiceDefinitionObject object, DmServiceDefinitionRenamingEvent event) {
        this.beginUpdate(t);
    }

    @Override
    public void reopenedEventReceived(Trace t, DmServiceDefinitionObject object, DmServiceDefinitionReopenedEvent event) {
        DmServiceDefinitionAbstractRepository dmServiceDefinitionRepository = (DmServiceDefinitionAbstractRepository)Utilities.getDmObject(this.externalObject);
        if (dmServiceDefinitionRepository == object) {
            this.updateRepositoryStatus(t, dmServiceDefinitionRepository.isOpen());
            this.updateTable(t, (DmServiceDefinitionAbstractRepository)object);
        } else {
            this.modifyItemInTable(t, object);
        }
    }

    @Override
    public void reopeningEventReceived(Trace t, DmServiceDefinitionObject object, DmServiceDefinitionReopeningEvent event) {
        DmServiceDefinitionAbstractRepository dmServiceDefinitionRepository = (DmServiceDefinitionAbstractRepository)Utilities.getDmObject(this.externalObject);
        if (dmServiceDefinitionRepository == object) {
            this.beginUpdate(t);
        }
    }

    @Override
    public void unknownDataModelEventReceived(Trace t, Object event) {
        ServiceDefinitionPlugin.unknownDataModelEventReceived(t, event);
    }

    public void changed(FilterChangedEvent e) {
        Trace t = Trace.getDefault();
        ServiceDefinitionRepositoryExtObject serviceDefinitionRepositoryExtObject = (ServiceDefinitionRepositoryExtObject)this.getObject();
        if (serviceDefinitionRepositoryExtObject != null) {
            DmServiceDefinitionAbstractRepository dmServiceDefinitionRepository = (DmServiceDefinitionAbstractRepository)Utilities.getDmObject(serviceDefinitionRepositoryExtObject);
            this.updateTable(t, dmServiceDefinitionRepository);
        }
    }

    public void selectionChanged(FilterChangedEvent e) {
        Trace t = Trace.getDefault();
        ServiceDefinitionRepositoryExtObject serviceDefinitionRepositoryExtObject = (ServiceDefinitionRepositoryExtObject)this.getObject();
        if (serviceDefinitionRepositoryExtObject != null) {
            DmServiceDefinitionAbstractRepository dmServiceDefinitionRepository = (DmServiceDefinitionAbstractRepository)Utilities.getDmObject(serviceDefinitionRepositoryExtObject);
            this.updateTable(t, dmServiceDefinitionRepository);
        }
    }
}

