/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.servicedef.ui.internal.defaults;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.servicedef.ui.internal.base.ServiceDefinitionPlugin;
import com.ibm.mq.explorer.servicedef.ui.internal.defaults.NewServiceDefinitionObjectProvider;
import com.ibm.mq.explorer.ui.internal.controls.WizPage;
import com.ibm.mq.explorer.ui.internal.objects.NewObjectWiz;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class NewServiceDefinitionObjectWizPage1
extends WizPage {
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.servicedef/src/com/ibm/mq/explorer/servicedef/ui/internal/defaults/NewServiceDefinitionObjectWizPage1.java";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    protected static final int HORIZONTAL_SPAN = 4;
    protected NewObjectWiz wizard;
    private NewServiceDefinitionObjectProvider newObjectProvider;
    private boolean pageContentCreated;
    private Combo messageExchangePatternCombo;
    private Text messageExchangePatternHelpText;
    private boolean interimObjectCreated = false;
    protected Control firstControl;
    private boolean firstOpen = true;
    public Text nameText;
    private static char[] invalidFilenameChars = new char[]{'/', '\\', '?', '<', '>', '|', ':', '*', '\"'};

    public NewServiceDefinitionObjectWizPage1(String pageName, NewObjectWiz wiz, NewServiceDefinitionObjectProvider newObjProvider, String title, String description, String helpId) {
        super(pageName, helpId);
        this.wizard = wiz;
        this.newObjectProvider = newObjProvider;
        this.interimObjectCreated = false;
        this.setTitle(title);
        this.setDescription(description);
    }

    public void createPageContent(final Trace t, Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(ServiceDefinitionPlugin.getMessage("ServiceDef.NewObjectWizard.Name.Label"));
        GridData layout = new GridData(768);
        layout.horizontalSpan = 4;
        label.setLayoutData((Object)layout);
        this.nameText = new Text(parent, 2048);
        layout = new GridData(768);
        layout.horizontalSpan = 4;
        this.nameText.setLayoutData((Object)layout);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String name = NewServiceDefinitionObjectWizPage1.this.nameText.getText();
                NewServiceDefinitionObjectWizPage1.this.wizard.setNewObjectName(name);
                NewServiceDefinitionObjectWizPage1.this.checkIfEnableButtons();
            }
        });
        this.firstControl = this.nameText;
        UiUtils.createBlankLine((Composite)parent, (int)4);
        label = new Label(parent, 0);
        label.setText(ServiceDefinitionPlugin.getMessage("ServiceDef.NewObjectWizard.Page1.MessageExchangePatternLabel"));
        layout = new GridData(768);
        layout.horizontalSpan = 4;
        label.setLayoutData((Object)layout);
        this.messageExchangePatternCombo = new Combo(parent, 2060);
        layout = new GridData(768);
        layout.horizontalSpan = 4;
        this.messageExchangePatternCombo.setLayoutData((Object)layout);
        String[] messageExchangePatterns = new String[]{NewServiceDefinitionObjectProvider.getMessageExchangePatternText(t, 0), NewServiceDefinitionObjectProvider.getMessageExchangePatternText(t, 1)};
        int i = 0;
        while (i < messageExchangePatterns.length) {
            this.messageExchangePatternCombo.add(messageExchangePatterns[i], i);
            ++i;
        }
        if (messageExchangePatterns.length <= 1) {
            this.messageExchangePatternCombo.setEnabled(false);
        }
        this.messageExchangePatternCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                int pattern = NewServiceDefinitionObjectWizPage1.this.messageExchangePatternCombo.getSelectionIndex();
                NewServiceDefinitionObjectWizPage1.this.newObjectProvider.setCurrentMessageExchangePattern(t, pattern);
                NewServiceDefinitionObjectWizPage1.this.updateHelpText(t);
            }
        });
        this.messageExchangePatternHelpText = new Text(parent, 2114);
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)this.messageExchangePatternHelpText, (boolean)true);
        layout = new GridData(768);
        layout.horizontalSpan = 4;
        layout.widthHint = 200;
        this.messageExchangePatternHelpText.setLayoutData((Object)layout);
        parent.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                UiUtils.resizeControl((Trace)t, (Control)NewServiceDefinitionObjectWizPage1.this.messageExchangePatternHelpText);
            }
        });
        this.pageContentCreated = true;
    }

    public boolean performFinish() {
        Trace t = Trace.getDefault();
        UiMQObject newObject = this.newObjectProvider.createInterimObject(t, this.wizard.getNewObjectTypeId(), this.wizard.getNewObjectName());
        boolean result = this.wizard.createObject(t, newObject.getDmObject(), null);
        return result;
    }

    public void checkIfEnableButtons() {
        Trace t = Trace.getDefault();
        if (this.pageContentCreated) {
            boolean pageComplete = false;
            String name = this.nameText.getText();
            if (name.length() == 0) {
                if (!this.firstOpen) {
                    String errorMessage = ServiceDefinitionPlugin.getMessage("ServiceDef.NewObjectWizard.Name.NotEnteredError");
                    this.setMessage(errorMessage, 3);
                }
            } else if (!NewServiceDefinitionObjectWizPage1.isNameValid(t, name)) {
                if (!this.firstOpen) {
                    String errorMessage = ServiceDefinitionPlugin.getMessage("ServiceDef.NewObjectWizard.Name.NotNotValidError");
                    this.setMessage(errorMessage, 3);
                }
            } else {
                pageComplete = true;
                this.setMessage(null);
                if (!this.interimObjectCreated) {
                    this.newObjectProvider.createInterimObject(t, this.wizard.getNewObjectTypeId(), name);
                    this.interimObjectCreated = true;
                }
            }
            this.setPageComplete(pageComplete);
            this.wizard.setEnableFinish(false);
            this.wizard.updateButtons(t);
            this.firstOpen = false;
        }
    }

    public void nextPressed() {
        Trace t = Trace.getDefault();
        this.newObjectProvider.createInterimObject(t, this.wizard.getNewObjectTypeId(), this.wizard.getNewObjectName());
    }

    public void createControl(Composite parent) {
        super.createControl(parent, 4);
    }

    public void setVisible(boolean visible) {
        Trace t = Trace.getDefault();
        super.setVisible(visible);
        if (visible) {
            String currentName = this.wizard.getNewObjectName();
            if (currentName != null && currentName.length() > 0) {
                this.nameText.setText(currentName);
            }
            if (this.messageExchangePatternCombo.getSelectionIndex() < 0) {
                this.messageExchangePatternCombo.select(0);
                this.updateHelpText(t);
            }
            this.firstControl.setFocus();
        }
    }

    public boolean pageContentCreated(Trace t) {
        return this.pageContentCreated;
    }

    public boolean firstOpen(Trace t) {
        return this.firstOpen;
    }

    public NewServiceDefinitionObjectProvider getNewObjectProvider(Trace t) {
        return this.newObjectProvider;
    }

    private void updateHelpText(Trace t) {
        int provider = this.newObjectProvider.getCurrentMessageExchangePattern();
        String text = NewServiceDefinitionObjectProvider.getMessageExchangePatternHelpText(t, provider);
        this.messageExchangePatternHelpText.setText(text);
        UiUtils.resizeControl((Trace)t, (Control)this.messageExchangePatternHelpText);
    }

    public static boolean isNameValid(Trace t, String filename) {
        int i = 0;
        while (i < invalidFilenameChars.length) {
            if (filename.indexOf(invalidFilenameChars[i]) >= 0) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

