/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.servicedef.ui.internal.custom.items;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.servicedef.core.internal.objects.DmServiceDefinitionObject;
import com.ibm.mq.explorer.servicedef.ui.internal.base.ServiceDefinitionPlugin;
import com.ibm.mq.explorer.servicedef.ui.internal.wsdls.UiServiceDefinitionWSDL;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.properties.AttributeModifiedEvent;
import com.ibm.mq.explorer.ui.internal.properties.CustomPropertyItem;
import com.ibm.mq.explorer.ui.internal.properties.IAttributeModifiedListener;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class EncodingCustomItem
extends CustomPropertyItem
implements IAttributeModifiedListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.servicedef/src/com/ibm/mq/explorer/servicedef/ui/internal/custom/items/EncodingCustomItem.java";
    private final int INDEX_INTEGER_NORMAL = 0;
    private final int INDEX_INTEGER_REVERSED = 1;
    private final int INDEX_DECIMAL_NORMAL = 0;
    private final int INDEX_DECIMAL_REVERSED = 1;
    private final int INDEX_FLOAT_NORMAL = 0;
    private final int INDEX_FLOAT_REVERSED = 1;
    private final int INDEX_FLOAT_S390 = 2;
    public static final String NATIVE = "NATIVE";
    public static final char NORMAL = 'N';
    public static final char REVERSED = 'R';
    public static final char S390 = '3';
    public static final char UNKNOWN = '?';
    private UiServiceDefinitionWSDL uiServiceDefinitionWSDL;
    private Attr attr = null;
    private boolean readonly = false;
    protected Message msgFile = null;
    private Button enableSectionButton;
    private Combo integerCombo;
    private Combo decimalCombo;
    private Combo floatCombo;
    private Text number;
    private Text mnemonic;
    private Composite parent = null;

    public EncodingCustomItem(Trace t, Composite parent, int style, UiMQObject uiMQObject, Attr attr, boolean readonly) {
        super(t, parent, style, uiMQObject, attr, readonly);
        this.uiServiceDefinitionWSDL = (UiServiceDefinitionWSDL)uiMQObject;
        this.attr = attr;
        this.readonly = readonly;
        this.parent = parent;
        this.msgFile = UiPlugin.getUIMessages((Trace)t, (String)"KEY_Properties");
    }

    public void init(Trace t) {
        Composite comp = new Composite(this.parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        comp.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.verticalSpacing = 10;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.makeColumnsEqualWidth = false;
        comp.setLayout((Layout)gridLayout);
        AttrType attrType = this.attr.getAttrType();
        Integer objectValue = (Integer)this.attr.getValue(t);
        int value = objectValue;
        Group groupProps = new Group(comp, 0);
        groupProps.setText(attrType.getDisplayTitle());
        gridData = new GridData(768);
        groupProps.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 5;
        groupProps.setLayout((Layout)gridLayout);
        this.enableSectionButton = new Button((Composite)groupProps, 32);
        this.enableSectionButton.setText(ServiceDefinitionPlugin.getMessage("ServiceDef.CustomItem.Encoding.Native"));
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.grabExcessHorizontalSpace = true;
        this.enableSectionButton.setLayoutData((Object)gridData);
        this.enableSectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Trace t = Trace.getDefault();
                Button button = (Button)e.getSource();
                if (button.getSelection()) {
                    EncodingCustomItem.this.integerCombo.setEnabled(true);
                    EncodingCustomItem.this.decimalCombo.setEnabled(true);
                    EncodingCustomItem.this.floatCombo.setEnabled(true);
                    EncodingCustomItem.this.mnemonic.setEnabled(true);
                    EncodingCustomItem.this.number.setEnabled(true);
                } else {
                    EncodingCustomItem.this.integerCombo.setEnabled(false);
                    EncodingCustomItem.this.decimalCombo.setEnabled(false);
                    EncodingCustomItem.this.floatCombo.setEnabled(false);
                    EncodingCustomItem.this.mnemonic.setEnabled(false);
                    EncodingCustomItem.this.number.setEnabled(false);
                }
                int newValue = EncodingCustomItem.this.getCurrentValue(t);
                EncodingCustomItem.this.setMnemonicValues(t, newValue);
            }
        });
        Label label = new Label((Composite)groupProps, 0);
        label.setText(ServiceDefinitionPlugin.getMessage("ServiceDef.CustomItem.Encoding.Integer"));
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.integerCombo = new Combo((Composite)groupProps, 12);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.integerCombo.setLayoutData((Object)gridData);
        this.integerCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Trace t = Trace.getDefault();
                int newValue = EncodingCustomItem.this.getCurrentValue(t);
                EncodingCustomItem.this.setMnemonicValues(t, newValue);
            }
        });
        label = new Label((Composite)groupProps, 0);
        label.setText(ServiceDefinitionPlugin.getMessage("ServiceDef.CustomItem.Encoding.Decimal"));
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.decimalCombo = new Combo((Composite)groupProps, 12);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.decimalCombo.setLayoutData((Object)gridData);
        this.decimalCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Trace t = Trace.getDefault();
                int newValue = EncodingCustomItem.this.getCurrentValue(t);
                EncodingCustomItem.this.setMnemonicValues(t, newValue);
            }
        });
        label = new Label((Composite)groupProps, 0);
        label.setText(ServiceDefinitionPlugin.getMessage("ServiceDef.CustomItem.Encoding.Float"));
        this.floatCombo = new Combo((Composite)groupProps, 12);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.floatCombo.setLayoutData((Object)gridData);
        this.floatCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Trace t = Trace.getDefault();
                int newValue = EncodingCustomItem.this.getCurrentValue(t);
                EncodingCustomItem.this.setMnemonicValues(t, newValue);
            }
        });
        label = new Label((Composite)groupProps, 0);
        label.setText(ServiceDefinitionPlugin.getMessage("ServiceDef.CustomItem.Encoding.Mnemonic"));
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.mnemonic = new Text((Composite)groupProps, 2048);
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)this.mnemonic, (boolean)true);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.mnemonic.setLayoutData((Object)gridData);
        label = new Label((Composite)groupProps, 0);
        label.setText(ServiceDefinitionPlugin.getMessage("ServiceDef.CustomItem.Encoding.Value"));
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.number = new Text((Composite)groupProps, 2048);
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)this.number, (boolean)true);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.number.setLayoutData((Object)gridData);
        String normal = ServiceDefinitionPlugin.getMessage("ServiceDef.CustomItem.Encoding.Normal");
        String reversed = ServiceDefinitionPlugin.getMessage("ServiceDef.CustomItem.Encoding.Reversed");
        String s390 = ServiceDefinitionPlugin.getMessage("ServiceDef.CustomItem.Encoding.S390");
        this.integerCombo.add(normal, 0);
        this.integerCombo.add(reversed, 1);
        this.decimalCombo.add(normal, 0);
        this.decimalCombo.add(reversed, 1);
        this.floatCombo.add(normal, 0);
        this.floatCombo.add(reversed, 1);
        this.floatCombo.add(s390, 2);
        this.setComboValues(t, value);
        this.setMnemonicValues(t, value);
        if (value == -2) {
            this.enableSectionButton.setSelection(false);
            this.integerCombo.setEnabled(false);
            this.decimalCombo.setEnabled(false);
            this.floatCombo.setEnabled(false);
            this.mnemonic.setEnabled(false);
            this.number.setEnabled(false);
        } else {
            this.enableSectionButton.setSelection(true);
            this.integerCombo.setEnabled(true);
            this.decimalCombo.setEnabled(true);
            this.floatCombo.setEnabled(true);
            this.mnemonic.setEnabled(true);
            this.number.setEnabled(true);
        }
    }

    private void setComboValues(Trace t, int value) {
        switch (value & 0xF) {
            case 1: {
                this.integerCombo.select(0);
                break;
            }
            case 2: {
                this.integerCombo.select(1);
                break;
            }
            default: {
                this.integerCombo.select(0);
            }
        }
        switch (value & 0xF0) {
            case 16: {
                this.decimalCombo.select(0);
                break;
            }
            case 32: {
                this.decimalCombo.select(1);
                break;
            }
            default: {
                this.decimalCombo.select(0);
            }
        }
        switch (value & 0xF00) {
            case 256: {
                this.floatCombo.select(0);
                break;
            }
            case 512: {
                this.floatCombo.select(1);
                break;
            }
            case 768: {
                this.floatCombo.select(2);
                break;
            }
            default: {
                this.floatCombo.select(0);
            }
        }
    }

    private int getCurrentValue(Trace t) {
        int result = 0;
        if (!this.enableSectionButton.getSelection()) {
            result = -2;
        } else {
            int index = this.integerCombo.getSelectionIndex();
            switch (index) {
                case 0: {
                    result |= 1;
                    break;
                }
                case 1: {
                    result |= 2;
                }
            }
            index = this.decimalCombo.getSelectionIndex();
            switch (index) {
                case 0: {
                    result |= 0x10;
                    break;
                }
                case 1: {
                    result |= 0x20;
                }
            }
            index = this.floatCombo.getSelectionIndex();
            switch (index) {
                case 0: {
                    result |= 0x100;
                    break;
                }
                case 1: {
                    result |= 0x200;
                    break;
                }
                case 2: {
                    result |= 0x300;
                }
            }
        }
        return result;
    }

    private void setMnemonicValues(Trace t, int value) {
        StringBuffer buffer = new StringBuffer();
        if (value == -2) {
            buffer.append("");
        } else if (value == 273) {
            buffer.append(NATIVE);
        } else {
            if ((value & 1) != 0) {
                buffer.append('N');
            } else if ((value & 2) != 0) {
                buffer.append('R');
            } else {
                buffer.append('?');
            }
            if ((value & 0x10) != 0) {
                buffer.append('N');
            } else if ((value & 0x20) != 0) {
                buffer.append('R');
            } else {
                buffer.append('?');
            }
            if ((value & 0x300) == 768) {
                buffer.append('3');
            } else if ((value & 0x100) == 256) {
                buffer.append('N');
            } else if ((value & 0x200) == 512) {
                buffer.append('R');
            } else {
                buffer.append('?');
            }
        }
        this.mnemonic.setText(buffer.toString());
        if (value == -2) {
            this.number.setText("");
        } else {
            this.number.setText(Integer.toString(value));
        }
    }

    public void restoreDefaults(Trace t) {
    }

    public boolean apply(Trace t, Object job) {
        int newValue;
        Integer objectValue;
        int originalValue;
        boolean isChanged = false;
        if (!this.readonly && (originalValue = (objectValue = (Integer)this.attr.getValue(t)).intValue()) != (newValue = this.getCurrentValue(t))) {
            DmServiceDefinitionObject dmServiceDefinitionObject = (DmServiceDefinitionObject)this.uiServiceDefinitionWSDL.getDmObject();
            Integer objectNewValue = newValue;
            if (dmServiceDefinitionObject.setAttributeValue(t, job, this.attr.getAttributeID(), 0, objectNewValue)) {
                isChanged = true;
            }
        }
        return isChanged;
    }

    public boolean isEnabled(Trace t) {
        return true;
    }

    public void changesApplied(Trace t) {
    }

    public void attrModified(AttributeModifiedEvent event) {
    }
}

