/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.servicedef.ui.internal.base;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.servicedef.core.internal.base.ServiceDefinitionDataModel;
import com.ibm.mq.explorer.servicedef.core.internal.objects.DmServiceDefinitionRepository;
import com.ibm.mq.explorer.servicedef.ui.extensions.ServiceDefinitionRepositoryExtObject;
import com.ibm.mq.explorer.servicedef.ui.internal.base.ObjectHandlerFactoryManager;
import com.ibm.mq.explorer.servicedef.ui.internal.base.ServiceDefinitionMenuActions;
import com.ibm.mq.explorer.servicedef.ui.internal.base.ServiceDefinitionTreeNodeFactory;
import com.ibm.mq.explorer.servicedef.ui.internal.defaults.ServiceDefinitionUnknownFilterProvider;
import com.ibm.mq.explorer.servicedef.ui.internal.objects.UiServiceDefinitionRepositoryFactory;
import com.ibm.mq.explorer.servicedef.ui.internal.repositories.ServiceDefinitionFolderTreeNode;
import com.ibm.mq.explorer.servicedef.ui.internal.repositories.ServiceDefinitionRepository;
import com.ibm.mq.explorer.servicedef.ui.internal.repositories.ServiceDefinitionRepositoryFilterProvider;
import com.ibm.mq.explorer.servicedef.ui.internal.repositories.ServiceDefinitionRepositoryTreeNode;
import com.ibm.mq.explorer.servicedef.ui.internal.repositories.UiServiceDefinitionRepository;
import com.ibm.mq.explorer.servicedef.ui.internal.wsdls.ServiceDefinitionWSDLFilterProvider;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class ServiceDefinitionPlugin
extends AbstractUIPlugin {
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.servicedef/src/com/ibm/mq/explorer/servicedef/ui/internal/base/ServiceDefinitionPlugin.java";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    private static final String pluginId = "com.ibm.mq.explorer.servicedef";
    private static ServiceDefinitionPlugin plugin;
    private static ResourceBundle resourceBundle;
    private static boolean pluginEnabled;
    private static boolean explorerInitialised;
    private static ServiceDefinitionDataModel dataModel;
    private static ServiceDefinitionFolderTreeNode serviceDefinitionFolderTreeNode;
    private static Message messages;
    private static Hashtable<String, ServiceDefinitionRepository> serviceDefinitionRepositories;
    private static boolean loadedRepositoriesFromDatamodel;
    private static ServiceDefinitionUnknownFilterProvider serviceDefinitionUnknownFilterProvider;
    private static ServiceDefinitionRepositoryFilterProvider serviceDefinitionRepositoryFilterProvider;
    private static ServiceDefinitionWSDLFilterProvider serviceDefinitionWSDLFilterProvider;

    static {
        serviceDefinitionRepositories = new Hashtable();
        loadedRepositoriesFromDatamodel = false;
        serviceDefinitionUnknownFilterProvider = new ServiceDefinitionUnknownFilterProvider();
        serviceDefinitionRepositoryFilterProvider = new ServiceDefinitionRepositoryFilterProvider();
        serviceDefinitionWSDLFilterProvider = new ServiceDefinitionWSDLFilterProvider();
    }

    public ServiceDefinitionPlugin() {
        plugin = this;
        try {
            resourceBundle = ResourceBundle.getBundle("com.ibm.mq.explorer.servicedef.ServiceDefPluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            resourceBundle = null;
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    static boolean isEnabled() {
        return pluginEnabled;
    }

    static void enable() {
        Trace t = Trace.getDefault();
        pluginEnabled = true;
        if (explorerInitialised) {
            ServiceDefinitionPlugin.initialise(t);
        }
    }

    static void initialise(Trace t) {
        explorerInitialised = true;
        if (pluginEnabled) {
            ObjectHandlerFactoryManager manager = new ObjectHandlerFactoryManager(t);
            manager.loadInternalObjectHandlerFactories(t);
            ArrayList objectHandlerFactories = manager.getList();
            messages = new Message(t, "com.ibm.mq.explorer.servicedef.ui.internal.base.ServiceDefStrings", ServiceDefinitionPlugin.class.getClassLoader());
            String stateLocation = ServiceDefinitionPlugin.getDefault().getStateLocation().toString();
            ClassLoader classLoader = ServiceDefinitionPlugin.class.getClassLoader();
            dataModel = new ServiceDefinitionDataModel(t, stateLocation, classLoader, objectHandlerFactories);
            if (Trace.isTracing) {
                t.data(66, "ServiceDefinitionPlugin.initialise", "Service Definition data store: " + stateLocation);
            }
            if (serviceDefinitionFolderTreeNode == null) {
                TreeNode mqRootTreeNode = UiPlugin.getUiMachineObject().getTreeNode();
                ServiceDefinitionTreeNodeFactory.addServiceDefinitionFolder(t, mqRootTreeNode);
                mqRootTreeNode.refresh();
            }
            ServiceDefinitionPlugin.loadServiceDefinitionRepositoriesFromDataModel(t);
        }
    }

    static void disable(Trace t) {
        pluginEnabled = false;
        explorerInitialised = true;
    }

    public static ServiceDefinitionPlugin getDefault() {
        return plugin;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = ServiceDefinitionPlugin.getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public static ResourceBundle getResourceBundle() {
        return resourceBundle;
    }

    public static void setResourceBundle(ResourceBundle bundle) {
        resourceBundle = bundle;
    }

    public static void refreshServiceDefinitionRepositoriesFromDataModel(Trace t) {
        if (pluginEnabled) {
            ArrayList<DmServiceDefinitionRepository> dmServiceDefinitionRepositories = dataModel.getRepositories();
            int i = 0;
            while (i < dmServiceDefinitionRepositories.size()) {
                DmServiceDefinitionRepository dmServiceDefinitionRepository = dmServiceDefinitionRepositories.get(i);
                if (!serviceDefinitionRepositories.containsKey(dmServiceDefinitionRepository.getFullName(t))) {
                    ServiceDefinitionPlugin.createServiceDefinitionRepository(t, dmServiceDefinitionRepository);
                    ServiceDefinitionMenuActions.asyncOpenRepository(t, dmServiceDefinitionRepository, UiPlugin.getShell(), false, false, false);
                }
                ++i;
            }
        }
    }

    private static void loadServiceDefinitionRepositoriesFromDataModel(Trace t) {
        if (!loadedRepositoriesFromDatamodel) {
            serviceDefinitionRepositories = new Hashtable();
            ArrayList<DmServiceDefinitionRepository> dmServiceDefinitionRepositories = dataModel.getRepositories();
            int i = 0;
            while (i < dmServiceDefinitionRepositories.size()) {
                DmServiceDefinitionRepository dmServiceDefinitionRepository = dmServiceDefinitionRepositories.get(i);
                ServiceDefinitionPlugin.createServiceDefinitionRepository(t, dmServiceDefinitionRepository);
                ServiceDefinitionMenuActions.asyncOpenRepository(t, dmServiceDefinitionRepository, UiPlugin.getShell(), false, false, false);
                ++i;
            }
            loadedRepositoriesFromDatamodel = true;
        }
    }

    public static ServiceDefinitionDataModel getDatamodel() {
        return dataModel;
    }

    public static String getMessage(String key) {
        return messages.getMessage(key);
    }

    public static String getMessage(String key, String[] inserts) {
        return messages.getMessage(key, inserts);
    }

    public static ServiceDefinitionFolderTreeNode getServiceDefinitionFolderTreeNode() {
        return serviceDefinitionFolderTreeNode;
    }

    public static void setServiceDefinitionFolderTreeNode(ServiceDefinitionFolderTreeNode treeNode) {
        serviceDefinitionFolderTreeNode = treeNode;
    }

    public static ServiceDefinitionRepository createServiceDefinitionRepository(Trace t, Shell sh, String name) {
        ServiceDefinitionRepository serviceDefinitionRepository = null;
        if (ServiceDefinitionPlugin.getServiceDefinitionRepository(name) == null) {
            try {
                DmServiceDefinitionRepository dmServiceDefinitionRepository = null;
                dmServiceDefinitionRepository = new DmServiceDefinitionRepository(t, name);
                ServiceDefinitionPlugin.getDatamodel().addRepository(t, dmServiceDefinitionRepository);
                serviceDefinitionRepository = ServiceDefinitionPlugin.createServiceDefinitionRepository(t, dmServiceDefinitionRepository);
            }
            catch (DmCoreException e) {
                MessageBox.showExceptionMessage((Trace)t, (Shell)sh, (DmCoreException)e);
            }
        }
        return serviceDefinitionRepository;
    }

    private static ServiceDefinitionRepository createServiceDefinitionRepository(Trace t, DmServiceDefinitionRepository dmServiceDefinitionRepository) {
        try {
            dmServiceDefinitionRepository.open(t);
        }
        catch (DmCoreException e) {
            MessageBox.showExceptionMessage((Trace)t, (Shell)UiPlugin.getShell(), (DmCoreException)e);
        }
        ServiceDefinitionRepository serviceDefinitionRepository = null;
        UiServiceDefinitionRepository serviceDefinitionRepositoryUiMQObject = UiServiceDefinitionRepositoryFactory.create(t, dmServiceDefinitionRepository);
        ServiceDefinitionRepositoryExtObject serviceDefinitionRepositoryExtObject = (ServiceDefinitionRepositoryExtObject)serviceDefinitionRepositoryUiMQObject.getExternalObject();
        String serviceDefinitionRepositoryId = dmServiceDefinitionRepository.getTitle();
        serviceDefinitionRepository = new ServiceDefinitionRepository(t, serviceDefinitionRepositoryId, dmServiceDefinitionRepository, serviceDefinitionRepositoryUiMQObject, serviceDefinitionRepositoryExtObject);
        serviceDefinitionRepositories.put(serviceDefinitionRepositoryId, serviceDefinitionRepository);
        ServiceDefinitionPlugin.refreshServiceDefinitionRepositories();
        return serviceDefinitionRepository;
    }

    private static void refreshServiceDefinitionRepositories() {
        if (serviceDefinitionFolderTreeNode != null) {
            serviceDefinitionFolderTreeNode.getParent().refresh();
        }
    }

    public static void removeServiceDefinitionRepository(Trace t, Shell sh, ServiceDefinitionRepository serviceDefinitionRepository) {
        DmServiceDefinitionRepository dmServiceDefinitionRepository = serviceDefinitionRepository.getDmObject();
        try {
            if (dmServiceDefinitionRepository.isOpen()) {
                dmServiceDefinitionRepository.close(t);
            }
            ServiceDefinitionPlugin.getDatamodel().removeRepository(t, dmServiceDefinitionRepository);
            ServiceDefinitionRepositoryTreeNode treeNode = serviceDefinitionRepository.getTreeNode();
            if (treeNode != null) {
                ServiceDefinitionPlugin.getServiceDefinitionFolderTreeNode().removeChildFromNode(treeNode);
            }
            serviceDefinitionRepositories.remove(serviceDefinitionRepository.getId());
            dmServiceDefinitionRepository.remove(t);
        }
        catch (DmCoreException e) {
            MessageBox.showExceptionMessage((Trace)t, (Shell)sh, (DmCoreException)e);
        }
        ServiceDefinitionPlugin.refreshServiceDefinitionRepositories();
    }

    public static ServiceDefinitionRepository getServiceDefinitionRepository(String Id) {
        return serviceDefinitionRepositories.get(Id);
    }

    public static Hashtable<String, ServiceDefinitionRepository> getAllServiceDefinitionRepositories() {
        return serviceDefinitionRepositories;
    }

    public static String getPluginId() {
        return pluginId;
    }

    public static ServiceDefinitionUnknownFilterProvider getServiceDefinitionUnknownFilterProvider() {
        return serviceDefinitionUnknownFilterProvider;
    }

    public static ServiceDefinitionRepositoryFilterProvider getServiceDefinitionRepositoryFilterProvider() {
        return serviceDefinitionRepositoryFilterProvider;
    }

    public static ServiceDefinitionWSDLFilterProvider getServiceDefinitionWSDLFilterProvider() {
        return serviceDefinitionWSDLFilterProvider;
    }

    public static void unknownDataModelEventReceived(Trace t, Object event) {
    }
}

