/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.servicedef.ui.exporters;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.servicedef.core.internal.objects.DmServiceDefinitionAbstractRepository;
import com.ibm.mq.explorer.servicedef.core.internal.objects.DmServiceDefinitionAbstractWSDL;
import com.ibm.mq.explorer.servicedef.core.internal.objects.DmServiceDefinitionObject;
import com.ibm.mq.explorer.servicedef.core.internal.objects.DmServiceDefinitionRepository;
import com.ibm.mq.explorer.servicedef.ui.exporters.WSDLExportContentProvider;
import com.ibm.mq.explorer.servicedef.ui.exporters.WSDLExportLabelProvider;
import com.ibm.mq.explorer.servicedef.ui.exporters.WSDLExportTreeViewerSorter;
import com.ibm.mq.explorer.servicedef.ui.exporters.WSDLExportViewerFilter;
import com.ibm.mq.explorer.servicedef.ui.internal.base.ServiceDefinitionPlugin;
import com.ibm.mq.explorer.servicedef.ui.internal.repositories.ServiceDefinitionRepository;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.CheckAndGreyTreeViewer;
import com.ibm.mq.explorer.ui.internal.controls.ExtDialog;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.util.ArrayList;
import java.util.Enumeration;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class WSDLExporterDialogBase
extends ExtDialog {
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.servicedef/src/com/ibm/mq/explorer/servicedef/ui/exporters/WSDLExporterDialogBase.java";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    protected Text fileBox = null;
    private Button browseButton = null;
    private String helpID = null;
    private String fileText = null;
    private String descrText = null;
    private String title = null;
    private Point preferredSize = null;
    protected CheckAndGreyTreeViewer treeViewer = null;
    private boolean isEnableOK = true;
    private ITreeContentProvider treeContentProvider = null;
    private ILabelProvider treeLabelProvider = null;
    private ViewerSorter treeViewSorter = null;
    private DmServiceDefinitionObject contextObject = null;

    public WSDLExporterDialogBase(Shell parent, String title, String descrText, String fileText, String help, ITreeContentProvider treeContentProvider, ILabelProvider labelProvider, ViewerSorter treeSorter, DmServiceDefinitionObject contextObject) {
        super(parent, 0);
        this.helpID = help;
        this.descrText = descrText;
        this.fileText = fileText;
        this.title = title;
        if (treeContentProvider != null) {
            this.treeContentProvider = treeContentProvider;
        }
        if (labelProvider != null) {
            this.treeLabelProvider = labelProvider;
        }
        if (treeSorter != null) {
            this.treeViewSorter = treeSorter;
        }
        this.contextObject = contextObject;
        this.create(Trace.getDefault());
    }

    protected void checkEnableOK() {
        Trace t = Trace.getDefault();
        int count = 0;
        Object[] checkedElements = this.treeViewer.getCheckedElements();
        int i = 0;
        while (i < checkedElements.length) {
            if (checkedElements[i] instanceof DmServiceDefinitionObject) {
                ++count;
                break;
            }
            ++i;
        }
        this.isEnableOK = count > 0 ? this.fileBox.getText().length() > 0 : false;
        super.enableOK(t, this.isEnableOK);
    }

    private void addFileBox(Trace t, String description, final Composite comp) {
        Message messageFile = UiPlugin.getUIMessages((Trace)t, (String)"KEY_Tables");
        Composite fileBoxComp = new Composite(comp, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 5;
        fileBoxComp.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 5;
        fileBoxComp.setLayoutData((Object)gridData);
        Label descr = new Label(fileBoxComp, 0);
        descr.setText(description);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        descr.setLayoutData((Object)gridData);
        this.fileBox = new Text(fileBoxComp, 2048);
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)this.fileBox, (boolean)true);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.fileBox.setLayoutData((Object)gridData);
        this.browseButton = new Button(fileBoxComp, 8);
        this.browseButton.setText(messageFile.getMessage(t, "UI.TABLES.Button.Browse"));
        gridData = new GridData(128);
        gridData.horizontalSpan = 2;
        this.browseButton.setLayoutData((Object)gridData);
        this.browseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String fn = WSDLExporterDialogBase.this.openBrowseDialog(comp.getShell());
                if (fn != null) {
                    WSDLExporterDialogBase.this.fileBox.setText(fn);
                    WSDLExporterDialogBase.this.fileBox.setSelection(fn.length() - 1);
                    WSDLExporterDialogBase.this.checkEnableOK();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        fileBoxComp.layout();
        fileBoxComp.pack();
    }

    public abstract boolean okPressed();

    public abstract void loadImportData(String var1);

    private String openBrowseDialog(Shell parent) {
        DirectoryDialog dd = new DirectoryDialog(parent, 0);
        dd.setFilterPath(this.fileBox.getText());
        String folder = dd.open();
        return folder;
    }

    public void cancelPressed(Trace t) {
    }

    public void createContent(Trace t, Composite composite) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 5;
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.marginHeight = 5;
        gridLayout.marginWidth = 5;
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        composite.setLayoutData((Object)gridData);
        Text text = new Text(composite, 66);
        text.setText(this.descrText);
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)text, (boolean)true);
        gridData = new GridData();
        gridData.widthHint = 500;
        gridData.horizontalSpan = 5;
        text.setLayoutData((Object)gridData);
        Label pad = new Label(composite, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        pad.setLayoutData((Object)gridData);
        this.treeViewer = new CheckAndGreyTreeViewer(composite);
        if (this.treeContentProvider != null) {
            this.treeViewer.setContentProvider((IContentProvider)this.treeContentProvider);
        } else {
            this.treeViewer.setContentProvider((IContentProvider)new WSDLExportContentProvider());
        }
        if (this.treeLabelProvider != null) {
            this.treeViewer.setLabelProvider((IBaseLabelProvider)this.treeLabelProvider);
        } else {
            this.treeViewer.setLabelProvider((IBaseLabelProvider)new WSDLExportLabelProvider());
        }
        if (this.treeViewSorter != null) {
            this.treeViewer.setSorter(this.treeViewSorter);
        } else {
            this.treeViewer.setSorter((ViewerSorter)new WSDLExportTreeViewerSorter());
        }
        this.treeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                WSDLExporterDialogBase.this.selectTreeElements((DmServiceDefinitionObject)event.getElement(), true);
                WSDLExporterDialogBase.this.checkEnableOK();
            }
        });
        this.treeViewer.addFilter((ViewerFilter)new WSDLExportViewerFilter());
        ArrayList<DmServiceDefinitionRepository> repositories = new ArrayList<DmServiceDefinitionRepository>();
        Enumeration<ServiceDefinitionRepository> repositoriesList = ServiceDefinitionPlugin.getAllServiceDefinitionRepositories().elements();
        while (repositoriesList.hasMoreElements()) {
            repositories.add(repositoriesList.nextElement().getDmObject());
        }
        Object[] treeNodes = repositories.toArray();
        this.treeViewer.setInput((Object)treeNodes);
        this.treeViewer.expandToLevel((Object)this.contextObject, 0);
        this.selectTreeElements(this.contextObject, false);
        gridData = new GridData(1808);
        gridData.heightHint = 300;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 5;
        this.treeViewer.getTree().setLayoutData((Object)gridData);
        pad = new Label(composite, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        pad.setLayoutData((Object)gridData);
        this.addFileBox(t, this.fileText, composite);
        this.fileBox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WSDLExporterDialogBase.this.checkEnableOK();
            }
        });
        pad = new Label(composite, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        pad.setLayoutData((Object)gridData);
        this.fileBox.setText("C:\\eclipse\\plugins\\padfilenamebox\\longfilename\\here");
        UiPlugin.getHelpSystem().setHelp((Control)composite, this.helpID);
        composite.pack();
        this.fileBox.setText("");
        this.preferredSize = composite.getSize();
        this.checkEnableOK();
    }

    public void createUserButtons(Trace t, Composite composite) {
    }

    public String getHelpId(Trace t) {
        return null;
    }

    public Image getImage(Trace t) {
        return null;
    }

    public Point getPreferredSize(Trace t) {
        return this.preferredSize;
    }

    public String getTitle(Trace t) {
        return this.title;
    }

    public boolean isEnableOK(Trace t) {
        return this.isEnableOK;
    }

    public boolean isPackDialog(Trace t) {
        return false;
    }

    public boolean isUserButtons(Trace t) {
        return false;
    }

    public boolean okPressed(Trace t) {
        return this.okPressed();
    }

    public void packDialog(Trace t) {
    }

    public boolean open(Trace t) {
        this.browseButton.setFocus();
        return super.open(t);
    }

    private void selectTreeElements(DmServiceDefinitionObject selectedObject, boolean postChanged) {
        if (this.contextObject instanceof DmServiceDefinitionAbstractWSDL || this.contextObject instanceof DmServiceDefinitionAbstractRepository) {
            Object[] children = this.treeContentProvider.getChildren((Object)selectedObject);
            boolean state = this.treeViewer.getChecked((Object)selectedObject);
            state = postChanged ? state : !state;
            this.treeViewer.setChecked((Object)selectedObject, state);
            int i = 0;
            while (i < children.length) {
                this.treeViewer.setChecked(children[i], state);
                ++i;
            }
        }
    }

    public void setTreeContentProvider(ITreeContentProvider provider) {
        this.treeContentProvider = provider;
    }

    public void setLabelProvider(ILabelProvider provider) {
        this.treeLabelProvider = provider;
    }

    public void setViewSorter(ViewerSorter sorter) {
        this.treeViewSorter = sorter;
    }
}

