/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.servicedef.ui.exporters;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.explorer.servicedef.core.internal.objects.DmServiceDefinitionAbstractWSDL;
import com.ibm.mq.explorer.servicedef.core.internal.objects.DmServiceDefinitionObject;
import com.ibm.mq.explorer.servicedef.core.internal.objects.WSDL;
import com.ibm.mq.explorer.servicedef.ui.exporters.WSDLExportContentProvider;
import com.ibm.mq.explorer.servicedef.ui.exporters.WSDLExportLabelProvider;
import com.ibm.mq.explorer.servicedef.ui.exporters.WSDLExportTreeViewerSorter;
import com.ibm.mq.explorer.servicedef.ui.exporters.WSDLExporterDialogBase;
import com.ibm.mq.explorer.servicedef.ui.internal.base.ServiceDefinitionPlugin;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.internal.wizards.datatransfer.FileSystemExportOperation;

public class WSDLExportWizard
extends WSDLExporterDialogBase
implements IOverwriteQuery {
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.servicedef/src/com/ibm/mq/explorer/servicedef/ui/exporters/WSDLExportWizard.java";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";

    public WSDLExportWizard(Shell parent, DmServiceDefinitionObject contextObject) {
        super(parent, ServiceDefinitionPlugin.getMessage("ServiceDefinition.Export.Wizard.Title"), ServiceDefinitionPlugin.getMessage("ServiceDefinition.Export.File.Description"), ServiceDefinitionPlugin.getMessage("ServiceDefinition.Export.File.FileSelectionDescription"), "com.ibm.mq.explorer.servicedef.infopop.UI_ServiceDefinitionExport", new WSDLExportContentProvider(), new WSDLExportLabelProvider(), new WSDLExportTreeViewerSorter(), contextObject);
    }

    @Override
    public void loadImportData(String filename) {
    }

    @Override
    public boolean okPressed() {
        Trace t = Trace.getDefault();
        this.enableOK(t, false);
        UiPlugin.showBusyCursor((Trace)t, (boolean)true);
        String exportFilename = this.fileBox.getText();
        Object[] elementsToExport = this.treeViewer.getCheckedElements();
        ArrayList<IResource> resources = new ArrayList<IResource>();
        IResource nextResource = null;
        int i = 0;
        while (i < elementsToExport.length) {
            if (elementsToExport[i] instanceof DmServiceDefinitionAbstractWSDL) {
                WSDL wsdlFile = (WSDL)((DmServiceDefinitionAbstractWSDL)elementsToExport[i]).getObject();
                nextResource = wsdlFile.getResource(t);
                resources.add(nextResource);
            }
            ++i;
        }
        NullProgressMonitor progressMonitor = new NullProgressMonitor();
        progressMonitor.beginTask("Copying files", resources.size());
        Iterator iterator = resources.iterator();
        File currentExportDestination = null;
        boolean canOverwriteFolderContents = false;
        boolean ignoreCurrentRepository = false;
        while (iterator.hasNext()) {
            IResource nextResourceToExport = (IResource)iterator.next();
            File nextExportDestination = new File(String.valueOf(exportFilename) + File.separator + nextResourceToExport.getParent().getName());
            if (currentExportDestination == null) {
                currentExportDestination = nextExportDestination;
            } else if (!currentExportDestination.equals(nextExportDestination)) {
                ignoreCurrentRepository = false;
                canOverwriteFolderContents = false;
                currentExportDestination = nextExportDestination;
            }
            if (!ignoreCurrentRepository) {
                if (!canOverwriteFolderContents) {
                    if (currentExportDestination.exists()) {
                        int ynBox = MessageBox.showYesNoMessage((Trace)t, (Shell)UiPlugin.getShell(), (String)CommonServices.getSystemMessage((String)"AMQ4869", (String[])new String[]{currentExportDestination.getAbsolutePath()}), (int)1, (String)"AMQ4869");
                        if (ynBox == 0) {
                            canOverwriteFolderContents = true;
                        } else {
                            ignoreCurrentRepository = true;
                        }
                    } else {
                        canOverwriteFolderContents = true;
                    }
                }
                if (canOverwriteFolderContents) {
                    FileSystemExportOperation fse = new FileSystemExportOperation(nextResourceToExport, exportFilename, (IOverwriteQuery)this);
                    try {
                        fse.run((IProgressMonitor)progressMonitor);
                    }
                    catch (Exception e) {
                        t.FFST(66, "WSDLExportWizard.okPressed", 2, 50024, "Failed to export service definition file: " + e.toString());
                    }
                }
            }
            progressMonitor.worked(1);
        }
        progressMonitor.done();
        UiPlugin.showBusyCursor((Trace)t, (boolean)false);
        return true;
    }

    public String queryOverwrite(String pathString) {
        return "ALL";
    }
}

