/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.servicedef.core.internal.xml;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.servicedef.core.internal.objects.WSDL;
import com.ibm.mq.explorer.servicedef.core.internal.objects.WSDLCommon;
import com.ibm.mq.explorer.servicedef.core.internal.params.ServiceDefinitionInputClientChannelConnectionName;
import com.ibm.mq.explorer.servicedef.core.internal.params.ServiceDefinitionInputClientChannelTransportType;
import com.ibm.mq.explorer.servicedef.core.internal.params.ServiceDefinitionInputEncoding;
import com.ibm.mq.explorer.servicedef.core.internal.params.ServiceDefinitionInputExpiry;
import com.ibm.mq.explorer.servicedef.core.internal.params.ServiceDefinitionInputMessageID;
import com.ibm.mq.explorer.servicedef.core.internal.params.ServiceDefinitionInputMessageType;
import com.ibm.mq.explorer.servicedef.core.internal.params.ServiceDefinitionInputPersistence;
import com.ibm.mq.explorer.servicedef.core.internal.params.ServiceDefinitionInputPriority;
import com.ibm.mq.explorer.servicedef.core.internal.params.ServiceDefinitionInputReportOptions;
import com.ibm.mq.explorer.servicedef.ui.internal.defaults.NewServiceDefinitionObjectProvider;
import com.ibm.mq.explorer.servicedef.ui.internal.wsdls.NewServiceDefinitionWSDLObjectProvider;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class XMLHandler {
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.servicedef/src/com/ibm/mq/explorer/servicedef/core/internal/xml/XMLHandler.java";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";

    private static void setServicePortProperty(String propertyValue, String xmlElementName, Element parentElement, Document document, int bindingType) {
        if (propertyValue.length() > 0) {
            Element parameter = document.createElement("wmqservice:" + xmlElementName);
            Text text = document.createTextNode(propertyValue);
            parameter.appendChild(text);
            parentElement.appendChild(parameter);
        }
    }

    private static void setServicePortProperties(Trace t, Element servicePort, WSDL wsdlObject, Document document, int bindingType) {
        XMLHandler.setServicePortProperty(wsdlObject.getInputCodedCharacterSetID(t), "codedCharSetId", servicePort, document, bindingType);
        XMLHandler.setServicePortProperty(ServiceDefinitionInputEncoding.getXMLString(wsdlObject.getInputEncoding(t)), "encoding", servicePort, document, bindingType);
        XMLHandler.setServicePortProperty(wsdlObject.getInputFormat(t), "format", servicePort, document, bindingType);
        XMLHandler.setServicePortProperty(ServiceDefinitionInputExpiry.getXMLString(wsdlObject.getInputExpiry(t)), "expiry", servicePort, document, bindingType);
        XMLHandler.setServicePortProperty(ServiceDefinitionInputMessageID.getXMLString(wsdlObject.getInputMessageID(t)), "msgId", servicePort, document, bindingType);
        XMLHandler.setServicePortProperty(ServiceDefinitionInputPersistence.getXMLString(wsdlObject.getInputPersistence(t)), "persistence", servicePort, document, bindingType);
        XMLHandler.setServicePortProperty(ServiceDefinitionInputPriority.getXMLString(wsdlObject.getInputPriority(t)), "priority", servicePort, document, bindingType);
        XMLHandler.setServicePortProperty(ServiceDefinitionInputReportOptions.getXMLString(wsdlObject.getInputReportOptions(t)), "reportOptions", servicePort, document, bindingType);
        XMLHandler.setServicePortProperty(ServiceDefinitionInputMessageID.getXMLString(wsdlObject.getInputCorrelationID(t)), "correlId", servicePort, document, bindingType);
        XMLHandler.setServicePortProperty(wsdlObject.getInputConnQM(t), "connectQueueManager", servicePort, document, bindingType);
        XMLHandler.setServicePortProperty(ServiceDefinitionInputMessageType.getXMLString(wsdlObject.getInputMessageType(t)), "msgType", servicePort, document, bindingType);
        XMLHandler.setServicePortProperty(wsdlObject.getInputUser(t), "usr", servicePort, document, bindingType);
        XMLHandler.setServicePortProperty(ServiceDefinitionInputClientChannelConnectionName.getXMLString(wsdlObject.getInputClientChannelConnName(t)), "connectionName", servicePort, document, bindingType);
        XMLHandler.setServicePortProperty(wsdlObject.getInputClientChannelName(t), "channelName", servicePort, document, bindingType);
        XMLHandler.setServicePortProperty(ServiceDefinitionInputClientChannelTransportType.getXMLString(wsdlObject.getInputClientChannelTransportType(t)), "transportType", servicePort, document, bindingType);
        XMLHandler.setServicePortProperty(wsdlObject.getInputChannelTableLibrary(t), "channelTableLib", servicePort, document, bindingType);
        XMLHandler.setServicePortProperty(wsdlObject.getInputChannelTableName(t), "channelTableName", servicePort, document, bindingType);
    }

    private static void setServicePortQueryParameter(String propertyValue, String uriElementName, StringBuffer queryString) {
        if (propertyValue.length() > 0) {
            if (queryString.length() > 0) {
                queryString.append("&");
            }
            queryString.append(String.valueOf(uriElementName) + "=" + propertyValue);
        }
    }

    private static String setServicePortReplyToQueryParameters(Trace t, WSDL wsdlObject) {
        StringBuffer queryString = new StringBuffer();
        XMLHandler.setServicePortQueryParameter(wsdlObject.getOutputCodedCharacterSetID(t), "codedCharSetId", queryString);
        XMLHandler.setServicePortQueryParameter(ServiceDefinitionInputEncoding.getXMLString(wsdlObject.getOutputEncoding(t)), "encoding", queryString);
        XMLHandler.setServicePortQueryParameter(wsdlObject.getOutputFormat(t), "format", queryString);
        XMLHandler.setServicePortQueryParameter(ServiceDefinitionInputExpiry.getXMLString(wsdlObject.getOutputExpiry(t)), "expiry", queryString);
        XMLHandler.setServicePortQueryParameter(ServiceDefinitionInputPersistence.getXMLString(wsdlObject.getOutputPersistence(t)), "persistence", queryString);
        XMLHandler.setServicePortQueryParameter(ServiceDefinitionInputPriority.getXMLString(wsdlObject.getOutputPriority(t)), "priority", queryString);
        XMLHandler.setServicePortQueryParameter(ServiceDefinitionInputReportOptions.getXMLString(wsdlObject.getOutputReportOptions(t)), "reportOptions", queryString);
        XMLHandler.setServicePortQueryParameter(ServiceDefinitionInputMessageID.getXMLString(wsdlObject.getOutputCorrelationID(t)), "correlId", queryString);
        XMLHandler.setServicePortQueryParameter(ServiceDefinitionInputMessageID.getXMLString(wsdlObject.getOutputMessageID(t)), "msgId", queryString);
        XMLHandler.setServicePortQueryParameter(ServiceDefinitionInputMessageType.getXMLString(wsdlObject.getOutputMessageType(t)), "msgType", queryString);
        XMLHandler.setServicePortQueryParameter(wsdlObject.getOutputUser(t), "usr", queryString);
        XMLHandler.setServicePortQueryParameter(wsdlObject.getOutputConnQM(t), "connectQueueManager", queryString);
        XMLHandler.setServicePortQueryParameter(wsdlObject.getOutputClientChannelName(t), "channelName", queryString);
        XMLHandler.setServicePortQueryParameter(ServiceDefinitionInputClientChannelTransportType.getXMLString(wsdlObject.getOutputClientChannelTransportType(t)), "transportType", queryString);
        XMLHandler.setServicePortQueryParameter(wsdlObject.getOutputChannelTableLibrary(t), "channelTableLib", queryString);
        XMLHandler.setServicePortQueryParameter(wsdlObject.getOutputChannelTableName(t), "channelTableName", queryString);
        if (queryString.length() > 0) {
            return queryString.toString();
        }
        return null;
    }

    public static String serialiseToXML(Trace t, String serviceDefinitionName, WSDL wsdlObject) {
        String xmlString = null;
        int bindingType = NewServiceDefinitionWSDLObjectProvider.getBindingType(t, wsdlObject.getBindingType(t));
        int MEP = NewServiceDefinitionObjectProvider.getMessageExchangePattern(t, wsdlObject.getMEP(t));
        boolean importedInNamespace = wsdlObject.getInputImportNamespace(t).length() > 0 || wsdlObject.getInputImportSchemaFile(t).length() > 0;
        boolean importedOutNamespace = wsdlObject.getOutputImportNamespace(t).length() > 0 || wsdlObject.getOutputImportSchemaFile(t).length() > 0;
        boolean importedNamespacesMatch = false;
        if (wsdlObject.getInputImportNamespace(t).equals(wsdlObject.getOutputImportNamespace(t)) && wsdlObject.getInputImportSchemaFile(t).equals(wsdlObject.getOutputImportSchemaFile(t))) {
            importedNamespacesMatch = true;
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element definitionsRoot = document.createElement("definitions");
            definitionsRoot.setAttribute("name", serviceDefinitionName);
            if (wsdlObject.getNamespace(t).length() > 0) {
                definitionsRoot.setAttribute("targetNamespace", wsdlObject.getNamespace(t));
            }
            definitionsRoot.setAttribute("xmlns:tns", wsdlObject.getNamespace(t));
            definitionsRoot.setAttribute("xmlns:wmqservice", "http://www.ibm.com/xmlns/prod/wmq/bindings/1.0");
            definitionsRoot.setAttribute("xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
            definitionsRoot.setAttribute("xmlns", "http://schemas.xmlsoap.org/wsdl/");
            if (bindingType == 1) {
                if (wsdlObject.getSOAPVersion(t) == 0) {
                    definitionsRoot.setAttribute("xmlns:soap", "http://schemas.xmlsoap.org/wsdl/soap/");
                } else if (wsdlObject.getSOAPVersion(t) == 1) {
                    definitionsRoot.setAttribute("xmlns:soap", "http://schemas.xmlsoap.org/wsdl/soap12/");
                }
            }
            if (importedInNamespace) {
                definitionsRoot.setAttribute("xmlns:importinms", wsdlObject.getInputImportNamespace(t));
            }
            if (importedOutNamespace && !importedNamespacesMatch) {
                definitionsRoot.setAttribute("xmlns:importoutms", wsdlObject.getOutputImportNamespace(t));
            }
            document.appendChild(definitionsRoot);
            if (importedInNamespace || importedOutNamespace) {
                Element types = document.createElement("types");
                Element xsdSchema = document.createElement("xsd:schema");
                xsdSchema.setAttribute("xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
                if (importedInNamespace) {
                    Element xsdInput = document.createElement("xsd:import");
                    if (wsdlObject.getInputImportNamespace(t).length() > 0) {
                        xsdInput.setAttribute("namespace", wsdlObject.getInputImportNamespace(t));
                    }
                    if (wsdlObject.getInputImportSchemaFile(t).length() > 0) {
                        xsdInput.setAttribute("schemaLocation", wsdlObject.getInputImportSchemaFile(t));
                    }
                    xsdSchema.appendChild(xsdInput);
                }
                if (importedOutNamespace && !importedNamespacesMatch) {
                    Element xsdOutput = document.createElement("xsd:import");
                    if (wsdlObject.getOutputImportNamespace(t).length() > 0) {
                        xsdOutput.setAttribute("namespace", wsdlObject.getOutputImportNamespace(t));
                    }
                    if (wsdlObject.getOutputImportSchemaFile(t).length() > 0) {
                        xsdOutput.setAttribute("schemaLocation", wsdlObject.getOutputImportSchemaFile(t));
                    }
                    xsdSchema.appendChild(xsdOutput);
                }
                types.appendChild(xsdSchema);
                definitionsRoot.appendChild(types);
            }
            Element inputMessage = document.createElement("message");
            inputMessage.setAttribute("name", String.valueOf(wsdlObject.getOperationName(t)) + "_" + "Input");
            Element inputMessagePart = document.createElement("part");
            inputMessagePart.setAttribute("name", String.valueOf(wsdlObject.getOperationName(t)) + "_" + "Input" + "_" + "Part");
            if (importedInNamespace) {
                inputMessagePart.setAttribute("type", "importinms:" + wsdlObject.getInputType(t));
            } else {
                inputMessagePart.setAttribute("type", wsdlObject.getInputType(t));
            }
            inputMessage.appendChild(inputMessagePart);
            definitionsRoot.appendChild(inputMessage);
            if (MEP == 1) {
                Element outputMessage = document.createElement("message");
                outputMessage.setAttribute("name", String.valueOf(wsdlObject.getOperationName(t)) + "_" + "Output");
                Element outputMessagePart = document.createElement("part");
                outputMessagePart.setAttribute("name", String.valueOf(wsdlObject.getOperationName(t)) + "_" + "Output" + "_" + "Part");
                if (importedOutNamespace && !importedNamespacesMatch) {
                    outputMessagePart.setAttribute("type", "importoutms:" + wsdlObject.getOutputType(t));
                } else if (importedOutNamespace && importedNamespacesMatch) {
                    outputMessagePart.setAttribute("type", "importinms:" + wsdlObject.getOutputType(t));
                } else {
                    outputMessagePart.setAttribute("type", wsdlObject.getOutputType(t));
                }
                outputMessage.appendChild(outputMessagePart);
                definitionsRoot.appendChild(outputMessage);
            }
            Element portType = document.createElement("portType");
            portType.setAttribute("name", String.valueOf(serviceDefinitionName) + "_" + "PortType");
            Element operation = document.createElement("operation");
            operation.setAttribute("name", wsdlObject.getOperationName(t));
            Element input = document.createElement("input");
            input.setAttribute("message", "tns:" + wsdlObject.getOperationName(t) + "_" + "Input");
            operation.appendChild(input);
            if (MEP == 1) {
                Element output = document.createElement("output");
                output.setAttribute("message", "tns:" + wsdlObject.getOperationName(t) + "_" + "Output");
                operation.appendChild(output);
            }
            portType.appendChild(operation);
            definitionsRoot.appendChild(portType);
            Element binding = document.createElement("binding");
            binding.setAttribute("name", String.valueOf(serviceDefinitionName) + "_" + "Wmq_Binding");
            binding.setAttribute("type", "tns:" + serviceDefinitionName + "_" + "PortType");
            if (bindingType == 0) {
                Element wmqServiceBinding = document.createElement("wmqservice:binding");
                binding.appendChild(wmqServiceBinding);
            } else if (bindingType == 1) {
                Element soapBinding = document.createElement("soap:binding");
                soapBinding.setAttribute("style", "document");
                soapBinding.setAttribute("transport", "http://www.ibm.com/xmlns/prod/wmq/transport");
                binding.appendChild(soapBinding);
            }
            Element bindingOperation = document.createElement("operation");
            bindingOperation.setAttribute("name", wsdlObject.getOperationName(t));
            if (wsdlObject.getOperationComment(t).length() > 0) {
                Element bindingOperationDocumentation = document.createElement("documentation");
                Text operationDocumentationText = document.createTextNode(wsdlObject.getOperationComment(t));
                bindingOperationDocumentation.appendChild(operationDocumentationText);
                bindingOperation.appendChild(bindingOperationDocumentation);
            }
            if (bindingType == 0) {
                if (wsdlObject.getAction(t).length() > 0) {
                    Element wmqServiceTargetAction = document.createElement("wmqservice:targetAction");
                    Text operationActionText = document.createTextNode(wsdlObject.getAction(t));
                    wmqServiceTargetAction.appendChild(operationActionText);
                    bindingOperation.appendChild(wmqServiceTargetAction);
                }
            } else if (bindingType == 1) {
                Element soapAction = document.createElement("soap:operation");
                soapAction.setAttribute("style", "document");
                soapAction.setAttribute("soapAction", wsdlObject.getAction(t));
                bindingOperation.appendChild(soapAction);
            }
            Element operationInput = document.createElement("input");
            if (bindingType == 0) {
                Element wmqServiceBodyInput = document.createElement("wmqservice:body");
                operationInput.appendChild(wmqServiceBodyInput);
            } else if (bindingType == 1) {
                Element soapServiceBodyInput = document.createElement("soap:body");
                soapServiceBodyInput.setAttribute("use", "literal");
                operationInput.appendChild(soapServiceBodyInput);
            }
            bindingOperation.appendChild(operationInput);
            if (MEP == 1) {
                Element operationOutput = document.createElement("output");
                if (bindingType == 0) {
                    Element wmqServiceBodyOutput = document.createElement("wmqservice:body");
                    operationOutput.appendChild(wmqServiceBodyOutput);
                } else if (bindingType == 1) {
                    Element soapServiceBodyOutput = document.createElement("soap:body");
                    soapServiceBodyOutput.setAttribute("use", "literal");
                    operationOutput.appendChild(soapServiceBodyOutput);
                }
                bindingOperation.appendChild(operationOutput);
            }
            binding.appendChild(bindingOperation);
            definitionsRoot.appendChild(binding);
            Element service = document.createElement("service");
            service.setAttribute("name", serviceDefinitionName);
            if (wsdlObject.getServiceComment(t).length() > 0) {
                Element serviceDocumentation = document.createElement("documentation");
                Text serviceDocumentationText = document.createTextNode(wsdlObject.getServiceComment(t));
                serviceDocumentation.appendChild(serviceDocumentationText);
                service.appendChild(serviceDocumentation);
            }
            Element servicePort = document.createElement("port");
            servicePort.setAttribute("name", String.valueOf(serviceDefinitionName) + "_" + "Wmq_Port");
            servicePort.setAttribute("binding", "tns:" + serviceDefinitionName + "_" + "Wmq_Binding");
            Element servicePortAddress = null;
            if (bindingType == 0) {
                servicePortAddress = document.createElement("wmqservice:address");
            } else if (bindingType == 1) {
                servicePortAddress = document.createElement("soap:address");
            } else {
                t.FFST(66, "XMLHandler.serialiseToXML", 2, 50024, "Expected MQ or SOAP binding type, but was neither.");
                servicePortAddress = document.createElement("address");
            }
            StringBuffer schemeSpecificPart = new StringBuffer("/" + wsdlObject.getInputQ(t));
            if (wsdlObject.getInputQM(t).length() > 0) {
                schemeSpecificPart.append("@" + wsdlObject.getInputQM(t));
            }
            URI addressLocation = new URI("wmq", schemeSpecificPart.toString(), null);
            servicePortAddress.setAttribute("location", addressLocation.toString());
            servicePort.appendChild(servicePortAddress);
            if (MEP == 1 && wsdlObject.getOutputQ(t).length() > 0) {
                Element servicePortReplyTo = document.createElement("wmqservice:replyTo");
                StringBuffer replyToSchemeSpecificPart = new StringBuffer("/" + wsdlObject.getOutputQ(t));
                if (wsdlObject.getOutputQM(t).length() > 0) {
                    replyToSchemeSpecificPart.append("@" + wsdlObject.getOutputQM(t));
                }
                String queryString = XMLHandler.setServicePortReplyToQueryParameters(t, wsdlObject);
                URI replyToAddressLocation = null;
                if (wsdlObject.getOutputClientChannelConnName(t).length() > 0) {
                    String host = WSDLCommon.getConnectionNameHost(t, wsdlObject.getOutputClientChannelConnName(t));
                    int port = WSDLCommon.getConnectionNamePort(t, wsdlObject.getOutputClientChannelConnName(t));
                    if (WSDLCommon.isIPv6(t, host)) {
                        host = "[" + host + "]";
                    }
                    replyToAddressLocation = new URI("wmq", null, host, port, replyToSchemeSpecificPart.toString(), queryString, null);
                } else {
                    replyToAddressLocation = new URI("wmq", null, replyToSchemeSpecificPart.toString(), queryString, null);
                }
                Text replyToAddressText = document.createTextNode(replyToAddressLocation.toString());
                servicePortReplyTo.appendChild(replyToAddressText);
                servicePort.appendChild(servicePortReplyTo);
            }
            XMLHandler.setServicePortProperties(t, servicePort, wsdlObject, document, bindingType);
            service.appendChild(servicePort);
            definitionsRoot.appendChild(service);
            TransformerFactory tFactory = TransformerFactory.newInstance();
            try {
                tFactory.setAttribute("indent-number", 2);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            try {
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            }
            catch (Exception exception) {}
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(new OutputStreamWriter((OutputStream)baos, "UTF-8"));
            DOMSource documentSource = new DOMSource(document);
            transformer.transform(documentSource, result);
            xmlString = baos.toString("UTF-8");
        }
        catch (ParserConfigurationException e) {
            t.FFST(66, "XMLHandler.serialiseToXML", 2, 50024, "Failed to configure the WSDL parser: " + e.toString());
        }
        catch (TransformerConfigurationException e) {
            t.FFST(66, "XMLHandler.serialiseToXML", 2, 50024, "Failed to configure the WSDL transformer: " + e.toString());
        }
        catch (TransformerException e) {
            t.FFST(66, "XMLHandler.serialiseToXML", 2, 50024, "WSDL transformer exception: " + e.toString());
        }
        catch (Exception e) {
            t.FFST(66, "XMLHandler.serialiseToXML", 2, 50024, "Exception thrown generating WSDL: " + e.toString());
        }
        return xmlString;
    }

    public static void deserialiseFromXML(Trace t, File xmlFile, WSDL wsdlObject) {
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = docBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(xmlFile);
            document.getDocumentElement().normalize();
            NodeList definitions = document.getElementsByTagName("definitions");
            if (definitions.getLength() == 1) {
                Node rootDefinitionsNode = definitions.item(0);
                if (rootDefinitionsNode instanceof Element) {
                    Element rootDefinitionsElement = (Element)rootDefinitionsNode;
                    String targetNamespace = rootDefinitionsElement.getAttribute("targetNamespace");
                    wsdlObject.setNamespace(t, targetNamespace);
                    String soapNamespace = rootDefinitionsElement.getAttribute("xmlns:soap");
                    if (soapNamespace.length() == 0) {
                        wsdlObject.setBindingType(t, NewServiceDefinitionWSDLObjectProvider.getBindingTypeText(t, 0));
                    } else {
                        wsdlObject.setBindingType(t, NewServiceDefinitionWSDLObjectProvider.getBindingTypeText(t, 1));
                    }
                    NodeList messageNodes = rootDefinitionsElement.getElementsByTagName("message");
                    if (messageNodes.getLength() == 1) {
                        wsdlObject.setMEP(t, NewServiceDefinitionObjectProvider.getMessageExchangePatternText(t, 0));
                    } else if (messageNodes.getLength() == 2) {
                        wsdlObject.setMEP(t, NewServiceDefinitionObjectProvider.getMessageExchangePatternText(t, 1));
                    }
                }
            } else {
                t.FFST(66, "XMLHandler.deserialiseFromXML", 2, 50024, "Failed to deserialise the WSDL: No definitions found");
            }
        }
        catch (SAXException e) {
            t.FFST(66, "XMLHandler.deserialiseFromXML", 2, 50024, "Failed to deserialise the WSDL: " + e.toString());
        }
        catch (IOException e) {
            t.FFST(66, "XMLHandler.deserialiseFromXML", 2, 50024, "Failed to read the WSDL: " + e.toString());
        }
        catch (ParserConfigurationException e) {
            t.FFST(66, "XMLHandler.deserialiseFromXML", 2, 50024, "Failed to configure the WSDL parser: " + e.toString());
        }
    }
}

