/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.servicedef.core.internal.params;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.utils.CoreServices;
import com.ibm.mq.explorer.servicedef.core.internal.objects.DmServiceDefinitionObject;
import com.ibm.mq.explorer.servicedef.core.internal.params.IServiceDefinitionParameter;
import java.util.Hashtable;

public abstract class AbstractServiceDefinitionParameter
implements IServiceDefinitionParameter {
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.servicedef/src/com/ibm/mq/explorer/servicedef/core/internal/params/AbstractServiceDefinitionParameter.java";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    protected int PCFID;
    protected String longName;

    public AbstractServiceDefinitionParameter(int id, String longName) {
        this.PCFID = id;
        this.longName = longName;
    }

    @Override
    public void actionChange(Trace t, DmServiceDefinitionObject dmObject) throws DmCoreException {
        Attr attr = dmObject.getAttributeInternal(t, this.PCFID, 0);
        Object newValue = attr.getNewValue(t);
        if (newValue != null) {
            this.update(t, dmObject, newValue);
        }
    }

    @Override
    public void actionRestore(Trace t, DmServiceDefinitionObject dmObject) throws DmCoreException {
        Attr attr = dmObject.getAttributeInternal(t, this.PCFID, 0);
        Object value = attr.getValue(t);
        this.update(t, dmObject, value);
    }

    @Override
    public void replaceValue(Trace t, DmServiceDefinitionObject dmObject) {
        Attr attr = dmObject.getAttributeInternal(t, this.PCFID, 0);
        Object newValue = attr.getNewValue(t);
        attr.replaceValue(t, newValue);
    }

    public abstract void update(Trace var1, DmServiceDefinitionObject var2, Object var3) throws DmCoreException;

    @Override
    public void validate(Trace t, DmServiceDefinitionObject dmObject) throws DmCoreException {
    }

    @Override
    public void addToHashtable(Hashtable<Integer, IServiceDefinitionParameter> table) {
        table.put(this.getId(), this);
    }

    @Override
    public int getId() {
        return this.PCFID;
    }

    @Override
    public String getLongName() {
        return this.longName;
    }

    @Override
    public String getFieldName(Trace t) {
        String stem = this.getLabelResourceStem();
        String name = CoreServices.message.getMessage(t, String.valueOf(stem) + ".title");
        String propTitle = CoreServices.message.getMessage(t, String.valueOf(stem) + Message.PROP_TITLE);
        if (propTitle.indexOf(Message.PROP_TITLE) == -1) {
            name = propTitle;
        }
        return name;
    }

    @Override
    public String getLabelResourceStem() {
        return "SERVICEDEFINITION_" + this.longName.toUpperCase();
    }

    @Override
    public String getSelectTitleId() {
        return "ServiceDef.SelectObject.title";
    }

    @Override
    public String getSelectDescriptionId() {
        return "ServiceDef.SelectObject." + this.longName + ".description";
    }
}

