/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.servicedef.core.internal.objects;

import com.ibm.mq.commonservices.internal.trace.Trace;

public class WSDLCommon {
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.servicedef/src/com/ibm/mq/explorer/servicedef/core/internal/objects/WSDLCommon.java";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String UNDERSCORE = "_";
    public static final String COLON = ":";
    public static final String OPEN_PARENTHESIS = "(";
    public static final String CLOSE_PARENTHESIS = ")";
    public static final String OPEN_SQUARE_BRACKET = "[";
    public static final String CLOSE_SQUARE_BRACKET = "]";
    public static final String FORWARD_SLASH = "/";
    public static final String AT_SYMBOL = "@";
    public static final String EQUALS = "=";
    public static final String AMPERSAND = "&";
    public static final String INPUT = "Input";
    public static final String OUTPUT = "Output";
    public static final String TYPE = "Type";
    public static final String PART = "Part";
    public static final String PORT_TYPE = "PortType";
    public static final String WMQ_BINDING = "Wmq_Binding";
    public static final String WMQ_PORT = "Wmq_Port";
    public static final String DOCUMENT = "document";
    public static final String LITERAL = "literal";
    public static final String SCHEMA = "schema";
    public static final String SCHEMA_LOCATION = "schemaLocation";
    public static final String NAMESPACE = "namespace";
    public static final String XML_ELT_NAME_DEFINITIONS = "definitions";
    public static final String XML_ELT_NAME_MESSAGE = "message";
    public static final String XML_ELT_NAME_PORT_TYPE = "portType";
    public static final String XML_ELT_NAME_BINDING = "binding";
    public static final String XML_ELT_NAME_OPERATION = "operation";
    public static final String XML_ELT_NAME_SERVICE = "service";
    public static final String XML_ELT_NAME_DOCUMENTATION = "documentation";
    public static final String XML_ELT_NAME_INPUT = "input";
    public static final String XML_ELT_NAME_OUTPUT = "output";
    public static final String XML_ELT_NAME_TARGET_ACTION = "targetAction";
    public static final String XML_ELT_NAME_ADDRESS = "address";
    public static final String XML_ELT_NAME_PORT = "port";
    public static final String XML_ELT_NAME_TYPES = "types";
    public static final String XML_ELT_NAME_PART = "part";
    public static final String XML_ELT_NAME_REPLY_TO = "replyTo";
    public static final String XML_ELT_NAME_IMPORT = "import";
    public static final String XML_ATT_NAME_SERVICE_NAME = "name";
    public static final String XML_ATT_NAME_TARGET_NAMESPACE = "targetNamespace";
    public static final String XML_ATT_NAME_NAME = "name";
    public static final String XML_ATT_NAME_TYPE = "type";
    public static final String XML_ATT_NAME_MESSAGE = "message";
    public static final String XML_ATT_NAME_BODY = "body";
    public static final String XML_ATT_NAME_BINDING = "binding";
    public static final String XML_ATT_NAME_STYLE = "style";
    public static final String XML_ATT_NAME_TRANSPORT = "transport";
    public static final String XML_ATT_NAME_CONTENT_TYPE = "contentType";
    public static final String XML_ATT_NAME_SOAP_ACTION = "soapAction";
    public static final String XML_ATT_NAME_USE = "use";
    public static final String XML_ATT_NAME_LOCATION = "location";
    public static final String XML_NS_PREFIX = "xmlns";
    public static final String XML_NS_TNS = "tns";
    public static final String XML_NS_WMQ_SERVICE = "wmqservice";
    public static final String XML_NS_XSD = "xsd";
    public static final String XML_NS_SOAP = "soap";
    public static final String XML_NS_IMPORT_IN = "importinms";
    public static final String XML_NS_IMPORT_OUT = "importoutms";
    public static final String XML_NS_TNS_FULL = "xmlns:tns";
    public static final String XML_NS_WMQ_SERVICE_FULL = "xmlns:wmqservice";
    public static final String XML_NS_XSD_FULL = "xmlns:xsd";
    public static final String XML_NS_SOAP_FULL = "xmlns:soap";
    public static final String XML_NS_IMPORT_IN_FULL = "xmlns:importinms";
    public static final String XML_NS_IMPORT_OUT_FULL = "xmlns:importoutms";
    public static final String XML_NS_URI_WMQ_SERVICE = "http://www.ibm.com/xmlns/prod/wmq/bindings/1.0";
    public static final String XML_NS_URI_XSD = "http://www.w3.org/2001/XMLSchema";
    public static final String XML_NS_URI_SOAP_1_1 = "http://schemas.xmlsoap.org/wsdl/soap/";
    public static final String XML_NS_URI_SOAP_1_2 = "http://schemas.xmlsoap.org/wsdl/soap12/";
    public static final String XML_NS_URI = "http://schemas.xmlsoap.org/wsdl/";
    public static final String XML_URI_TRANSPORT = "http://www.ibm.com/xmlns/prod/wmq/transport";
    public static final String XML_URI_SCHEME_WMQ = "wmq";

    public WSDLCommon(Trace t) {
    }

    public static boolean isIPv6(Trace t, String hostName) {
        boolean isIPv6 = false;
        int indexOfFirstColon = hostName.indexOf(COLON);
        if (indexOfFirstColon < hostName.length() - 1) {
            int indexOfSecondColon = hostName.indexOf(COLON, indexOfFirstColon + 1);
            isIPv6 = indexOfFirstColon >= 0 && indexOfSecondColon >= 0 && indexOfFirstColon != indexOfSecondColon;
        }
        return isIPv6;
    }

    public static String getConnectionNameHost(Trace t, String connectionName) {
        String host = connectionName;
        int bracketIndex = connectionName.indexOf(OPEN_PARENTHESIS);
        if (bracketIndex >= 0) {
            host = connectionName.substring(0, bracketIndex);
        }
        return host;
    }

    public static int getConnectionNamePort(Trace t, String connectionName) {
        int port = -1;
        String portString = "";
        int openBracketIndex = connectionName.indexOf(OPEN_PARENTHESIS);
        int closeBracketIndex = connectionName.indexOf(CLOSE_PARENTHESIS);
        if (openBracketIndex >= 0 && closeBracketIndex >= 0 && closeBracketIndex > openBracketIndex) {
            portString = connectionName.substring(openBracketIndex + 1, closeBracketIndex);
            try {
                port = Integer.parseInt(portString);
            }
            catch (NumberFormatException e) {
                t.FFST(66, "WSDLCommon.getConnectionNamePort", 2, 50024, "Failed to parse port from connection name: " + e.toString());
            }
            if (port < 0) {
                port = -1;
            }
        }
        return port;
    }
}

