/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.servicedef.core.internal.objects;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.explorer.core.internal.attrs.AbstractAttrTypeEnum;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.servicedef.core.internal.exceptions.NameAlreadyExistsException;
import com.ibm.mq.explorer.servicedef.core.internal.objects.DmServiceDefinitionAbstractRepository;
import com.ibm.mq.explorer.servicedef.core.internal.objects.DmServiceDefinitionObject;
import com.ibm.mq.explorer.servicedef.ui.internal.base.ServiceDefinitionPlugin;
import java.io.FileNotFoundException;
import javax.naming.NamingException;

public class ErrorHandler {
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.servicedef/src/com/ibm/mq/explorer/servicedef/core/internal/objects/ErrorHandler.java";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    private static final ErrorHandler singleton = new ErrorHandler();
    public static final int OPERATION_FILE_CREATE = 0;
    public static final int OPERATION_FILE_DELETE = 1;
    public static final int OPERATION_REPOSITORY_CREATE = 2;
    public static final int OPERATION_REPOSITORY_DELETE = 3;
    public static final int OPERATION_REPOSITORY_OPEN = 4;
    private static final String[] operationNames = new String[]{"createFile", "deleteFile", "createRepository", "deleteRepository", "openRepository"};

    private ErrorHandler() {
    }

    public static ErrorHandler getHandler() {
        return singleton;
    }

    public void handleException(Trace t, Exception e, String name, DmServiceDefinitionObject dmServiceDefinitionObject, int operation) throws DmCoreException {
        this.traceError(t, e, "ErrorHandler.handleException");
        if (e instanceof NameAlreadyExistsException) {
            this.handleNameAlreadyExistsException(t, (NameAlreadyExistsException)e, name, dmServiceDefinitionObject, operation);
        } else if (e instanceof FileNotFoundException) {
            this.handleFileNotFoundException(t, (FileNotFoundException)e, name, dmServiceDefinitionObject, operation);
        } else {
            this.handleUnexpected(t, e, name, dmServiceDefinitionObject, operation, false);
        }
    }

    private void handleNameAlreadyExistsException(Trace t, NameAlreadyExistsException e, String name, DmServiceDefinitionObject dmServiceDefinitionObject, int operation) throws DmCoreException {
        String insert = name;
        this.throwException(t, (Throwable)e, "ServiceDefinition.Exception.Type.AlreadyExists", insert);
    }

    private void handleFileNotFoundException(Trace t, FileNotFoundException e, String name, DmServiceDefinitionObject dmServiceDefinitionObject, int operation) throws DmCoreException {
        String insert = name;
        this.throwException(t, (Throwable)e, "ServiceDefinition.Exception.Type.FileNotFound", insert);
    }

    public void handleUnexpected(Trace t, Throwable e, String name, DmServiceDefinitionAbstractRepository dmServiceDefinitionRepository, int operation) throws DmCoreException {
        this.handleUnexpected(t, e, name, dmServiceDefinitionRepository, operation, true);
    }

    private void handleUnexpected(Trace t, Throwable e, String name, DmServiceDefinitionObject dmServiceDefinitionObject, int operation, boolean traceError) throws DmCoreException {
        if (traceError) {
            this.traceError(t, e, "ErrorHandler.handleUnexpected");
        }
        String insert0 = e.toString();
        String insert1 = operationNames[operation];
        String insert2 = name;
        String[] inserts = new String[]{insert0, insert1, insert2};
        this.throwException(t, e, CommonServices.getSystemMessage((String)"AMQ4868"), inserts);
    }

    private void throwException(Trace t, Throwable cause, String msgId, String insert) throws DmCoreException {
        String[] inserts = new String[]{insert};
        this.throwException(t, cause, msgId, inserts);
    }

    private void throwException(Trace t, Throwable cause, String msgId, String[] inserts) throws DmCoreException {
        DmCoreException dmCoreException = this.generateException(t, cause, msgId, inserts);
        throw dmCoreException;
    }

    private DmCoreException generateException(Trace t, Throwable cause, String msgId, String[] inserts) {
        String message = ServiceDefinitionPlugin.getMessage(msgId, inserts);
        DmCoreException dmCoreException = this.generateException(t, cause, msgId, message);
        return dmCoreException;
    }

    private DmCoreException generateException(Trace t, Throwable cause, String msgId, String message) {
        DmCoreException dmCoreException = null;
        dmCoreException = cause == null ? new DmCoreException(t, message, msgId, 50042, 0, 30) : new DmCoreException(t, message, cause, msgId, 50042, 0, 30);
        return dmCoreException;
    }

    public DmCoreException generateDamagedObjectException(Trace t, Throwable e, String name, DmServiceDefinitionAbstractRepository dmServiceDefinitionRepository) {
        this.traceError(t, e, "ErrorHandler.generateDamagedObjectException");
        String insert0 = e.toString();
        String insert1 = name;
        String insert2 = null;
        String msgId = null;
        Throwable rootCause = null;
        if (e instanceof NamingException) {
            rootCause = ((NamingException)e).getRootCause();
        }
        if (rootCause == null) {
            msgId = "ServiceDefinition.Exception.Type.UnexpectedFileLookup";
        } else {
            insert2 = rootCause.getMessage();
            msgId = "ServiceDefinition.Exception.Type.UnexpectedFileLookup2";
        }
        String[] inserts = new String[]{insert0, insert1, insert2};
        DmCoreException dmCoreException = this.generateException(t, e, msgId, inserts);
        return dmCoreException;
    }

    public void throwInconsistentAttributesException(Trace t, Attr changingAttr, Attr conflictingAttr) throws DmCoreException {
        String msgId = "ServiceDefinition.Exception.Type.InconsistentAttrs";
        AttrType changingAttrType = changingAttr.getAttrType();
        AttrType conflictingAttrType = conflictingAttr.getAttrType();
        Object changingValue = changingAttr.getNewValue(t);
        Object conflictingValue = conflictingAttr.getValue(t);
        String insert0 = changingAttrType.getDisplayTitle();
        String insert1 = changingAttrType.getDisplayGroup().toString(t);
        String insert2 = ((AbstractAttrTypeEnum)changingAttrType).getEnumeratedValue(t, (Number)changingValue);
        String insert3 = conflictingAttrType.getDisplayTitle();
        String insert4 = conflictingAttrType.getDisplayGroup().toString(t);
        String insert5 = ((AbstractAttrTypeEnum)conflictingAttrType).getEnumeratedValue(t, (Number)conflictingValue);
        String[] inserts = new String[]{insert0, insert1, insert2, insert3, insert4, insert5};
        this.throwException(t, null, msgId, inserts);
    }

    private void traceError(Trace t, Throwable throwable, String fid) {
        if (Trace.isTracing && t != null && throwable != null) {
            String stackTrace = t.getJavaStack(throwable);
            StringBuffer errorMessage = new StringBuffer("Exception caught in JMS Admin:\n" + throwable.toString() + "\n" + stackTrace);
            Throwable cause = throwable.getCause();
            if (cause != null) {
                String causeStackTrace = t.getJavaStack(cause);
                errorMessage.append("Caused by:\n" + cause.toString() + "\n" + causeStackTrace);
            }
            t.data(66, fid, errorMessage.toString());
        }
    }
}

