/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.servicedef.core.internal.objects;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.servicedef.core.internal.base.ServiceDefinitionDataModel;
import com.ibm.mq.explorer.servicedef.core.internal.events.DmServiceDefinitionDeletedEvent;
import com.ibm.mq.explorer.servicedef.core.internal.events.DmServiceDefinitionDeletingEvent;
import com.ibm.mq.explorer.servicedef.core.internal.handler.IObjectHandler;
import com.ibm.mq.explorer.servicedef.core.internal.objects.DmServiceDefinitionAbstractRepository;
import com.ibm.mq.explorer.servicedef.core.internal.objects.DmServiceDefinitionAbstractWSDL;
import com.ibm.mq.explorer.servicedef.core.internal.objects.ErrorHandler;
import com.ibm.mq.explorer.servicedef.core.internal.objects.WSDL;
import com.ibm.mq.explorer.servicedef.core.internal.xml.XMLHandler;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.osgi.framework.Bundle;

public class DmServiceDefinitionWSDL
extends DmServiceDefinitionAbstractWSDL {
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.servicedef/src/com/ibm/mq/explorer/servicedef/core/internal/objects/DmServiceDefinitionWSDL.java";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    private static HashMap<Integer, AttrType> allAttributesByType = null;
    public static final String WSDL_EXTENSION = ".wsdl";
    public static final String ROOT_KEY = "SeviceDefinitionWSDL";

    public DmServiceDefinitionWSDL(Trace t, String name, WSDL wsdl, DmServiceDefinitionAbstractRepository dmRepository) {
        super(t, wsdl, dmRepository);
        if (this.attributesByType == null) {
            this.attributesByType = allAttributesByType;
        }
        this.serviceDefinitionParameters = ServiceDefinitionDataModel.getDmServiceDefinitionWSDLParameters(t).getParameters();
        this.createParameterAttributes(t);
        this.createExtraAttributes(t, name, 2003, 2006);
    }

    public IDmObject clone(Trace t, String name) {
        WSDL object = (WSDL)this.baseObject;
        return new DmServiceDefinitionWSDL(t, name, object, this.dmRepository);
    }

    @Override
    public String getFullName(Trace t) {
        String name;
        String fullName = name = this.getAttributeValue(t, 15100, 0);
        return fullName;
    }

    @Override
    public void remove(Trace t) throws DmCoreException {
        DmServiceDefinitionDeletingEvent deletingEvent = new DmServiceDefinitionDeletingEvent(this);
        this.setChanged();
        this.notifyObservers(deletingEvent);
        String name = this.getAttributeValue(t, 15100, 0);
        Exception except = null;
        IProject project = (IProject)this.dmRepository.getObject();
        NullProgressMonitor progressMonitor = new NullProgressMonitor();
        progressMonitor.beginTask("Removing resource:" + name, 9);
        IResource wsdlFile = project.findMember(String.valueOf(name) + WSDL_EXTENSION);
        if (wsdlFile != null) {
            try {
                try {
                    wsdlFile.delete(true, (IProgressMonitor)progressMonitor);
                    progressMonitor.worked(1);
                    IObjectHandler handler = this.dmRepository.getObjectHandler(t, project);
                    handler.removeFromSnapshot(this.dmRepository, name);
                }
                catch (CoreException e) {
                    ErrorHandler.getHandler().handleException(t, (Exception)((Object)e), name, this, 1);
                    DmServiceDefinitionDeletedEvent deletedEvent = new DmServiceDefinitionDeletedEvent(this);
                    deletedEvent.setError(except);
                    this.setChanged();
                    this.notifyObservers(deletedEvent);
                }
            }
            finally {
                DmServiceDefinitionDeletedEvent deletedEvent = new DmServiceDefinitionDeletedEvent(this);
                deletedEvent.setError(except);
                this.setChanged();
                this.notifyObservers(deletedEvent);
            }
        } else {
            DmServiceDefinitionDeletedEvent deletedEvent = new DmServiceDefinitionDeletedEvent(this);
            deletedEvent.setError(except);
            this.setChanged();
            this.notifyObservers(deletedEvent);
            ErrorHandler.getHandler().handleException(t, new FileNotFoundException(name), name, this, 1);
        }
    }

    public static boolean staticInit(Trace t, Bundle bund) {
        if ((allAttributesByType = DmServiceDefinitionWSDL.initAllAttrTypeTable(t, "DmServiceDefinitionWSDL", allAttributesByType, bund)) == null) {
            if (Trace.isTracing) {
                t.data(66, "DmServiceDefinitionWSDL.staticInit", 900, "Error loading allAttributesByType table");
            }
            return false;
        }
        return true;
    }

    public static int[] getAllAttributesByType(Trace t) {
        return DmServiceDefinitionWSDL.getAllAttributesByType(t, allAttributesByType);
    }

    public static String getAttributeTitle(Trace t, int id) {
        return DmServiceDefinitionWSDL.getAttributeTitle(t, allAttributesByType, id);
    }

    public static int[] getDisplayColumnSequence(Trace t, int[] ids, boolean zOS) {
        return DmServiceDefinitionWSDL.getDisplayColumnSequence(t, allAttributesByType, ids, zOS);
    }

    public static boolean isAttributeRepeating(Trace t, int id) {
        return DmServiceDefinitionWSDL.isAttributeRepeating(t, allAttributesByType, id);
    }

    public static AttrType getAttributeType(Trace t, int id) {
        return DmServiceDefinitionWSDL.getAttributeType(t, allAttributesByType, id);
    }

    public InputStream getXMLStream(Trace t) throws DmCoreException {
        ByteArrayInputStream bais = null;
        String xmlString = XMLHandler.serialiseToXML(t, this.getFullName(t), (WSDL)this.baseObject);
        try {
            bais = new ByteArrayInputStream(xmlString.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            ErrorHandler.getHandler().handleException(t, e, this.getFullName(t), this, 0);
            bais = new ByteArrayInputStream(xmlString.getBytes());
        }
        return bais;
    }

    public void setResource(Trace t, IResource resource) {
        ((WSDL)this.baseObject).setResource(t, resource);
    }
}

