/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.servicedef.core.internal.objects;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.servicedef.core.internal.base.ServiceDefinitionDataModel;
import com.ibm.mq.explorer.servicedef.core.internal.events.DmServiceDefinitionDeletedEvent;
import com.ibm.mq.explorer.servicedef.core.internal.events.DmServiceDefinitionDeletingEvent;
import com.ibm.mq.explorer.servicedef.core.internal.handler.IObjectHandler;
import com.ibm.mq.explorer.servicedef.core.internal.objects.DmServiceDefinitionAbstractRepository;
import com.ibm.mq.explorer.servicedef.ui.internal.base.ServiceDefinitionPlugin;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ui.IMemento;
import org.osgi.framework.Bundle;
import org.xml.sax.Attributes;

public class DmServiceDefinitionRepository
extends DmServiceDefinitionAbstractRepository {
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.servicedef/src/com/ibm/mq/explorer/servicedef/core/internal/objects/DmServiceDefinitionRepository.java";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    private static HashMap<Integer, AttrType> allAttributesByType = null;
    public static final String ROOT_KEY = "SeviceDefinitionRepository";
    private static final String NAME_KEY = "name";
    private static final String REPOSITORY_STATE_KEY_PREFIX = "repositoryState_";
    public static final String LINESEPARATOR = System.getProperty("line.separator");

    public DmServiceDefinitionRepository(Trace t, String name) {
        super(t, null, 2004, null);
        String status = ServiceDefinitionPlugin.getMessage("ServiceDefinition.ServiceDefinitionRepository.Status.Connected");
        if (this.attributesByType == null) {
            this.attributesByType = allAttributesByType;
        }
        ServiceDefinitionDataModel datamodel = ServiceDefinitionDataModel.getDataModel();
        this.objectHandlers = datamodel.getObjectHandlers(t);
        this.createExtraAttributes(t, name, 2004, 2010);
        this.createAttribute(t, null, 15111, 0, status);
        NullProgressMonitor progressMonitor = new NullProgressMonitor();
        progressMonitor.beginTask("Creating project:" + name, 9);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        this.baseObject = root.getProject(name);
        IProject project = (IProject)this.baseObject;
        try {
            if (!project.exists()) {
                project.create(null);
                progressMonitor.setTaskName("Open new project");
                project.open(null);
                progressMonitor.worked(1);
                progressMonitor.setTaskName("Set project description");
                IProjectDescription description = project.getDescription();
                String[] natures = description.getNatureIds();
                String[] newNatures = new String[natures.length + 1];
                System.arraycopy(natures, 0, newNatures, 0, natures.length);
                newNatures[natures.length] = "com.ibm.mq.explorer.servicedef.repository.nature";
                description.setNatureIds(newNatures);
                project.setDescription(description, (IProgressMonitor)progressMonitor);
                progressMonitor.worked(1);
            }
        }
        catch (CoreException e) {
            t.FFST(66, "DmServiceDefinitionRepository.DmServiceDefinitionRepository", 2, 50024, "Failed to create new repository: " + e.toString());
        }
    }

    @Override
    public boolean equals(Object obj) {
        Trace t = Trace.getDefault();
        if (obj.getClass() != DmServiceDefinitionRepository.class) {
            return false;
        }
        return ((DmServiceDefinitionRepository)obj).getFullName(t).equals(this.getFullName(t));
    }

    @Override
    public void close(Trace t) {
        this.closeRepository_internal(t);
        super.close(t);
    }

    private void closeRepository_internal(Trace t) {
        String status = ServiceDefinitionPlugin.getMessage("ServiceDefinition.ServiceDefinitionRepository.Status.Disconnected");
        Attr attr = this.getAttribute(t, 15111, 0);
        if (attr != null) {
            attr.replaceValue(t, (Object)status);
        }
    }

    @Override
    public void remove(Trace t) throws DmCoreException {
        DmServiceDefinitionDeletingEvent deletingEvent = new DmServiceDefinitionDeletingEvent(this);
        this.setChanged();
        this.notifyObservers(deletingEvent);
        String name = this.getAttributeValue(t, 15100, 0);
        IProject project = (IProject)this.getObject();
        NullProgressMonitor progressMonitor = new NullProgressMonitor();
        CoreException except = null;
        try {
            project.delete(true, true, (IProgressMonitor)progressMonitor);
        }
        catch (CoreException e) {
            except = e;
        }
        if (except == null && this.dmRepository != null) {
            IObjectHandler handler = this.dmRepository.getObjectHandler(t, project);
            handler.removeFromSnapshot(this.dmRepository, name);
        }
        DmServiceDefinitionDeletedEvent deletedEvent = new DmServiceDefinitionDeletedEvent(this);
        deletedEvent.setError((Exception)((Object)except));
        this.setChanged();
        this.notifyObservers(deletedEvent);
    }

    public String getObjectName(Trace t, String name) {
        return name;
    }

    @Override
    public String getFullName(Trace t) {
        String name;
        String fullName = name = this.getAttributeValue(t, 15100, 0);
        return fullName;
    }

    public void serialize(Trace t, OutputStreamWriter writer) throws IOException {
        String repositoryStateString;
        String name = this.getAttributeValue(t, 15100, 0);
        writer.write("<SeviceDefinitionRepository");
        this.writeKeyValue(writer, NAME_KEY, name);
        Attr repositoryState = this.getAttribute(t, 15111, 0);
        if (repositoryState != null && (repositoryStateString = (String)repositoryState.getValue(t)) != null) {
            this.writeKeyValue(writer, REPOSITORY_STATE_KEY_PREFIX, repositoryStateString);
        }
        writer.write("/>");
        writer.write(LINESEPARATOR);
    }

    public void serializeAsMemento(Trace t, IMemento rootWrite) {
        String repositoryStateString;
        IMemento child = rootWrite.createChild(ROOT_KEY);
        String name = this.getAttributeValue(t, 15100, 0);
        child.putString(NAME_KEY, name);
        Attr repositoryState = this.getAttribute(t, 15111, 0);
        if (repositoryState != null && (repositoryStateString = (String)repositoryState.getValue(t)) != null) {
            child.putString(REPOSITORY_STATE_KEY_PREFIX, repositoryStateString);
        }
    }

    private void writeKeyValue(Writer writer, String key, Object object) throws IOException {
        if (object != null) {
            String value = object.toString();
            writer.write(" " + key + "=\"" + value + "\"");
        }
    }

    public static DmServiceDefinitionRepository startElement(Trace t, String qName, Attributes atts) {
        DmServiceDefinitionRepository rep = null;
        String strName = null;
        int length = atts.getLength();
        int i = 0;
        while (i < length) {
            String localName = atts.getLocalName(i);
            String value = atts.getValue(i);
            if (NAME_KEY.equals(localName)) {
                strName = value;
            }
            ++i;
        }
        if (strName != null) {
            rep = new DmServiceDefinitionRepository(t, strName);
        }
        return rep;
    }

    public static DmServiceDefinitionRepository createFromMemento(Trace t, IMemento memento) {
        DmServiceDefinitionRepository rep = null;
        String strName = memento.getString(NAME_KEY);
        if (strName != null) {
            rep = new DmServiceDefinitionRepository(t, strName);
        }
        return rep;
    }

    public static int[] getAllAttributesByType(Trace t) {
        return DmServiceDefinitionRepository.getAllAttributesByType(t, allAttributesByType);
    }

    public static boolean staticInit(Trace t, Bundle bund) {
        if ((allAttributesByType = DmServiceDefinitionRepository.initAllAttrTypeTable(t, "DmServiceDefinitionRepository", allAttributesByType, bund)) == null) {
            if (Trace.isTracing) {
                t.data(66, "DmServiceDefinitionRepository.staticInit", 900, "Error loading allAttributesByType table");
            }
            return false;
        }
        return true;
    }

    public static String getAttributeTitle(Trace t, int id) {
        return DmServiceDefinitionRepository.getAttributeTitle(t, allAttributesByType, id);
    }

    public static int[] getDisplayColumnSequence(Trace t, int[] ids, boolean zOS) {
        return DmServiceDefinitionRepository.getDisplayColumnSequence(t, allAttributesByType, ids, zOS);
    }

    public static boolean isAttributeRepeating(Trace t, int id) {
        return DmServiceDefinitionRepository.isAttributeRepeating(t, allAttributesByType, id);
    }

    public static AttrType getAttributeType(Trace t, int id) {
        return DmServiceDefinitionRepository.getAttributeType(t, allAttributesByType, id);
    }
}

