/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.servicedef.core.internal.objects;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.AbstractAttrTypeNumber;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrBoolean;
import com.ibm.mq.explorer.core.internal.attrs.AttrByteArray;
import com.ibm.mq.explorer.core.internal.attrs.AttrInt;
import com.ibm.mq.explorer.core.internal.attrs.AttrIntArray;
import com.ibm.mq.explorer.core.internal.attrs.AttrIntArrayEnum;
import com.ibm.mq.explorer.core.internal.attrs.AttrIntArrayEnumRange;
import com.ibm.mq.explorer.core.internal.attrs.AttrKey;
import com.ibm.mq.explorer.core.internal.attrs.AttrLong;
import com.ibm.mq.explorer.core.internal.attrs.AttrString;
import com.ibm.mq.explorer.core.internal.attrs.AttrStringArray;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeBitEnum;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeBoolean;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeByteArray;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeDateTime;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeEnum;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeEnumRange;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeFixedLengthString;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeFixedLengthStringEnum;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeFixedLengthStringEnumRange;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeFixedLengthStringListItem;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeFixedLengthWMQNameListItem;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeIPAddress;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeInt;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeIntArray;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeIntArrayEnum;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeIntArrayEnumRange;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeLong;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeLongEnum;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeLongEnumRange;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeObject;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeRange;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeString;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeStringArray;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeURL;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeUnsignedInt;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeWMQName;
import com.ibm.mq.explorer.core.internal.attrs.AttrURL;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.event.DmActionEvent;
import com.ibm.mq.explorer.core.internal.event.DmActionListener;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.core.internal.objects.TableFactory;
import com.ibm.mq.explorer.servicedef.core.internal.events.DmServiceDefinitionChangedEvent;
import com.ibm.mq.explorer.servicedef.core.internal.events.DmServiceDefinitionChangingEvent;
import com.ibm.mq.explorer.servicedef.core.internal.events.DmServiceDefinitionChildAddedEvent;
import com.ibm.mq.explorer.servicedef.core.internal.events.DmServiceDefinitionDeletedEvent;
import com.ibm.mq.explorer.servicedef.core.internal.events.DmServiceDefinitionDeletingEvent;
import com.ibm.mq.explorer.servicedef.core.internal.events.DmServiceDefinitionEvent;
import com.ibm.mq.explorer.servicedef.core.internal.events.DmServiceDefinitionRenameEvent;
import com.ibm.mq.explorer.servicedef.core.internal.events.DmServiceDefinitionRenamingEvent;
import com.ibm.mq.explorer.servicedef.core.internal.handler.IObjectHandler;
import com.ibm.mq.explorer.servicedef.core.internal.objects.DmServiceDefinitionAbstractRepository;
import com.ibm.mq.explorer.servicedef.core.internal.objects.DmServiceDefinitionRepository;
import com.ibm.mq.explorer.servicedef.core.internal.params.IServiceDefinitionParameter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Observable;
import java.util.Set;
import org.osgi.framework.Bundle;

public abstract class DmServiceDefinitionObject
extends Observable
implements IDmObject {
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.servicedef/src/com/ibm/mq/explorer/servicedef/core/internal/objects/DmServiceDefinitionObject.java";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String NOT_FOUND = "[not_found]";
    public static final String NOT_DEFINED = "[not_defined]";
    public static final int TYPE_ALL = 2000;
    public static final int TYPE_NONE = 2001;
    public static final int TYPE_ABSTRACT_WSDL = 2003;
    public static final int TYPE_REPOSITORY = 2004;
    public static final int TYPE_UNKNOWN = 2005;
    public static final int SUBTYPE_WSDL = 2006;
    public static final int SUBTYPE_ALL = 2007;
    public static final int SUBTYPE_NONE = 2008;
    public static final int SUBTYPE_UNKNOWN = 2009;
    public static final int SUBTYPE_REPOSITORY = 2010;
    public static final int[] REPOSITORY_SUBTYPES = new int[]{2010};
    public static final int[] WSDL_SUBTYPES = new int[]{2006};
    public static final int[] UNKNOWN_SUBTYPES = new int[]{2009};
    private static final int SHIFT_BITS = 32;
    protected Object baseObject;
    private int objectType;
    private Hashtable<AttrKey, Attr> attributes;
    protected HashMap<Integer, AttrType> attributesByType;
    protected Hashtable<Integer, IServiceDefinitionParameter> serviceDefinitionParameters;
    protected DmServiceDefinitionAbstractRepository dmRepository;

    public DmServiceDefinitionObject(Trace t, Object aObject, int aObjectType, DmServiceDefinitionAbstractRepository aDmContext) {
        this.baseObject = aObject;
        this.objectType = aObjectType;
        this.dmRepository = aDmContext;
        this.attributes = new Hashtable();
    }

    protected void createExtraAttributes(Trace t, String name, int type, int subtype) {
        this.createAttribute(t, null, 15100, 0, name);
        this.createAttribute(t, null, 15101, 0, type);
        this.createAttribute(t, null, 15102, 0, subtype);
    }

    public DmServiceDefinitionRepository getDmServiceDefinitionRepository(Trace t) {
        DmServiceDefinitionRepository result = null;
        DmServiceDefinitionObject initial = this;
        DmServiceDefinitionAbstractRepository parent = this.dmRepository;
        while (parent != null) {
            initial = parent;
            parent = parent.dmRepository;
        }
        if (initial instanceof DmServiceDefinitionRepository) {
            result = (DmServiceDefinitionRepository)initial;
        } else {
            t.FFST(66, "DmServiceDefinitionObject.getDmServiceDefinitionRepository", 0, 0, initial.getClass().toString());
        }
        return result;
    }

    public DmServiceDefinitionAbstractRepository getParent() {
        return this.dmRepository;
    }

    public String getFullName(Trace t) {
        DmServiceDefinitionAbstractRepository parent = this.dmRepository;
        String parentFullName = NOT_DEFINED;
        if (parent != null) {
            parentFullName = parent.getFullName(t);
        }
        String name = this.getAttributeValue(t, 15100, 0);
        String separator = "/";
        String fullName = null;
        fullName = parentFullName.endsWith(separator) || name.startsWith(separator) ? String.valueOf(parentFullName) + name : String.valueOf(parentFullName) + separator + name;
        return fullName;
    }

    public Attr getAttributeInternal(Trace t, int id, int index) {
        return this.attributes.get(new AttrKey(id, index));
    }

    public Attr getAttribute(Trace t, int id, int index) {
        return this.getAttributeInternal(t, id, index);
    }

    public String getAttributeValue(Trace t, int id, int index) {
        String retValue = NOT_FOUND;
        Attr a = this.getAttributeInternal(t, id, index);
        if (a != null) {
            retValue = a.toString(t);
        }
        if (Trace.isTracing) {
            t.data(66, "DmServiceDefinitionObject.getAttributeValue", 300, "Attribute id = " + id + "." + index + ", value = " + retValue);
        }
        return retValue;
    }

    protected static AttrType getAttributeType(Trace t, HashMap<Integer, AttrType> hm, int id) {
        if (hm == null) {
            if (Trace.isTracing) {
                t.data(66, "DmServiceDefinitionObject.getAttributeType", 900, "<All> table for attribute id " + id + " has not been created");
            }
            return null;
        }
        AttrType at = hm.get(id);
        if (at == null) {
            if (Trace.isTracing) {
                t.data(66, "DmServiceDefinitionObject.getAttributeType", 900, "No attribute type in table for attribute id " + id);
            }
            return null;
        }
        int type = at.getAttributeType();
        if (Trace.isTracing) {
            t.data(66, "DmServiceDefinitionObject.getAttributeType", 300, "Attribute id = " + id + ", type = " + type);
        }
        return at;
    }

    public int getRepeatingIndexes(Trace t, int id) {
        Attr a;
        int index = 1;
        while ((a = this.attributes.get(new AttrKey(id, index))) != null) {
            ++index;
        }
        if (Trace.isTracing) {
            t.data(66, "DmServiceDefinitionObject.getRepeatingIndexes", 300, "Attribute id = " + id + ", repeating indexes = " + (index - 1));
        }
        return index;
    }

    public int[] getAllAttributes(Trace t) {
        return this.getAllAttributes(t, false);
    }

    public int[] getAllAttributes(Trace t, boolean update) {
        int[] ids = this.getKnownAttributes(t);
        return ids;
    }

    protected int[] getKnownAttributes(Trace t) {
        int count = 0;
        Set<AttrKey> k = this.attributes.keySet();
        for (AttrKey ak : k) {
            if (ak.getRepeatingIndex() != 0) continue;
            ++count;
        }
        int[] ids = new int[count];
        int index = 0;
        k = this.attributes.keySet();
        for (AttrKey ak : k) {
            if (ak.getRepeatingIndex() != 0) continue;
            ids[index] = ak.getAttributeID();
            ++index;
        }
        return ids;
    }

    public DmQueueManager getQueueManager() {
        return null;
    }

    protected static int[] getAllAttributesByType(Trace t, HashMap<Integer, AttrType> hm) {
        if (hm == null) {
            String message = "objectType not initialised";
            t.FFST(66, "DmServiceDefinitionObject.getAllAttributesByType", 2, 0, message);
            return new int[0];
        }
        int[] ids = new int[hm.size()];
        int index = 0;
        Set<Integer> k = hm.keySet();
        Iterator<Integer> i = k.iterator();
        while (i.hasNext()) {
            ids[index] = i.next();
            ++index;
        }
        return ids;
    }

    public void debug(Trace t) {
        Set<AttrKey> k = this.attributes.keySet();
        for (AttrKey ak : k) {
            Attr a = this.attributes.get(ak);
            a.debug(t);
        }
    }

    public boolean setAttributeValue(Trace t, Object job, int id, int index, Object value) {
        boolean result = true;
        AttrKey key = new AttrKey(id, index);
        Attr a = this.attributes.get(key);
        if (a == null) {
            this.createAttribute(t, job, id, index, value);
        } else {
            a.setNewValue(t, value);
        }
        ArrayList list = (ArrayList)job;
        IServiceDefinitionParameter parameter = this.serviceDefinitionParameters.get(id);
        list.add(parameter);
        return result;
    }

    public IServiceDefinitionParameter getParameter(int id) {
        return this.serviceDefinitionParameters.get(id);
    }

    public boolean replaceAttributeValue(Trace t, int id, int index, Object value) {
        boolean result = true;
        AttrKey key = new AttrKey(id, index);
        Attr a = this.attributes.get(key);
        if (a == null) {
            result = false;
        } else {
            a.setNewValue(t, value);
            IServiceDefinitionParameter parameter = this.serviceDefinitionParameters.get(id);
            parameter.replaceValue(t, this);
            try {
                parameter.actionChange(t, this);
            }
            catch (DmCoreException dmCoreException) {
                result = false;
            }
        }
        return result;
    }

    public Attr createAttribute(Trace t, Object job, int id, int repeatIndex, Object value) {
        AttrString attr = null;
        AttrKey key = new AttrKey(id, repeatIndex);
        AttrType aType = this.attributesByType.get(id);
        if (aType == null) {
            String message = "Attribute type " + id + " has not been initialised for " + this.getClass().toString();
            t.FFST(66, "DmServiceDefinitionObject.createAttribute", 2, 0, message);
            return null;
        }
        int type = aType.getAttributeType();
        switch (type) {
            case 1: {
                attr = new AttrInt(t, id, repeatIndex, ((Integer)value).intValue(), (AbstractAttrTypeNumber)((AttrTypeInt)aType), (IDmObject)this);
                break;
            }
            case 2: {
                attr = new AttrString(t, id, repeatIndex, (String)value, (AttrTypeString)aType, (IDmObject)this);
                break;
            }
            case 6: {
                attr = new AttrString(t, id, repeatIndex, (String)value, (AttrTypeString)((AttrTypeFixedLengthString)aType), (IDmObject)this);
                break;
            }
            case 4: {
                attr = new AttrInt(t, id, repeatIndex, ((Integer)value).intValue(), (AbstractAttrTypeNumber)((AttrTypeRange)aType), (IDmObject)this);
                break;
            }
            case 29: {
                attr = new AttrLong(t, id, repeatIndex, ((Long)value).longValue(), (AbstractAttrTypeNumber)((AttrTypeLong)aType), (IDmObject)this);
                break;
            }
            case 3: {
                attr = new AttrInt(t, id, repeatIndex, ((Integer)value).intValue(), (AbstractAttrTypeNumber)((AttrTypeEnum)aType), (IDmObject)this);
                break;
            }
            case 5: {
                attr = new AttrString(t, id, repeatIndex, ((String)value).trim(), (AttrTypeString)((AttrTypeIPAddress)aType), (IDmObject)this);
                break;
            }
            case 7: {
                attr = new AttrString(t, id, repeatIndex, ((String)value).trim(), (AttrTypeString)((AttrTypeWMQName)aType), (IDmObject)this);
                break;
            }
            case 9: {
                attr = new AttrString(t, id, repeatIndex, (String)value, (AttrTypeString)((AttrTypeFixedLengthStringEnum)aType), (IDmObject)this);
                break;
            }
            case 11: {
                attr = new AttrInt(t, id, repeatIndex, ((Integer)value).intValue(), (AbstractAttrTypeNumber)((AttrTypeEnumRange)aType), (IDmObject)this);
                break;
            }
            case 12: {
                attr = new AttrLong(t, id, repeatIndex, ((Long)value).longValue(), (AbstractAttrTypeNumber)((AttrTypeLong)aType), (IDmObject)this);
                break;
            }
            case 10: {
                long l = ((Integer)value).intValue();
                l <<= 32;
                attr = new AttrLong(t, id, repeatIndex, l >>= 32, (AbstractAttrTypeNumber)((AttrTypeUnsignedInt)aType), (IDmObject)this);
                break;
            }
            case 13: {
                attr = new AttrString(t, id, repeatIndex, (String)value, (AttrTypeString)((AttrTypeFixedLengthStringEnumRange)aType), (IDmObject)this);
                break;
            }
            case 14: {
                attr = new AttrIntArray(t, id, repeatIndex, (int[])value, (AttrTypeIntArray)aType, (IDmObject)this);
                break;
            }
            case 18: {
                attr = new AttrIntArrayEnum(t, id, repeatIndex, (int[])value, (AttrTypeIntArrayEnum)aType, (IDmObject)this);
                break;
            }
            case 22: {
                attr = new AttrIntArrayEnumRange(t, id, repeatIndex, (int[])value, (AttrTypeIntArrayEnumRange)aType, (IDmObject)this);
                break;
            }
            case 15: {
                attr = new AttrStringArray(t, id, repeatIndex, (String[])value, (AttrTypeStringArray)aType, (IDmObject)this);
                break;
            }
            case 8: {
                attr = new AttrStringArray(t, id, repeatIndex, (String[])value, (AttrTypeStringArray)((AttrTypeFixedLengthStringListItem)aType), (IDmObject)this);
                break;
            }
            case 21: {
                attr = new AttrStringArray(t, id, repeatIndex, (String[])value, (AttrTypeStringArray)((AttrTypeFixedLengthWMQNameListItem)aType), (IDmObject)this);
                break;
            }
            case 16: {
                attr = new AttrByteArray(t, id, repeatIndex, (byte[])value, (AttrTypeByteArray)aType, (IDmObject)this);
                break;
            }
            case 19: {
                attr = new AttrByteArray(t, id, repeatIndex, (byte[])value, (AttrTypeByteArray)aType, (IDmObject)this);
                break;
            }
            case 20: {
                attr = new AttrInt(t, id, repeatIndex, ((Integer)value).intValue(), (AbstractAttrTypeNumber)((AttrTypeBitEnum)aType), (IDmObject)this);
                break;
            }
            case 23: {
                attr = new AttrString(t, id, repeatIndex, ((String)value).trim(), (AttrTypeString)((AttrTypeDateTime)aType), (IDmObject)this);
                break;
            }
            case 24: {
                attr = new AttrURL(t, id, repeatIndex, (URL)value, (AttrTypeURL)aType, (IDmObject)this);
                break;
            }
            case 25: {
                attr = new AttrBoolean(t, id, repeatIndex, ((Boolean)value).booleanValue(), (AttrTypeBoolean)aType, (IDmObject)this);
                break;
            }
            case 26: {
                attr = new AttrString(t, id, repeatIndex, (String)value, (AttrTypeString)((AttrTypeObject)aType), (IDmObject)this);
                break;
            }
            case 27: {
                attr = new AttrLong(t, id, repeatIndex, ((Long)value).longValue(), (AbstractAttrTypeNumber)((AttrTypeLongEnum)aType), (IDmObject)this);
                break;
            }
            case 28: {
                attr = new AttrLong(t, id, repeatIndex, ((Long)value).longValue(), (AbstractAttrTypeNumber)((AttrTypeLongEnumRange)aType), (IDmObject)this);
                break;
            }
            default: {
                if (Trace.isTracing) {
                    t.data(66, "DmServiceDefinitionObject.createAttribute", 900, "Error - unknown attribute type (" + aType.getAttributeType() + ")");
                }
                t.FFST(66, "DmServiceDefinitionObject.createAttribute", 0, 0, "Missing AttrType in switch statement");
            }
        }
        this.attributes.put(key, (Attr)attr);
        return attr;
    }

    public boolean deleteAttribute(Trace t, Object job, int id, int index) {
        AttrKey key = new AttrKey(id, index);
        Attr oldAttr = this.attributes.remove(key);
        return oldAttr != null;
    }

    public Object beginUpdate(Trace t) {
        return new ArrayList();
    }

    public void endUpdate(Trace t, Object job) {
    }

    public boolean isSystemObject(Trace t) {
        return false;
    }

    public boolean isSystemDefault(Trace t) {
        return false;
    }

    public boolean isEnumerationIdValid(Trace t, int attrId, int enumId) {
        return true;
    }

    public boolean isFilteringSupported(Trace t) {
        return false;
    }

    public int getObjectType(Trace t) {
        return this.objectType;
    }

    public int getObjectSubType(Trace t) {
        return 0;
    }

    public int[] getObjectSubTypes(Trace t) {
        return null;
    }

    public int getStatusType(Trace t) {
        return 0;
    }

    public String getParentName(Trace t) {
        return NOT_DEFINED;
    }

    public void initialize(Trace t) {
    }

    public void createParameterAttributes(Trace t) {
        IServiceDefinitionParameter parameter = null;
        try {
            Enumeration<IServiceDefinitionParameter> en = this.serviceDefinitionParameters.elements();
            while (en.hasMoreElements()) {
                parameter = en.nextElement();
                parameter.createAttribute(t, this);
            }
        }
        catch (Throwable e) {
            String insert1 = e.getMessage();
            String insert2 = this.getClass().toString();
            String insert3 = parameter.getLongName();
            if (insert1 != null) {
                t.data(66, "DmServiceDefinitionObject.createParameterAttributes", 800, insert1);
            }
            t.data(66, "DmServiceDefinitionObject.createParameterAttributes", 800, insert2);
            t.data(66, "DmServiceDefinitionObject.createParameterAttributes", 800, insert3);
            t.FFST(66, "DmServiceDefinitionObject.createParameterAttributes", 1, 50010, parameter.getId(), 0, insert1, insert2, insert3);
        }
    }

    public int actionCreate(Trace t, DmActionListener listener, Object job) {
        ArrayList list = (ArrayList)job;
        return this.updateObject(t, listener, list, false);
    }

    public int actionChange(Trace t, DmActionListener listener, Object job, boolean force) {
        ArrayList list = (ArrayList)job;
        return this.updateObject(t, listener, list, true);
    }

    private int updateObject(Trace t, DmActionListener listener, ArrayList<IServiceDefinitionParameter> parameters, boolean changing) {
        int rc = 0;
        DmCoreException except = null;
        boolean change = changing;
        if (this.dmRepository != null) {
            Collection<DmServiceDefinitionObject> serviceDefinitionObjects = this.dmRepository.getObjects(t);
            if (change && !serviceDefinitionObjects.contains(this)) {
                rc = 2085;
                except = DmCoreException.create((Trace)t, (DmObject)this.getQueueManager(), (int)0, (int)rc, (int)2);
                change = false;
            }
            if (change) {
                DmServiceDefinitionChangingEvent changingAddedEvent = new DmServiceDefinitionChangingEvent(this);
                this.setChanged();
                this.notifyObservers(changingAddedEvent);
            }
        }
        try {
            try {
                if (except == null) {
                    this.validateParameters(t, parameters);
                    this.changeParameters(t, parameters);
                    this.dmRepository.handle(t, this);
                    this.replaceValues(t, parameters);
                }
            }
            catch (DmCoreException e) {
                Object event;
                rc = e.getReasonCode();
                except = e;
                this.restoreValues(t, parameters);
                if (listener != null) {
                    event = new DmActionEvent((Object)this, 0, rc, except);
                    listener.dmActionDone((DmActionEvent)event);
                }
                event = null;
                if (change) {
                    event = new DmServiceDefinitionChangedEvent(this);
                    ((DmServiceDefinitionEvent)event).setError((Exception)((Object)except));
                    this.setChanged();
                    this.notifyObservers(event);
                } else if (except == null && this.dmRepository != null) {
                    event = new DmServiceDefinitionChildAddedEvent(this.dmRepository, this);
                    this.dmRepository.setChanged();
                    this.dmRepository.notifyObservers(event);
                }
            }
        }
        finally {
            Object event;
            if (listener != null) {
                event = new DmActionEvent((Object)this, 0, rc, except);
                listener.dmActionDone((DmActionEvent)event);
            }
            event = null;
            if (change) {
                event = new DmServiceDefinitionChangedEvent(this);
                ((DmServiceDefinitionEvent)event).setError((Exception)((Object)except));
                this.setChanged();
                this.notifyObservers(event);
            } else if (except == null && this.dmRepository != null) {
                event = new DmServiceDefinitionChildAddedEvent(this.dmRepository, this);
                this.dmRepository.setChanged();
                this.dmRepository.notifyObservers(event);
            }
        }
        return 0;
    }

    private void validateParameters(Trace t, ArrayList<IServiceDefinitionParameter> parameters) throws DmCoreException {
        for (IServiceDefinitionParameter parameter : parameters) {
            parameter.validate(t, this);
        }
        this.performCrossAttributeValidation(t, parameters);
    }

    private void changeParameters(Trace t, ArrayList<IServiceDefinitionParameter> parameters) throws DmCoreException {
        for (IServiceDefinitionParameter parameter : parameters) {
            parameter.actionChange(t, this);
        }
    }

    private void restoreValues(Trace t, Object job) {
        ArrayList list = (ArrayList)job;
        for (IServiceDefinitionParameter parameter : list) {
            try {
                parameter.actionRestore(t, this);
            }
            catch (DmCoreException e2) {
                t.data(66, "DmServiceDefinitionObject.restoreValues", Integer.MIN_VALUE, e2.getMessage());
            }
        }
    }

    private void replaceValues(Trace t, Object job) {
        ArrayList list = (ArrayList)job;
        for (IServiceDefinitionParameter parameter : list) {
            parameter.replaceValue(t, this);
        }
    }

    public int actionDelete(Trace t, DmActionListener listener, Object parms) {
        DmCoreException dmCoreException = null;
        DmServiceDefinitionDeletingEvent deletingEvent = new DmServiceDefinitionDeletingEvent(this);
        this.setChanged();
        this.notifyObservers(deletingEvent);
        try {
            try {
                this.remove(t);
            }
            catch (DmCoreException e) {
                dmCoreException = e;
                DmServiceDefinitionDeletedEvent deletedEvent = new DmServiceDefinitionDeletedEvent(this);
                deletedEvent.setError((Exception)((Object)dmCoreException));
                this.setChanged();
                this.notifyObservers(deletedEvent);
            }
        }
        finally {
            DmServiceDefinitionDeletedEvent deletedEvent = new DmServiceDefinitionDeletedEvent(this);
            deletedEvent.setError((Exception)((Object)dmCoreException));
            this.setChanged();
            this.notifyObservers(deletedEvent);
        }
        return 0;
    }

    protected static String getClassName(String className) {
        if (className.lastIndexOf(46) > 0) {
            return className.substring(className.lastIndexOf(46) + 1);
        }
        return className;
    }

    protected static HashMap<Integer, AttrType> initAllAttrTypeTable(Trace t, String name, HashMap<Integer, AttrType> hm, Bundle bund) {
        HashMap newAttrTypeTable = hm;
        if (newAttrTypeTable != null) {
            if (Trace.isTracing) {
                t.data(66, "DmServiceDefinitionObject.initAllAttrTypeTable", 300, "allAttributesByType table already initialized");
            }
            return newAttrTypeTable;
        }
        newAttrTypeTable = TableFactory.getHashMap((Trace)t, (String)name, (Bundle)bund);
        if (newAttrTypeTable == null) {
            if (Trace.isTracing) {
                t.data(66, "DmServiceDefinitionObject.initAllAttrTypeTable", 900, "Error loading allAttributesByType table for " + name);
            }
            return null;
        }
        return newAttrTypeTable;
    }

    protected static String getAttributeTitle(Trace t, HashMap<Integer, AttrType> hm, int id) {
        if (hm == null) {
            if (Trace.isTracing) {
                t.data(66, "DmServiceDefinitionObject.getAttributeTitle", 900, "<All> table for attribute id " + id + " has not been created");
            }
            return null;
        }
        AttrType at = hm.get(id);
        if (at == null) {
            if (Trace.isTracing) {
                t.data(66, "DmServiceDefinitionObject.getAttributeTitle", 900, "No attribute type in table for attribute id " + id);
            }
            return null;
        }
        String s = at.getDisplayTitle();
        if (Trace.isTracing) {
            t.data(66, "DmServiceDefinitionObject.getAttributeTitle", 300, "Attribute id = " + id + ", title = " + s);
        }
        return s;
    }

    protected static int[] getDisplayColumnSequence(Trace t, HashMap<Integer, AttrType> hm, int[] ids, boolean zOS) {
        int[] retValue = new int[ids.length];
        if (hm == null) {
            if (Trace.isTracing) {
                t.data(66, "DmServiceDefinitionObject.getDisplayColumnSequence", 900, "<All> table has not been created");
            }
            return null;
        }
        if (Trace.isTracing) {
            if (zOS) {
                t.data(66, "DmServiceDefinitionObject.getDisplayColumnSequence", 300, "Getting the zOS display column sequence");
            } else {
                t.data(66, "DmServiceDefinitionObject.getDisplayColumnSequence", 300, "Getting the distributed display column sequence");
            }
        }
        int i = 0;
        while (i < ids.length) {
            AttrType at = hm.get(ids[i]);
            if (at == null) {
                retValue[i] = -1;
                if (Trace.isTracing) {
                    t.data(66, "DmServiceDefinitionObject.getDisplayColumnSequence", 900, "No attribute type in table for attribute id " + ids[i]);
                }
            } else {
                retValue[i] = zOS ? at.getZosDisplayColumnSequence() : at.getDisplayColumnSequence();
                if (Trace.isTracing) {
                    t.data(66, "DmServiceDefinitionObject.getDisplayColumnSequence", 300, "Attribute id = " + ids[i] + ", display sequence = " + retValue[i]);
                }
            }
            ++i;
        }
        return retValue;
    }

    protected static boolean isAttributeRepeating(Trace t, HashMap<Integer, AttrType> hm, int id) {
        if (hm == null) {
            if (Trace.isTracing) {
                t.data(66, "DmServiceDefinitionObject.isAttributeRepeating", 900, "<All> table for attribute id " + id + " has not been created");
            }
            return false;
        }
        AttrType at = hm.get(id);
        if (at == null) {
            if (Trace.isTracing) {
                t.data(66, "DmServiceDefinitionObject.isAttributeRepeating", 900, "No attribute type in table for attribute id " + id);
            }
            return false;
        }
        boolean repeating = at.isRepeating();
        if (Trace.isTracing) {
            t.data(66, "DmServiceDefinitionObject.isAttributeRepeating", 300, "Attribute id = " + id + ", repeating = " + Boolean.toString(repeating));
        }
        return repeating;
    }

    protected String getAttrValueByteArray(byte[] array) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < array.length) {
            byte item = array[i];
            buffer.append(item);
            buffer.append(" ");
            ++i;
        }
        return buffer.toString();
    }

    protected Integer getAttrValueLong(long value) {
        return (int)value;
    }

    protected Integer getAttrValueBoolean(boolean value) {
        return value ? 1 : 0;
    }

    protected Integer getAttrValueInteger(int value) {
        return value;
    }

    protected String getAttrValueString(String value) {
        String attrValue = value;
        if (attrValue == null) {
            attrValue = "";
        }
        return attrValue;
    }

    public Object getObject() {
        return this.baseObject;
    }

    public void rename(Trace t, String newName) throws DmCoreException {
        DmServiceDefinitionRenamingEvent renamingEvent = new DmServiceDefinitionRenamingEvent(this, newName);
        this.setChanged();
        this.notifyObservers(renamingEvent);
        DmServiceDefinitionObject newDmServiceDefinitionObject = null;
        Exception except = null;
        Object object = this.getObject();
        Attr attr = this.getAttributeInternal(t, 15100, 0);
        String oldName = (String)attr.getValue(t);
        if (except == null && this.dmRepository != null) {
            IObjectHandler handler = this.dmRepository.getObjectHandler(t, object);
            handler.removeFromSnapshot(this.dmRepository, oldName);
            newDmServiceDefinitionObject = handler.addToSnapshot(this.dmRepository, newName, object);
        }
        DmServiceDefinitionRenameEvent renameEvent = new DmServiceDefinitionRenameEvent(this, newDmServiceDefinitionObject);
        renameEvent.setError(except);
        this.setChanged();
        this.notifyObservers(renameEvent);
    }

    public void remove(Trace t) throws DmCoreException {
        DmServiceDefinitionDeletingEvent deletingEvent = new DmServiceDefinitionDeletingEvent(this);
        this.setChanged();
        this.notifyObservers(deletingEvent);
        Exception except = null;
        DmServiceDefinitionDeletedEvent deletedEvent = new DmServiceDefinitionDeletedEvent(this);
        deletedEvent.setError(except);
        this.setChanged();
        this.notifyObservers(deletedEvent);
    }

    @Override
    public void setChanged() {
        super.setChanged();
    }

    public void performCrossAttributeValidation(Trace t, ArrayList<IServiceDefinitionParameter> parameters) {
    }

    public boolean equals(Object object) {
        Trace t = Trace.getDefault();
        boolean result = false;
        if (object != null && object instanceof DmServiceDefinitionObject) {
            String fullName = this.getFullName(t);
            DmServiceDefinitionRepository repository = this.getDmServiceDefinitionRepository(t);
            String repositoryName = repository.getTitle();
            DmServiceDefinitionObject comparisonObject = (DmServiceDefinitionObject)object;
            String comparisonFullName = comparisonObject.getFullName(t);
            DmServiceDefinitionRepository comparisonRepository = comparisonObject.getDmServiceDefinitionRepository(t);
            String comparisonRepositoryName = comparisonRepository.getTitle();
            if (fullName.equals(comparisonFullName) && repositoryName.equals(comparisonRepositoryName)) {
                result = true;
            }
        }
        return result;
    }

    public void initializeWithDefaults(Trace t) {
    }

    public int getAttributeDifferenceCount(Trace t, IDmObject second) {
        return 0;
    }

    public int getNameAttributeId() {
        return -1;
    }
}

