/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.servicedef.core.internal.objects;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.servicedef.core.internal.events.DmServiceDefinitionClosedEvent;
import com.ibm.mq.explorer.servicedef.core.internal.events.DmServiceDefinitionClosingEvent;
import com.ibm.mq.explorer.servicedef.core.internal.exceptions.NameAlreadyExistsException;
import com.ibm.mq.explorer.servicedef.core.internal.handler.IObjectHandler;
import com.ibm.mq.explorer.servicedef.core.internal.objects.DmServiceDefinitionObject;
import com.ibm.mq.explorer.servicedef.core.internal.objects.DmServiceDefinitionWSDL;
import com.ibm.mq.explorer.servicedef.core.internal.objects.ErrorHandler;
import com.ibm.mq.explorer.servicedef.core.internal.objects.WSDL;
import com.ibm.mq.explorer.servicedef.ui.internal.base.ServiceDefinitionPlugin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public abstract class DmServiceDefinitionAbstractRepository
extends DmServiceDefinitionObject {
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.servicedef/src/com/ibm/mq/explorer/servicedef/core/internal/objects/DmServiceDefinitionAbstractRepository.java";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    protected Hashtable<String, IObjectHandler> objectHandlers;
    private Hashtable<String, DmServiceDefinitionObject> dmObjects = new Hashtable();
    private boolean isOpen = true;

    protected DmServiceDefinitionAbstractRepository(Trace t, Object object, int type, DmServiceDefinitionAbstractRepository dmRepository) {
        super(t, object, type, dmRepository);
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void open(Trace t) throws DmCoreException {
        this.openRepository_internal(t);
    }

    private void openRepository_internal(Trace t) throws DmCoreException {
        String status = ServiceDefinitionPlugin.getMessage("ServiceDefinition.ServiceDefinitionRepository.Status.Connected");
        Attr attr = this.getAttribute(t, 15111, 0);
        if (attr != null) {
            attr.replaceValue(t, (Object)status);
        }
        String name = null;
        try {
            IProject project = (IProject)this.baseObject;
            IResource[] resources = project.members();
            int i = 0;
            while (i < resources.length) {
                String resourceFileName = resources[i].getName();
                if (resourceFileName.endsWith(".wsdl")) {
                    name = resourceFileName.substring(0, resourceFileName.indexOf(".wsdl"));
                    WSDL object = new WSDL(t, resources[i]);
                    IObjectHandler handler = this.getObjectHandler(t, object);
                    if (handler != null) {
                        try {
                            handler.addToSnapshot(this, name, object);
                        }
                        catch (DmCoreException exception) {
                            ErrorHandler.getHandler().handleException(t, (Exception)((Object)exception), name, this, 4);
                        }
                    }
                }
                ++i;
            }
        }
        catch (CoreException exception) {
            ErrorHandler.getHandler().handleException(t, (Exception)((Object)exception), name, this, 4);
        }
        this.isOpen = true;
    }

    public void close(Trace t) {
        DmServiceDefinitionClosingEvent closingEvent = new DmServiceDefinitionClosingEvent(this);
        this.setChanged();
        this.notifyObservers(closingEvent);
        Exception except = null;
        this.isOpen = false;
        if (except == null) {
            this.closeAbstractRepository_internal(t);
        }
        DmServiceDefinitionClosedEvent closedEvent = new DmServiceDefinitionClosedEvent(this);
        closedEvent.setError(except);
        this.setChanged();
        this.notifyObservers(closedEvent);
    }

    protected void closeAbstractRepository_internal(Trace t) {
        this.dmObjects.clear();
    }

    protected void handle(Trace t, DmServiceDefinitionObject dmServiceDefinitionObject) throws DmCoreException {
        Object object = dmServiceDefinitionObject.getObject();
        DmServiceDefinitionWSDL wsdlObject = (DmServiceDefinitionWSDL)dmServiceDefinitionObject;
        String name = dmServiceDefinitionObject.getAttributeValue(t, 15100, 0);
        NameAlreadyExistsException except = null;
        NullProgressMonitor progressMonitor = new NullProgressMonitor();
        progressMonitor.beginTask("Creating project:" + name, 9);
        IProject project = (IProject)this.baseObject;
        IFile file = project.getFile(String.valueOf(name) + ".wsdl");
        try {
            if (!file.exists()) {
                file.create(wsdlObject.getXMLStream(t), true, (IProgressMonitor)progressMonitor);
                wsdlObject.setResource(t, (IResource)file);
                progressMonitor.worked(1);
            } else {
                except = new NameAlreadyExistsException();
            }
        }
        catch (CoreException e) {
            ErrorHandler.getHandler().handleException(t, (Exception)((Object)e), name, this, 0);
        }
        if (except != null) {
            ErrorHandler.getHandler().handleException(t, except, name, this, 0);
        }
        IObjectHandler handler = this.getObjectHandler(t, object);
        handler.addToSnapshot(this, name, dmServiceDefinitionObject);
        progressMonitor.worked(1);
    }

    public IObjectHandler getObjectHandler(Trace t, Object object) {
        IObjectHandler objectHandler = null;
        objectHandler = object instanceof IProject ? this.objectHandlers.get("com.ibm.mq.explorer.servicedef.Repository") : (object instanceof WSDL ? this.objectHandlers.get("com.ibm.mq.explorer.servicedef.WSDL") : this.objectHandlers.get("<Unknown>"));
        return objectHandler;
    }

    public int[] getMandatoryIds(Trace t) {
        return new int[]{15100};
    }

    public String getTitle() {
        Trace t = Trace.getDefault();
        String title = this.getAttributeValue(t, 15100, 0);
        return title;
    }

    public String toString(Trace t) {
        return this.getAttributeValue(t, 15100, 0);
    }

    public Collection<DmServiceDefinitionObject> getObjects(Trace t) {
        ArrayList<DmServiceDefinitionObject> list = new ArrayList<DmServiceDefinitionObject>();
        Enumeration<DmServiceDefinitionObject> en = this.dmObjects.elements();
        while (en.hasMoreElements()) {
            list.add(en.nextElement());
        }
        return list;
    }

    public Collection<DmServiceDefinitionObject> getObjects(Trace t, DmObjectFilter filter) {
        ArrayList<DmServiceDefinitionObject> list = new ArrayList<DmServiceDefinitionObject>();
        Enumeration<DmServiceDefinitionObject> en = this.dmObjects.elements();
        while (en.hasMoreElements()) {
            DmServiceDefinitionObject object = en.nextElement();
            if (!this.match(t, object, filter)) continue;
            list.add(object);
        }
        return list;
    }

    public Collection<DmServiceDefinitionObject> getLikeObjects(Trace t, DmServiceDefinitionObject object) {
        Collection<DmServiceDefinitionObject> collection = this.getObjects(t);
        return collection;
    }

    public boolean match(Trace t, DmServiceDefinitionObject object, DmObjectFilter filter) {
        boolean result = true;
        return result;
    }

    public boolean isEmpty(Trace t) {
        return this.dmObjects.isEmpty();
    }

    public void addToSnapshot(Trace t, String alias, DmServiceDefinitionObject object) {
        this.dmObjects.put(alias, object);
    }

    public void removeFromSnapshot(Trace t, String alias) {
        this.dmObjects.remove(alias);
    }

    public IDmObject clone(Trace t, String name) {
        return null;
    }
}

