/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.servicedef.core.internal.base;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.servicedef.core.internal.handler.IObjectHandler;
import com.ibm.mq.explorer.servicedef.core.internal.handler.IObjectHandlerFactory;
import com.ibm.mq.explorer.servicedef.core.internal.objects.DmServiceDefinitionRepository;
import com.ibm.mq.explorer.servicedef.core.internal.objects.DmServiceDefinitionUnknown;
import com.ibm.mq.explorer.servicedef.core.internal.objects.DmServiceDefinitionWSDL;
import com.ibm.mq.explorer.servicedef.core.internal.paramlist.DmServiceDefinitionWSDLParameters;
import com.ibm.mq.explorer.servicedef.ui.internal.base.ServiceDefinitionPlugin;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;
import org.osgi.framework.Bundle;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ServiceDefinitionDataModel
extends DefaultHandler {
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.servicedef/src/com/ibm/mq/explorer/servicedef/core/internal/base/ServiceDefinitionDataModel.java";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String STATE_FILENAME = "ServiceDefinition.xml";
    public static final String SERVICE_DEF_ROOT_KEY = "ServiceDefinitionRepositories";
    public static final String LINESEPERATOR = System.getProperty("line.separator");
    private boolean parseSuccessfull;
    private ArrayList<DmServiceDefinitionRepository> repositories;
    private static String stateLocation;
    private static ServiceDefinitionDataModel dataModel;
    private ArrayList<IObjectHandlerFactory> objectHandlerFactories;
    private static DmServiceDefinitionWSDLParameters dmServiceDefinitionWSDLParameters;
    private static final String VERSION_KEY = "FileVersion";
    private static final String THIS_VERSION = "1.0.0";

    public ServiceDefinitionDataModel(Trace t, String dir, ClassLoader aClassLoader, ArrayList<IObjectHandlerFactory> aObjectHandlerFactories) {
        dataModel = this;
        this.repositories = new ArrayList();
        stateLocation = dir;
        this.objectHandlerFactories = aObjectHandlerFactories;
        Bundle bundle = ServiceDefinitionPlugin.getDefault().getBundle();
        DmServiceDefinitionWSDL.staticInit(t, bundle);
        DmServiceDefinitionRepository.staticInit(t, bundle);
        DmServiceDefinitionUnknown.staticInit(t, bundle);
        this.restore(t);
    }

    public void close(Trace t) {
    }

    public void addNewRepository(Trace t, String name) throws DmCoreException {
        DmServiceDefinitionRepository repository = new DmServiceDefinitionRepository(t, name);
        this.addRepository(t, repository);
    }

    public void addRepository(Trace t, DmServiceDefinitionRepository repository) throws DmCoreException {
        if (!this.repositories.contains(repository)) {
            this.repositories.add(repository);
            this.save(t);
        }
    }

    public void removeRepository(Trace t, DmServiceDefinitionRepository repository) throws DmCoreException {
        this.repositories.remove(repository);
        this.save(t);
    }

    public ArrayList<DmServiceDefinitionRepository> getRepositories() {
        return this.repositories;
    }

    public static ServiceDefinitionDataModel getDataModel() {
        return dataModel;
    }

    public Hashtable<String, IObjectHandler> getObjectHandlers(Trace t) {
        Hashtable<String, IObjectHandler> list = new Hashtable<String, IObjectHandler>();
        int i = 0;
        while (i < this.objectHandlerFactories.size()) {
            IObjectHandlerFactory factory = this.objectHandlerFactories.get(i);
            IObjectHandler handler = factory.makeObjectHandler();
            String id = handler.getID();
            list.put(id, handler);
            ++i;
        }
        return list;
    }

    public boolean save(Trace t) throws DmCoreException {
        boolean result = false;
        OutputStreamWriter writer = null;
        try {
            try {
                File file = ServiceDefinitionDataModel.getDataStoreLocation();
                FileOutputStream output = new FileOutputStream(file);
                writer = new OutputStreamWriter((OutputStream)output, "UTF-8");
                writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                writer.write(LINESEPERATOR);
                writer.write("<!DOCTYPE ServiceDefinitionRepositories SYSTEM \"ServiceDefinitionRepositories.dtd\">");
                writer.write(LINESEPERATOR);
                writer.write("<ServiceDefinitionRepositories>");
                writer.write(LINESEPERATOR);
                int i = 0;
                while (i < this.repositories.size()) {
                    DmServiceDefinitionRepository rep = this.repositories.get(i);
                    rep.serialize(t, writer);
                    ++i;
                }
                writer.write("</ServiceDefinitionRepositories>");
                writer.write(LINESEPERATOR);
                result = true;
            }
            catch (Exception e) {
                UiPlugin.logException((Exception)e);
                String msg = CommonServices.getSystemMessage((String)"AMQ4557");
                t.data(66, "ServiceDefinitionDataModel.save", Integer.MIN_VALUE, String.valueOf(msg) + ": " + e.toString());
                throw new DmCoreException(t, msg, (Throwable)e, "AMQ4557", 0, 0, 20);
            }
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e1) {
                UiPlugin.logException((Exception)e1);
            }
        }
        return result;
    }

    public IMemento getReposAsXMLMemento(Trace t) {
        XMLMemento rootWrite = XMLMemento.createWriteRoot((String)SERVICE_DEF_ROOT_KEY);
        rootWrite.putString(VERSION_KEY, THIS_VERSION);
        int i = 0;
        while (i < this.repositories.size()) {
            DmServiceDefinitionRepository rep = this.repositories.get(i);
            rep.serializeAsMemento(t, (IMemento)rootWrite);
            ++i;
        }
        return rootWrite;
    }

    /*
     * Exception decompiling
     */
    public void restore(Trace t) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean restoreFromMemento(Trace t, IMemento memento) {
        IMemento[] serviceDefRepos;
        boolean result = true;
        IMemento[] iMementoArray = serviceDefRepos = memento.getChildren("SeviceDefinitionRepository");
        int n = serviceDefRepos.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento sDefRepo = iMementoArray[n2];
            DmServiceDefinitionRepository rep = DmServiceDefinitionRepository.createFromMemento(t, sDefRepo);
            if (rep != null) {
                try {
                    this.addRepository(t, rep);
                }
                catch (DmCoreException e) {
                    t.FFST(66, "ServiceDefinitionDataModel.restoreFromMemento", 1, 0, e.getMessage());
                    result = false;
                }
            }
            ++n2;
        }
        return result;
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes atts) throws SAXException {
        Trace t = Trace.getDefault();
        if ("SeviceDefinitionRepository".equals(qName)) {
            DmServiceDefinitionRepository rep = null;
            rep = DmServiceDefinitionRepository.startElement(t, qName, atts);
            if (rep != null) {
                try {
                    this.addRepository(t, rep);
                }
                catch (DmCoreException e) {
                    t.FFST(66, "ServiceDefinitionDataModel.startElement", 1, 0, e.getMessage());
                    SAXException saxException = new SAXException((Exception)((Object)e));
                    throw saxException;
                }
            }
        }
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        this.parseSuccessfull = false;
        super.error(e);
    }

    public boolean isParseSuccessfull() {
        return this.parseSuccessfull;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        Trace t = Trace.getDefault();
        InputSource is = null;
        if (systemId.indexOf("ServiceDefinitionRepositories.dtd") != -1) {
            String dtd = this.serviceDefinitionRepositoriesDtd();
            char[] aryDtd = dtd.toCharArray();
            CharArrayReader charReader = new CharArrayReader(aryDtd);
            is = new InputSource(charReader);
        } else {
            try {
                is = super.resolveEntity(publicId, systemId);
            }
            catch (Exception e) {
                t.FFST(66, "ServiceDefinitionDataModel.resolveEntity", 0, 0, e.getMessage());
                SAXException saxException = new SAXException(e);
                throw saxException;
            }
        }
        return is;
    }

    private String serviceDefinitionRepositoriesDtd() {
        String dtd = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!ELEMENT ServiceDefinitionRepositories (ServiceDefinitionRepositor*)>\n\n<!ELEMENT ServiceDefinitionRepository EMPTY>\n<!ATTLIST ServiceDefinitionRepository url CDATA #REQUIRED>\n";
        return dtd;
    }

    public static DmServiceDefinitionWSDLParameters getDmServiceDefinitionWSDLParameters(Trace t) {
        if (dmServiceDefinitionWSDLParameters == null) {
            dmServiceDefinitionWSDLParameters = new DmServiceDefinitionWSDLParameters(t);
        }
        return dmServiceDefinitionWSDLParameters;
    }

    public static File getDataStoreLocation() {
        return new File(stateLocation, STATE_FILENAME);
    }
}

