/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.importexport.internal;

import java.io.IOException;
import java.io.InputStream;

public class SimulatedInputStream
extends InputStream {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.importexport/src/com/ibm/mq/explorer/importexport/internal/SimulatedInputStream.java";
    private char[] data;
    private int pointer = 0;

    public SimulatedInputStream() {
        this("");
    }

    public SimulatedInputStream(String data) {
        this.data = data != null ? data.toCharArray() : "".toCharArray();
    }

    @Override
    public int read() throws IOException {
        if (this.pointer < this.data.length) {
            return this.data[this.pointer++];
        }
        return -1;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.pointer < this.data.length) {
            int i = 0;
            while (i < len && i + off < b.length) {
                int val = this.read();
                if (val <= -1) break;
                b[i + off] = (byte)val;
                ++i;
            }
            return i;
        }
        return -1;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public long skip(long n) {
        if (n <= 0L) {
            return 0L;
        }
        int oldPointer = this.pointer;
        int i = 0;
        while ((long)i < n && this.pointer < this.data.length) {
            ++this.pointer;
            ++i;
        }
        return this.pointer - oldPointer;
    }
}

