/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.importexport.internal;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.importexport.internal.ImportExportTreeNode;
import com.ibm.mq.explorer.importexport.internal.PluginEnabledEvent;
import com.ibm.mq.explorer.importexport.internal.PluginEnabledListener;
import com.ibm.mq.explorer.ui.extensions.ExplorerNotifyEvent;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.importexport.ImportExportCategory;
import com.ibm.mq.explorer.ui.internal.importexport.ImportExportSubcategory;
import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class ImportexportPlugin
extends AbstractUIPlugin {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.importexport/src/com/ibm/mq/explorer/importexport/internal/ImportexportPlugin.java";
    private static ImportexportPlugin plugin;
    private static Message message;
    public static final String IMPORT_ID = "com.ibm.mq.explorer.importexport";
    private static final String RESOURCE = "com.ibm.mq.explorer.importexport.internal.common";
    public static final String XML_SUFFIX = "xml";
    public static final String ZIP_SUFFIX = "zip";
    public static final String INFORMATION_FILE = "ImportExportInformation.xml";
    public static final String CURRENT_VERSION = "1.1";
    public static final String ROOT_KEY = "ImportExportFile";
    public static final String VERSION_KEY = "Version";
    public static final String CREATION_DATE_KEY = "CreationDate";
    private static ImportExportCategory[] registeredCats;
    private static ImportExportSubcategory[] registeredSubcats;
    private static ArrayList<ImportExportTreeNode> treeNodes;
    private static Vector<PluginEnabledListener> pluginEnabledListeners;

    static {
        message = null;
        registeredCats = null;
        registeredSubcats = null;
        treeNodes = null;
        pluginEnabledListeners = null;
    }

    public ImportexportPlugin() {
        plugin = this;
        treeNodes = new ArrayList();
        pluginEnabledListeners = new Vector();
    }

    public static Message getPluginMessages(Trace t) {
        if (message == null) {
            try {
                ClassLoader classLoader = ((Object)((Object)plugin)).getClass().getClassLoader();
                message = new Message(t, RESOURCE, classLoader);
            }
            catch (Exception exception) {
                message = new Message(t, RESOURCE);
            }
        }
        return message;
    }

    public static String getResourceString(Trace t, String key) {
        String messageText = message.getMessage(t, key);
        return messageText;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public static void loadImportExportCategories(Trace t) {
        registeredCats = UiPlugin.getImportExportCategories((Trace)t);
        ArrayList<ImportExportSubcategory> subcats = new ArrayList<ImportExportSubcategory>();
        int i = 0;
        while (i < registeredCats.length) {
            ImportExportCategory cat = registeredCats[i];
            ImportExportTreeNode catTreeNode = new ImportExportTreeNode(t, null, cat);
            treeNodes.add(catTreeNode);
            ArrayList subs = registeredCats[i].getSubcategories(t);
            int j = 0;
            while (j < subs.size()) {
                ImportExportSubcategory subcat = (ImportExportSubcategory)subs.get(j);
                subcats.add(subcat);
                ImportExportTreeNode subcatTreeNode = new ImportExportTreeNode(t, catTreeNode, subcat);
                treeNodes.add(subcatTreeNode);
                catTreeNode.addChildTreeNode(t, subcatTreeNode);
                ++j;
            }
            ++i;
        }
        registeredSubcats = subcats.toArray(new ImportExportSubcategory[subcats.size()]);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }

    public static ImportexportPlugin getDefault() {
        return plugin;
    }

    public static Shell getShell() {
        IWorkbench wkbench = ImportexportPlugin.getDefault().getWorkbench();
        IWorkbenchWindow win = wkbench.getActiveWorkbenchWindow();
        if (win == null) {
            win = wkbench.getWorkbenchWindows()[0];
        }
        return win.getShell();
    }

    public static ImportExportCategory[] getRegisteredCategories() {
        return registeredCats;
    }

    public static ImportExportSubcategory[] getRegisteredSubcategories() {
        return registeredSubcats;
    }

    public static ImportExportCategory getRegisteredCategory(Trace t, String catId) {
        ImportExportCategory ieCat = null;
        int i = 0;
        while (i < registeredCats.length) {
            ImportExportCategory cat = registeredCats[i];
            if (cat.getCategoryId().compareTo(catId) == 0) {
                ieCat = cat;
                break;
            }
            ++i;
        }
        return ieCat;
    }

    public static ImportExportSubcategory getRegisteredSubcategory(Trace t, String catId, String subcatId) {
        ImportExportSubcategory subcat = null;
        int i = 0;
        while (i < registeredSubcats.length) {
            ImportExportSubcategory sub = registeredSubcats[i];
            if (sub.getCategoryId().compareTo(catId) == 0 && sub.getSubcategoryId().compareTo(subcatId) == 0) {
                subcat = sub;
                break;
            }
            ++i;
        }
        return subcat;
    }

    private static ImportExportCategory findImportExportCategory(Trace t, String catId) {
        ImportExportCategory cat = null;
        int i = 0;
        while (i < registeredCats.length) {
            if (registeredCats[i].getCategoryId().compareTo(catId) == 0) {
                cat = registeredCats[i];
                break;
            }
            ++i;
        }
        return cat;
    }

    private static ImportExportSubcategory findImportExportSubcategory(Trace t, String catId, String subcatId) {
        ImportExportSubcategory subcat = null;
        int i = 0;
        while (i < registeredSubcats.length) {
            if (registeredSubcats[i].getCategoryId().compareTo(catId) == 0 && registeredSubcats[i].getSubcategoryId().compareTo(subcatId) == 0) {
                subcat = registeredSubcats[i];
                break;
            }
            ++i;
        }
        return subcat;
    }

    public static ImportExportTreeNode[] getTreeNodes() {
        return treeNodes.toArray(new ImportExportTreeNode[treeNodes.size()]);
    }

    public static void setAllTreeNodesVisible(Trace t, boolean visible) {
        int i = 0;
        while (i < treeNodes.size()) {
            ImportExportTreeNode treeNode = treeNodes.get(i);
            treeNode.setVisible(visible);
            ++i;
        }
    }

    public static boolean setCategoryTreeNodeVisible(Trace t, String catId, boolean visible) {
        boolean result = false;
        ImportExportCategory cat = ImportexportPlugin.findImportExportCategory(t, catId);
        if (cat != null) {
            result = ImportexportPlugin.setCategoryTreeNodeVisible(t, cat, visible);
        }
        return result;
    }

    public static boolean setCategoryTreeNodeVisible(Trace t, ImportExportCategory cat, boolean visible) {
        ImportExportTreeNode treeNode;
        boolean result = false;
        if (cat != null && (treeNode = ImportexportPlugin.getCategoryTreeNode(t, cat)) != null) {
            treeNode.setVisible(visible);
            result = true;
        }
        return result;
    }

    public static ImportExportTreeNode getCategoryTreeNode(Trace t, ImportExportCategory cat) {
        ImportExportTreeNode treeNode = null;
        if (cat != null) {
            int i = 0;
            while (i < treeNodes.size()) {
                ImportExportTreeNode node = treeNodes.get(i);
                Object obj = node.getObject();
                if (obj == cat) {
                    treeNode = node;
                    break;
                }
                ++i;
            }
        }
        return treeNode;
    }

    public static boolean setSubcategoryTreeNodeVisible(Trace t, String catId, String subcatId, boolean visible, boolean setParentVisible) {
        boolean result = false;
        ImportExportSubcategory subcat = ImportexportPlugin.findImportExportSubcategory(t, catId, subcatId);
        if (subcat != null) {
            result = ImportexportPlugin.setSubcategoryTreeNodeVisible(t, subcat, visible, setParentVisible);
        }
        return result;
    }

    public static boolean setSubcategoryTreeNodeVisible(Trace t, ImportExportSubcategory subcat, boolean visible, boolean setParentVisible) {
        ImportExportTreeNode treeNode;
        boolean result = false;
        if (subcat != null && (treeNode = ImportexportPlugin.getSubcategoryTreeNode(t, subcat)) != null) {
            treeNode.setVisible(visible);
            if (visible && setParentVisible) {
                treeNode.getParent().setVisible(visible);
            }
            result = true;
        }
        return result;
    }

    public static ImportExportTreeNode getSubcategoryTreeNode(Trace t, ImportExportSubcategory subcat) {
        ImportExportTreeNode treeNode = null;
        if (subcat != null) {
            int i = 0;
            while (i < treeNodes.size()) {
                ImportExportTreeNode node = treeNodes.get(i);
                Object obj = node.getObject();
                if (obj == subcat) {
                    treeNode = node;
                    break;
                }
                ++i;
            }
        }
        return treeNode;
    }

    public static void enableTreeNodesForEnabledPlugins(Trace t) {
        int i = 0;
        while (i < treeNodes.size()) {
            ImportExportTreeNode node = treeNodes.get(i);
            String pluginId = node.getAssociatedPluginId(t);
            if (pluginId != null && pluginId.length() > 0) {
                node.setEnabled(UiPlugin.isPluginEnabled((String)pluginId));
            } else {
                node.setEnabled(false);
            }
            ++i;
        }
    }

    public static void addSelChangedListener(Trace t, PluginEnabledListener listener) {
        pluginEnabledListeners.addElement(listener);
    }

    public static void removeSelChangedListener(Trace t, PluginEnabledListener listener) {
        pluginEnabledListeners.removeElement(listener);
    }

    public static void pluginEnabled(ExplorerNotifyEvent expEvent, String id) {
        Trace t = Trace.getDefault();
        PluginEnabledEvent event = new PluginEnabledEvent(expEvent, id);
        int size = pluginEnabledListeners.size();
        int i = 0;
        while (i < size) {
            PluginEnabledListener listener = pluginEnabledListeners.elementAt(i);
            listener.pluginEnabled(t, event);
            ++i;
        }
    }

    public static String getPluginId(Trace t, String catId, String subcatId) {
        String pluginId = null;
        int i = 0;
        while (i < registeredSubcats.length) {
            ImportExportSubcategory subcat = registeredSubcats[i];
            if (subcat.getCategoryId().compareTo(catId) == 0 && subcat.getSubcategoryId().compareTo(subcatId) == 0) {
                pluginId = subcat.getPluginId();
                break;
            }
            ++i;
        }
        return pluginId;
    }
}

