/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.importexport.internal;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.importexport.internal.ImportExportWizPage;
import com.ibm.mq.explorer.importexport.internal.ImportManager;
import com.ibm.mq.explorer.importexport.internal.ImportexportPlugin;
import com.ibm.mq.explorer.importexport.internal.Messages;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.CheckAndGreyTreeViewer;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ImportWizardPage
extends ImportExportWizPage {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.importexport/src/com/ibm/mq/explorer/importexport/internal/ImportWizardPage.java";
    private FileFieldEditor fileFieldEditor;
    private Composite fileSelectionArea;
    private Text treeLabel;
    private ImportManager importManager = new ImportManager();

    protected ImportWizardPage(String name) {
        super(name, "com.ibm.mq.explorer.ui.infopop.UI_Import_Wizard");
    }

    public void createControl(Composite parent) {
        super.createControl(parent, 3);
    }

    public void createPageContent(final Trace t, Composite parent) {
        this.setHeadings(Messages.ImportWizardPage_Title, null);
        this.fileSelectionArea = new Composite(parent, 0);
        GridData fileSelectionData = new GridData(768);
        fileSelectionData.grabExcessHorizontalSpace = true;
        fileSelectionData.horizontalSpan = 3;
        this.fileSelectionArea.setLayoutData((Object)fileSelectionData);
        GridLayout fileSelectionLayout = new GridLayout();
        fileSelectionLayout.numColumns = 3;
        fileSelectionLayout.makeColumnsEqualWidth = false;
        fileSelectionLayout.marginWidth = 0;
        fileSelectionLayout.marginHeight = 0;
        this.fileSelectionArea.setLayout((Layout)fileSelectionLayout);
        this.fileFieldEditor = new FileFieldEditor("fileSelect", Messages.ImportWizardPage_FileFieldLabel, this.fileSelectionArea);
        this.fileSelectionArea.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Shell shell = e.display.getActiveShell();
                int requiredWidth = e.width + 40;
                if (shell.getSize().x < requiredWidth) {
                    shell.setSize(requiredWidth, shell.getSize().y);
                }
                ImportWizardPage.this.fileSelectionArea.removePaintListener((PaintListener)this);
            }
        });
        this.fileFieldEditor.getTextControl(this.fileSelectionArea).addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Path path = new Path(ImportWizardPage.this.fileFieldEditor.getStringValue());
                int rc = ImportWizardPage.this.importManager.setImportSource(t, (IPath)path);
                String msg = null;
                switch (rc) {
                    case 0: {
                        break;
                    }
                    case -1: {
                        msg = Messages.ImportManager_ErrorReadingSettingsFile;
                        break;
                    }
                    case 3: {
                        msg = Messages.ImportManager_InvalidExtension;
                        break;
                    }
                    case 4: {
                        msg = Messages.ImportManager_FileNotValid;
                        break;
                    }
                    case 1: {
                        msg = Messages.ImportManager_FileNotFound;
                        break;
                    }
                    case 2: {
                        msg = Messages.ImportManager_FileIsDir;
                        break;
                    }
                    default: {
                        msg = Messages.ImportManager_FileNotValid;
                    }
                }
                ImportWizardPage.this.setErrorMessage(msg);
                ImportWizardPage.this.treeViewer.setInput((Object)ImportexportPlugin.getTreeNodes());
                ImportWizardPage.this.treeViewer.getTree().setEnabled(true);
                ImportWizardPage.this.treeViewer.checkAllElements(t, true);
                ImportWizardPage.this.checkIfEnableButtons();
            }
        });
        String[] extensions = new String[]{"*.xml", "*.zip"};
        this.fileFieldEditor.setFileExtensions(extensions);
        UiUtils.createBlankLine((Composite)parent, (int)3);
        this.treeLabel = new Text(parent, 64);
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)this.treeLabel, (boolean)true);
        this.treeLabel.setText(Messages.ImportWizardPage_TreeLabel);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        this.treeLabel.setLayoutData((Object)gridData);
        this.treeViewer = new CheckAndGreyTreeViewer(parent);
        this.treeViewer.setContentProvider(this.importManager.getTreeContentProvider());
        this.treeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ImportWizardPage.this.checkIfEnableButtons();
            }
        });
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 3;
        this.treeViewer.getControl().setLayoutData((Object)gridData);
        this.fileFieldEditor.setFocus();
    }

    public void nextPressed() {
    }

    public boolean performFinish() {
        Trace t = Trace.getDefault();
        Object[] selection = this.treeViewer.getCheckedElements();
        this.importManager.importSelection(t, selection);
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                Trace t1 = Trace.getDefault();
                if (ImportManager.isImportComplete()) {
                    if (ImportManager.isRestartRequired()) {
                        MessageBox.showSystemMessageById((Trace)t1, (Shell)ImportexportPlugin.getShell(), (String)"AMQ4187", null, (String)"AMQ4187");
                        UiPlugin.setPersistOnShutdown((boolean)false);
                        UiPlugin.restartExplorer((Trace)t1);
                    } else {
                        MessageBox.showSystemMessageById((Trace)t1, (Shell)ImportexportPlugin.getShell(), (String)"AMQ4541");
                    }
                }
                ImportWizardPage.this.importManager.notifyImportStatus(t1);
            }
        });
        return true;
    }

    @Override
    protected boolean isValidPathSelected() {
        Trace t = Trace.getDefault();
        boolean result = false;
        if (this.fileFieldEditor.getStringValue().equals("")) {
            this.setErrorMessage(Messages.ImportWizardPage_NoFileSpecified);
        } else {
            result = this.importManager.checkValidInputSource(t) == 0;
        }
        return result;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.checkUiPluginInitialised();
        }
    }

    private void checkUiPluginInitialised() {
        if (!UiPlugin.isInitialized() || UiPlugin.getMQNavigatorView() == null) {
            this.fileFieldEditor.setEnabled(false, this.fileSelectionArea);
            this.setMessage(Messages.ImportWizard_UIPluginNotInitialised, 3);
            this.treeViewer.getControl().dispose();
            this.treeLabel.setText(Messages.ImportWizard_UIPluginNotInitialisedDetails);
            GridData gridData = new GridData(1808);
            gridData.grabExcessHorizontalSpace = true;
            gridData.grabExcessVerticalSpace = true;
            gridData.horizontalSpan = 3;
            this.treeLabel.setLayoutData((Object)gridData);
            this.treeLabel.getParent().layout();
            this.setPageComplete(false);
        }
    }
}

