/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.importexport.internal;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.explorer.core.internal.utils.PersistQueueManagerHandles;
import com.ibm.mq.explorer.importexport.internal.IExplorerRuntimeImportNotify;
import com.ibm.mq.explorer.importexport.internal.ImportExportManager;
import com.ibm.mq.explorer.importexport.internal.ImportExportTreeNode;
import com.ibm.mq.explorer.importexport.internal.ImportexportPlugin;
import com.ibm.mq.explorer.importexport.internal.Messages;
import com.ibm.mq.explorer.importexport.internal.SimulatedInputStream;
import com.ibm.mq.explorer.tests.internal.actions.TestsImportExport;
import com.ibm.mq.explorer.ui.extensions.IExplorerAbstractImportExport;
import com.ibm.mq.explorer.ui.extensions.IExplorerImportExport;
import com.ibm.mq.explorer.ui.extensions.IExplorerImportManager;
import com.ibm.mq.explorer.ui.extensions.IExplorerRuntimeImportExport;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.importexport.ExplorerImportExportHandles;
import com.ibm.mq.explorer.ui.internal.importexport.ImportExportCategory;
import com.ibm.mq.explorer.ui.internal.importexport.ImportExportSubcategory;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public class ImportManager
extends ImportExportManager
implements IExplorerImportManager {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.importexport/src/com/ibm/mq/explorer/importexport/internal/ImportManager.java";
    private static final String ALL_PREFS_V6_SUBCATEGORY = "ALL_PREFS_V6";
    private static final int VERSION_6 = 1;
    private static final int VERSION_701 = 2;
    private static final int VERSION_CURRENT = 3;
    private int inputSourceVersion = 0;
    private IPath importSource = null;
    private int cachedInputSourceRC = 0;
    private List<String> importCompleteCategories = null;
    private List<String> importFailedSubcategories = null;
    private static boolean isRestartRequired = false;
    private static boolean isImportComplete = false;
    private static ArrayList<IExplorerRuntimeImportNotify> importNotifyClasses = null;
    private ArrayList<ImportExportSubcategory> subCategoriesInSource = null;
    private static ImportExportSubcategory v6PrefsSubCategory = new ImportExportSubcategory(Trace.getDefault(), "ALL_PREFS_V6", "com.ibm.mq.explorer.ui.category.preferences", "ALL_PREFS_V6", "ALL_PREFS_V6", "ALL_PREFS_V6", null, false);

    public ImportManager() {
        if (importNotifyClasses == null) {
            importNotifyClasses = new ArrayList();
        }
    }

    public int setImportSource(Trace t, IPath path) {
        String fileExtension;
        this.importSource = null;
        this.inputSourceVersion = 3;
        this.subCategoriesInSource = new ArrayList();
        int rc = 0;
        File file = path.toFile();
        rc = !file.exists() ? 1 : (file.isDirectory() ? 2 : ((fileExtension = (fileExtension = path.getFileExtension()) == null ? "" : fileExtension.toLowerCase()).equals("xml") ? this.readXMLImportData(t, file) : (fileExtension.equals("zip") ? this.readZipImportData(t, file) : 3)));
        if (rc == 0) {
            this.importSource = path;
        }
        this.cachedInputSourceRC = rc;
        return rc;
    }

    private int readXMLImportData(Trace t, File file) {
        int rc = 0;
        try {
            ImportexportPlugin.setAllTreeNodesVisible(t, false);
            FileReader fileReader = null;
            fileReader = new FileReader(file);
            XMLMemento readRoot = null;
            readRoot = XMLMemento.createReadRoot((Reader)fileReader);
            String rootType = readRoot.getType();
            if (rootType != null && !rootType.equals("MQExplorer")) {
                rc = 4;
            } else {
                this.inputSourceVersion = 3;
                IMemento[] iMementoArray = readRoot.getChildren("category");
                int n = iMementoArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IMemento category = iMementoArray[n2];
                    IMemento[] iMementoArray2 = category.getChildren("subcategory");
                    int n3 = iMementoArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IMemento subcategory = iMementoArray2[n4];
                        ImportexportPlugin.setSubcategoryTreeNodeVisible(t, category.getID(), subcategory.getID(), true, true);
                        this.subCategoriesInSource.add(ImportexportPlugin.getRegisteredSubcategory(t, category.getID(), subcategory.getID()));
                        ++n4;
                    }
                    ++n2;
                }
                fileReader.close();
            }
        }
        catch (IOException e) {
            t.FFST(66, "ImportManager.readXMLImportData", 10, -1, 0, 0, e.getMessage(), null, null);
            String msgBoxText = NLS.bind((String)Messages.ImportManager_ErrorReadingFile, (Object)file.toString());
            MessageBox.showMessageFailure((Trace)t, (Shell)UiPlugin.getShell(), (String)msgBoxText);
            rc = -1;
        }
        catch (WorkbenchException e) {
            t.FFST(66, "ImportManager.readXMLImportData", 10, -1, 0, 0, e.getMessage(), null, null);
            String msgBoxText = NLS.bind((String)Messages.ImportManager_ErrorReadingFile, (Object)file.toString());
            MessageBox.showMessageFailure((Trace)t, (Shell)UiPlugin.getShell(), (String)msgBoxText);
            rc = -1;
        }
        return rc;
    }

    public boolean importAll(Trace t) {
        boolean result = false;
        if (this.cachedInputSourceRC == 0) {
            result = this.importSubcategories(t, this.subCategoriesInSource);
        }
        return result;
    }

    public void importSelection(Trace t, Object[] selection) {
        Hashtable<String, ArrayList<ImportExportSubcategory>> selectedCategorysHash = this.processSelection(t, selection);
        ArrayList<ImportExportSubcategory> selectedCategorys = new ArrayList<ImportExportSubcategory>();
        Enumeration<ArrayList<ImportExportSubcategory>> enumeration = selectedCategorysHash.elements();
        while (enumeration.hasMoreElements()) {
            selectedCategorys.addAll((Collection)enumeration.nextElement());
        }
        if (this.inputSourceVersion == 1) {
            Object[] objectArray = selection;
            int n = selection.length;
            int n2 = 0;
            while (n2 < n) {
                ImportExportTreeNode node;
                String category;
                Object o = objectArray[n2];
                if (o instanceof ImportExportTreeNode && (category = ((ImportExportCategory)(node = (ImportExportTreeNode)o).getObject()).getCategoryId()).equals(v6PrefsSubCategory.getCategoryId())) {
                    selectedCategorys.add(v6PrefsSubCategory);
                }
                ++n2;
            }
        }
        this.importSubcategories(t, selectedCategorys);
    }

    public boolean importSubcategories(Trace t, List<ImportExportSubcategory> subcategories) {
        this.importFailedSubcategories = new ArrayList<String>();
        isImportComplete = false;
        isRestartRequired = false;
        boolean continueExport = false;
        boolean showOverrideWarning = this.getShowOverride(t, subcategories);
        if (showOverrideWarning) {
            String msg = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4138");
            int rc = MessageBox.showYesNoMessage((Trace)t, (Shell)ImportexportPlugin.getShell(), (String)msg, (int)1, (String)"AMQ4138");
            if (rc == 0) {
                continueExport = true;
            }
        } else {
            continueExport = true;
        }
        boolean result = true;
        if (continueExport) {
            String fileExtension = this.importSource.getFileExtension().toLowerCase();
            if (fileExtension.equals("xml")) {
                result = this.importSelectionFromXML(t, subcategories);
            } else if (fileExtension.equals("zip")) {
                result = this.importSubcategoriesFromZip(t, subcategories);
            }
            if (result && this.importFailedSubcategories.size() == 0) {
                ImportManager.setImportComplete();
            } else {
                if (this.importFailedSubcategories.size() > 0) {
                    StringBuffer failedMessage = new StringBuffer("Import failures occured in the following plugins: ");
                    int i = 0;
                    while (i < this.importFailedSubcategories.size()) {
                        failedMessage.append(this.importFailedSubcategories.get(i));
                        if (i < this.importFailedSubcategories.size() - 1) {
                            failedMessage.append(", ");
                        }
                        ++i;
                    }
                    t.data(67, "ImportManager.importSubcategories", 900, failedMessage.toString());
                    UiPlugin.logMessage((String)"com.ibm.mq.explorer.importexport", (String)failedMessage.toString());
                }
                MessageBox.showSystemMessageById((Trace)t, (Shell)UiPlugin.getShell(), (String)"AMQ4185", null);
            }
        }
        return result;
    }

    private boolean getShowOverride(Trace t, List<ImportExportSubcategory> subcategories) {
        boolean override = false;
        if (this.inputSourceVersion == 1) {
            override = true;
        } else {
            for (ImportExportSubcategory subcat : subcategories) {
                IExplorerAbstractImportExport importExportClass = subcat.getImportExportClass();
                if (importExportClass instanceof IExplorerRuntimeImportExport) {
                    if (!((IExplorerRuntimeImportExport)importExportClass).isDestructiveImport()) continue;
                    override = true;
                    continue;
                }
                override = true;
            }
        }
        return override;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean importSelectionFromXML(Trace t, List<ImportExportSubcategory> selectedSubcategorys) {
        boolean result = false;
        try {
            try {
                FileReader fileReader = new FileReader(this.importSource.toFile());
                XMLMemento readRoot = XMLMemento.createReadRoot((Reader)fileReader);
                IMemento setsCategory = null;
                IMemento[] iMementoArray = readRoot.getChildren("category");
                int n = iMementoArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IMemento categoryMemento = iMementoArray[n2];
                    ArrayList<ImportExportSubcategory> selectedSubcats = new ArrayList<ImportExportSubcategory>();
                    for (ImportExportSubcategory subCategory : selectedSubcategorys) {
                        if (!subCategory.getCategoryId().equals(categoryMemento.getID())) continue;
                        selectedSubcats.add(subCategory);
                    }
                    if (selectedSubcats != null && !selectedSubcats.isEmpty()) {
                        if (categoryMemento.getID().equals("com.ibm.mq.explorer.ui.category.sets")) {
                            setsCategory = categoryMemento;
                        } else {
                            result = this.importCategoryFromXML(categoryMemento, selectedSubcats);
                        }
                    }
                    ++n2;
                }
                if (setsCategory == null) return result;
                ArrayList<ImportExportSubcategory> selectedSubcats = new ArrayList<ImportExportSubcategory>();
                for (ImportExportSubcategory subCategory : selectedSubcategorys) {
                    if (!subCategory.getCategoryId().equals(setsCategory.getID())) continue;
                    selectedSubcats.add(subCategory);
                }
                if (selectedSubcats == null) return result;
                result = this.importCategoryFromXML(setsCategory, selectedSubcats);
                return result;
            }
            catch (IOException e) {
                result = false;
                t.FFST(66, "ImportManager.importSelectionFromXML", 10, -1, 0, 0, e.getMessage(), null, null);
                if (!result) return result;
                this.importCompleteCategories = this.processSelectionAsStrings(t, selectedSubcategorys);
                return result;
            }
            catch (WorkbenchException e) {
                result = false;
                t.FFST(66, "ImportManager.importSelectionFromXML", 10, -1, 0, 0, e.getMessage(), null, null);
                if (!result) return result;
                this.importCompleteCategories = this.processSelectionAsStrings(t, selectedSubcategorys);
                return result;
            }
        }
        finally {
            if (result) {
                this.importCompleteCategories = this.processSelectionAsStrings(t, selectedSubcategorys);
            }
        }
    }

    private boolean importCategoryFromXML(IMemento categoryMemento, ArrayList<ImportExportSubcategory> selectedSubcats) {
        boolean result = false;
        boolean ranImport = false;
        IMemento[] iMementoArray = categoryMemento.getChildren("subcategory");
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento subcategoryMemento = iMementoArray[n2];
            for (ImportExportSubcategory subcat : selectedSubcats) {
                if (subcat.getSubcategoryId().equals(subcategoryMemento.getID())) {
                    IExplorerAbstractImportExport importExportClass = subcat.getImportExportClass();
                    if (importExportClass instanceof IExplorerRuntimeImportExport) {
                        result = ((IExplorerRuntimeImportExport)importExportClass).importData(subcat.getCategoryId(), subcat.getSubcategoryId(), subcategoryMemento);
                        ranImport = true;
                    } else {
                        SimulatedInputStream inputStream = new SimulatedInputStream(subcategoryMemento.getTextData());
                        result = ((IExplorerImportExport)importExportClass).importData(subcat.getCategoryId(), subcat.getSubcategoryId(), (InputStream)inputStream);
                        ranImport = true;
                        this.setRestartRequired();
                    }
                }
                if (!ranImport || result) continue;
                this.importFailedSubcategories.add(subcat.getSubcategoryId());
            }
            ++n2;
        }
        return result;
    }

    private void setRestartRequired() {
        isRestartRequired = true;
    }

    public static boolean isRestartRequired() {
        return isRestartRequired;
    }

    public static void setImportComplete() {
        isImportComplete = true;
    }

    public static boolean isImportComplete() {
        return isImportComplete;
    }

    private int readZipImportData(Trace t, File file) {
        int rc = 0;
        this.inputSourceVersion = this.getExportVersionFromZip(t, file);
        if (this.inputSourceVersion == 1) {
            rc = this.readZipImportDataV6(t, file);
        } else if (this.inputSourceVersion == 2) {
            rc = this.readZipImportDataV701(t, file);
        }
        return rc;
    }

    private int readZipImportDataV6(Trace t, File file) {
        int rc = 0;
        boolean validExport = false;
        try {
            ImportexportPlugin.setAllTreeNodesVisible(t, false);
            ZipFile zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry o = entries.nextElement();
                if (!(o instanceof ZipEntry)) continue;
                ZipEntry entry = o;
                if (entry.getName().equals("WMQ_Filters.xml")) {
                    ImportexportPlugin.setSubcategoryTreeNodeVisible(t, "com.ibm.mq.explorer.ui.category.filters.schemes", "com.ibm.mq.explorer.ui.subcategory.filters", true, true);
                    this.subCategoriesInSource.add(ImportexportPlugin.getRegisteredSubcategory(t, "com.ibm.mq.explorer.ui.category.filters.schemes", "com.ibm.mq.explorer.ui.subcategory.filters"));
                    validExport = true;
                    continue;
                }
                if (entry.getName().equals("WMQ_Preferences.xml")) {
                    ImportexportPlugin.setCategoryTreeNodeVisible(t, "com.ibm.mq.explorer.ui.category.preferences", true);
                    this.subCategoriesInSource.add(v6PrefsSubCategory);
                    validExport = true;
                    continue;
                }
                if (entry.getName().equals("WMQ_Schemes.xml")) {
                    ImportexportPlugin.setSubcategoryTreeNodeVisible(t, "com.ibm.mq.explorer.ui.category.filters.schemes", "com.ibm.mq.explorer.ui.subcategory.schemes", true, true);
                    this.subCategoriesInSource.add(ImportexportPlugin.getRegisteredSubcategory(t, "com.ibm.mq.explorer.ui.category.filters.schemes", "com.ibm.mq.explorer.ui.subcategory.schemes"));
                    validExport = true;
                    continue;
                }
                if (!entry.getName().equals("WMQ_Handles.xml")) continue;
                ImportexportPlugin.setSubcategoryTreeNodeVisible(t, "com.ibm.mq.explorer.ui.category.conn.info", "com.ibm.mq.explorer.ui.subcategory.handles", true, true);
                this.subCategoriesInSource.add(ImportexportPlugin.getRegisteredSubcategory(t, "com.ibm.mq.explorer.ui.category.conn.info", "com.ibm.mq.explorer.ui.subcategory.handles"));
                validExport = true;
            }
            zipFile.close();
            if (!validExport) {
                rc = 4;
            }
        }
        catch (IOException e) {
            t.FFST(66, "ImportManager.readZipImportDataV6", 10, -1, 0, 0, e.getMessage(), null, null);
            String msgBoxText = NLS.bind((String)Messages.ImportManager_ErrorReadingFile, (Object)file.toString());
            MessageBox.showMessageFailure((Trace)t, (Shell)UiPlugin.getShell(), (String)msgBoxText);
            rc = -1;
        }
        return rc;
    }

    private int readZipImportDataV701(Trace t, File file) {
        int rc = 0;
        boolean validExport = false;
        try {
            ImportexportPlugin.setAllTreeNodesVisible(t, false);
            ZipFile zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry;
                String entryFilename;
                ZipEntry o = entries.nextElement();
                if (!(o instanceof ZipEntry) || (entryFilename = (entry = o).getName()).equals("ImportExportInformation.xml")) continue;
                int separatorIndex = entryFilename.indexOf("\\");
                if (separatorIndex == -1) {
                    separatorIndex = entryFilename.indexOf("/");
                }
                if (separatorIndex == -1) continue;
                String catId = entryFilename.substring(0, separatorIndex);
                String subcatId = entryFilename.substring(separatorIndex + 1);
                int suffixIndex = subcatId.indexOf(".xml");
                if (suffixIndex != -1) {
                    subcatId = subcatId.substring(0, suffixIndex);
                }
                if (!ImportexportPlugin.setSubcategoryTreeNodeVisible(t, catId, subcatId, true, true)) continue;
                this.subCategoriesInSource.add(ImportexportPlugin.getRegisteredSubcategory(t, catId, subcatId));
                validExport = true;
            }
            if (!validExport) {
                rc = 4;
            }
            zipFile.close();
        }
        catch (IOException e) {
            t.FFST(66, "ImportManager.readZipImportDataV701", 10, -1, 0, 0, e.getMessage(), null, null);
            String msgBoxText = NLS.bind((String)Messages.ImportManager_ErrorReadingFile, (Object)file.toString());
            MessageBox.showMessageFailure((Trace)t, (Shell)UiPlugin.getShell(), (String)msgBoxText);
            rc = -1;
        }
        return rc;
    }

    private int getExportVersionFromZip(Trace t, File file) {
        int version = 1;
        try {
            ZipFile zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String entryFilename = entry.getName();
                int separatorIndex = entryFilename.indexOf("\\");
                if (separatorIndex == -1) {
                    separatorIndex = entryFilename.indexOf("/");
                }
                if (separatorIndex == -1) continue;
                version = 2;
            }
        }
        catch (IOException e) {
            t.FFST(66, "ImportManager.getExportVersionFromZip", 10, -1, 0, 0, e.getMessage(), null, null);
        }
        return version;
    }

    private boolean importSubcategoriesFromZip(Trace t, List<ImportExportSubcategory> subcategories) {
        boolean result = false;
        if (this.inputSourceVersion == 1) {
            result = this.importSubcategoriesFromZipV6(t, subcategories);
        } else if (this.inputSourceVersion == 2) {
            result = this.importSubcategoriesFromZipV701(t, subcategories);
        }
        return result;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean importSubcategoriesFromZipV701(Trace t, List<ImportExportSubcategory> subcategories) {
        boolean result = false;
        boolean ranImport = false;
        try {
            try {
                ZipFile zipFile = new ZipFile(this.importSource.toFile());
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    String filename;
                    int separatorPos;
                    ZipEntry entry = entries.nextElement();
                    if (entry.getName().equals("ImportExportInformation.xml") || entry.isDirectory() || (separatorPos = (filename = entry.getName()).indexOf("\\")) == -1 && (separatorPos = filename.indexOf("/")) == -1) continue;
                    String categoryId = filename.substring(0, separatorPos);
                    String subcategoryId = filename.substring(separatorPos + 1, filename.indexOf(".xml"));
                    List<ImportExportSubcategory> subcatsForCategory = this.getSubcategoriesForId(t, categoryId, subcategories);
                    for (ImportExportSubcategory subcat : subcatsForCategory) {
                        InputStream inputStream;
                        if (!subcat.getSubcategoryId().equals(subcategoryId)) continue;
                        ranImport = false;
                        IExplorerAbstractImportExport importExportClass = subcat.getImportExportClass();
                        if (importExportClass instanceof IExplorerRuntimeImportExport) {
                            inputStream = zipFile.getInputStream(entry);
                            if (inputStream.available() == 0) continue;
                            if (importExportClass instanceof TestsImportExport && this.inputSourceVersion == 2) {
                                result = ((TestsImportExport)importExportClass).importData(categoryId, subcategoryId, inputStream);
                                ranImport = true;
                            } else if (importExportClass instanceof ExplorerImportExportHandles && this.inputSourceVersion == 2) {
                                result = this.importSelectionWithDtd(t, inputStream, (IExplorerRuntimeImportExport)importExportClass, categoryId, subcategoryId, "WMQ_Handles");
                                ranImport = true;
                            } else if (subcategoryId.equals("com.ibm.mq.explorer.jmsadmin.contexts") && this.inputSourceVersion == 2) {
                                result = this.importSelectionWithDtd(t, inputStream, (IExplorerRuntimeImportExport)importExportClass, categoryId, subcategoryId, "JndiInitialContexts");
                                ranImport = true;
                            } else if (subcategoryId.equals("com.ibm.mq.explorer.servicedef.repositories")) {
                                result = this.importSelectionWithDtd(t, inputStream, (IExplorerRuntimeImportExport)importExportClass, categoryId, subcategoryId, "ServiceDefinitionRepositories");
                                ranImport = true;
                            } else {
                                InputStreamReader inputReader = new InputStreamReader(inputStream);
                                XMLMemento readRoot = XMLMemento.createReadRoot((Reader)inputReader);
                                result = ((IExplorerRuntimeImportExport)importExportClass).importData(categoryId, subcategoryId, (IMemento)readRoot);
                                ranImport = true;
                            }
                            inputStream.close();
                        } else {
                            inputStream = zipFile.getInputStream(entry);
                            System.out.println("Importing data for " + categoryId + "/" + subcategoryId);
                            result = ((IExplorerImportExport)importExportClass).importData(categoryId, subcategoryId, inputStream);
                            ranImport = true;
                            inputStream.close();
                            this.setRestartRequired();
                        }
                        if (!ranImport || result) continue;
                        this.importFailedSubcategories.add(subcat.getSubcategoryId());
                    }
                }
                result = true;
                return result;
            }
            catch (IOException e) {
                result = false;
                t.FFST(66, "ImportManager.importSubcategoriesFromZipV701", 10, -1, 0, 0, e.getMessage(), null, null);
                if (!result) return result;
                this.importCompleteCategories = this.processSelectionAsStrings(t, subcategories);
                return result;
            }
            catch (WorkbenchException e) {
                result = false;
                t.FFST(66, "ImportManager.importSubcategoriesFromZipV701", 10, -1, 0, 0, e.getMessage(), null, null);
                if (!result) return result;
                this.importCompleteCategories = this.processSelectionAsStrings(t, subcategories);
                return result;
            }
            catch (Exception e) {
                result = false;
                t.FFST(66, "ImportManager.importSubcategoriesFromZipV701", 10, -1, 0, 0, e.getMessage(), null, null);
                if (!result) return result;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                this.importCompleteCategories = this.processSelectionAsStrings(t, subcategories);
                return result;
            }
        }
        finally {
            if (result) {
                this.importCompleteCategories = this.processSelectionAsStrings(t, subcategories);
            }
        }
    }

    private boolean importSelectionWithDtd(Trace t, InputStream inputStream, IExplorerRuntimeImportExport importExportClass, String categoryId, String subcategoryId, String dtdName) throws WorkbenchException, IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        StringReader inputReader = this.getReaderWithoutDTD(t, inputStreamReader, dtdName);
        XMLMemento readRoot = XMLMemento.createReadRoot((Reader)inputReader);
        boolean result = importExportClass.importData(categoryId, subcategoryId, (IMemento)readRoot);
        return result;
    }

    private StringReader getReaderWithoutDTD(Trace t, InputStreamReader inputReader, String dtdName) throws IOException {
        StringBuilder sb = new StringBuilder();
        String line = null;
        BufferedReader inputStringReader = new BufferedReader(inputReader);
        while ((line = inputStringReader.readLine()) != null) {
            if (line.contains(String.valueOf(dtdName) + ".dtd")) continue;
            sb.append(String.valueOf(line) + "\n");
        }
        inputStringReader.close();
        StringReader outputReader = new StringReader(sb.toString());
        return outputReader;
    }

    private boolean importSubcategoriesFromZipV6(Trace t, List<ImportExportSubcategory> subcategories) {
        boolean result = true;
        try {
            ZipFile zipFile = new ZipFile(this.importSource.toFile());
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                InputStream inputStream = zipFile.getInputStream(entry);
                String entryFilename = entry.getName();
                if (entryFilename.equals("WMQ_Filters.xml")) {
                    for (ImportExportSubcategory subcat : this.getSubcategoriesForId(t, "com.ibm.mq.explorer.ui.category.filters.schemes", subcategories)) {
                        if (!subcat.getSubcategoryId().equals("com.ibm.mq.explorer.ui.subcategory.filters") || this.importEntry(t, entry, inputStream)) continue;
                        result = false;
                        this.importFailedSubcategories.add(subcat.getSubcategoryId());
                    }
                    continue;
                }
                if (entryFilename.equals("WMQ_Preferences.xml")) {
                    if (this.getSubcategoriesForId(t, "com.ibm.mq.explorer.ui.category.preferences", subcategories).size() <= 0 || !this.importEntry(t, entry, inputStream) || UiPlugin.importPreferencesFromXmlFile((Trace)t, null)) continue;
                    result = false;
                    this.importFailedSubcategories.add("com.ibm.mq.explorer.ui.category.preferences");
                    continue;
                }
                if (entryFilename.equals("WMQ_Schemes.xml")) {
                    for (ImportExportSubcategory subcat : this.getSubcategoriesForId(t, "com.ibm.mq.explorer.ui.category.filters.schemes", subcategories)) {
                        if (!subcat.getSubcategoryId().equals("com.ibm.mq.explorer.ui.subcategory.schemes") || this.importEntry(t, entry, inputStream)) continue;
                        result = false;
                        this.importFailedSubcategories.add(subcat.getSubcategoryId());
                    }
                    continue;
                }
                if (!entryFilename.equals("WMQ_Handles.xml")) continue;
                for (ImportExportSubcategory subcat : this.getSubcategoriesForId(t, "com.ibm.mq.explorer.ui.category.conn.info", subcategories)) {
                    if (!subcat.getSubcategoryId().equals("com.ibm.mq.explorer.ui.subcategory.handles")) continue;
                    if (!this.importEntry(t, entry, inputStream)) {
                        result = false;
                        this.importFailedSubcategories.add(subcat.getSubcategoryId());
                        continue;
                    }
                    PersistQueueManagerHandles.setSave((boolean)false);
                }
            }
        }
        catch (ZipException e) {
            result = false;
            t.FFST(66, "ImportManager.importSubcategoriesFromZipV6", 10, -1, 0, 0, e.getMessage(), null, null);
        }
        catch (IOException e) {
            result = false;
            t.FFST(66, "ImportManager.importSubcategoriesFromZipV6", 10, -1, 0, 0, e.getMessage(), null, null);
        }
        if (result) {
            this.setRestartRequired();
            this.importCompleteCategories = this.processSelectionAsStrings(t, subcategories);
        }
        return result;
    }

    private boolean importEntry(Trace t, ZipEntry entry, InputStream inputStream) {
        return this.importEntry(t, entry.getName(), inputStream);
    }

    private boolean importEntry(Trace t, String entry, InputStream inputStream) {
        boolean result = true;
        String fileName = UiPlugin.getPersistentFileLocation() + File.separator + entry;
        try {
            int b;
            File f = new File(fileName);
            FileOutputStream fileOutputStream = new FileOutputStream(f);
            while ((b = inputStream.read()) != -1) {
                fileOutputStream.write(b);
            }
        }
        catch (FileNotFoundException e) {
            t.FFST(66, "ImportManager.importEntry", 2, 50028, e.getMessage());
            result = false;
        }
        catch (IOException e) {
            t.FFST(66, "ImportManager.importEntry", 1, 50028, e.getMessage());
            result = false;
        }
        return result;
    }

    public int checkValidInputSource(Trace t) {
        return this.cachedInputSourceRC;
    }

    public static void addListener(IExplorerRuntimeImportNotify listener) {
        if (importNotifyClasses == null) {
            importNotifyClasses = new ArrayList();
        }
        importNotifyClasses.add(listener);
    }

    public static void removeListener(IExplorerRuntimeImportNotify listener) {
        if (importNotifyClasses == null) {
            importNotifyClasses = new ArrayList();
        } else {
            importNotifyClasses.remove(listener);
        }
    }

    public void notifyImportStatus(Trace t) {
        if (isImportComplete) {
            this.notifyImportComplete(t, this.importCompleteCategories);
        } else {
            this.notifyImportFailed(t, this.importFailedSubcategories);
        }
    }

    private void notifyImportComplete(Trace t, List<String> subcategories) {
        int i = 0;
        while (i < importNotifyClasses.size()) {
            IExplorerRuntimeImportNotify listener = importNotifyClasses.get(i);
            listener.notifyImportComplete(subcategories);
            if (Trace.isTracing) {
                t.data(67, "ImportManager.notifyImportComplete", 500, "Class '" + listener.toString() + "' sent Import Complete event");
            }
            ++i;
        }
    }

    private void notifyImportFailed(Trace t, List<String> failedSubcategories) {
        int i = 0;
        while (i < importNotifyClasses.size()) {
            IExplorerRuntimeImportNotify listener = importNotifyClasses.get(i);
            listener.notifyImportFailed(failedSubcategories);
            if (Trace.isTracing) {
                t.data(67, "ImportManager.notifyImportFailed", 500, "Class '" + listener.toString() + "' sent Import Failed event");
            }
            ++i;
        }
    }

    public boolean canImportId(Trace t, String categoryId, String subcategoryId) {
        boolean result = ImportexportPlugin.getRegisteredSubcategory(t, categoryId, subcategoryId) == null;
        return result;
    }

    private List<ImportExportSubcategory> getSubcategoriesForId(Trace t, String categoryId, List<ImportExportSubcategory> subcategories) {
        ArrayList<ImportExportSubcategory> filteredSubcats = new ArrayList<ImportExportSubcategory>();
        for (ImportExportSubcategory subcat : subcategories) {
            if (!subcat.getCategoryId().equals(categoryId)) continue;
            filteredSubcats.add(subcat);
        }
        return filteredSubcats;
    }
}

