/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.importexport.internal;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.importexport.internal.ExportManager;
import com.ibm.mq.explorer.importexport.internal.FileSaveFieldEditor;
import com.ibm.mq.explorer.importexport.internal.ImportExportTreeNode;
import com.ibm.mq.explorer.importexport.internal.ImportExportWizPage;
import com.ibm.mq.explorer.importexport.internal.ImportexportPlugin;
import com.ibm.mq.explorer.importexport.internal.Messages;
import com.ibm.mq.explorer.ui.internal.controls.CheckAndGreyTreeViewer;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ExportWizardPage
extends ImportExportWizPage {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.importexport/src/com/ibm/mq/explorer/importexport/internal/ExportWizardPage.java";
    private ExportManager exportManager = new ExportManager();
    private FileSaveFieldEditor fileFieldEditor;

    protected ExportWizardPage(String name) {
        super(name, "com.ibm.mq.explorer.ui.infopop.UI_Export_Wizard");
    }

    public void createControl(Composite parent) {
        super.createControl(parent, 3);
    }

    public void createPageContent(Trace t, Composite parent) {
        ImportExportTreeNode[] treeNodes;
        this.setHeadings(Messages.ExportWizardPage_Title, null);
        Text treeLabel = new Text(parent, 4);
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)treeLabel, (boolean)true);
        treeLabel.setText(Messages.ExportWizardPage_TreeLabel);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        treeLabel.setLayoutData((Object)gridData);
        this.treeViewer = new CheckAndGreyTreeViewer(parent);
        this.treeViewer.setContentProvider(this.exportManager.getTreeContentProvider());
        ImportexportPlugin.enableTreeNodesForEnabledPlugins(t);
        ImportExportTreeNode[] importExportTreeNodeArray = treeNodes = ImportexportPlugin.getTreeNodes();
        int n = treeNodes.length;
        int n2 = 0;
        while (n2 < n) {
            ImportExportTreeNode tn = importExportTreeNodeArray[n2];
            tn.setVisible(true);
            ++n2;
        }
        this.treeViewer.setInput((Object)treeNodes);
        this.treeViewer.checkAllElements(t, true);
        this.treeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ExportWizardPage.this.checkIfEnableButtons();
            }
        });
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 3;
        this.treeViewer.getControl().setLayoutData((Object)gridData);
        UiUtils.createBlankLine((Composite)parent, (int)3);
        Text fileSelectLabel = new Text(parent, 4);
        fileSelectLabel.setText(Messages.ExportWizardPage_FileSelectLabel);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 3;
        fileSelectLabel.setLayoutData((Object)gridData);
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)fileSelectLabel, (boolean)true);
        final Composite fileSelectionArea = new Composite(parent, 0);
        GridData fileSelectionData = new GridData(768);
        fileSelectionData.grabExcessHorizontalSpace = true;
        fileSelectionData.horizontalSpan = 3;
        fileSelectionArea.setLayoutData((Object)fileSelectionData);
        GridLayout fileSelectionLayout = new GridLayout();
        fileSelectionLayout.numColumns = 3;
        fileSelectionLayout.makeColumnsEqualWidth = false;
        fileSelectionLayout.marginWidth = 0;
        fileSelectionLayout.marginHeight = 0;
        fileSelectionArea.setLayout((Layout)fileSelectionLayout);
        this.fileFieldEditor = new FileSaveFieldEditor("fileSelect", "", fileSelectionArea);
        fileSelectionArea.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Shell shell = e.display.getActiveShell();
                int requiredWidth = e.width + 40;
                if (shell.getSize().x < requiredWidth) {
                    shell.setSize(requiredWidth, shell.getSize().y);
                }
                fileSelectionArea.removePaintListener((PaintListener)this);
            }
        });
        String[] extensions = new String[]{"*.xml"};
        this.fileFieldEditor.setFileExtensions(extensions);
        this.fileFieldEditor.getTextControl(fileSelectionArea).setEditable(false);
        this.fileFieldEditor.getTextControl(fileSelectionArea).addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String fileText = ExportWizardPage.this.fileFieldEditor.getStringValue();
                String extension = new Path(fileText).getFileExtension();
                if (extension == null) {
                    ExportWizardPage.this.fileFieldEditor.setStringValue(String.valueOf(fileText) + "." + "xml");
                } else if (extension.equals("")) {
                    ExportWizardPage.this.fileFieldEditor.setStringValue(String.valueOf(fileText) + "xml");
                }
                ExportWizardPage.this.checkIfEnableButtons();
            }
        });
        this.treeViewer.getControl().setFocus();
    }

    public void nextPressed() {
    }

    public boolean performFinish() {
        Trace t = Trace.getDefault();
        Path path = new Path(this.fileFieldEditor.getStringValue());
        if (path.toFile().exists()) {
            String msg = Message.format((String)CommonServices.getSystemMessage((Trace)t, (String)"AMQ4820"), (String)path.toString());
            int rc = MessageBox.showYesNoMessage((Trace)t, (Shell)this.getShell(), (String)msg, (int)1, (String)"AMQ4820");
            if (rc == 1) {
                return false;
            }
        }
        Object[] selection = this.treeViewer.getCheckedElements();
        this.exportManager.exportSelection(t, (IPath)path, selection);
        return true;
    }

    @Override
    protected boolean isValidPathSelected() {
        boolean valid;
        Path path = new Path(this.fileFieldEditor.getStringValue());
        if (path.isEmpty()) {
            this.setErrorMessage(Messages.ExportWizardPage_NoFileSpecified);
            return false;
        }
        if (path.isValidPath(path.toString())) {
            valid = true;
            this.setErrorMessage(null);
        } else {
            this.setErrorMessage(Messages.ExportWizardPage_InvalidPath);
            valid = false;
        }
        return valid;
    }
}

