/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.importexport.internal;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.importexport.internal.ImportExportManager;
import com.ibm.mq.explorer.importexport.internal.SimulatedOutputStream;
import com.ibm.mq.explorer.ui.extensions.IExplorerAbstractImportExport;
import com.ibm.mq.explorer.ui.extensions.IExplorerImportExport;
import com.ibm.mq.explorer.ui.extensions.IExplorerRuntimeImportExport;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.importexport.ImportExportSubcategory;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

public class ExportManager
extends ImportExportManager {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.importexport/src/com/ibm/mq/explorer/importexport/internal/ExportManager.java";

    public void exportSelection(Trace t, IPath fileName, Object[] selection) {
        try {
            File xmlFile = fileName.toFile();
            xmlFile.createNewFile();
            XMLMemento writeRoot = XMLMemento.createWriteRoot((String)"MQExplorer");
            Hashtable<String, ArrayList<ImportExportSubcategory>> selectedCategorys = this.processSelection(t, selection);
            for (String category : selectedCategorys.keySet()) {
                IMemento categoryMemento = writeRoot.createChild("category", category);
                for (ImportExportSubcategory subcategory : selectedCategorys.get(category)) {
                    IMemento subcategoryMemento = categoryMemento.createChild("subcategory", subcategory.getSubcategoryId());
                    IExplorerAbstractImportExport importExportClass = subcategory.getImportExportClass();
                    if (importExportClass instanceof IExplorerRuntimeImportExport) {
                        IMemento memento = ((IExplorerRuntimeImportExport)importExportClass).exportData(category, subcategory.getSubcategoryId());
                        if (memento == null) continue;
                        subcategoryMemento.putMemento(memento);
                        continue;
                    }
                    SimulatedOutputStream outputStream = new SimulatedOutputStream();
                    ((IExplorerImportExport)importExportClass).exportData(category, subcategory.getSubcategoryId(), (OutputStream)outputStream);
                    subcategoryMemento.putTextData(outputStream.getBuffer().toString());
                }
            }
            FileWriter fw = new FileWriter(xmlFile);
            writeRoot.save((Writer)fw);
            fw.close();
            MessageBox.showSystemMessageById((Trace)t, (Shell)UiPlugin.getShell(), (String)"AMQ4542", (String[])new String[]{xmlFile.getAbsolutePath()});
        }
        catch (IOException e) {
            t.data(67, "ExportManager.exportSelection", 300, "Error when writing to " + fileName.toString() + ": " + e.getMessage());
            UiPlugin.logException((Exception)e);
            MessageBox.showSystemMessageById((Trace)t, (Shell)UiPlugin.getShell(), (String)"AMQ4186", null);
        }
    }
}

