/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ams.ui.internal.policies;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.ams.ui.internal.base.Messages;
import com.ibm.mq.explorer.ams.ui.internal.policies.GetDistinguishedNameDialog;
import com.ibm.mq.explorer.core.internal.attrs.AttrInt;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.properties.CustomPropertyPage;
import com.ibm.mq.explorer.ui.internal.properties.UiDisplayGroup;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class PolicyPropertyPage
extends CustomPropertyPage {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2010.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ams/src/com/ibm/mq/explorer/ams/ui/internal/policies/PolicyPropertyPage.java";
    private UiMQObject uiMQObject = null;
    private IDmObject dmObject = null;
    private Button signAddDN;
    private Button signRemoveDN;
    private Text signDNDescription;
    private int toleration;
    private int keyReuse;
    private String signAlg = "";
    private boolean acceptAnySigned;
    private String encAlg = "";
    private ArrayList<String> signDistNames;
    private ArrayList<String> recipDistNames;
    private int tolerationSelection;
    public static final int TOLERATION_STRICT = 0;
    public static final int TOLERATION_TOLERATE = 1;
    private boolean EncryptionOnlySupport = false;
    private Button keyReuseDisabled = null;
    private Button keyReuseUnlimited = null;
    private Button keyReuseCustom = null;
    private Spinner keyReuseCustomCount = null;
    private int keyReuseSelection;
    public static final int KEYREUSE_DISABLED = 0;
    public static final int KEYREUSE_UNLIMITED = -1;
    private static final int TEXT_WIDTH_HINT = 400;
    private static final int HORIZONTAL_INDENT = 30;
    private static final int HORIZONTAL_SPAN = 3;
    private Combo signAlgorithmCombo;
    private List signDistNamesList;
    private Combo encAlgorithmCombo;
    private Text encAlgorithmLabel;
    private Text keyReuseCustomCountLabel;
    private List recipDistNamesList;
    private Button recipAddDN;
    private Button recipRemoveDN;
    private Text recipDNDescription;
    private Button radioAnySigned;
    private Button radioDNrestrict;

    public PolicyPropertyPage(Trace t, Composite parent_, int style, UiMQObject uiMQObject_, UiDisplayGroup uiDispGroup, boolean readonly) {
        super(t, parent_, style, uiMQObject_, uiDispGroup, readonly);
        this.uiMQObject = uiMQObject_;
    }

    public void init(Trace t) {
        this.dmObject = this.uiMQObject.getDmObject();
        this.EncryptionOnlySupport = this.dmObject.getQueueManager().getCommandLevel() >= 900;
        GridLayout gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 8;
        gridLayout.verticalSpacing = 8;
        gridLayout.marginWidth = 8;
        gridLayout.marginHeight = 8;
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.numColumns = 2;
        this.setLayout((Layout)gridLayout);
        this.createPolicyName(t);
        this.createToleration(t);
        this.createSigning(t);
        this.createEncyption(t);
        this.toggleSignDNComponents();
    }

    private void createPolicyName(Trace t) {
        Text policyNameLabel = new Text((Composite)this, 66);
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)policyNameLabel, (boolean)true);
        policyNameLabel.setText(Messages.PolicyPropertyPage_PolicyName);
        GridData gridData = new GridData();
        policyNameLabel.setLayoutData((Object)gridData);
        Text policyName = new Text((Composite)this, 2048);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        policyName.setLayoutData((Object)gridData);
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)policyName, (boolean)false);
        policyName.setText(this.dmObject.getTitle());
    }

    private void createToleration(Trace t) {
        Group tolerationGroup = new Group((Composite)this, 0);
        tolerationGroup.setText(Messages.PolicyPropertyPage_TolerationGroupLabel);
        GridLayout gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 8;
        gridLayout.verticalSpacing = 8;
        gridLayout.marginWidth = 8;
        gridLayout.marginHeight = 8;
        gridLayout.makeColumnsEqualWidth = false;
        tolerationGroup.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        tolerationGroup.setLayoutData((Object)gridData);
        Button radioStrict = new Button((Composite)tolerationGroup, 16);
        radioStrict.setText(Messages.PolicyPropertyPage_TolerationStrict);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        radioStrict.setLayoutData((Object)gridData);
        radioStrict.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PolicyPropertyPage.this.tolerationSelection = 0;
            }
        });
        radioStrict.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = String.valueOf(Messages.PolicyPropertyPage_TolerationStrict) + ". " + Messages.PolicyPropertyPage_TolerationStrictDescription;
            }
        });
        Label strictLabel = new Label((Composite)tolerationGroup, 64);
        strictLabel.setText(Messages.PolicyPropertyPage_TolerationStrictDescription);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalIndent = 30;
        gridData.horizontalAlignment = 4;
        gridData.widthHint = 400;
        strictLabel.setLayoutData((Object)gridData);
        Button radioTolerate = new Button((Composite)tolerationGroup, 16);
        radioTolerate.setText(Messages.PolicyPropertyPage_TolerationTolerate);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        radioTolerate.setLayoutData((Object)gridData);
        radioTolerate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PolicyPropertyPage.this.tolerationSelection = 1;
            }
        });
        radioTolerate.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = String.valueOf(Messages.PolicyPropertyPage_TolerationTolerate) + ". " + Messages.PolicyPropertyPage_TolerationTolerateDescription;
            }
        });
        Label tolerateLabel = new Label((Composite)tolerationGroup, 64);
        tolerateLabel.setText(Messages.PolicyPropertyPage_TolerationTolerateDescription);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.horizontalIndent = 30;
        gridData.widthHint = 400;
        tolerateLabel.setLayoutData((Object)gridData);
        String tolerationValue = this.dmObject.getAttributeValue(t, 235, 0);
        if (tolerationValue.equals(Messages.DmAmsMessageProtectionPolicy_TolerationStrict)) {
            radioStrict.setSelection(true);
            radioTolerate.setSelection(false);
            this.toleration = 0;
            this.tolerationSelection = 0;
        } else {
            radioStrict.setSelection(false);
            radioTolerate.setSelection(true);
            this.toleration = 1;
            this.tolerationSelection = 1;
        }
    }

    private void createEncyption(final Trace t) {
        String dn;
        Group encryptionGroup = new Group((Composite)this, 0);
        encryptionGroup.setText(Messages.PolicyPropertyPage_EncryptionGroupTitle);
        GridLayout gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 8;
        gridLayout.verticalSpacing = 8;
        gridLayout.marginWidth = 8;
        gridLayout.marginHeight = 8;
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.numColumns = 3;
        encryptionGroup.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        encryptionGroup.setLayoutData((Object)gridData);
        this.encAlgorithmLabel = new Text((Composite)encryptionGroup, 4);
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)this.encAlgorithmLabel, (boolean)true);
        this.encAlgorithmLabel.setText(Messages.PolicyPropertyPage_EncryptionAlgorithmLabel);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        this.encAlgorithmLabel.setLayoutData((Object)gridData);
        this.encAlgorithmCombo = new Combo((Composite)encryptionGroup, 12);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.encAlgorithmCombo.setLayoutData((Object)gridData);
        this.encAlgorithmCombo.add(Messages.DmEseMessageProtectionPolicy_Enc_Alg_NONE);
        this.encAlgorithmCombo.add("RC2");
        this.encAlgorithmCombo.add("DES");
        this.encAlgorithmCombo.add("Triple DES");
        this.encAlgorithmCombo.add("AES128");
        this.encAlgorithmCombo.add("AES256");
        this.encAlg = this.dmObject.getAttributeValue(t, 237, 0);
        this.encAlgorithmCombo.setText(this.encAlg);
        this.encAlgorithmCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PolicyPropertyPage.this.toggleEncDNComponents();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Composite buttonGroup = new Composite((Composite)encryptionGroup, 0);
        buttonGroup.setLayout((Layout)new GridLayout());
        gridData = new GridData();
        gridData.widthHint = 400;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 3;
        buttonGroup.setLayoutData((Object)gridData);
        this.keyReuseDisabled = new Button(buttonGroup, 16);
        this.keyReuseDisabled.setText(Messages.PolicyPropertyPage_KeyReuseDisabledLabel);
        this.keyReuseDisabled.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PolicyPropertyPage.this.keyReuseSelection = 0;
                PolicyPropertyPage.this.keyReuseCustomCount.setEnabled(false);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.keyReuseUnlimited = new Button(buttonGroup, 16);
        this.keyReuseUnlimited.setText(Messages.PolicyPropertyPage_KeyReuseUnlimitedLabel);
        this.keyReuseUnlimited.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PolicyPropertyPage.this.keyReuseSelection = -1;
                PolicyPropertyPage.this.keyReuseCustomCount.setEnabled(false);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.keyReuseCustom = new Button(buttonGroup, 16);
        this.keyReuseCustom.setText(Messages.PolicyPropertyPage_KeyReuseCustomLabel);
        this.keyReuseCustom.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PolicyPropertyPage.this.keyReuseSelection = PolicyPropertyPage.this.keyReuseCustomCount.getSelection();
                PolicyPropertyPage.this.keyReuseCustomCount.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.keyReuseCustomCountLabel = new Text(buttonGroup, 4);
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)this.keyReuseCustomCountLabel, (boolean)true);
        this.keyReuseCustomCountLabel.setText(Messages.PolicyPropertyPage_KeyReuseCustomCountLabel);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        this.keyReuseCustomCountLabel.setLayoutData((Object)gridData);
        this.keyReuseCustomCount = new Spinner(buttonGroup, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.keyReuseCustomCount.setLayoutData((Object)gridData);
        this.keyReuseCustomCount.setMinimum(1);
        this.keyReuseCustomCount.setMaximum(9999999);
        UiUtils.limitSpinner((Trace)t, (Spinner)this.keyReuseCustomCount);
        AttrInt krAttr = (AttrInt)this.dmObject.getAttribute(t, 267, 0);
        this.keyReuse = krAttr != null ? (Integer)krAttr.getValue(t) : 0;
        switch (this.keyReuse) {
            case 0: {
                this.keyReuseDisabled.setSelection(true);
                this.keyReuseCustomCount.setEnabled(false);
                break;
            }
            case -1: {
                this.keyReuseUnlimited.setSelection(true);
                this.keyReuseCustomCount.setEnabled(false);
                break;
            }
            default: {
                this.keyReuseCustom.setSelection(true);
                this.keyReuseCustomCount.setEnabled(true);
                this.keyReuseCustomCount.setSelection(this.keyReuse);
            }
        }
        this.recipDNDescription = new Text((Composite)encryptionGroup, 66);
        this.recipDNDescription.setText(Messages.PolicyPropertyPage_EncryptionListDescription);
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)this.recipDNDescription, (boolean)true);
        gridData = new GridData();
        gridData.widthHint = 400;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 3;
        this.recipDNDescription.setLayoutData((Object)gridData);
        this.recipDistNamesList = new List((Composite)encryptionGroup, 2818);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 3;
        gridData.heightHint = this.recipDistNamesList.getItemHeight() * 3;
        this.recipDistNamesList.setLayoutData((Object)gridData);
        this.recipDistNames = new ArrayList();
        int repeatIndex = 0;
        while (!"[not_found]".equals(dn = this.dmObject.getAttributeValue(t, 2114, repeatIndex++))) {
            this.recipDistNames.add(dn);
            this.recipDistNamesList.add(dn);
        }
        this.recipDistNamesList.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PolicyPropertyPage.this.toggleEncDNComponents();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.recipAddDN = new Button((Composite)encryptionGroup, 8);
        this.recipAddDN.setText(Messages.PolicyPropertyPage_AddDNButton);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.recipAddDN.setLayoutData((Object)gridData);
        this.recipAddDN.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GetDistinguishedNameDialog addDNDlg = new GetDistinguishedNameDialog(PolicyPropertyPage.this.getShell(), 0);
                addDNDlg.setTitle(Messages.PolicyPropertyPage_AddDNDlg_Title);
                addDNDlg.setInformationStrings(new String[]{Messages.PolicyPropertyPage_AddDNDlg_Description});
                addDNDlg.create(t);
                boolean result = addDNDlg.open(t);
                if (result) {
                    PolicyPropertyPage.this.recipDistNamesList.add(addDNDlg.getObjectName());
                }
                PolicyPropertyPage.this.toggleEncDNComponents();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.recipRemoveDN = new Button((Composite)encryptionGroup, 8);
        this.recipRemoveDN.setText(Messages.PolicyPropertyPage_RemoveDNButton);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.recipRemoveDN.setLayoutData((Object)gridData);
        this.recipRemoveDN.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int[] selected = PolicyPropertyPage.this.recipDistNamesList.getSelectionIndices();
                if (selected.length > 0) {
                    PolicyPropertyPage.this.recipDistNamesList.remove(selected);
                }
                PolicyPropertyPage.this.toggleEncDNComponents();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.toggleEncDNComponents();
    }

    private void createSigning(final Trace t) {
        String dn;
        Group signingGroup = new Group((Composite)this, 0);
        signingGroup.setText(Messages.PolicyPropertyPage_SigningGroupTitle);
        GridLayout gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 8;
        gridLayout.verticalSpacing = 8;
        gridLayout.marginWidth = 8;
        gridLayout.marginHeight = 8;
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.numColumns = 3;
        signingGroup.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        signingGroup.setLayoutData((Object)gridData);
        Text signingAlgorithmLabel = new Text((Composite)signingGroup, 4);
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)signingAlgorithmLabel, (boolean)true);
        signingAlgorithmLabel.setText(Messages.PolicyPropertyPage_SignatureAlgorithmLabel);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        signingAlgorithmLabel.setLayoutData((Object)gridData);
        this.signAlgorithmCombo = new Combo((Composite)signingGroup, 12);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.signAlgorithmCombo.setLayoutData((Object)gridData);
        this.signAlgorithmCombo.add(Messages.DmEseMessageProtectionPolicy_Sign_Alg_NONE);
        this.signAlgorithmCombo.add("MD5");
        this.signAlgorithmCombo.add("SHA1");
        this.signAlgorithmCombo.add("SHA256");
        this.signAlgorithmCombo.add("SHA384");
        this.signAlgorithmCombo.add("SHA512");
        this.signAlg = this.dmObject.getAttributeValue(t, 236, 0);
        this.signAlgorithmCombo.setText(this.signAlg);
        this.signAlgorithmCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PolicyPropertyPage.this.toggleSignDNComponents();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        UiUtils.createBlankLine((Composite)signingGroup, (int)3);
        Composite signingButtonGroup = new Composite((Composite)signingGroup, 0);
        signingButtonGroup.setLayout((Layout)new GridLayout());
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        signingButtonGroup.setLayoutData((Object)gridData);
        this.radioAnySigned = new Button(signingButtonGroup, 16);
        this.radioAnySigned.setText(Messages.PolicyPropertyPage_AcceptAnySigned);
        this.radioAnySigned.setSelection(true);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 3;
        this.radioAnySigned.setLayoutData((Object)gridData);
        this.radioAnySigned.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PolicyPropertyPage.this.toggleSignDNComponents();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.radioDNrestrict = new Button(signingButtonGroup, 16);
        this.radioDNrestrict.setText(Messages.PolicyPropertyPage_OnlyAcceptFromList);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 3;
        this.radioDNrestrict.setLayoutData((Object)gridData);
        this.radioDNrestrict.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PolicyPropertyPage.this.toggleSignDNComponents();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.signDNDescription = new Text((Composite)signingGroup, 66);
        this.signDNDescription.setText(Messages.PolicyPropertyPage_SignatureListDescription);
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)this.signDNDescription, (boolean)true);
        gridData = new GridData();
        gridData.widthHint = 400;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 3;
        this.signDNDescription.setLayoutData((Object)gridData);
        this.signDistNamesList = new List((Composite)signingGroup, 2818);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 3;
        gridData.heightHint = this.signDistNamesList.getItemHeight() * 3;
        this.signDistNamesList.setLayoutData((Object)gridData);
        this.signDistNames = new ArrayList();
        int repeatIndex = 0;
        while (!"[not_found]".equals(dn = this.dmObject.getAttributeValue(t, 2113, repeatIndex))) {
            this.signDistNames.add(dn);
            this.signDistNamesList.add(dn);
            ++repeatIndex;
        }
        this.radioAnySigned.setSelection(this.signDistNamesList.getItemCount() <= 0);
        this.radioDNrestrict.setSelection(this.signDistNamesList.getItemCount() > 0);
        this.acceptAnySigned = this.radioAnySigned.getSelection();
        this.signDistNamesList.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PolicyPropertyPage.this.toggleSignDNComponents();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.signAddDN = new Button((Composite)signingGroup, 8);
        this.signAddDN.setText(Messages.PolicyPropertyPage_AddDNButton);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.signAddDN.setLayoutData((Object)gridData);
        this.signRemoveDN = new Button((Composite)signingGroup, 8);
        this.signRemoveDN.setText(Messages.PolicyPropertyPage_RemoveDNButton);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.signRemoveDN.setLayoutData((Object)gridData);
        this.signRemoveDN.setEnabled(false);
        this.signAddDN.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GetDistinguishedNameDialog addDNDlg = new GetDistinguishedNameDialog(PolicyPropertyPage.this.getShell(), 0);
                addDNDlg.setTitle(Messages.PolicyPropertyPage_AddDNDlg_Title);
                addDNDlg.setInformationStrings(new String[]{Messages.PolicyPropertyPage_AddDNDlg_Description});
                addDNDlg.create(t);
                boolean result = addDNDlg.open(t);
                if (result) {
                    PolicyPropertyPage.this.signDistNamesList.add(addDNDlg.getObjectName());
                }
                PolicyPropertyPage.this.toggleSignDNComponents();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.signRemoveDN.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int[] selected = PolicyPropertyPage.this.signDistNamesList.getSelectionIndices();
                if (selected.length > 0) {
                    PolicyPropertyPage.this.signDistNamesList.remove(selected);
                }
                PolicyPropertyPage.this.toggleSignDNComponents();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.toggleSignDNComponents();
    }

    public void restoreDefaults(Trace t) {
    }

    public boolean apply(Trace t, Object job) {
        boolean applied = false;
        boolean changed = false;
        if (this.changeNeeded(t) && this.isValid(t)) {
            String[] recipientDNs;
            String signAlgSelection;
            changed = this.dmObject.setAttributeValue(t, job, 235, 0, (Object)this.getTolerationSelection());
            if (changed) {
                this.toleration = this.tolerationSelection;
                applied = true;
            }
            if (changed = this.dmObject.setAttributeValue(t, job, 267, 0, (Object)this.getKeyReuseSelection())) {
                this.keyReuse = this.keyReuseSelection;
                applied = true;
            }
            if (changed = this.dmObject.setAttributeValue(t, job, 236, 0, (Object)this.getSignatureAlgorithmSelection(signAlgSelection = this.signAlgorithmCombo.getText()))) {
                this.signAlg = signAlgSelection;
                applied = true;
            }
            this.acceptAnySigned = this.radioAnySigned.getSelection();
            int repeatIndex = 0;
            Iterator<String> it = this.signDistNames.iterator();
            while (it.hasNext()) {
                it.next();
                this.dmObject.deleteAttribute(t, null, 2113, repeatIndex++);
            }
            this.signDistNames.clear();
            if (!this.signDistNamesList.isEnabled()) {
                this.signDistNamesList.removeAll();
            }
            String[] signatureDNs = this.signDistNamesList.getItems();
            repeatIndex = 0;
            String[] stringArray = signatureDNs;
            int n = signatureDNs.length;
            int n2 = 0;
            while (n2 < n) {
                String distinguishedName = stringArray[n2];
                if (changed = this.dmObject.setAttributeValue(t, job, 2113, repeatIndex++, (Object)distinguishedName)) {
                    this.signDistNames.add(distinguishedName);
                    applied = true;
                }
                ++n2;
            }
            String encAlgSelection = this.encAlgorithmCombo.getText();
            int enc = this.getEncryptionAlgorithmSelection(encAlgSelection);
            if (!this.encAlgorithmCombo.isEnabled()) {
                enc = 0;
            }
            if (changed = this.dmObject.setAttributeValue(t, job, 237, 0, (Object)enc)) {
                this.encAlg = encAlgSelection;
                applied = true;
            }
            repeatIndex = 0;
            it = this.recipDistNames.iterator();
            while (it.hasNext()) {
                it.next();
                this.dmObject.deleteAttribute(t, null, 2114, repeatIndex++);
            }
            this.recipDistNames.clear();
            if (!this.recipDistNamesList.isEnabled()) {
                this.recipDistNamesList.removeAll();
            }
            repeatIndex = 0;
            String[] stringArray2 = recipientDNs = this.recipDistNamesList.getItems();
            int n3 = recipientDNs.length;
            int n4 = 0;
            while (n4 < n3) {
                String distinguishedName = stringArray2[n4];
                if (changed = this.dmObject.setAttributeValue(t, job, 2114, repeatIndex++, (Object)distinguishedName)) {
                    this.recipDistNames.add(distinguishedName);
                    applied = true;
                }
                ++n4;
            }
        }
        return applied;
    }

    public boolean isValid(Trace t) {
        boolean valid = true;
        if (this.signDistNamesList.isEnabled() && this.signDistNamesList.getItemCount() <= 0) {
            valid = false;
            MessageBox.showMessageFailure((Trace)t, (Shell)this.getShell(), (String)Messages.PolicyPropertyPage_SigningDNRequired);
        }
        if (valid && this.encAlgorithmCombo.isEnabled() && !Messages.DmEseMessageProtectionPolicy_Enc_Alg_NONE.equals(this.encAlgorithmCombo.getText()) && this.recipDistNamesList.getItemCount() <= 0) {
            valid = false;
            MessageBox.showMessageFailure((Trace)t, (Shell)this.getShell(), (String)Messages.PolicyPropertyPage_EncryptionDNRequired);
        }
        return valid;
    }

    public boolean isAnyControlEnabled(Trace t) {
        return true;
    }

    public void changesApplied(Trace t) {
    }

    private boolean changeNeeded(Trace t) {
        boolean change = false;
        change = this.tolerationChanged();
        if (!change) {
            change = this.signAlgorithmChanged();
        }
        if (!change) {
            change = this.signRestrictionsChanged();
        }
        if (!change) {
            change = this.signDNsChanged();
        }
        if (!change) {
            change = this.encAlgorithmChanged();
        }
        if (!change) {
            change = this.recipDNsChanged();
        }
        if (!change) {
            change = this.keyReuseChanged();
        }
        return change;
    }

    private int getTolerationSelection() {
        int selection = 1;
        if (this.tolerationSelection == 0) {
            selection = 0;
        }
        return selection;
    }

    private int getKeyReuseSelection() {
        int selection = this.keyReuseSelection;
        switch (this.keyReuseSelection) {
            case 0: {
                selection = 0;
                break;
            }
            case -1: {
                selection = -1;
            }
        }
        return selection;
    }

    private int getSignatureAlgorithmSelection(String title) {
        int algorithm = 0;
        if (title.equals(Messages.DmEseMessageProtectionPolicy_Sign_Alg_NONE)) {
            algorithm = 0;
        } else if (title.equals("MD5")) {
            algorithm = 1;
        } else if (title.equals("SHA1")) {
            algorithm = 2;
        } else if (title.equals("SHA256")) {
            algorithm = 4;
        } else if (title.equals("SHA384")) {
            algorithm = 5;
        } else if (title.equals("SHA512")) {
            algorithm = 6;
        }
        return algorithm;
    }

    private int getEncryptionAlgorithmSelection(String title) {
        int algorithm = 0;
        if (title.equals(Messages.DmEseMessageProtectionPolicy_Enc_Alg_NONE)) {
            algorithm = 0;
        } else if (title.equals("RC2")) {
            algorithm = 1;
        } else if (title.equals("DES")) {
            algorithm = 2;
        } else if (title.equals("Triple DES")) {
            algorithm = 3;
        } else if (title.equals("AES128")) {
            algorithm = 4;
        } else if (title.equals("AES256")) {
            algorithm = 5;
        }
        return algorithm;
    }

    private boolean tolerationChanged() {
        boolean changed = false;
        if (this.tolerationSelection != this.toleration) {
            changed = true;
        }
        return changed;
    }

    private boolean keyReuseChanged() {
        boolean changed = false;
        if (this.keyReuseSelection != this.keyReuse) {
            changed = true;
        }
        return changed;
    }

    private boolean signAlgorithmChanged() {
        boolean changed = false;
        if (!this.signAlg.equals(this.signAlgorithmCombo.getText())) {
            changed = true;
        }
        return changed;
    }

    private boolean signRestrictionsChanged() {
        boolean changed = false;
        if (this.acceptAnySigned != this.radioAnySigned.getSelection()) {
            changed = true;
        }
        return changed;
    }

    private boolean encAlgorithmChanged() {
        boolean changed = false;
        if (!this.encAlg.equals(this.encAlgorithmCombo.getText())) {
            changed = true;
        }
        return changed;
    }

    private boolean signDNsChanged() {
        boolean changed = false;
        String[] signatureDNs = this.signDistNamesList.getItems();
        ArrayList<String> signatures = new ArrayList<String>();
        String[] stringArray = signatureDNs;
        int n = signatureDNs.length;
        int n2 = 0;
        while (n2 < n) {
            String distinguishedName = stringArray[n2];
            signatures.add(distinguishedName);
            ++n2;
        }
        if (!signatures.equals(this.signDistNames)) {
            changed = true;
        }
        return changed;
    }

    private boolean recipDNsChanged() {
        boolean changed = false;
        String[] signatureDNs = this.recipDistNamesList.getItems();
        ArrayList<String> signatures = new ArrayList<String>();
        String[] stringArray = signatureDNs;
        int n = signatureDNs.length;
        int n2 = 0;
        while (n2 < n) {
            String distinguishedName = stringArray[n2];
            signatures.add(distinguishedName);
            ++n2;
        }
        if (!signatures.equals(this.recipDistNames)) {
            changed = true;
        }
        return changed;
    }

    private void toggleSignDNComponents() {
        boolean enable = this.getSignatureAlgorithmSelection(this.signAlgorithmCombo.getText()) != 0;
        this.signAddDN.setEnabled(enable);
        this.signDistNamesList.setEnabled(enable);
        this.signDNDescription.setEnabled(enable);
        this.signRemoveDN.setEnabled(enable && this.signDistNamesList.getSelectionCount() > 0);
        this.radioAnySigned.setEnabled(enable);
        this.radioDNrestrict.setEnabled(enable);
        if (enable) {
            boolean restrictEnabled = this.radioDNrestrict.getSelection();
            this.signDNDescription.setEnabled(restrictEnabled);
            this.signAddDN.setEnabled(restrictEnabled);
            this.signDistNamesList.setEnabled(restrictEnabled);
            this.signRemoveDN.setEnabled(restrictEnabled && this.signDistNamesList.getSelectionCount() > 0);
        }
        this.toggleAllEncDNComponents();
    }

    private void toggleEncDNComponents() {
        boolean sign_enable = this.getSignatureAlgorithmSelection(this.signAlgorithmCombo.getText()) != 0;
        boolean enc_enable = this.getEncryptionAlgorithmSelection(this.encAlgorithmCombo.getText()) != 0;
        this.recipAddDN.setEnabled(enc_enable);
        this.recipDistNamesList.setEnabled(enc_enable);
        this.recipDNDescription.setEnabled(enc_enable);
        if (sign_enable) {
            this.keyReuseSelection = 0;
            this.keyReuseDisabled.setSelection(true);
            this.keyReuseDisabled.setEnabled(enc_enable);
            this.keyReuseUnlimited.setEnabled(false);
            this.keyReuseUnlimited.setSelection(false);
            this.keyReuseCustom.setEnabled(false);
            this.keyReuseCustom.setSelection(false);
            this.keyReuseCustomCountLabel.setEnabled(false);
            this.keyReuseCustomCount.setEnabled(false);
            this.keyReuseCustomCount.setSelection(1);
        } else {
            this.keyReuseDisabled.setEnabled(enc_enable && this.EncryptionOnlySupport);
            this.keyReuseUnlimited.setEnabled(enc_enable && this.EncryptionOnlySupport);
            this.keyReuseCustom.setEnabled(enc_enable && this.EncryptionOnlySupport);
            this.keyReuseCustomCountLabel.setEnabled(enc_enable && this.EncryptionOnlySupport);
            this.keyReuseCustomCount.setEnabled(enc_enable && this.EncryptionOnlySupport && this.keyReuseCustom.getSelection());
        }
        this.recipRemoveDN.setEnabled(enc_enable && this.recipDistNamesList.getSelectionCount() > 0);
    }

    private void toggleAllEncDNComponents() {
        if (this.encAlgorithmCombo != null) {
            this.toggleEncDNComponents();
        }
    }
}

