/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ams.ui.internal.policies;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.ams.ui.internal.base.AmsPlugin;
import com.ibm.mq.explorer.ams.ui.internal.base.Messages;
import com.ibm.mq.explorer.ams.ui.internal.policies.PoliciesTreeNode;
import com.ibm.mq.explorer.ams.ui.internal.policies.PoliciesTreeNodeObject;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.event.DmMonitor;
import com.ibm.mq.explorer.core.internal.event.DmObjectEvent;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.event.DmObjectListEvent;
import com.ibm.mq.explorer.core.internal.event.DmObjectSummaryEvent;
import com.ibm.mq.explorer.core.internal.event.DmQueueManagerListener;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.ui.extensions.ITreeNodeFactory;
import com.ibm.mq.explorer.ui.extensions.MQQmgrExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class PoliciesTreeNodeFactory
implements IExecutableExtension,
ITreeNodeFactory {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2010.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ams/src/com/ibm/mq/explorer/ams/ui/internal/policies/PoliciesTreeNodeFactory.java";
    protected static Map<DmQueueManager, Boolean> enabledMap = Collections.synchronizedMap(new HashMap());

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }

    public void addChildrenToTreeNode(final TreeNode parent) {
        final Trace t = Trace.getDefault();
        String parentId = parent.getId();
        if (parentId.startsWith("com.ibm.mq.explorer.treenode.qm.")) {
            Boolean amsEnabled;
            boolean nodeAlreadyExists;
            MQQmgrExtObject qmgr = (MQQmgrExtObject)parent.getObject();
            final UiQueueManager uiQM = (UiQueueManager)qmgr.getInternalObject();
            boolean addedToCache = false;
            final RemoveAMSNodeListener listener = new RemoveAMSNodeListener(t, uiQM.getDmQueueManagerObject());
            boolean doit = uiQM.isConnected();
            if (doit && (nodeAlreadyExists = parent.isChildExist("com.ibm.mq.explorer.ams.node.policies"))) {
                doit = false;
            }
            if (uiQM.getPlatform(t) == 1) {
                doit = false;
            }
            if (doit && (amsEnabled = enabledMap.get(uiQM.getDmQueueManagerObject())) != null) {
                doit = false;
                if (amsEnabled.booleanValue()) {
                    PoliciesTreeNodeFactory.addPoliciesTreeNode(t, qmgr, parent, listener);
                }
            }
            if (doit) {
                Boolean capable = AmsPlugin.isAmsCapable(t, uiQM.getDmQueueManagerObject());
                if (capable != null) {
                    enabledMap.put(uiQM.getDmQueueManagerObject(), capable);
                    addedToCache = true;
                    if (capable.booleanValue()) {
                        PoliciesTreeNodeFactory.addPoliciesTreeNode(t, qmgr, parent, listener);
                    }
                } else if (uiQM.getDmQueueManagerObject().isLocal()) {
                    Boolean apiExitLoaded = AmsPlugin.isAmsApiExitLoaded((UiMQObject)uiQM, t, uiQM.getDmQueueManagerObject());
                    enabledMap.put(uiQM.getDmQueueManagerObject(), apiExitLoaded);
                    addedToCache = true;
                    if (apiExitLoaded.booleanValue()) {
                        PoliciesTreeNodeFactory.addPoliciesTreeNode(t, qmgr, parent, listener);
                    }
                } else {
                    AmsPlugin.capabilityExecutor.schedule(new Runnable(){

                        @Override
                        public void run() {
                            PoliciesTreeNodeFactory.this.hasAMSQueue(t, uiQM, parent, listener);
                        }
                    }, AmsPlugin.scheduledDelay, TimeUnit.MILLISECONDS);
                }
            }
            if (addedToCache) {
                Object key = DmMonitor.addQueueManagerListener((Trace)t, (DmQueueManagerListener)listener, (boolean)true);
                listener.setNotificationId(key);
            }
        }
    }

    public void hasAMSQueue(Trace t, UiQueueManager uiQM, TreeNode parent, RemoveAMSNodeListener listener) {
        DmObjectFilter amsQueueFilter = new DmObjectFilter(t, "SYSTEM.PROTECTION.POLICY.QUEUE", 13);
        int result = -1;
        try {
            result = uiQM.getDmQueueManagerObject().getObjects(t, amsQueueFilter, false).size();
        }
        catch (DmCoreException e) {
            t.data(66, "PoliciesTreeNodeFactory.hasAMSQueue", 900, "Event returned from datamodel contained an exception:" + e.getMessage());
        }
        if (result == 1) {
            enabledMap.put(uiQM.getDmQueueManagerObject(), Boolean.TRUE);
            PoliciesTreeNodeFactory.addPoliciesTreeNodeOnGuiThread(t, (MQQmgrExtObject)parent.getObject(), parent, listener);
        } else {
            enabledMap.put(uiQM.getDmQueueManagerObject(), Boolean.FALSE);
        }
    }

    public static void addPoliciesTreeNodeOnGuiThread(final Trace t, final MQQmgrExtObject qmgr, final TreeNode parent, final RemoveAMSNodeListener listener) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return;
        }
        Display display = workbench.getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                PoliciesTreeNodeFactory.addPoliciesTreeNode(t, qmgr, parent, listener);
                UiPlugin.refreshNavigatorViews((Trace)t, (boolean)true);
            }
        });
    }

    public static void addPoliciesTreeNode(Trace t, MQQmgrExtObject qmgr, TreeNode parent, RemoveAMSNodeListener listener) {
        PoliciesTreeNodeObject policiesNodeObject = new PoliciesTreeNodeObject(Messages.PoliciesTreeNode_Label);
        PoliciesTreeNode node = new PoliciesTreeNode(parent, policiesNodeObject, "com.ibm.mq.explorer.ams");
        policiesNodeObject.setTreeNode(node);
        UiQueueManager uiQM = (UiQueueManager)qmgr.getInternalObject();
        policiesNodeObject.setInternalObject(uiQM);
        parent.addChildToNode((TreeNode)node, 6);
        listener.setTreeInfo(parent, node);
    }

    private final class RemoveAMSNodeListener
    implements DmQueueManagerListener {
        private final DmQueueManager manager;
        private TreeNode parent;
        private PoliciesTreeNode node;
        private Trace t;
        private Object notificationId;

        private RemoveAMSNodeListener(Trace t, DmQueueManager manager) {
            this.manager = manager;
            this.t = t;
        }

        public void setNotificationId(Object key) {
            this.notificationId = key;
        }

        public void setTreeInfo(TreeNode parent, PoliciesTreeNode node) {
            this.parent = parent;
            this.node = node;
        }

        public void dmQueueManagerConnected(DmObjectEvent event) {
        }

        public void dmQueueManagerConnecting(DmObjectEvent event) {
        }

        public void dmQueueManagerDisconnected(DmObjectEvent event) {
            DmQueueManager disconnectedManager = (DmQueueManager)event.getSource();
            if (this.manager.getUUID().equals(disconnectedManager.getUUID())) {
                enabledMap.remove(this.manager);
                this.removeNodeOnGuiThread();
                DmMonitor.removeQueueManagerListener((Trace)this.t, (DmQueueManagerListener)this, (Object)this.notificationId);
            }
        }

        private void removeNodeOnGuiThread() {
            IWorkbench workbench = PlatformUI.getWorkbench();
            if (workbench == null) {
                return;
            }
            Display display = workbench.getDisplay();
            if (display == null) {
                return;
            }
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    if (RemoveAMSNodeListener.this.parent != null && RemoveAMSNodeListener.this.parent.isChildExist("com.ibm.mq.explorer.ams.node.policies") && RemoveAMSNodeListener.this.node != null) {
                        RemoveAMSNodeListener.this.parent.removeChildFromNode((TreeNode)RemoveAMSNodeListener.this.node);
                        UiPlugin.refreshNavigatorViews((Trace)RemoveAMSNodeListener.this.t, (boolean)true);
                    }
                }
            });
        }

        public void dmQueueManagerHidden(DmObjectEvent event) {
        }

        public void dmQueueManagerShown(DmObjectEvent event) {
        }

        public void dmObjectAdded(DmObjectEvent event) {
        }

        public void dmObjectChanged(DmObjectEvent event) {
        }

        public void dmObjectDeleted(DmObjectEvent event) {
        }

        public void dmObjectSummary(DmObjectSummaryEvent event) {
        }

        public void dmRefreshComplete(DmObjectEvent event) {
        }

        public void dmObjectListDone(DmObjectListEvent event) {
        }
    }
}

