/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ams.ui.internal.policies;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.ams.ui.internal.base.AmsPlugin;
import com.ibm.mq.explorer.ams.ui.internal.base.Messages;
import com.ibm.mq.explorer.ams.ui.internal.policies.PoliciesTreeNodeObject;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import com.ibm.mq.explorer.ui.internal.objects.NewObjectProvider;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import java.util.concurrent.TimeUnit;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

public class PoliciesTreeNode
extends TreeNode {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2010.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ams/src/com/ibm/mq/explorer/ams/ui/internal/policies/PoliciesTreeNode.java";
    private Boolean amsEnabled = false;

    public PoliciesTreeNode(TreeNode parent, final PoliciesTreeNodeObject policiesNodeObject, String plugin_id) {
        super(parent, (MQExtObject)policiesNodeObject, plugin_id);
        AmsPlugin.capabilityExecutor.schedule(new Runnable(){

            @Override
            public void run() {
                if (policiesNodeObject.getInternalDataObject() == null) {
                    AmsPlugin.capabilityExecutor.schedule(this, AmsPlugin.scheduledDelay, TimeUnit.MILLISECONDS);
                } else {
                    PoliciesTreeNode.this.checkAMSCapability(policiesNodeObject);
                }
            }
        }, AmsPlugin.scheduledDelay, TimeUnit.MILLISECONDS);
    }

    private void checkAMSCapability(PoliciesTreeNodeObject policiesNodeObject) {
        final UiQueueManager uiQM = (UiQueueManager)policiesNodeObject.getInternalObject();
        final Trace t = Trace.getDefault();
        Boolean capable = AmsPlugin.isAmsCapable(t, uiQM.getDmQueueManagerObject());
        if (capable != null) {
            this.amsEnabled = capable;
        } else if (uiQM.getDmQueueManagerObject().isLocal()) {
            this.amsEnabled = AmsPlugin.isAmsApiExitLoaded((UiMQObject)uiQM, t, uiQM.getDmQueueManagerObject());
        } else {
            AmsPlugin.capabilityExecutor.schedule(new Runnable(){

                @Override
                public void run() {
                    DmObjectFilter amsQueueFilter = new DmObjectFilter(t, "SYSTEM.PROTECTION.POLICY.QUEUE", 13);
                    int result = -1;
                    try {
                        result = uiQM.getDmQueueManagerObject().getObjects(t, amsQueueFilter, false).size();
                    }
                    catch (DmCoreException e) {
                        t.data(66, "PoliciesTreeNode.checkAMSCapability", 900, "Event returned from datamodel contained an exception:" + e.getMessage());
                    }
                    PoliciesTreeNode.this.amsEnabled = result == 1;
                }
            }, AmsPlugin.scheduledDelay, TimeUnit.MILLISECONDS);
        }
    }

    public String toString() {
        return Messages.PoliciesTreeNode_Label;
    }

    public String getId() {
        return "com.ibm.mq.explorer.ams.node.policies";
    }

    public String getSequence() {
        return "975";
    }

    public String getContentPageId() {
        return "com.ibm.mq.explorer.ams.ui.internal.policies.PoliciesContentPage";
    }

    public String getHelpId() {
        return "com.ibm.mq.explorer.ams.PoliciesNode";
    }

    public Image getIcon() {
        return null;
    }

    public int compare(TreeNode child1, TreeNode child2) {
        return TreeNode.compareBySequence((TreeNode)child1, (TreeNode)child2);
    }

    public boolean isContextMenuFromUiObject() {
        return false;
    }

    public boolean isAddChildrenWhenExpanded() {
        return false;
    }

    public NewObjectProvider getNewObjectProvider(Trace t) {
        return null;
    }

    public void appendToContextMenu(Shell shell, IMenuManager manager) {
        super.appendToContextMenu(shell, manager);
        manager.add((IContributionItem)new GroupMarker("group1"));
    }

    public boolean testAttribute(Object target, String name, String value) {
        if ("amsEnabled".equals(name)) {
            return this.amsEnabled.toString().equals(value);
        }
        return super.testAttribute(target, name, value);
    }
}

