/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ams.ui.internal.policies;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.ams.ui.internal.base.Messages;
import com.ibm.mq.explorer.ams.ui.internal.policies.GetDistinguishedNameDialog;
import com.ibm.mq.explorer.ams.ui.internal.policies.NewPolicyWiz;
import com.ibm.mq.explorer.ams.ui.internal.policies.NewPolicyWizPage1;
import com.ibm.mq.explorer.ui.internal.controls.WizPage;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class NewPolicyWizPage3
extends WizPage {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2010.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ams/src/com/ibm/mq/explorer/ams/ui/internal/policies/NewPolicyWizPage3.java";
    private static final int HORIZONTAL_SPAN = 3;
    private static final int TEXT_WIDTH_HINT = 400;
    private Combo algorithmCombo;
    private Button keyReuseDisabled = null;
    private Button keyReuseUnlimited = null;
    private Button keyReuseCustom = null;
    private Spinner keyReuseCustomCount = null;
    private int keyReuseSelection;
    private Text keyReuseCustomCountLabel;
    public static final int KEYREUSE_DISABLED = 0;
    public static final int KEYREUSE_UNLIMITED = -1;
    private List distNamesList;
    private boolean firstTime = true;
    private Button addDN;
    private Button removeDN;
    private Text dnDescription;

    public NewPolicyWizPage3(String pageName) {
        super(pageName, "com.ibm.mq.explorer.ams.NewPolicyWizPage3");
        String titleText = Messages.NewPolicyWiz_TitleText;
        this.setTitle(titleText);
        String description = Messages.NewPolicyWiz_Page3_Description;
        this.setDescription(description);
    }

    public void nextPressed() {
    }

    public boolean performFinish() {
        return true;
    }

    public void checkIfEnableButtons() {
        boolean canProceed;
        NewPolicyWiz wizard = (NewPolicyWiz)this.getWizard();
        wizard.setEnableFinish(false);
        if (this.distNamesList.getSelectionCount() > 0) {
            this.removeDN.setEnabled(true);
        } else {
            this.removeDN.setEnabled(false);
        }
        if (this.getEncryptionAlgorithmSelection() == 0) {
            if (!this.firstTime) {
                this.setErrorMessage(Messages.NewPolicyWiz_Page3_NoAlgSelected);
            } else {
                this.firstTime = false;
            }
            canProceed = false;
        } else if (this.distNamesList.getItemCount() == 0) {
            if (!this.firstTime) {
                this.setErrorMessage(Messages.NewPolicyWiz_Page3_NoDNSpecified);
            } else {
                this.firstTime = false;
            }
            canProceed = false;
        } else {
            this.setErrorMessage(null);
            canProceed = true;
        }
        this.setPageComplete(canProceed);
        wizard.getContainer().updateButtons();
    }

    public void createPageContent(final Trace t, final Composite parent) {
        Layout layout = parent.getLayout();
        if (layout instanceof GridLayout) {
            ((GridLayout)layout).makeColumnsEqualWidth = false;
            ((GridLayout)layout).horizontalSpacing = 12;
        }
        Group encryptionGroup = new Group(parent, 0);
        encryptionGroup.setText(Messages.NewPolicyWiz_Page3_EncryptionGroupTitle);
        GridLayout gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 8;
        gridLayout.verticalSpacing = 8;
        gridLayout.marginWidth = 8;
        gridLayout.marginHeight = 8;
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.numColumns = 3;
        encryptionGroup.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        encryptionGroup.setLayoutData((Object)gridData);
        Text algorithmLabel = new Text((Composite)encryptionGroup, 4);
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)algorithmLabel, (boolean)true);
        algorithmLabel.setText(Messages.NewPolicyWiz_Page3_EncryptionAlgorithmLabel);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        algorithmLabel.setLayoutData((Object)gridData);
        this.algorithmCombo = new Combo((Composite)encryptionGroup, 12);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.algorithmCombo.setLayoutData((Object)gridData);
        this.algorithmCombo.add(Messages.DmEseMessageProtectionPolicy_Enc_Alg_NONE);
        this.algorithmCombo.add("RC2");
        this.algorithmCombo.add("DES");
        this.algorithmCombo.add("Triple DES");
        this.algorithmCombo.add("AES128");
        this.algorithmCombo.add("AES256");
        this.algorithmCombo.setText(Messages.DmEseMessageProtectionPolicy_Enc_Alg_NONE);
        this.algorithmCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NewPolicyWizPage3.this.checkIfEnableButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Composite buttonGroup = new Composite((Composite)encryptionGroup, 0);
        buttonGroup.setLayout((Layout)new GridLayout());
        gridData = new GridData();
        gridData.widthHint = 400;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 3;
        buttonGroup.setLayoutData((Object)gridData);
        this.keyReuseDisabled = new Button(buttonGroup, 16);
        this.keyReuseDisabled.setText(Messages.PolicyPropertyPage_KeyReuseDisabledLabel);
        this.keyReuseDisabled.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NewPolicyWizPage3.this.keyReuseSelection = 0;
                NewPolicyWizPage3.this.keyReuseCustomCount.setEnabled(false);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.keyReuseUnlimited = new Button(buttonGroup, 16);
        this.keyReuseUnlimited.setText(Messages.PolicyPropertyPage_KeyReuseUnlimitedLabel);
        this.keyReuseUnlimited.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NewPolicyWizPage3.this.keyReuseSelection = -1;
                NewPolicyWizPage3.this.keyReuseCustomCount.setEnabled(false);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.keyReuseCustom = new Button(buttonGroup, 16);
        this.keyReuseCustom.setText(Messages.PolicyPropertyPage_KeyReuseCustomLabel);
        this.keyReuseCustom.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NewPolicyWizPage3.this.keyReuseSelection = NewPolicyWizPage3.this.keyReuseCustomCount.getSelection();
                NewPolicyWizPage3.this.keyReuseCustomCount.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.keyReuseCustomCountLabel = new Text(buttonGroup, 4);
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)this.keyReuseCustomCountLabel, (boolean)true);
        this.keyReuseCustomCountLabel.setText(Messages.PolicyPropertyPage_KeyReuseCustomCountLabel);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        this.keyReuseCustomCountLabel.setLayoutData((Object)gridData);
        this.keyReuseCustomCount = new Spinner(buttonGroup, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.keyReuseCustomCount.setLayoutData((Object)gridData);
        this.keyReuseCustomCount.setMinimum(1);
        this.keyReuseCustomCount.setMaximum(9999999);
        UiUtils.limitSpinner((Trace)t, (Spinner)this.keyReuseCustomCount);
        this.keyReuseDisabled.setSelection(true);
        this.keyReuseCustomCount.setEnabled(false);
        UiUtils.createBlankLine((Composite)encryptionGroup, (int)3);
        this.dnDescription = new Text((Composite)encryptionGroup, 66);
        this.dnDescription.setText(Messages.NewPolicyWiz_Page3_ListDescription);
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)this.dnDescription, (boolean)true);
        gridData = new GridData();
        gridData.widthHint = 400;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 3;
        this.dnDescription.setLayoutData((Object)gridData);
        this.distNamesList = new List((Composite)encryptionGroup, 2818);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 3;
        gridData.heightHint = this.distNamesList.getItemHeight() * 5;
        this.distNamesList.setLayoutData((Object)gridData);
        this.distNamesList.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NewPolicyWizPage3.this.checkIfEnableButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.addDN = new Button((Composite)encryptionGroup, 8);
        this.addDN.setText(Messages.NewPolicyWiz_AddDNButton);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.addDN.setLayoutData((Object)gridData);
        this.addDN.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GetDistinguishedNameDialog addDNDlg = new GetDistinguishedNameDialog(parent.getShell(), 0);
                addDNDlg.setTitle(Messages.NewPolicyWiz_AddDNDlg_Title);
                addDNDlg.setInformationStrings(new String[]{Messages.NewPolicyWiz_AddEncDNDlg_Description});
                addDNDlg.create(t);
                boolean result = addDNDlg.open(t);
                if (result) {
                    NewPolicyWizPage3.this.distNamesList.add(addDNDlg.getObjectName());
                }
                NewPolicyWizPage3.this.checkIfEnableButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.removeDN = new Button((Composite)encryptionGroup, 8);
        this.removeDN.setText(Messages.NewPolicyWiz_RemoveDNButton);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.removeDN.setLayoutData((Object)gridData);
        this.removeDN.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int[] selected = NewPolicyWizPage3.this.distNamesList.getSelectionIndices();
                if (selected.length > 0) {
                    NewPolicyWizPage3.this.distNamesList.remove(selected);
                }
                NewPolicyWizPage3.this.checkIfEnableButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    public void createControl(Composite parent) {
        super.createControl(parent, 3);
    }

    public int getKeyReuseSelection() {
        int keyreuse = this.keyReuseSelection;
        switch (this.keyReuseSelection) {
            case 0: {
                keyreuse = 0;
                break;
            }
            case -1: {
                keyreuse = -1;
            }
        }
        return keyreuse;
    }

    public int getEncryptionAlgorithmSelection() {
        String selection = this.getEncryptionAlgorithmSelectionText();
        int algorithm = 0;
        if (selection.equals(Messages.DmEseMessageProtectionPolicy_Enc_Alg_NONE)) {
            algorithm = 0;
        } else if (selection.equals("RC2")) {
            algorithm = 1;
        } else if (selection.equals("DES")) {
            algorithm = 2;
        } else if (selection.equals("Triple DES")) {
            algorithm = 3;
        } else if (selection.equals("AES128")) {
            algorithm = 4;
        } else if (selection.equals("AES256")) {
            algorithm = 5;
        }
        return algorithm;
    }

    public String getEncryptionAlgorithmSelectionText() {
        return this.algorithmCombo.getText();
    }

    public String[] getRecipientDistinguishedNames() {
        if (this.getEncryptionAlgorithmSelection() == 0) {
            return new String[0];
        }
        return this.distNamesList.getItems();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        NewPolicyWizPage1 page1 = (NewPolicyWizPage1)this.getWizard().getPage(NewPolicyWiz.PAGE1);
        if (page1.getPolicySelection() == 2) {
            this.keyReuseDisabled.setEnabled(true);
            this.keyReuseUnlimited.setEnabled(true);
            this.keyReuseCustomCountLabel.setEnabled(true);
            this.keyReuseCustom.setEnabled(true);
            this.keyReuseCustomCount.setEnabled(false);
        } else {
            this.keyReuseDisabled.setSelection(true);
            this.keyReuseDisabled.setEnabled(true);
            this.keyReuseUnlimited.setEnabled(false);
            this.keyReuseUnlimited.setSelection(false);
            this.keyReuseCustomCountLabel.setEnabled(false);
            this.keyReuseCustom.setEnabled(false);
            this.keyReuseCustom.setSelection(false);
            this.keyReuseCustomCount.setSelection(1);
            this.keyReuseCustomCount.setEnabled(false);
        }
        if (this.algorithmCombo != null) {
            this.algorithmCombo.setFocus();
        }
    }
}

