/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ams.ui.internal.policies;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.ams.ui.internal.base.Messages;
import com.ibm.mq.explorer.ams.ui.internal.policies.GetDistinguishedNameDialog;
import com.ibm.mq.explorer.ams.ui.internal.policies.NewPolicyWiz;
import com.ibm.mq.explorer.ui.internal.controls.WizPage;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;

public class NewPolicyWizPage2
extends WizPage {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2010.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ams/src/com/ibm/mq/explorer/ams/ui/internal/policies/NewPolicyWizPage2.java";
    private static final int HORIZONTAL_SPAN = 3;
    private static final int TEXT_WIDTH_HINT = 400;
    private Combo algorithmCombo;
    private List distNamesList;
    private Button addDN;
    private Button removeDN;
    private Text dnDescription;
    private Button radioDNrestrict;
    private boolean firstTime = true;

    public NewPolicyWizPage2(String pageName) {
        super(pageName, "com.ibm.mq.explorer.ams.NewPolicyWizPage2");
        String titleText = Messages.NewPolicyWiz_TitleText;
        this.setTitle(titleText);
        String description = Messages.NewPolicyWiz_Page2_Description;
        this.setDescription(description);
    }

    public void nextPressed() {
    }

    public boolean performFinish() {
        return true;
    }

    public void checkIfEnableButtons() {
        boolean canProceed;
        this.toggleDNComponents();
        NewPolicyWiz wizard = (NewPolicyWiz)this.getWizard();
        wizard.setEnableFinish(false);
        if (this.getSignatureAlgorithmSelection() == 0) {
            if (!this.firstTime) {
                this.setErrorMessage(Messages.NewPolicyWiz_Page2_NoAlgSelected);
            } else {
                this.firstTime = false;
            }
            canProceed = false;
        } else if (this.radioDNrestrict.getSelection() && this.distNamesList.getItemCount() == 0) {
            if (!this.firstTime) {
                this.setErrorMessage(Messages.NewPolicyWiz_Page2_NoDNSpecified);
            } else {
                this.firstTime = false;
            }
            canProceed = false;
        } else {
            this.setErrorMessage(null);
            canProceed = true;
        }
        this.setPageComplete(canProceed);
        wizard.getContainer().updateButtons();
    }

    public void createPageContent(final Trace t, final Composite parent) {
        Layout layout = parent.getLayout();
        if (layout instanceof GridLayout) {
            ((GridLayout)layout).makeColumnsEqualWidth = false;
            ((GridLayout)layout).horizontalSpacing = 12;
        }
        Group signingGroup = new Group(parent, 0);
        signingGroup.setText(Messages.NewPolicyWiz_Page2_SigningGroupTitle);
        GridLayout gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 8;
        gridLayout.verticalSpacing = 8;
        gridLayout.marginWidth = 8;
        gridLayout.marginHeight = 8;
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.numColumns = 3;
        signingGroup.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        signingGroup.setLayoutData((Object)gridData);
        Text algorithmLabel = new Text((Composite)signingGroup, 4);
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)algorithmLabel, (boolean)true);
        algorithmLabel.setText(Messages.NewPolicyWiz_Page2_SignatureAlgorithmLabel);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        algorithmLabel.setLayoutData((Object)gridData);
        this.algorithmCombo = new Combo((Composite)signingGroup, 12);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.algorithmCombo.setLayoutData((Object)gridData);
        this.algorithmCombo.add(Messages.DmEseMessageProtectionPolicy_Sign_Alg_NONE);
        this.algorithmCombo.add("MD5");
        this.algorithmCombo.add("SHA1");
        this.algorithmCombo.add("SHA256");
        this.algorithmCombo.add("SHA384");
        this.algorithmCombo.add("SHA512");
        this.algorithmCombo.setText(Messages.DmEseMessageProtectionPolicy_Sign_Alg_NONE);
        this.algorithmCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NewPolicyWizPage2.this.checkIfEnableButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        UiUtils.createBlankLine((Composite)signingGroup, (int)3);
        Composite signingButtonGroup = new Composite((Composite)signingGroup, 0);
        signingButtonGroup.setLayout((Layout)new GridLayout());
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        signingButtonGroup.setLayoutData((Object)gridData);
        Button radioAnySigned = new Button(signingButtonGroup, 16);
        radioAnySigned.setText(Messages.NewPolicyWiz_Page2_AcceptAnySigned);
        radioAnySigned.setSelection(true);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 3;
        radioAnySigned.setLayoutData((Object)gridData);
        radioAnySigned.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NewPolicyWizPage2.this.checkIfEnableButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.radioDNrestrict = new Button(signingButtonGroup, 16);
        this.radioDNrestrict.setText(Messages.NewPolicyWiz_Page2_OnlyAcceptFromList);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 3;
        this.radioDNrestrict.setLayoutData((Object)gridData);
        this.radioDNrestrict.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NewPolicyWizPage2.this.checkIfEnableButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        UiUtils.createBlankLine((Composite)signingGroup, (int)3);
        this.dnDescription = new Text((Composite)signingGroup, 66);
        this.dnDescription.setText(Messages.NewPolicyWiz_Page2_ListDescription);
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)this.dnDescription, (boolean)true);
        gridData = new GridData();
        gridData.widthHint = 400;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 3;
        this.dnDescription.setLayoutData((Object)gridData);
        this.distNamesList = new List((Composite)signingGroup, 2818);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 3;
        gridData.heightHint = this.distNamesList.getItemHeight() * 5;
        this.distNamesList.setLayoutData((Object)gridData);
        this.distNamesList.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NewPolicyWizPage2.this.checkIfEnableButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.addDN = new Button((Composite)signingGroup, 8);
        this.addDN.setText(Messages.NewPolicyWiz_AddDNButton);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.addDN.setLayoutData((Object)gridData);
        this.removeDN = new Button((Composite)signingGroup, 8);
        this.removeDN.setText(Messages.NewPolicyWiz_RemoveDNButton);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.removeDN.setLayoutData((Object)gridData);
        this.removeDN.setEnabled(false);
        this.addDN.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GetDistinguishedNameDialog addDNDlg = new GetDistinguishedNameDialog(parent.getShell(), 0);
                addDNDlg.setTitle(Messages.NewPolicyWiz_AddDNDlg_Title);
                addDNDlg.setInformationStrings(new String[]{Messages.NewPolicyWiz_AddSigDNDlg_Description});
                addDNDlg.create(t);
                boolean result = addDNDlg.open(t);
                if (result) {
                    NewPolicyWizPage2.this.distNamesList.add(addDNDlg.getObjectName());
                }
                NewPolicyWizPage2.this.checkIfEnableButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.removeDN.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int[] selected = NewPolicyWizPage2.this.distNamesList.getSelectionIndices();
                if (selected.length > 0) {
                    NewPolicyWizPage2.this.distNamesList.remove(selected);
                }
                NewPolicyWizPage2.this.checkIfEnableButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.toggleDNComponents();
    }

    public void createControl(Composite parent) {
        super.createControl(parent, 3);
    }

    public int getSignatureAlgorithmSelection() {
        String selection = this.getSignatureAlgorithmSelectionText();
        int algorithm = 0;
        if (selection.equals(Messages.DmEseMessageProtectionPolicy_Sign_Alg_NONE)) {
            algorithm = 0;
        } else if (selection.equals("MD5")) {
            algorithm = 1;
        } else if (selection.equals("SHA1")) {
            algorithm = 2;
        } else if (selection.equals("SHA256")) {
            algorithm = 4;
        } else if (selection.equals("SHA384")) {
            algorithm = 5;
        } else if (selection.equals("SHA512")) {
            algorithm = 6;
        }
        return algorithm;
    }

    public String getSignatureAlgorithmSelectionText() {
        return this.algorithmCombo.getText();
    }

    public String[] getSignatureDistinguishedNames() {
        if (!this.radioDNrestrict.getSelection()) {
            return new String[0];
        }
        return this.distNamesList.getItems();
    }

    private void toggleDNComponents() {
        boolean enable = this.radioDNrestrict.getSelection();
        this.addDN.setEnabled(enable);
        this.distNamesList.setEnabled(enable);
        this.dnDescription.setEnabled(enable);
        this.removeDN.setEnabled(enable && this.distNamesList.getSelectionCount() > 0);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.algorithmCombo != null) {
            this.algorithmCombo.setFocus();
        }
    }
}

