/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ams.ui.internal.policies;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.ams.core.internal.base.PCF;
import com.ibm.mq.explorer.ams.core.internal.objects.DmAmsMessageProtectionPolicy;
import com.ibm.mq.explorer.ams.ui.internal.base.Messages;
import com.ibm.mq.explorer.ams.ui.internal.policies.NewPolicyWizPage1;
import com.ibm.mq.explorer.ams.ui.internal.policies.NewPolicyWizPage2;
import com.ibm.mq.explorer.ams.ui.internal.policies.NewPolicyWizPage3;
import com.ibm.mq.explorer.ams.ui.internal.policies.NewPolicyWizPage4;
import com.ibm.mq.explorer.ams.ui.internal.policies.PoliciesTreeNode;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.ui.extensions.MQQmgrExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class NewPolicyWiz
extends Wizard
implements IRunnableWithProgress {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ams/src/com/ibm/mq/explorer/ams/ui/internal/policies/NewPolicyWiz.java";
    private Message coreMsgFile;
    private NewPolicyWizPage1 page1;
    private NewPolicyWizPage2 page2;
    private NewPolicyWizPage3 page3;
    private NewPolicyWizPage4 page4;
    public static String PAGE1 = "Page1";
    public static String PAGE2 = "Page2";
    public static String PAGE3 = "Page3";
    public static String PAGE4 = "Page4";
    private MQQmgrExtObject queueManager = null;
    private boolean enableFinish = false;

    public NewPolicyWiz() {
        Trace t = Trace.getDefault();
        this.coreMsgFile = UiPlugin.getUIMessages((Trace)t, (String)"KEY_NewObject");
        String title = Messages.NewPolicyWiz_WindowTitle;
        this.setWindowTitle(title);
        this.page1 = new NewPolicyWizPage1(PAGE1);
        this.page2 = new NewPolicyWizPage2(PAGE2);
        this.page3 = new NewPolicyWizPage3(PAGE3);
        this.page4 = new NewPolicyWizPage4(PAGE4);
        this.addPage((IWizardPage)this.page1);
        this.addPage((IWizardPage)this.page2);
        this.addPage((IWizardPage)this.page3);
        this.addPage((IWizardPage)this.page4);
        this.setHelpAvailable(false);
    }

    public boolean canFinish() {
        return this.enableFinish;
    }

    public void setEnableFinish(boolean enableFinishValue) {
        this.enableFinish = enableFinishValue;
    }

    public boolean performFinish() {
        Trace t = Trace.getDefault();
        try {
            this.getContainer().run(false, false, (IRunnableWithProgress)this);
        }
        catch (Exception e) {
            e.printStackTrace();
            t.FFST(66, "NewPolicyWiz.performFinish", 10, 2195, 0, 0, e.getClass().getName(), e.getMessage(), null);
        }
        return true;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage nextPage = super.getNextPage(page);
        if (page instanceof NewPolicyWizPage1) {
            if (this.page1.getPolicySelection() == 2) {
                nextPage = nextPage.getNextPage();
            }
        } else if (page instanceof NewPolicyWizPage2 && this.page1.getPolicySelection() == 0) {
            nextPage = nextPage.getNextPage();
        }
        return nextPage;
    }

    public void setQueueManagerSelection(IStructuredSelection selection) {
        TreeNode qmNode;
        Object o = selection.getFirstElement();
        if (o instanceof PoliciesTreeNode && (o = (qmNode = ((PoliciesTreeNode)((Object)o)).getRealParent()).getObject()) instanceof MQQmgrExtObject) {
            MQQmgrExtObject qmgr;
            this.queueManager = qmgr = (MQQmgrExtObject)o;
        }
    }

    public MQQmgrExtObject getQueueManagerSelection() {
        return this.queueManager;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        final Trace t = Trace.getDefault();
        int units = 30;
        monitor.beginTask(Messages.NewPolicyWiz_FinishOperationName, units);
        monitor.worked(10);
        int rc = this.createObject_perform(t);
        monitor.worked(20);
        if (rc != 0) {
            int compcode;
            String message;
            switch (rc) {
                case 3328: {
                    String key = "AMQ4048";
                    String text = CommonServices.getSystemMessage((Trace)t, (String)key);
                    StringBuffer sb = new StringBuffer();
                    sb.append(rc);
                    sb.append(":");
                    sb.append(PCF.lookupReasonCode(rc));
                    message = Message.format((String)text, (String)sb.toString());
                    compcode = 2;
                    break;
                }
                case 3007: {
                    String key = CommonServices.getSystemMessageId((Trace)t, (int)rc);
                    String text = CommonServices.getSystemMessage((Trace)t, (String)key);
                    String pcf = "MQCMD_CREATE_POLICY";
                    message = Message.format((String)text, (String)pcf, (String)this.queueManager.getName());
                    compcode = 2;
                    break;
                }
                case 2085: {
                    String key = "AMQ4561";
                    String text = CommonServices.getSystemMessage((Trace)t, (String)key);
                    String pcf2 = "MQCMD_CREATE_POLICY";
                    message = Message.format((String)text, (String)pcf2, (String)this.queueManager.getName());
                    compcode = 2;
                    break;
                }
                case 2055: {
                    String key = "AMQ4638";
                    String text = CommonServices.getSystemMessage((Trace)t, (String)key);
                    String pcf3 = "MQCMD_CREATE_POLICY";
                    message = Message.format((String)text, (String)pcf3, (String)this.queueManager.getName());
                    compcode = 1;
                    break;
                }
                default: {
                    String key = "AMQ4999";
                    String text = CommonServices.getSystemMessage((Trace)t, (String)key);
                    Integer errorCode = rc;
                    String error = PCF.lookupReasonCode(rc);
                    error = error != null ? String.valueOf(errorCode.toString()) + " : " + error : errorCode.toString();
                    message = Message.format((String)text, (String)error);
                    compcode = 2;
                }
            }
            if (message != null) {
                IWorkbench workbench = PlatformUI.getWorkbench();
                if (workbench == null) {
                    return;
                }
                Display display = workbench.getDisplay();
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        int imgType = 1;
                        switch (compcode) {
                            case 0: {
                                imgType = 2;
                                break;
                            }
                            case 1: {
                                imgType = 4;
                                break;
                            }
                            case 2: {
                                imgType = 1;
                            }
                        }
                        String[] buttons = new String[]{NewPolicyWiz.this.coreMsgFile.getMessage(t, "UI.GENERAL.CLOSE")};
                        MessageBox.showMessage((Trace)t, (Shell)NewPolicyWiz.this.getShell(), (String)message, (int)imgType, (String[])buttons, (int)0, null);
                    }
                });
            }
        }
        monitor.done();
    }

    private int createObject_perform(Trace t) {
        String selectedQueueName = this.page1.getSelectedQueueName();
        DmAmsMessageProtectionPolicy dmObject = new DmAmsMessageProtectionPolicy(t);
        UiQueueManager uiQueueManager = (UiQueueManager)this.queueManager.getInternalObject();
        DmQueueManager dmQueueManager = uiQueueManager.getDmQueueManagerObject();
        dmObject.setQueueManager(dmQueueManager);
        Object job = dmObject.beginUpdate(t);
        dmObject.setAttributeValue(t, job, 2112, 0, selectedQueueName);
        dmObject.setAttributeValue(t, job, 238, 0, 1);
        if (this.page1.getPolicySelection() == 0 || this.page1.getPolicySelection() == 1) {
            dmObject.setAttributeValue(t, job, 236, 0, this.page2.getSignatureAlgorithmSelection());
        }
        String[] signatureDNs = this.page2.getSignatureDistinguishedNames();
        int repeatIndex = 0;
        String[] stringArray = signatureDNs;
        int n = signatureDNs.length;
        int n2 = 0;
        while (n2 < n) {
            String distinguishedName = stringArray[n2];
            dmObject.setAttributeValue(t, job, 2113, repeatIndex++, distinguishedName);
            ++n2;
        }
        if (this.page1.getPolicySelection() == 1 || this.page1.getPolicySelection() == 2) {
            dmObject.setAttributeValue(t, job, 237, 0, this.page3.getEncryptionAlgorithmSelection());
            if (this.page1.getPolicySelection() == 2) {
                dmObject.setAttributeValue(t, job, 267, 0, this.page3.getKeyReuseSelection());
            }
            String[] RecipientDNs = this.page3.getRecipientDistinguishedNames();
            repeatIndex = 0;
            String[] stringArray2 = RecipientDNs;
            int n3 = RecipientDNs.length;
            n = 0;
            while (n < n3) {
                String distinguishedName = stringArray2[n];
                dmObject.setAttributeValue(t, job, 2114, repeatIndex++, distinguishedName);
                ++n;
            }
        } else {
            dmObject.setAttributeValue(t, job, 237, 0, 0);
        }
        int toleration = this.page1.getTolerationSelection() == 0 ? 0 : 1;
        dmObject.setAttributeValue(t, job, 235, 0, toleration);
        int rc = dmObject.actionCreate(t, null, job);
        dmObject.endUpdate(t, job);
        return rc;
    }
}

