/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ams.ui.internal.base;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.ams.core.internal.base.AmsDataModel;
import com.ibm.mq.explorer.ams.core.internal.objects.DmAmsMessageProtectionPolicy;
import com.ibm.mq.explorer.ams.ui.internal.base.AmsObjectAttributeDetails;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.ui.internal.apiexits.ApiExit;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrderManager;
import com.ibm.mq.explorer.ui.internal.attributeorder.IAttributeDetails;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.objects.RepeatingValueObject;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import java.util.ArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class AmsPlugin
extends AbstractUIPlugin {
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ams/src/com/ibm/mq/explorer/ams/ui/internal/base/AmsPlugin.java";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String PLUGIN_ID = "com.ibm.mq.explorer.ams";
    private static AmsPlugin plugin;
    private static boolean pluginEnabled;
    private static boolean explorerInitialised;
    private static AmsDataModel dataModel;
    public static ScheduledExecutorService capabilityExecutor;
    public static long scheduledDelay;

    static {
        capabilityExecutor = Executors.newSingleThreadScheduledExecutor();
        scheduledDelay = 50L;
    }

    public AmsPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    static boolean isEnabled() {
        return pluginEnabled;
    }

    static void enable() {
        Trace t = Trace.getDefault();
        pluginEnabled = true;
        if (explorerInitialised) {
            AmsPlugin.initialise(t);
        }
    }

    static void initialise(Trace t) {
        explorerInitialised = true;
        if (pluginEnabled) {
            dataModel = new AmsDataModel(t);
            String genericObjectName = "ams.generic.object.name";
            AttributeOrderManager attributeOrderManager = UiPlugin.getAttributeOrderManager();
            int[] allAttributes = DmAmsMessageProtectionPolicy.getAllAttributesByType(t);
            String[] attributeNames = new String[allAttributes.length];
            AmsObjectAttributeDetails attributeDetails = new AmsObjectAttributeDetails();
            int[] columnSequence = DmAmsMessageProtectionPolicy.getDisplayColumnSequence(t, allAttributes, false);
            int i = 0;
            while (i < allAttributes.length) {
                attributeNames[i] = DmAmsMessageProtectionPolicy.getAttributeTitle(t, allAttributes[i]);
                ++i;
            }
            attributeOrderManager.register(t, (IAttributeDetails)attributeDetails, "com.ibm.mq.explorer.ams.EseMessageProtectionPolicy", genericObjectName, "com.ibm.mq.explorer.ams.EseMessageProtectionPolicy", allAttributes, attributeNames, columnSequence);
        }
    }

    static void disable(Trace t) {
        pluginEnabled = false;
        explorerInitialised = true;
    }

    public static AmsPlugin getDefault() {
        return plugin;
    }

    public static AmsDataModel getDatamodel() {
        return dataModel;
    }

    public static boolean isAmsEnabled(UiMQObject parent, Trace t, DmQueueManager dmQmgr) {
        Boolean amsCapable = AmsPlugin.isAmsCapable(t, dmQmgr);
        if (amsCapable != null) {
            return amsCapable;
        }
        return AmsPlugin.isAmsApiExitLoaded(parent, t, dmQmgr);
    }

    public static Boolean isAmsCapable(Trace t, DmQueueManager dmQmgr) {
        Attr at = dmQmgr.getAttribute(t, 251, 0);
        if (at != null) {
            Integer value = (Integer)at.getValue(t);
            if (value == null) {
                return null;
            }
            if (value == 1) {
                return true;
            }
            return false;
        }
        return null;
    }

    public static boolean isAmsApiExitLoaded(UiMQObject parent, Trace t, DmQueueManager dmQmgr) {
        UiQueueManager uqm = new UiQueueManager(t, (IDmObject)dmQmgr, parent);
        ArrayList apiExits = uqm.getApiExitsArray(t);
        for (RepeatingValueObject rvo : apiExits) {
            ApiExit exit;
            if (!(rvo instanceof ApiExit) || !(exit = (ApiExit)rvo).getName(t).equals("mqs") && !exit.getName(t).equals("mqams")) continue;
            return true;
        }
        return false;
    }
}

