/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ams.ui.internal.base;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.ams.core.internal.events.DmAmsObjectEvent;
import com.ibm.mq.explorer.ams.core.internal.events.DmAmsObjectListener;
import com.ibm.mq.explorer.ams.core.internal.events.DmAmsObjectView;
import com.ibm.mq.explorer.ams.core.internal.objects.DmAmsObject;
import com.ibm.mq.explorer.ams.ui.internal.base.AmsPlugin;
import com.ibm.mq.explorer.ams.ui.internal.base.Messages;
import com.ibm.mq.explorer.ams.ui.internal.policies.UiPolicy;
import com.ibm.mq.explorer.ams.ui.internal.policies.UiPolicyFactory;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.ui.extensions.ContentPage;
import com.ibm.mq.explorer.ui.extensions.ContentTitleBar;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTable;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTableUpdate;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class AmsContentPage
extends ContentPage
implements DmAmsObjectListener {
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ams/src/com/ibm/mq/explorer/ams/ui/internal/base/AmsContentPage.java";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    protected ExplorerTable explorerTable;
    protected Label explorerTableLabel;
    protected ContentTitleBar titleBar;
    private MQExtObject externalObject;
    private DmAmsObjectView view;
    private ArrayList<MQExtObject> amsExtObjects;

    public AmsContentPage(Trace t, Composite parent) {
        super(parent, 0);
    }

    public void init() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.setLayout((Layout)gridLayout);
        this.titleBar = new ContentTitleBar((Composite)this, 0);
        GridData gridData = new GridData(768);
        this.titleBar.setLayoutData((Object)gridData);
    }

    protected abstract void addExplorerTable(Trace var1);

    public abstract String getId();

    public void setObject(MQExtObject object) {
        Trace t = Trace.getDefault();
        DmQueueManager dmQmgr = null;
        UiMQObject uiMQObject = (UiMQObject)object.getInternalObject();
        if (uiMQObject instanceof UiQueueManager) {
            dmQmgr = ((UiQueueManager)uiMQObject).getDmQueueManagerObject();
        }
        if (this.externalObject != object) {
            this.externalObject = object;
            String InstanceId = dmQmgr.getDmTitle();
            this.explorerTable.setInstance(t, InstanceId, false);
        }
    }

    public void setActive(boolean isActive) {
        Trace t = Trace.getDefault();
        if (isActive) {
            this.explorerTable.beginUpdate(t);
            this.explorerTable.removeAll(t);
            this.explorerTable.endUpdate(t);
            DmQueueManager dmQmgr = null;
            UiMQObject uiMQObject = (UiMQObject)this.externalObject.getInternalObject();
            if (uiMQObject instanceof UiQueueManager) {
                dmQmgr = ((UiQueueManager)uiMQObject).getDmQueueManagerObject();
                if (dmQmgr.isLocal() && !AmsPlugin.isAmsEnabled((UiMQObject)this.externalObject.getInternalObject(), t, dmQmgr)) {
                    this.warnNoInterceptor(t);
                }
                this.view = new DmAmsObjectView(t, dmQmgr, this);
            }
        } else if (this.view != null) {
            this.view.removeListener(t);
            this.view = null;
        }
    }

    private void warnNoInterceptor(Trace t) {
        Message coreMsgFile = UiPlugin.getUIMessages((Trace)t, (String)"KEY_NewObject");
        String[] buttons = new String[]{coreMsgFile.getMessage(t, "UI.GENERAL.CLOSE")};
        MessageBox.showMessage((Trace)t, (Shell)this.getShell(), (String)Messages.AmsContentPane_NoInterceptor, (int)4, (String[])buttons, (int)0, null);
    }

    public MQExtObject getObject() {
        return this.externalObject;
    }

    public void updatePage() {
    }

    public void refresh() {
        this.setActive(false);
        this.setActive(true);
    }

    public void repaint() {
        this.explorerTable.repaint();
    }

    public boolean isEnableRefreshAction() {
        return true;
    }

    public boolean isEnableSystemObjectsAction() {
        return false;
    }

    public void showSystemObjects(boolean show) {
    }

    public void instanceDeleted(Object object) {
    }

    protected void beginUpdate(Trace t) {
        this.explorerTable.queueUpdate(t, new ExplorerTableUpdate(t, 4), true, true);
    }

    private void endUpdate(Trace t) {
        this.explorerTable.queueUpdate(t, new ExplorerTableUpdate(t, 5), true, true);
    }

    @Override
    public void dmObjectAdded(DmAmsObjectEvent event) {
        Trace t = Trace.getDefault();
        DmAmsObject object = (DmAmsObject)event.getSource();
        UiMQObject uiMQObject = (UiMQObject)this.externalObject.getInternalObject();
        UiPolicy uiPolicy = UiPolicyFactory.create(t, object, uiMQObject);
        this.beginUpdate(t);
        this.explorerTable.queueUpdate(t, new ExplorerTableUpdate(t, 1, (Object)uiPolicy), false, true);
        this.endUpdate(t);
    }

    @Override
    public void dmObjectChanged(DmAmsObjectEvent event) {
        DmAmsObject object;
        Trace t = Trace.getDefault();
        UiPolicy uiPolicy = this.getItemInTable(t, object = (DmAmsObject)event.getSource());
        if (uiPolicy != null) {
            this.beginUpdate(t);
            this.explorerTable.queueUpdate(t, new ExplorerTableUpdate(t, 2, (Object)uiPolicy), false, true);
            this.endUpdate(t);
        }
    }

    @Override
    public void dmObjectDeleted(DmAmsObjectEvent event) {
        DmAmsObject object;
        Trace t = Trace.getDefault();
        UiPolicy uiPolicy = this.getItemInTable(t, object = (DmAmsObject)event.getSource());
        if (uiPolicy != null) {
            this.beginUpdate(t);
            this.explorerTable.queueUpdate(t, new ExplorerTableUpdate(t, 3, (Object)uiPolicy), false, true);
            this.endUpdate(t);
        }
    }

    @Override
    public void dmRefreshComplete(DmAmsObjectEvent event) {
    }

    private UiPolicy getItemInTable(final Trace t, DmAmsObject dmAmsObject) {
        UiPlugin.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                AmsContentPage.this.amsExtObjects = AmsContentPage.this.explorerTable.getObjects(t);
            }
        });
        UiPolicy uiPolicy = null;
        Iterator<MQExtObject> iter = this.amsExtObjects.iterator();
        while (iter.hasNext() && uiPolicy == null) {
            MQExtObject extObject = iter.next();
            UiPolicy uiObject = (UiPolicy)((Object)extObject.getInternalObject());
            DmAmsObject currentObject = (DmAmsObject)uiObject.getDmObject();
            if (!currentObject.equals(dmAmsObject)) continue;
            uiPolicy = uiObject;
        }
        return uiPolicy;
    }
}

