/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ams.core.internal.objects;

import com.ibm.mq.MQException;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.ams.core.internal.base.PCF;
import com.ibm.mq.explorer.ams.core.internal.objects.DmAmsObject;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.event.DmActionEvent;
import com.ibm.mq.explorer.core.internal.event.DmActionListener;
import com.ibm.mq.explorer.core.internal.report.ReportManager;
import com.ibm.mq.pcf.PCFMessage;
import com.ibm.mq.pcf.PCFParameter;
import com.ibm.mq.pcf.event.PCFQuery;

public class PCFAction
extends Thread {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ams/src/com/ibm/mq/explorer/ams/core/internal/objects/PCFAction.java";
    private DmAmsObject dmObject = null;
    private PCFMessage request = null;
    private int command = 0;
    private DmActionListener listener = null;
    private int reasonCode = 0;
    private int completionCode = 0;
    private DmCoreException dmCoreException = null;
    public static final String SEPARATOR = "@";

    public PCFAction(Trace t, int cmd, DmAmsObject dmo) {
        this.dmObject = dmo;
        this.command = cmd;
        this.request = new PCFMessage(cmd);
    }

    @Override
    public void run() {
        Trace t = Trace.getDefault();
        this.reasonCode = this.execute(t);
        if (this.reasonCode == 0) {
            this.listener.dmActionDone(new DmActionEvent((Object)this.dmObject, this.command, this.reasonCode));
        } else {
            String msgId = this.reasonCode == 2055 ? "AMQ4638" : "AMQ4048";
            String text = CommonServices.getSystemMessage((Trace)t, (String)msgId);
            StringBuffer sb = new StringBuffer();
            sb.append(this.reasonCode);
            sb.append(":");
            sb.append(PCF.lookupReasonCode(this.reasonCode));
            String msg = Message.format((String)text, (String)sb.toString());
            int severity = CommonServices.getSystemMessageSeverity((Trace)t, (String)msgId);
            this.completionCode = this.reasonCode == 2055 ? 1 : 2;
            this.dmCoreException = new DmCoreException(t, msg, msgId, this.reasonCode, this.completionCode, severity);
            this.listener.dmActionDone(new DmActionEvent((Object)this.dmObject, this.command, this.reasonCode, this.dmCoreException));
        }
    }

    protected void addParameter(Trace t, PCFParameter parameter) {
        this.request.addParameter(parameter);
    }

    protected int execute(Trace t, DmActionListener aListener) {
        return this.execute(t, aListener, 4);
    }

    protected int execute(Trace t, DmActionListener _Listener, int _action) {
        int rc = 0;
        if (_Listener == null) {
            rc = this.execute(t);
        } else {
            this.listener = _Listener;
            this.start();
        }
        return rc;
    }

    protected int execute(Trace t) {
        int rc = 2149;
        ReportManager.getDefault().add(t, this.dmObject.getQueueManager().getTitle(), this.request);
        try {
            PCFMessage[] responses = this.dmObject.getQueueManager().sendCommand(t, this.request);
            if (responses != null) {
                PCFMessage message = responses[0];
                rc = message.getReason();
            }
        }
        catch (MQException mqe) {
            rc = mqe.reasonCode;
            PCFQuery.traceMQRequest((Trace)t, (PCFMessage)this.request);
            PCFQuery.traceMQException((Trace)t, (MQException)mqe);
        }
        return rc;
    }

    public PCFMessage getRequest(Trace t) {
        return this.request;
    }
}

