/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ams.core.internal.objects;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.ams.core.internal.objects.PCFAction;
import com.ibm.mq.explorer.core.internal.attrs.AbstractAttrTypeNumber;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrBoolean;
import com.ibm.mq.explorer.core.internal.attrs.AttrByteArray;
import com.ibm.mq.explorer.core.internal.attrs.AttrInt;
import com.ibm.mq.explorer.core.internal.attrs.AttrIntArray;
import com.ibm.mq.explorer.core.internal.attrs.AttrIntArrayEnum;
import com.ibm.mq.explorer.core.internal.attrs.AttrIntArrayEnumRange;
import com.ibm.mq.explorer.core.internal.attrs.AttrKey;
import com.ibm.mq.explorer.core.internal.attrs.AttrLong;
import com.ibm.mq.explorer.core.internal.attrs.AttrString;
import com.ibm.mq.explorer.core.internal.attrs.AttrStringArray;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeBitEnum;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeBoolean;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeByteArray;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeDateTime;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeEnum;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeEnumRange;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeFixedLengthString;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeFixedLengthStringEnum;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeFixedLengthStringEnumRange;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeFixedLengthStringListItem;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeFixedLengthWMQNameListItem;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeIPAddress;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeInt;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeIntArray;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeIntArrayEnum;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeIntArrayEnumRange;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeLong;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeLongEnum;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeLongEnumRange;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeObject;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeRange;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeString;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeStringArray;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeURL;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeUnsignedInt;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeWMQName;
import com.ibm.mq.explorer.core.internal.attrs.AttrURL;
import com.ibm.mq.explorer.core.internal.event.DmActionListener;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.core.internal.objects.TableFactory;
import com.ibm.mq.pcf.PCFConstants;
import com.ibm.mq.pcf.PCFMessage;
import com.ibm.mq.pcf.PCFParameter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Observable;
import java.util.Set;
import org.osgi.framework.Bundle;

public abstract class DmAmsObject
extends Observable
implements IDmObject {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ams/src/com/ibm/mq/explorer/ams/core/internal/objects/DmAmsObject.java";
    public static final String NOT_FOUND = "[not_found]";
    public static final String NOT_DEFINED = "[not_defined]";
    public static final int TYPE_MESSAGE_PROTECTION_POLICY = 2002;
    private static final int SHIFT_BITS = 32;
    private int objectType;
    private Hashtable<AttrKey, Attr> attributes;
    private DmQueueManager dmQueueManger;
    protected HashMap<Integer, AttrType> attributesByType;

    public DmAmsObject(Trace t, int aObjectType) {
        this.objectType = aObjectType;
        this.attributes = new Hashtable();
    }

    public Attr getAttributeInternal(Trace t, int id, int index) {
        return this.attributes.get(new AttrKey(id, index));
    }

    public Attr getAttribute(Trace t, int id, int index) {
        return this.getAttributeInternal(t, id, index);
    }

    public String getAttributeValue(Trace t, int id, int index) {
        String retValue = NOT_FOUND;
        Attr a = this.getAttributeInternal(t, id, index);
        if (a != null) {
            retValue = a.toString(t);
        }
        return retValue;
    }

    protected static AttrType getAttributeType(Trace t, HashMap<Integer, AttrType> hm, int id) {
        if (hm == null) {
            if (Trace.isTracing) {
                t.data(66, "DmAmsObject.getAttributeType", 900, "<All> table for attribute id " + id + " has not been created");
            }
            return null;
        }
        AttrType at = hm.get(id);
        if (at == null) {
            if (Trace.isTracing) {
                t.data(66, "DmAmsObject.getAttributeType", 900, "No attribute type in table for attribute id " + id);
            }
            return null;
        }
        return at;
    }

    public int getRepeatingIndexes(Trace t, int id) {
        Attr a;
        int index = 1;
        while ((a = this.attributes.get(new AttrKey(id, index))) != null) {
            ++index;
        }
        return index;
    }

    public int[] getAllAttributes(Trace t) {
        int[] ids = this.getKnownAttributes(t);
        return ids;
    }

    private int[] getKnownAttributes(Trace t) {
        int count = 0;
        Set<AttrKey> k = this.attributes.keySet();
        for (AttrKey ak : k) {
            if (ak.getRepeatingIndex() != 0) continue;
            ++count;
        }
        int[] ids = new int[count];
        int index = 0;
        k = this.attributes.keySet();
        for (AttrKey ak : k) {
            if (ak.getRepeatingIndex() != 0) continue;
            ids[index] = ak.getAttributeID();
            ++index;
        }
        return ids;
    }

    public DmQueueManager getQueueManager() {
        return this.dmQueueManger;
    }

    public void setQueueManager(DmQueueManager dmQueueManager) {
        this.dmQueueManger = dmQueueManager;
    }

    protected static int[] getAllAttributesByType(Trace t, HashMap<Integer, AttrType> hm) {
        if (hm == null) {
            String message = "objectType not initialised";
            t.FFST(66, "DmAmsObject.getAllAttributesByType", 2, 0, message);
            return new int[0];
        }
        int[] ids = new int[hm.size()];
        int index = 0;
        Set<Integer> k = hm.keySet();
        Iterator<Integer> i = k.iterator();
        while (i.hasNext()) {
            ids[index] = i.next();
            ++index;
        }
        return ids;
    }

    public void debug(Trace t) {
        Set<AttrKey> k = this.attributes.keySet();
        for (AttrKey ak : k) {
            Attr a = this.attributes.get(ak);
            a.debug(t);
        }
    }

    public boolean setAttributeValue(Trace t, Object job, int id, int index, Object value) {
        boolean result = true;
        AttrKey key = new AttrKey(id, index);
        Attr a = this.attributes.get(key);
        if (a == null) {
            this.createAttribute(t, job, id, index, value);
        } else {
            a.setNewValue(t, value);
        }
        if (job != null) {
            ArrayList list = (ArrayList)job;
            list.add(key);
        }
        return result;
    }

    public boolean replaceAttributeValue(Trace t, int id, int index, Object value) {
        boolean result = true;
        AttrKey key = new AttrKey(id, index);
        Attr a = this.attributes.get(key);
        if (a == null) {
            result = false;
        } else {
            a.setNewValue(t, value);
        }
        return result;
    }

    public Attr createAttribute(Trace t, Object job, int id, int repeatIndex, Object value) {
        AttrString attr = null;
        AttrKey key = new AttrKey(id, repeatIndex);
        AttrType aType = this.attributesByType.get(id);
        if (aType == null) {
            String message = "Attribute type " + id + " has not been initialised for " + this.getClass().toString();
            t.FFST(66, "DmAmsObject.createAttribute", 2, 0, message);
            return null;
        }
        int type = aType.getAttributeType();
        switch (type) {
            case 1: {
                attr = new AttrInt(t, id, repeatIndex, ((Integer)value).intValue(), (AbstractAttrTypeNumber)((AttrTypeInt)aType), (IDmObject)this);
                break;
            }
            case 2: {
                attr = new AttrString(t, id, repeatIndex, (String)value, (AttrTypeString)aType, (IDmObject)this);
                break;
            }
            case 6: {
                attr = new AttrString(t, id, repeatIndex, (String)value, (AttrTypeString)((AttrTypeFixedLengthString)aType), (IDmObject)this);
                break;
            }
            case 4: {
                attr = new AttrInt(t, id, repeatIndex, ((Integer)value).intValue(), (AbstractAttrTypeNumber)((AttrTypeRange)aType), (IDmObject)this);
                break;
            }
            case 29: {
                attr = new AttrLong(t, id, repeatIndex, ((Long)value).longValue(), (AbstractAttrTypeNumber)((AttrTypeLong)aType), (IDmObject)this);
                break;
            }
            case 3: {
                attr = new AttrInt(t, id, repeatIndex, ((Integer)value).intValue(), (AbstractAttrTypeNumber)((AttrTypeEnum)aType), (IDmObject)this);
                break;
            }
            case 5: {
                attr = new AttrString(t, id, repeatIndex, ((String)value).trim(), (AttrTypeString)((AttrTypeIPAddress)aType), (IDmObject)this);
                break;
            }
            case 7: {
                attr = new AttrString(t, id, repeatIndex, ((String)value).trim(), (AttrTypeString)((AttrTypeWMQName)aType), (IDmObject)this);
                break;
            }
            case 9: {
                attr = new AttrString(t, id, repeatIndex, (String)value, (AttrTypeString)((AttrTypeFixedLengthStringEnum)aType), (IDmObject)this);
                break;
            }
            case 11: {
                attr = new AttrInt(t, id, repeatIndex, ((Integer)value).intValue(), (AbstractAttrTypeNumber)((AttrTypeEnumRange)aType), (IDmObject)this);
                break;
            }
            case 12: {
                attr = new AttrLong(t, id, repeatIndex, ((Long)value).longValue(), (AbstractAttrTypeNumber)((AttrTypeLong)aType), (IDmObject)this);
                break;
            }
            case 10: {
                long l = ((Integer)value).intValue();
                l <<= 32;
                attr = new AttrLong(t, id, repeatIndex, l >>= 32, (AbstractAttrTypeNumber)((AttrTypeUnsignedInt)aType), (IDmObject)this);
                break;
            }
            case 13: {
                attr = new AttrString(t, id, repeatIndex, (String)value, (AttrTypeString)((AttrTypeFixedLengthStringEnumRange)aType), (IDmObject)this);
                break;
            }
            case 14: {
                attr = new AttrIntArray(t, id, repeatIndex, (int[])value, (AttrTypeIntArray)aType, (IDmObject)this);
                break;
            }
            case 18: {
                attr = new AttrIntArrayEnum(t, id, repeatIndex, (int[])value, (AttrTypeIntArrayEnum)aType, (IDmObject)this);
                break;
            }
            case 22: {
                attr = new AttrIntArrayEnumRange(t, id, repeatIndex, (int[])value, (AttrTypeIntArrayEnumRange)aType, (IDmObject)this);
                break;
            }
            case 15: {
                attr = new AttrStringArray(t, id, repeatIndex, (String[])value, (AttrTypeStringArray)aType, (IDmObject)this);
                break;
            }
            case 8: {
                attr = new AttrStringArray(t, id, repeatIndex, (String[])value, (AttrTypeStringArray)((AttrTypeFixedLengthStringListItem)aType), (IDmObject)this);
                break;
            }
            case 21: {
                attr = new AttrStringArray(t, id, repeatIndex, (String[])value, (AttrTypeStringArray)((AttrTypeFixedLengthWMQNameListItem)aType), (IDmObject)this);
                break;
            }
            case 16: {
                attr = new AttrByteArray(t, id, repeatIndex, (byte[])value, (AttrTypeByteArray)aType, (IDmObject)this);
                break;
            }
            case 19: {
                attr = new AttrByteArray(t, id, repeatIndex, (byte[])value, (AttrTypeByteArray)aType, (IDmObject)this);
                break;
            }
            case 20: {
                attr = new AttrInt(t, id, repeatIndex, ((Integer)value).intValue(), (AbstractAttrTypeNumber)((AttrTypeBitEnum)aType), (IDmObject)this);
                break;
            }
            case 23: {
                attr = new AttrString(t, id, repeatIndex, ((String)value).trim(), (AttrTypeString)((AttrTypeDateTime)aType), (IDmObject)this);
                break;
            }
            case 24: {
                attr = new AttrURL(t, id, repeatIndex, (URL)value, (AttrTypeURL)aType, (IDmObject)this);
                break;
            }
            case 25: {
                attr = new AttrBoolean(t, id, repeatIndex, ((Boolean)value).booleanValue(), (AttrTypeBoolean)aType, (IDmObject)this);
                break;
            }
            case 26: {
                attr = new AttrString(t, id, repeatIndex, (String)value, (AttrTypeString)((AttrTypeObject)aType), (IDmObject)this);
                break;
            }
            case 27: {
                attr = new AttrLong(t, id, repeatIndex, ((Long)value).longValue(), (AbstractAttrTypeNumber)((AttrTypeLongEnum)aType), (IDmObject)this);
                break;
            }
            case 28: {
                attr = new AttrLong(t, id, repeatIndex, ((Long)value).longValue(), (AbstractAttrTypeNumber)((AttrTypeLongEnumRange)aType), (IDmObject)this);
                break;
            }
            default: {
                if (Trace.isTracing) {
                    t.data(66, "DmAmsObject.createAttribute", 900, "Error - unknown attribute type (" + aType.getAttributeType() + ")");
                }
                t.FFST(66, "DmAmsObject.createAttribute", 0, 0, "Missing AttrType in switch statement");
            }
        }
        this.attributes.put(key, (Attr)attr);
        return attr;
    }

    public boolean deleteAttribute(Trace t, Object job, int id, int index) {
        AttrKey key = new AttrKey(id, index);
        Attr oldAttr = this.attributes.remove(key);
        return oldAttr != null;
    }

    public Object beginUpdate(Trace t) {
        ArrayList job = new ArrayList();
        return job;
    }

    public void endUpdate(Trace t, Object job) {
    }

    public boolean isSystemObject(Trace t) {
        return false;
    }

    public boolean isSystemDefault(Trace t) {
        return false;
    }

    public boolean isEnumerationIdValid(Trace t, int attrId, int enumId) {
        return true;
    }

    public boolean isFilteringSupported(Trace t) {
        return false;
    }

    public int getObjectType(Trace t) {
        return this.objectType;
    }

    public int getObjectSubType(Trace t) {
        return 0;
    }

    public int[] getObjectSubTypes(Trace t) {
        return null;
    }

    public int getStatusType(Trace t) {
        return 0;
    }

    public String getParentName(Trace t) {
        return NOT_DEFINED;
    }

    public void initialize(Trace t) {
    }

    public int actionCreate(Trace t, DmActionListener listener, Object job) {
        int rc = 0;
        PCFAction cmd = new PCFAction(t, 206, this);
        ArrayList list = (ArrayList)job;
        for (Object key : list) {
            Attr a = this.attributes.get(key);
            int pcfConstant = a.getAttributeID();
            Object value = a.getValue(t);
            if (value instanceof String) {
                cmd.getRequest(t).addParameter(pcfConstant, (String)value);
                continue;
            }
            if (!(value instanceof Integer)) continue;
            int i = (Integer)value;
            cmd.getRequest(t).addParameter(pcfConstant, i);
        }
        this.endUpdate(t, job);
        rc = cmd.execute(t, listener);
        return rc;
    }

    public int actionChange(Trace t, DmActionListener listener, Object job, boolean force) {
        int rc = 0;
        PCFAction cmd = new PCFAction(t, 208, this);
        cmd.getRequest(t).addParameter(2112, this.getTitle());
        cmd.getRequest(t).addParameter(238, 1);
        ArrayList list = (ArrayList)job;
        for (Object key : list) {
            Attr a = this.attributes.get(key);
            int pcfConstant = a.getAttributeID();
            Object value = a.getNewValue(t);
            if (value == null) {
                value = a.getValue(t);
            }
            if (value instanceof String) {
                cmd.getRequest(t).addParameter(pcfConstant, (String)value);
                continue;
            }
            if (!(value instanceof Integer)) continue;
            int i = (Integer)value;
            cmd.getRequest(t).addParameter(pcfConstant, i);
        }
        this.endUpdate(t, job);
        rc = cmd.execute(t, listener);
        return rc;
    }

    public int actionDelete(Trace t, DmActionListener listener, Object parms) {
        int rc = 0;
        PCFAction cmd = new PCFAction(t, 207, this);
        cmd.getRequest(t).addParameter(2112, this.getTitle());
        cmd.getRequest(t).addParameter(238, 1);
        rc = cmd.execute(t, listener, 2);
        return rc;
    }

    protected static String getClassName(String className) {
        if (className.lastIndexOf(46) > 0) {
            return className.substring(className.lastIndexOf(46) + 1);
        }
        return className;
    }

    protected static HashMap<Integer, AttrType> initAllAttrTypeTable(Trace t, String name, HashMap<Integer, AttrType> hm, Bundle bund) {
        if (hm != null) {
            if (Trace.isTracing) {
                t.data(66, "DmAmsObject.initAllAttrTypeTable", 300, "allAttributesByType table already initialized");
            }
            return hm;
        }
        hm = TableFactory.getHashMap((Trace)t, (String)name, (Bundle)bund);
        if (hm == null) {
            if (Trace.isTracing) {
                t.data(66, "DmAmsObject.initAllAttrTypeTable", 900, "Error loading allAttributesByType table for " + name);
            }
            return null;
        }
        return hm;
    }

    protected static String getAttributeTitle(Trace t, HashMap<Integer, AttrType> hm, int id) {
        if (hm == null) {
            if (Trace.isTracing) {
                t.data(66, "DmAmsObject.getAttributeTitle", 900, "<All> table for attribute id " + id + " has not been created");
            }
            return null;
        }
        AttrType at = hm.get(id);
        if (at == null) {
            if (Trace.isTracing) {
                t.data(66, "DmAmsObject.getAttributeTitle", 900, "No attribute type in table for attribute id " + id);
            }
            return null;
        }
        String s = at.getDisplayTitle();
        return s;
    }

    protected static int[] getDisplayColumnSequence(Trace t, HashMap<Integer, AttrType> hm, int[] ids, boolean zOS) {
        int[] retValue = new int[ids.length];
        if (hm == null) {
            if (Trace.isTracing) {
                t.data(66, "DmAmsObject.getDisplayColumnSequence", 900, "<All> table has not been created");
            }
            return null;
        }
        int i = 0;
        while (i < ids.length) {
            AttrType at = hm.get(ids[i]);
            if (at == null) {
                retValue[i] = -1;
                if (Trace.isTracing) {
                    t.data(66, "DmAmsObject.getDisplayColumnSequence", 900, "No attribute type in table for attribute id " + ids[i]);
                }
            } else {
                retValue[i] = zOS ? at.getZosDisplayColumnSequence() : at.getDisplayColumnSequence();
            }
            ++i;
        }
        return retValue;
    }

    protected static boolean isAttributeRepeating(Trace t, HashMap<Integer, AttrType> hm, int id) {
        if (hm == null) {
            if (Trace.isTracing) {
                t.data(66, "DmAmsObject.isAttributeRepeating", 900, "<All> table for attribute id " + id + " has not been created");
            }
            return false;
        }
        AttrType at = hm.get(id);
        if (at == null) {
            if (Trace.isTracing) {
                t.data(66, "DmAmsObject.isAttributeRepeating", 900, "No attribute type in table for attribute id " + id);
            }
            return false;
        }
        boolean repeating = at.isRepeating();
        return repeating;
    }

    @Override
    public void setChanged() {
        super.setChanged();
    }

    public boolean equals(Object object) {
        boolean result = false;
        if (object != null && object instanceof DmAmsObject && this.getTitle().equals(((DmAmsObject)object).getTitle())) {
            result = true;
        }
        return result;
    }

    public void initializeWithDefaults(Trace t) {
    }

    public static String getTypeName(Trace t, int objectType) {
        switch (objectType) {
            case 2002: {
                return "DmAmsMessageProtectionPolicy";
            }
        }
        if (Trace.isTracing) {
            t.data(65, "DmAmsObject.getTypeName", 900, "Unknown object type : " + objectType);
        }
        return NOT_FOUND;
    }

    protected String getUniqueObjectName(Object object) {
        String uniqueName = String.valueOf(object.getClass().getName()) + "@" + System.identityHashCode(object);
        return uniqueName;
    }

    public static synchronized IDmObject getDmObject(Trace t, ArrayList<IDmObject> al, String name) {
        DmAmsObject retValue = null;
        boolean found = false;
        int index = 0;
        index = 0;
        while (index < al.size()) {
            block5: {
                try {
                    retValue = (DmAmsObject)al.get(index);
                    if (name.equals(retValue.getTitle())) {
                        found = true;
                        break;
                    }
                }
                catch (ClassCastException cce) {
                    if (!Trace.isTracing) break block5;
                    t.data(65, "DmAmsObject.getDmObject", 1000, "Error getting Dm object : " + cce.getMessage());
                }
            }
            ++index;
        }
        if (!found) {
            retValue = null;
        }
        return retValue;
    }

    public synchronized void addAttrFromPCFResponse(Trace t, PCFMessage pcfMessage) {
        int signRepeatIndex = 0;
        int recipRepeatIndex = 0;
        this.attributes.clear();
        Enumeration e = pcfMessage.getParameters();
        while (e.hasMoreElements()) {
            PCFParameter p = (PCFParameter)e.nextElement();
            if (p.getParameter() == 2113) {
                this.addAttr(t, this.attributesByType, p, signRepeatIndex++);
                continue;
            }
            if (p.getParameter() == 2114) {
                this.addAttr(t, this.attributesByType, p, recipRepeatIndex++);
                continue;
            }
            this.addAttr(t, this.attributesByType, p, 0);
        }
    }

    protected void addAttr(Trace t, HashMap<Integer, AttrType> typeTable, PCFParameter p, int repeatIndex) {
        block8: {
            Object value = "";
            int id = p.getParameter();
            switch (p.getType()) {
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 9: {
                    value = p.getValue();
                    if (!Trace.isTracing) break;
                    t.data(65, "DmAmsObject.addAttr", 300, "PCF attribute " + p.getParameter() + ", PCF type " + p.getType());
                    break;
                }
                case 23: {
                    Long longValue = (Long)p.getValue();
                    int intValue = longValue.intValue();
                    value = intValue;
                    if (!Trace.isTracing) break;
                    t.data(65, "DmAmsObject.addAttr", 300, "PCF attribute " + p.getParameter() + ", PCF type " + p.getType());
                    break;
                }
                default: {
                    if (Trace.isTracing) {
                        t.data(65, "DmAmsObject.addAttr", 900, "Unsupported PCF type : " + p.getType());
                    }
                    return;
                }
            }
            try {
                this.addAttr(t, typeTable, id, repeatIndex, value);
            }
            catch (ClassCastException cce) {
                String idName = PCFConstants.lookupParameter((int)id);
                if (idName == null) {
                    idName = "unknown";
                }
                if (!Trace.isTracing) break block8;
                t.data(65, "DmAmsObject.addAttr", 900, "ClassCastException for attribute id " + id + ".0 (" + cce.getMessage() + ")");
            }
        }
    }

    protected boolean addAttr(Trace t, HashMap<Integer, AttrType> typeTable, int id, int repeatIndex, Object value) {
        return this.addAttr(t, this.attributes, typeTable, id, repeatIndex, value);
    }

    private boolean addAttr(Trace t, Hashtable<AttrKey, Attr> attrsTable, HashMap<Integer, AttrType> typeTable, int id, int repeatIndex, Object value) {
        return this.addAttr(t, attrsTable, typeTable, id, repeatIndex, value, false);
    }

    private boolean addAttr(Trace t, Hashtable<AttrKey, Attr> attrsTable, HashMap<Integer, AttrType> typeTable, int id, int repeatIndex, Object value, boolean defaultValue) {
        if (typeTable == null) {
            if (Trace.isTracing) {
                t.data(65, "DmAmsObject.addAttr", 900, "Attribute type table not initialized");
            }
            return false;
        }
        boolean trimString = true;
        Integer attrID = id;
        Object oldValue = null;
        AttrType aType = typeTable.get(attrID);
        if (aType == null) {
            String idName = PCFConstants.lookupParameter((int)id);
            if (idName == null) {
                idName = "unknown";
            }
            if (Trace.isTracing) {
                t.data(65, "DmAmsObject.addAttr", 900, "Attribute id " + id + "(" + idName + ") not found in object type (" + this.objectType + ") table");
            }
            return false;
        }
        int type = aType.getAttributeType();
        if (Trace.isTracing) {
            t.data(65, "DmAmsObject.addAttr", 300, "Attribute id " + id + ", attribute type " + type);
        }
        if (value == null) {
            if (Trace.isTracing) {
                t.data(65, "DmAmsObject.addAttr", 900, "Null value given for attribute id " + id + " in type (" + this.objectType + ") table");
            }
            return false;
        }
        AttrKey attrKey = new AttrKey(id, repeatIndex);
        AttrIntArray attr = null;
        if ((type == 15 || type == 8 || type == 21) && value instanceof String) {
            if (Trace.isTracing) {
                t.data(65, "DmAmsObject.addAttr", 300, "Resetting String to String []");
            }
            value = ((String)value).startsWith(" ") ? new String[]{} : new String[]{(String)value};
        }
        if (aType instanceof AttrTypeString) {
            trimString = ((AttrTypeString)aType).isTrimmed();
        }
        switch (type) {
            case 1: {
                attr = new AttrInt(t, id, repeatIndex, ((Integer)value).intValue(), (AbstractAttrTypeNumber)((AttrTypeInt)aType), (IDmObject)this);
                break;
            }
            case 2: {
                if (trimString) {
                    attr = new AttrString(t, id, repeatIndex, ((String)value).trim(), (AttrTypeString)aType, (IDmObject)this);
                    break;
                }
                attr = new AttrString(t, id, repeatIndex, (String)value, (AttrTypeString)aType, (IDmObject)this);
                break;
            }
            case 6: {
                if (trimString) {
                    attr = new AttrString(t, id, repeatIndex, ((String)value).trim(), (AttrTypeString)((AttrTypeFixedLengthString)aType), (IDmObject)this);
                    break;
                }
                attr = new AttrString(t, id, repeatIndex, (String)value, (AttrTypeString)((AttrTypeFixedLengthString)aType), (IDmObject)this);
                break;
            }
            case 4: {
                attr = new AttrInt(t, id, repeatIndex, ((Integer)value).intValue(), (AbstractAttrTypeNumber)((AttrTypeRange)aType), (IDmObject)this);
                break;
            }
            case 29: {
                attr = new AttrLong(t, id, repeatIndex, ((Long)value).longValue(), (AbstractAttrTypeNumber)((AttrTypeLong)aType), (IDmObject)this);
                break;
            }
            case 3: {
                attr = new AttrInt(t, id, repeatIndex, ((Integer)value).intValue(), (AbstractAttrTypeNumber)((AttrTypeEnum)aType), (IDmObject)this);
                break;
            }
            case 5: {
                if (trimString) {
                    attr = new AttrString(t, id, repeatIndex, ((String)value).trim(), (AttrTypeString)((AttrTypeIPAddress)aType), (IDmObject)this);
                    break;
                }
                attr = new AttrString(t, id, repeatIndex, (String)value, (AttrTypeString)((AttrTypeIPAddress)aType), (IDmObject)this);
                break;
            }
            case 7: {
                if (trimString) {
                    attr = new AttrString(t, id, repeatIndex, ((String)value).trim(), (AttrTypeString)((AttrTypeWMQName)aType), (IDmObject)this);
                    break;
                }
                attr = new AttrString(t, id, repeatIndex, (String)value, (AttrTypeString)((AttrTypeWMQName)aType), (IDmObject)this);
                break;
            }
            case 9: {
                attr = new AttrString(t, id, repeatIndex, ((String)value).trim(), (AttrTypeString)((AttrTypeFixedLengthStringEnum)aType), (IDmObject)this);
                break;
            }
            case 11: {
                attr = new AttrInt(t, id, repeatIndex, ((Integer)value).intValue(), (AbstractAttrTypeNumber)((AttrTypeEnumRange)aType), (IDmObject)this);
                break;
            }
            case 12: {
                attr = new AttrLong(t, id, repeatIndex, Long.parseLong(((String)value).trim()), (AbstractAttrTypeNumber)((AttrTypeLong)aType), (IDmObject)this);
                break;
            }
            case 10: {
                long l = (long)((Integer)value).intValue() & 0xFFFFFFFFL;
                attr = new AttrLong(t, id, repeatIndex, l, (AbstractAttrTypeNumber)((AttrTypeUnsignedInt)aType), (IDmObject)this);
                break;
            }
            case 13: {
                if (trimString) {
                    attr = new AttrString(t, id, repeatIndex, ((String)value).trim(), (AttrTypeString)((AttrTypeFixedLengthStringEnumRange)aType), (IDmObject)this);
                    break;
                }
                attr = new AttrString(t, id, repeatIndex, (String)value, (AttrTypeString)((AttrTypeFixedLengthStringEnumRange)aType), (IDmObject)this);
                break;
            }
            case 14: {
                attr = new AttrIntArray(t, id, repeatIndex, (int[])value, (AttrTypeIntArray)aType, (IDmObject)this);
                break;
            }
            case 18: {
                attr = new AttrIntArrayEnum(t, id, repeatIndex, (int[])value, (AttrTypeIntArrayEnum)aType, (IDmObject)this);
                break;
            }
            case 22: {
                attr = new AttrIntArrayEnumRange(t, id, repeatIndex, (int[])value, (AttrTypeIntArrayEnumRange)aType, (IDmObject)this);
                break;
            }
            case 15: {
                attr = new AttrStringArray(t, id, repeatIndex, value, (AttrTypeStringArray)aType, (IDmObject)this);
                break;
            }
            case 8: {
                attr = new AttrStringArray(t, id, repeatIndex, value, (AttrTypeStringArray)((AttrTypeFixedLengthStringListItem)aType), (IDmObject)this);
                break;
            }
            case 21: {
                attr = new AttrStringArray(t, id, repeatIndex, value, (AttrTypeStringArray)((AttrTypeFixedLengthWMQNameListItem)aType), (IDmObject)this);
                break;
            }
            case 16: {
                attr = new AttrByteArray(t, id, repeatIndex, (byte[])value, (AttrTypeByteArray)aType, (IDmObject)this);
                break;
            }
            case 19: {
                attr = new AttrByteArray(t, id, repeatIndex, (byte[])value, (AttrTypeByteArray)aType, (IDmObject)this);
                break;
            }
            case 20: {
                attr = new AttrInt(t, id, repeatIndex, ((Integer)value).intValue(), (AbstractAttrTypeNumber)((AttrTypeBitEnum)aType), (IDmObject)this);
                break;
            }
            case 23: {
                if (trimString) {
                    attr = new AttrString(t, id, repeatIndex, ((String)value).trim(), (AttrTypeString)((AttrTypeDateTime)aType), (IDmObject)this);
                    break;
                }
                attr = new AttrString(t, id, repeatIndex, (String)value, (AttrTypeString)((AttrTypeDateTime)aType), (IDmObject)this);
                break;
            }
            case 25: {
                attr = new AttrBoolean(t, id, repeatIndex, ((Boolean)value).booleanValue(), (AttrTypeBoolean)aType, (IDmObject)this);
                break;
            }
            case 26: {
                if (trimString) {
                    attr = new AttrString(t, id, repeatIndex, ((String)value).trim(), (AttrTypeString)((AttrTypeObject)aType), (IDmObject)this);
                    break;
                }
                attr = new AttrString(t, id, repeatIndex, (String)value, (AttrTypeString)((AttrTypeObject)aType), (IDmObject)this);
                break;
            }
            default: {
                if (!Trace.isTracing) break;
                t.data(65, "DmAmsObject.addAttr", 900, "Error - unknown attribute type (" + aType.getAttributeType() + ")");
            }
        }
        if (attr != null) {
            oldValue = attrsTable.put(attrKey, (Attr)attr);
            if (defaultValue) {
                attr.setDefaultValueUsed(t, true);
            }
        }
        if (Trace.isTracing && oldValue != null && !((Attr)oldValue).toString(t).equals(value)) {
            t.data(65, "DmAmsObject.addAttr", 300, "Updating attribute " + id + "." + repeatIndex + " with value = " + value);
        }
        return true;
    }

    public int getAttributeDifferenceCount(Trace t, IDmObject dmObject2) {
        int countChanged = 0;
        int[] attrIds1 = this.getAllAttributes(t);
        int i = 0;
        while (i < attrIds1.length) {
            Attr attr1 = null;
            Attr attr2 = null;
            String attrValue1 = null;
            String attrValue2 = null;
            boolean attrPresent1 = true;
            boolean attrPresent2 = true;
            boolean repeating = false;
            int index = 0;
            do {
                attr1 = this.getAttribute(t, attrIds1[i], index);
                attr2 = dmObject2.getAttribute(t, attrIds1[i], index);
                attrPresent1 = true;
                attrPresent2 = true;
                if (attr1 != null) {
                    attrValue1 = attr1.toString(t);
                } else {
                    attrPresent1 = false;
                }
                if (attr2 != null) {
                    attrValue2 = attr2.toString(t);
                } else {
                    attrPresent2 = false;
                }
                if (index == 0) {
                    repeating = attr1.getAttrType().isRepeating();
                }
                ++index;
                if (attrPresent1 == attrPresent2 && (!attrPresent1 || !attrPresent2 || attrValue1 == null || attrValue2 == null || attrValue1.compareTo(attrValue2) == 0)) continue;
                ++countChanged;
                break;
            } while (repeating && attrPresent1 && attrPresent2);
            ++i;
        }
        return countChanged;
    }
}

