/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ams.core.internal.events;

import com.ibm.mq.MQException;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.ams.core.internal.events.DmAmsCommonObjectView;
import com.ibm.mq.explorer.ams.core.internal.events.DmAmsObjectEvent;
import com.ibm.mq.explorer.ams.core.internal.events.DmAmsObjectListener;
import com.ibm.mq.explorer.ams.core.internal.objects.DmAmsObject;
import com.ibm.mq.explorer.ams.core.internal.objects.DmAmsObjectFactory;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.core.internal.trace.GenerateFFST;
import com.ibm.mq.explorer.core.internal.utils.CoreServices;
import com.ibm.mq.pcf.MQCFST;
import com.ibm.mq.pcf.PCFMessage;
import com.ibm.mq.pcf.PCFParameter;
import com.ibm.mq.pcf.event.ErrorListener;
import com.ibm.mq.pcf.event.PCFEvent;
import com.ibm.mq.pcf.event.PCFListener;
import com.ibm.mq.pcf.event.PCFQuery;
import com.ibm.mq.pcf.event.PCFQueryTemplate;
import com.ibm.mq.pcf.event.PCFSummaryEvent;
import java.util.ArrayList;

public class DmAmsObjectView
extends DmAmsCommonObjectView
implements PCFListener,
ErrorListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ams/src/com/ibm/mq/explorer/ams/core/internal/events/DmAmsObjectView.java";
    private DmAmsObjectListener objectListener = null;
    private boolean active = false;
    private PCFQuery pcfQuery = null;

    public DmAmsObjectView(Trace t, DmQueueManager qMgr, DmAmsObjectListener listener) {
        super(t, qMgr);
        this.objectListener = listener;
        if (this.addListener(t)) {
            this.refresh(t, false);
        }
    }

    private boolean addListener(Trace t) {
        boolean added;
        block2: {
            added = false;
            try {
                this.active = true;
                t.eventListenerAdded("DmAmsObjectView.addListener", 1, t.formatEventListenerData(t, (Object)this, (Object)this.objectListener, DmAmsObject.getTypeName(t, 2002)));
                this.getQueueManager(t).getPcfMonitorAgent(t).addErrorListener(t, (ErrorListener)this);
                PCFParameter[] pcfParameter = new PCFParameter[]{new MQCFST(2112, "*")};
                PCFQueryTemplate template = new PCFQueryTemplate(205, pcfParameter, 2085);
                template.setKeyAttrs(new int[]{2112});
                template.setResponseNameId(2112);
                this.pcfQuery = new PCFQuery(template);
                this.getQueueManager(t).getPcfMonitorAgent(t).addPCFListener(t, (PCFListener)this, this.pcfQuery);
                added = true;
                this.report(t, this.pcfQuery);
            }
            catch (DmCoreException dmCoreException) {
                if (!Trace.isTracing) break block2;
                t.data(65, "DmAmsObjectView.addListener", 900, "Error adding listener - PCFMonitorAgent not defined");
            }
        }
        return added;
    }

    public void removeListener(Trace t) {
        this.active = false;
        t.eventListenerRemoved("DmAmsObjectView.removeListener", 1, t.formatEventListenerData(t, (Object)this, (Object)this.objectListener, DmAmsObject.getTypeName(t, 2002)));
        this.removePCFListener(t);
    }

    public void handleEvent(PCFEvent event) {
        Trace t = Trace.getDefault();
        ArrayList<IDmObject> list = this.getListOfObjects(t);
        DmQueueManager qMgrObject = this.getQueueManager(t);
        DmAmsObject object = null;
        String title = qMgrObject.getTitle();
        if (event.getObjectName() == null) {
            t.eventReceived("DmAmsObjectView.handleEvent", 1, t.formatEventListenerData(t, (Object)this, (Object)this.objectListener, DmAmsObjectEvent.getNotifyName(t, event.getType()), String.valueOf(qMgrObject.getTitle()) + "(" + event.getCommand() + ")", Boolean.toString(event.isLast())));
        } else {
            t.eventReceived("DmAmsObjectView.handleEvent", 1, t.formatEventListenerData(t, (Object)this, (Object)this.objectListener, DmAmsObjectEvent.getNotifyName(t, event.getType()), String.valueOf(event.getObjectName().trim()) + "(" + event.getCommand() + ")", Boolean.toString(event.isLast())));
        }
        if (Trace.isTracing) {
            t.data(65, "DmAmsObjectView.handleEvent", 300, "Event type " + DmAmsObjectEvent.getNotifyName(t, event.getType()) + ", for " + event.getObjectName());
        }
        if (!this.getQueueManager(t).isConnected() || this.getQueueManager(t).isDisconnecting()) {
            if (Trace.isTracing) {
                t.data(65, "DmAmsObjectView.handleEvent", 300, "Event ignored - queue manager " + this.getQueueManager(t).getTreeName(t) + " disconnected");
            }
            return;
        }
        int objectType = this.getDmObjectType(t);
        int eventObjectType = event.getCommand();
        if (Trace.isTracing) {
            t.data(65, "DmAmsObjectView.handleEvent", 300, "Event object type " + eventObjectType + " (original type " + objectType + ")");
        }
        if (!(event instanceof PCFSummaryEvent)) {
            PCFMessage pcfMessage = event.getPCFMessage();
            title = event.getObjectName();
            if (title == null) {
                if (Trace.isTracing) {
                    t.data(65, "DmAmsObjectView.handleEvent", 300, "Ignored event type : " + event.getType() + ", name is null");
                }
                return;
            }
            title = title.trim();
            if (eventObjectType != 2) {
                if (Trace.isTracing) {
                    t.data(65, "DmAmsObjectView.handleEvent", 300, "Looking for object with title = " + title);
                }
                object = (DmAmsObject)DmAmsObject.getDmObject(t, list, title);
            }
            switch (event.getType()) {
                case 1: {
                    if (object == null) {
                        this.addDmObject(t, pcfMessage, object, title, objectType, list, event.isLast());
                        break;
                    }
                    this.changeDmObject(t, pcfMessage, object, title, objectType, event.isLast());
                    break;
                }
                case 4: {
                    if (object != null) {
                        this.changeDmObject(t, pcfMessage, object, title, objectType, event.isLast());
                        break;
                    }
                    this.addDmObject(t, pcfMessage, object, title, objectType, list, event.isLast());
                    break;
                }
                case 2: {
                    this.deleteDmObject(t, object, objectType, list, event.isLast());
                    break;
                }
                default: {
                    if (!Trace.isTracing) break;
                    t.data(65, "DmAmsObjectView.handleEvent", 900, "Unknown event type : " + event.getType() + ", for : " + event.getObjectName());
                }
            }
        }
    }

    public synchronized void notifyDmObjectListener(Trace t, DmAmsObject source, int notifyType, boolean last) {
        this.notifyDmObjectListener(t, source, notifyType, last, null);
    }

    public synchronized void notifyDmObjectListener(Trace t, DmAmsObject source, int notifyType, boolean last, DmCoreException ex) {
        block15: {
            block14: {
                if (!this.getQueueManager(t).isConnected() || !this.active || CoreServices.isClosing((Trace)t)) break block14;
                int dmType = source.getObjectType(t);
                String title = source.getTitle();
                String listenerName = this.objectListener.toString();
                t.eventListenerNotified("DmAmsObjectView.notifyDmObjectListener", 1, t.formatEventListenerData(t, (Object)this, (Object)this.objectListener, DmAmsObjectEvent.getNotifyName(t, notifyType), String.valueOf(source.getTitle().trim()) + "(" + dmType + ")", Boolean.toString(last)));
                switch (notifyType) {
                    case 1: {
                        if (Trace.isTracing) {
                            t.data(65, "DmAmsObjectView.notifyDmObjectListener", 300, "Notifying " + listenerName + " for new object : " + title);
                        }
                        this.objectListener.dmObjectAdded(new DmAmsObjectEvent(source, dmType, last, this, ex, 1));
                        break;
                    }
                    case 4: {
                        if (this.getQueueManager(t).isConnected()) {
                            if (Trace.isTracing) {
                                t.data(65, "DmAmsObjectView.notifyDmObjectListener", 300, "Notifying " + listenerName + " for changes to object : " + title);
                            }
                            this.objectListener.dmObjectChanged(new DmAmsObjectEvent(source, dmType, last, this, ex, 4));
                            break;
                        }
                        if (Trace.isTracing) {
                            t.data(65, "DmAmsObjectView.notifyDmObjectListener", 300, "Change notification ignored - queue manager " + this.getQueueManager(t).getTitle() + " not connected");
                            break;
                        }
                        break block15;
                    }
                    case 2: {
                        if (Trace.isTracing) {
                            t.data(65, "DmAmsObjectView.notifyDmObjectListener", 300, "Notifying " + listenerName + " for deleted object : " + title);
                        }
                        this.objectListener.dmObjectDeleted(new DmAmsObjectEvent(source, dmType, last, this, ex, 2));
                        break;
                    }
                    case 104: {
                        if (Trace.isTracing) {
                            t.data(65, "DmAmsObjectView.notifyDmObjectListener", 300, "Notifying " + listenerName + " for refresh object : " + title);
                        }
                        this.objectListener.dmRefreshComplete(new DmAmsObjectEvent(source, dmType, last, this, ex, 104));
                        break;
                    }
                    default: {
                        if (Trace.isTracing) {
                            t.data(65, "DmAmsObjectView.notifyDmObjectListener", 900, "Unknown notify type : " + notifyType);
                            break;
                        }
                        break block15;
                    }
                }
                break block15;
            }
            if (Trace.isTracing) {
                t.data(65, "DmAmsObjectView.notifyDmObjectListener", 300, "Event ignored - listener was not notified");
            }
        }
    }

    private void addDmObject(Trace t, PCFMessage pcfMessage, DmAmsObject object, String title, int objectType, ArrayList<IDmObject> list, boolean last) {
        boolean notified = false;
        if (object == null) {
            DmAmsObject newObject = DmAmsObjectFactory.create(t, this.getQueueManager(t), objectType, title);
            if (newObject != null) {
                list.add(newObject);
                newObject.addAttrFromPCFResponse(t, pcfMessage);
                newObject.initialize(t);
                if (!notified && (this.getStatusQuery(t) == null || this.getStatusQuery(t) != null && objectType != this.getDmStatusObjectType(t))) {
                    this.notifyDmObjectListener(t, newObject, 1, last);
                }
            }
        } else if (objectType != 2) {
            if (Trace.isTracing) {
                t.data(65, "DmAmsObjectView.addDmObject", 900, "Object " + title + " already known");
            }
        } else if (Trace.isTracing) {
            t.data(65, "DmAmsObjectView.addDmObject", 300, "Add notification ignored - queue manager " + title);
        }
    }

    private void changeDmObject(Trace t, PCFMessage pcfMessage, DmAmsObject object, String title, int objectType, boolean last) {
        boolean notified = false;
        if (object != null) {
            object.addAttrFromPCFResponse(t, pcfMessage);
            object.initialize(t);
            if (!notified && (this.getStatusQuery(t) == null || this.getStatusQuery(t) != null && objectType != this.getDmStatusObjectType(t))) {
                this.notifyDmObjectListener(t, object, 4, last);
            }
        } else if (Trace.isTracing) {
            t.data(65, "DmAmsObjectView.changeDmObject", 900, "Object not known " + title);
        }
    }

    private void deleteDmObject(Trace t, DmAmsObject object, int objectType, ArrayList<IDmObject> list, boolean last) {
        boolean notified = false;
        if (object != null) {
            if (!notified && (this.getStatusQuery(t) == null || this.getStatusQuery(t) != null && objectType != this.getDmStatusObjectType(t))) {
                this.notifyDmObjectListener(t, object, 2, last);
            }
            list.remove(object);
        }
    }

    private void removePCFListener(Trace t) {
        block3: {
            try {
                this.getQueueManager(t).getPcfMonitorAgent(t).removeListener(t, (PCFListener)this, this.pcfQuery);
                if (this.getStatusQuery(t) != null) {
                    this.getQueueManager(t).getPcfMonitorAgent(t).removeListener(t, (PCFListener)this, this.getStatusQuery(t));
                }
                this.getQueueManager(t).getPcfMonitorAgent(t).removeErrorListener(t, (ErrorListener)this);
            }
            catch (DmCoreException dmCoreException) {
                if (!Trace.isTracing) break block3;
                t.data(65, "DmAmsObjectView.removePCFListener", 900, "Error removing listener - PCFMonitorAgent not defined");
            }
        }
    }

    public void refresh(Trace t, boolean sync) {
        block9: {
            if (!this.isCommandServerRunning(t)) {
                return;
            }
            if (!this.active) {
                if (Trace.isTracing) {
                    t.data(65, "DmAmsObjectView.refresh", 300, "View not active " + this.toString());
                }
                return;
            }
            try {
                if (sync) {
                    if (Trace.isTracing) {
                        t.data(65, "DmAmsObjectView.refresh", 800, "Performing synchronous refresh");
                    }
                    this.getQueueManager(t).getPcfMonitorAgent(t).refresh(t, (PCFListener)this);
                } else {
                    if (Trace.isTracing) {
                        t.data(65, "DmAmsObjectView.refresh", 800, "Performing asynchronous refresh");
                    }
                    this.getQueueManager(t).getPcfMonitorAgent(t).refreshAsync(t, (PCFListener)this);
                }
            }
            catch (Exception e) {
                if (!Trace.isTracing) break block9;
                t.data(65, "DmAmsObjectView.refresh", 900, "Error performing refresh\n" + e.toString());
            }
        }
    }

    public void onError(MQException mqe) {
        Trace t = Trace.getDefault();
        if (!GenerateFFST.ignoreFFST((Trace)t, (int)mqe.reasonCode)) {
            t.FFST(65, "DmAmsObjectView.onError", 0, mqe.reasonCode, mqe.getMessage());
        }
    }

    public DmAmsObjectListener getListener() {
        return this.objectListener;
    }

    private boolean isCommandServerRunning(Trace t) {
        if (!this.getQueueManager(t).isCommandServerRunning(t)) {
            int cmd = 205;
            this.getQueueManager(t).setException(t, this.getQueueManager(t).createException(t, cmd, 2322, 2));
            this.getQueueManager(t).disconnectAsync(t, 2322);
            return false;
        }
        return true;
    }

    public boolean isActive() {
        return this.active;
    }
}

