/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ams.core.internal.events;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.core.internal.report.ReportManager;
import com.ibm.mq.pcf.PCFException;
import com.ibm.mq.pcf.PCFMessage;
import com.ibm.mq.pcf.event.PCFQuery;
import java.util.ArrayList;

public class DmAmsCommonObjectView {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ams/src/com/ibm/mq/explorer/ams/core/internal/events/DmAmsCommonObjectView.java";
    private DmQueueManager queueManager = null;
    private ArrayList<IDmObject> listOfObjects = null;
    private PCFQuery statusQueury = null;
    private DmCoreException dmCoreException = null;
    private int dmObjectType = -1;
    private int dmStatusObjectType = -1;
    protected static int NOT_FOUND = -1;

    public DmAmsCommonObjectView(Trace t, DmQueueManager qMgr) {
        this.queueManager = qMgr;
        this.dmObjectType = 2002;
        this.listOfObjects = new ArrayList(10);
    }

    protected int getObjectTypeFromPCFMessage(Trace t, PCFMessage pcfMessage, int id) {
        int type;
        block2: {
            type = NOT_FOUND;
            try {
                type = pcfMessage.getIntParameterValue(id);
            }
            catch (PCFException pCFException) {
                if (!Trace.isTracing) break block2;
                t.data(65, "DmAmsCommonObjectView.getObjectTypeFromPCFMessage", 1000, "Object type not found in PFCMessage");
            }
        }
        return type;
    }

    protected String getObjectNameFromPCFMessage(Trace t, PCFMessage pcfMessage, int id) {
        String name = "";
        Object o = pcfMessage.getParameterValue(id);
        if (o == null) {
            if (Trace.isTracing) {
                t.data(65, "DmAmsCommonObjectView.getObjectNameFromPCFMessage", 1000, "Object name not found in PFCMessage");
            }
            return "";
        }
        if (o instanceof String) {
            name = (String)o;
        } else if (o instanceof byte[]) {
            name = new String((byte[])o);
        } else if (Trace.isTracing) {
            t.data(65, "DmAmsCommonObjectView.getObjectNameFromPCFMessage", 900, "Unknown object type in PFCMessage");
        }
        return name.trim();
    }

    protected ArrayList<IDmObject> getListOfObjects(Trace t) {
        return this.listOfObjects;
    }

    protected PCFQuery getStatusQuery(Trace t) {
        return this.statusQueury;
    }

    protected void setStatusQuery(Trace t, PCFQuery q) {
        this.statusQueury = q;
    }

    public DmQueueManager getQueueManager(Trace t) {
        return this.queueManager;
    }

    protected DmCoreException getException(Trace t) {
        return this.dmCoreException;
    }

    public int getDmObjectType(Trace t) {
        return this.dmObjectType;
    }

    protected int getDmStatusObjectType(Trace t) {
        return this.dmStatusObjectType;
    }

    protected void setDmStatusObjectType(Trace t, int i) {
        this.dmStatusObjectType = i;
    }

    protected void setException(Trace t, DmCoreException ex) {
        this.dmCoreException = ex;
    }

    protected void report(Trace t, PCFQuery query) {
        ReportManager.getDefault().add(t, this.getQueueManager(t).getTitle(), query);
    }
}

